/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.meet;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jitsi.impl.configuration.ConfigurationServiceImpl;
import org.jitsi.meet.OSGi;
import org.jitsi.meet.OSGiBundleConfig;
import org.jitsi.meet.OSGiClassLoader;
import org.jitsi.meet.ShutdownService;
import org.jitsi.osgi.ServiceUtils2;
import org.jitsi.retry.RetryStrategy;
import org.jitsi.retry.SimpleRetryTask;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.component.ComponentBase;
import org.jivesoftware.whack.ExternalComponentManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.xeustechnologies.jcl.JarClassLoader;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;

public class ComponentMain {
    private static final Logger logger = Logger.getLogger(ComponentMain.class);
    private static final Object exitSyncRoot = new Object();
    private ComponentBase component;
    private ExternalComponentManager componentManager;
    private RetryStrategy connectRetry;
    private final Object connectSynRoot = new Object();
    private ScheduledExecutorService executorService;

    public void runMainProgramLoop(OSGiBundleConfig bundleConfig) {
        this.runMainProgramLoop(null, bundleConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMainProgramLoop(ComponentBase component, OSGiBundleConfig bundleConfig) {
        ConfigurationServiceImpl.PASSWORD_SYS_PROPS = "pass";
        ConfigurationServiceImpl.PASSWORD_CMD_LINE_ARGS = "secret,user_password";
        OSGi.setBundleConfig(bundleConfig);
        bundleConfig.setSystemPropertyDefaults();
        ClassLoader classLoader = this.loadBundlesJars(bundleConfig);
        OSGi.setClassLoader(classLoader);
        BundleActivator activator = new BundleActivator(){

            public void start(BundleContext bundleContext) throws Exception {
                ComponentMain.registerShutdownService(bundleContext);
                ServiceUtils2.getService(bundleContext, ConfigurationService.class).logConfigurationProperties("(pass)|(secret)");
            }

            public void stop(BundleContext bundleContext) throws Exception {
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = exitSyncRoot;
                synchronized (object) {
                    exitSyncRoot.notifyAll();
                }
            }
        });
        OSGi.start(activator);
        if (component == null || this.startComponent(component)) {
            try {
                Object object = exitSyncRoot;
                synchronized (object) {
                    exitSyncRoot.wait();
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        this.stopComponent();
        OSGi.stop(activator);
    }

    private ClassLoader loadBundlesJars(OSGiBundleConfig bundleConfig) {
        String bundlesJarsPath = bundleConfig.getBundlesJarsPath();
        if (bundlesJarsPath == null) {
            return ClassLoader.getSystemClassLoader();
        }
        JarClassLoader jcl = new JarClassLoader();
        jcl.add(bundlesJarsPath + "/");
        return new OSGiClassLoader(jcl, ClassLoader.getSystemClassLoader());
    }

    private boolean startComponent(ComponentBase component) {
        this.component = component;
        String host = component.getHostname();
        int port = component.getPort();
        this.componentManager = new ExternalComponentManager(host, port, false);
        String componentSubDomain = component.getSubdomain();
        this.componentManager.setSecretKey(componentSubDomain, component.getSecret());
        this.componentManager.setServerName(component.getDomain());
        this.executorService = Executors.newScheduledThreadPool(1);
        component.init();
        this.connectRetry = new RetryStrategy(this.executorService);
        this.connectRetry.runRetryingTask(new SimpleRetryTask(0L, 5000L, true, this.getConnectCallable()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopComponent() {
        Object object = this.connectSynRoot;
        synchronized (object) {
            if (this.component == null || this.componentManager == null) {
                return;
            }
            if (this.connectRetry != null) {
                this.connectRetry.cancel();
                this.connectRetry = null;
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            this.component.shutdown();
            try {
                this.componentManager.removeComponent(this.component.getSubdomain());
            }
            catch (ComponentException e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.component.dispose();
            this.component = null;
            this.componentManager = null;
        }
    }

    private Callable<Boolean> getConnectCallable() {
        return () -> {
            try {
                Object object = this.connectSynRoot;
                synchronized (object) {
                    if (this.componentManager == null || this.component == null) {
                        return false;
                    }
                    this.componentManager.addComponent(this.component.getSubdomain(), (Component)this.component);
                    return false;
                }
            }
            catch (ComponentException e) {
                logger.error((Object)(e.getMessage() + ", host:" + this.component.getHostname() + ", port:" + this.component.getPort()), (Throwable)e);
                return true;
            }
        };
    }

    private static void registerShutdownService(BundleContext bundleContext) {
        bundleContext.registerService(ShutdownService.class, (Object)new ShutdownService(){
            private boolean shutdownStarted = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beginShutdown() {
                if (this.shutdownStarted) {
                    return;
                }
                this.shutdownStarted = true;
                Object object = exitSyncRoot;
                synchronized (object) {
                    exitSyncRoot.notifyAll();
                }
            }
        }, null);
    }
}

