/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.bigintcrypto;

import gnu.java.math.MPN;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Random;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class BigIntegerCrypto
extends Number
implements Comparable<BigIntegerCrypto> {
    private transient int ival;
    private transient int[] words;
    private byte[] magnitude;
    private int signum;
    private static final long serialVersionUID = -3877199389772696545L;
    private static final int minFixNum = -100;
    private static final int maxFixNum = 1024;
    private static final int numFixNum = 1125;
    private static final BigIntegerCrypto[] smallFixNums = new BigIntegerCrypto[1125];
    public static final BigIntegerCrypto ZERO;
    public static final BigIntegerCrypto ONE;
    public static final BigIntegerCrypto TEN;
    private static final int FLOOR = 1;
    private static final int CEILING = 2;
    private static final int TRUNCATE = 3;
    private static final int ROUND = 4;
    private static final int[] primes;
    private static final int[] k;
    private static final int[] t;
    private static final byte[] bit4_count;

    private BigIntegerCrypto() {
    }

    private BigIntegerCrypto(int value) {
        this.ival = value;
    }

    public BigIntegerCrypto(String s, int radix) {
        this();
        byte[] bytes;
        int i;
        boolean negative;
        int len = s.length();
        char ch = s.charAt(0);
        if (ch == '-') {
            negative = true;
            i = 1;
            bytes = new byte[len - 1];
        } else {
            negative = false;
            i = 0;
            bytes = new byte[len];
        }
        int byte_len = 0;
        while (i < len) {
            ch = s.charAt(i);
            int digit = Character.digit(ch, radix);
            if (digit < 0) {
                throw new NumberFormatException("Invalid character at position #" + i);
            }
            bytes[byte_len++] = (byte)digit;
            ++i;
        }
        BigIntegerCrypto result = len <= 15 && radix <= 16 ? BigIntegerCrypto.valueOf(Long.parseLong(s, radix)) : BigIntegerCrypto.valueOf(bytes, byte_len, negative, radix);
        Arrays.fill(bytes, (byte)0);
        this.ival = result.ival;
        this.words = result.words;
    }

    public BigIntegerCrypto(String val) {
        this(val, 10);
    }

    public BigIntegerCrypto(byte[] val) {
        this();
        if (val == null || val.length < 1) {
            throw new NumberFormatException();
        }
        this.words = BigIntegerCrypto.byteArrayToIntArray(val, val[0] < 0 ? -1 : 0);
        BigIntegerCrypto result = BigIntegerCrypto.make(this.words, this.words.length);
        this.ival = result.ival;
        this.words = result.words;
    }

    public BigIntegerCrypto(int signum, byte[] magnitude) {
        this();
        if (magnitude == null || signum > 1 || signum < -1) {
            throw new NumberFormatException();
        }
        if (signum == 0) {
            int i;
            for (i = magnitude.length - 1; i >= 0 && magnitude[i] == 0; --i) {
            }
            if (i >= 0) {
                throw new NumberFormatException();
            }
            return;
        }
        this.words = BigIntegerCrypto.byteArrayToIntArray(magnitude, 0);
        BigIntegerCrypto result = BigIntegerCrypto.make(this.words, this.words.length);
        this.ival = result.ival;
        this.words = result.words;
        if (signum < 0) {
            this.setNegative();
        }
    }

    public BigIntegerCrypto(int numBits, Random rnd) {
        this();
        if (numBits < 0) {
            throw new IllegalArgumentException();
        }
        this.init(numBits, rnd);
    }

    public BigIntegerCrypto(int numBits, RandomGenerator rnd) {
        this();
        if (numBits < 0) {
            throw new IllegalArgumentException();
        }
        this.init(numBits, rnd);
    }

    private void init(int numBits, Random rnd) {
        int nwords;
        int highbits = numBits & 0x1F;
        int highBitByteCount = (highbits + 7) / 8;
        int discardedBitCount = highbits % 8;
        if (discardedBitCount != 0) {
            discardedBitCount = 8 - discardedBitCount;
        }
        byte[] highBitBytes = new byte[highBitByteCount];
        if (highbits > 0) {
            rnd.nextBytes(highBitBytes);
            highbits = (highBitBytes[highBitByteCount - 1] & 0xFF) >>> discardedBitCount;
            for (int i = highBitByteCount - 2; i >= 0; --i) {
                highbits = highbits << 8 | highBitBytes[i] & 0xFF;
            }
        }
        for (nwords = numBits / 32; highbits == 0 && nwords > 0; --nwords) {
            highbits = rnd.nextInt();
        }
        if (nwords == 0 && highbits >= 0) {
            this.ival = highbits;
        } else {
            this.ival = highbits < 0 ? nwords + 2 : nwords + 1;
            this.words = new int[this.ival];
            this.words[nwords] = highbits;
            while (--nwords >= 0) {
                this.words[nwords] = rnd.nextInt();
            }
        }
    }

    private void init(int numBits, RandomGenerator rnd) {
        int nwords;
        int highbits = numBits & 0x1F;
        int highBitByteCount = (highbits + 7) / 8;
        int discardedBitCount = highbits % 8;
        if (discardedBitCount != 0) {
            discardedBitCount = 8 - discardedBitCount;
        }
        byte[] highBitBytes = new byte[highBitByteCount];
        if (highbits > 0) {
            rnd.nextBytes(highBitBytes);
            highbits = (highBitBytes[highBitByteCount - 1] & 0xFF) >>> discardedBitCount;
            for (int i = highBitByteCount - 2; i >= 0; --i) {
                highbits = highbits << 8 | highBitBytes[i] & 0xFF;
            }
        }
        byte[] tmpBytes = new byte[4];
        for (nwords = numBits / 32; highbits == 0 && nwords > 0; highbits |= tmpBytes[3] << 24, --nwords) {
            rnd.nextBytes(tmpBytes);
            highbits = tmpBytes[0];
            highbits |= tmpBytes[1] << 8;
            highbits |= tmpBytes[2] << 16;
        }
        if (nwords == 0 && highbits >= 0) {
            this.ival = highbits;
        } else {
            this.ival = highbits < 0 ? nwords + 2 : nwords + 1;
            this.words = new int[this.ival];
            this.words[nwords] = highbits;
            while (--nwords >= 0) {
                rnd.nextBytes(tmpBytes);
                this.words[nwords] = tmpBytes[0];
                int n = nwords;
                this.words[n] = this.words[n] | tmpBytes[1] << 8;
                int n2 = nwords;
                this.words[n2] = this.words[n2] | tmpBytes[2] << 16;
                int n3 = nwords;
                this.words[n3] = this.words[n3] | tmpBytes[3] << 24;
            }
        }
    }

    public BigIntegerCrypto(int bitLength, int certainty, Random rnd) {
        this();
        BigIntegerCrypto result = new BigIntegerCrypto();
        do {
            result.init(bitLength, rnd);
        } while (!(result = result.setBit(bitLength - 1)).isProbablePrime(certainty));
        this.ival = result.ival;
        this.words = result.words;
    }

    public BigIntegerCrypto(int bitLength, int certainty, RandomGenerator rnd) {
        this();
        BigIntegerCrypto result = new BigIntegerCrypto();
        do {
            result.init(bitLength, rnd);
        } while (!(result = result.setBit(bitLength - 1)).isProbablePrime(certainty));
        this.ival = result.ival;
        this.words = result.words;
    }

    public void zeroize() {
        if (this.words != null) {
            Arrays.fill(this.words, 0);
            this.words = null;
            this.ival = 0;
        }
    }

    public static BigIntegerCrypto probablePrime(int bitLength, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException();
        }
        return new BigIntegerCrypto(bitLength, 100, rnd);
    }

    public static BigIntegerCrypto valueOf(long val) {
        if (val >= -100L && val <= 1024L) {
            return smallFixNums[(int)val - -100];
        }
        int i = (int)val;
        if ((long)i == val) {
            return new BigIntegerCrypto(i);
        }
        BigIntegerCrypto result = BigIntegerCrypto.alloc(2);
        result.ival = 2;
        result.words[0] = i;
        result.words[1] = (int)(val >> 32);
        return result;
    }

    private static BigIntegerCrypto make(int[] words, int len) {
        if (words == null) {
            return BigIntegerCrypto.valueOf(len);
        }
        if ((len = BigIntegerCrypto.wordsNeeded(words, len)) <= 1) {
            return len == 0 ? ZERO : BigIntegerCrypto.valueOf(words[0]);
        }
        BigIntegerCrypto num = new BigIntegerCrypto();
        num.words = words;
        num.ival = len;
        return num;
    }

    private static int[] byteArrayToIntArray(byte[] bytes, int sign) {
        int[] words = new int[bytes.length / 4 + 1];
        int nwords = words.length;
        int bptr = 0;
        int word = sign;
        int i = bytes.length % 4;
        while (i > 0) {
            word = word << 8 | bytes[bptr] & 0xFF;
            --i;
            ++bptr;
        }
        words[--nwords] = word;
        while (nwords > 0) {
            words[--nwords] = bytes[bptr++] << 24 | (bytes[bptr++] & 0xFF) << 16 | (bytes[bptr++] & 0xFF) << 8 | bytes[bptr++] & 0xFF;
        }
        return words;
    }

    private static BigIntegerCrypto alloc(int nwords) {
        BigIntegerCrypto result = new BigIntegerCrypto();
        if (nwords > 1) {
            result.words = new int[nwords];
        }
        return result;
    }

    private void realloc(int nwords) {
        if (nwords == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                    this.words[0] = 0;
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < nwords || this.words.length > nwords + 2) {
            int[] new_words = new int[nwords];
            if (this.words == null) {
                new_words[0] = this.ival;
                this.ival = 1;
            } else {
                if (nwords < this.ival) {
                    this.ival = nwords;
                }
                System.arraycopy(this.words, 0, new_words, 0, this.ival);
                Arrays.fill(this.words, 0);
            }
            this.words = new_words;
        }
    }

    private boolean isNegative() {
        return (this.words == null ? this.ival : this.words[this.ival - 1]) < 0;
    }

    public int signum() {
        if (this.ival == 0 && this.words == null) {
            return 0;
        }
        int top = this.words == null ? this.ival : this.words[this.ival - 1];
        return top < 0 ? -1 : 1;
    }

    private static int compareTo(BigIntegerCrypto x, BigIntegerCrypto y) {
        int y_len;
        boolean y_negative;
        if (x.words == null && y.words == null) {
            return x.ival < y.ival ? -1 : (x.ival > y.ival ? 1 : 0);
        }
        boolean x_negative = x.isNegative();
        if (x_negative != (y_negative = y.isNegative())) {
            return x_negative ? -1 : 1;
        }
        int x_len = x.words == null ? 1 : x.ival;
        int n = y_len = y.words == null ? 1 : y.ival;
        if (x_len != y_len) {
            return x_len > y_len != x_negative ? 1 : -1;
        }
        return MPN.cmp(x.words, y.words, x_len);
    }

    @Override
    public int compareTo(BigIntegerCrypto val) {
        return BigIntegerCrypto.compareTo(this, val);
    }

    public BigIntegerCrypto min(BigIntegerCrypto val) {
        return BigIntegerCrypto.compareTo(this, val) < 0 ? this : val;
    }

    public BigIntegerCrypto max(BigIntegerCrypto val) {
        return BigIntegerCrypto.compareTo(this, val) > 0 ? this : val;
    }

    private boolean isZero() {
        return this.words == null && this.ival == 0;
    }

    private boolean isOne() {
        return this.words == null && this.ival == 1;
    }

    private static int wordsNeeded(int[] words, int len) {
        int i;
        block4: {
            int word;
            i = len;
            if (i <= 0) break block4;
            if ((word = words[--i]) == -1) {
                while (i > 0 && (word = words[i - 1]) < 0) {
                    --i;
                    if (word == -1) continue;
                    break;
                }
            } else {
                while (word == 0 && i > 0 && (word = words[i - 1]) >= 0) {
                    --i;
                }
            }
        }
        return i + 1;
    }

    private BigIntegerCrypto canonicalize() {
        if (this.words != null && (this.ival = BigIntegerCrypto.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            Arrays.fill(this.words, 0);
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    private static BigIntegerCrypto add(int x, int y) {
        return BigIntegerCrypto.valueOf((long)x + (long)y);
    }

    private static BigIntegerCrypto add(BigIntegerCrypto x, int y) {
        if (x.words == null) {
            return BigIntegerCrypto.add(x.ival, y);
        }
        BigIntegerCrypto result = new BigIntegerCrypto(0);
        result.setAdd(x, y);
        return result.canonicalize();
    }

    private void setAdd(BigIntegerCrypto x, int y) {
        if (x.words == null) {
            this.set((long)x.ival + (long)y);
            return;
        }
        int len = x.ival;
        this.realloc(len + 1);
        long carry = y;
        for (int i = 0; i < len; ++i) {
            this.words[i] = (int)(carry += (long)x.words[i] & 0xFFFFFFFFL);
            carry >>= 32;
        }
        if (x.words[len - 1] < 0) {
            --carry;
        }
        this.words[len] = (int)carry;
        this.ival = BigIntegerCrypto.wordsNeeded(this.words, len + 1);
    }

    private void setAdd(int y) {
        this.setAdd(this, y);
    }

    private void set(long y) {
        int i = (int)y;
        if ((long)i == y) {
            this.ival = i;
            if (this.words != null) {
                Arrays.fill(this.words, 0);
            }
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = i;
            this.words[1] = (int)(y >> 32);
            this.ival = 2;
        }
    }

    private void set(int[] words, int length) {
        this.ival = length;
        if (this.words != null) {
            Arrays.fill(this.words, 0);
        }
        this.words = words;
    }

    private void set(BigIntegerCrypto y) {
        if (y.words == null) {
            this.set(y.ival);
        } else if (this != y) {
            this.realloc(y.ival);
            System.arraycopy(y.words, 0, this.words, 0, y.ival);
            this.ival = y.ival;
        }
    }

    private static BigIntegerCrypto add(BigIntegerCrypto x, BigIntegerCrypto y, int k) {
        long y_ext;
        int i;
        if (x.words == null && y.words == null) {
            return BigIntegerCrypto.valueOf((long)k * (long)y.ival + (long)x.ival);
        }
        if (k != 1) {
            y = k == -1 ? BigIntegerCrypto.neg(y) : BigIntegerCrypto.times(y, BigIntegerCrypto.valueOf(k));
        }
        if (x.words == null) {
            return BigIntegerCrypto.add(y, x.ival);
        }
        if (y.words == null) {
            return BigIntegerCrypto.add(x, y.ival);
        }
        if (y.ival > x.ival) {
            BigIntegerCrypto tmp = x;
            x = y;
            y = tmp;
        }
        BigIntegerCrypto result = BigIntegerCrypto.alloc(x.ival + 1);
        long carry = MPN.add_n(result.words, x.words, y.words, i);
        long l = y_ext = y.words[i - 1] < 0 ? 0xFFFFFFFFL : 0L;
        for (i = y.ival; i < x.ival; ++i) {
            result.words[i] = (int)(carry += ((long)x.words[i] & 0xFFFFFFFFL) + y_ext);
            carry >>>= 32;
        }
        if (x.words[i - 1] < 0) {
            --y_ext;
        }
        result.words[i] = (int)(carry + y_ext);
        result.ival = i + 1;
        return result.canonicalize();
    }

    public BigIntegerCrypto add(BigIntegerCrypto val) {
        return BigIntegerCrypto.add(this, val, 1);
    }

    public BigIntegerCrypto subtract(BigIntegerCrypto val) {
        return BigIntegerCrypto.add(this, val, -1);
    }

    private static BigIntegerCrypto times(BigIntegerCrypto x, int y) {
        boolean negative;
        if (y == 0) {
            return ZERO;
        }
        if (y == 1) {
            return x;
        }
        int[] xwords = x.words;
        int xlen = x.ival;
        if (xwords == null) {
            return BigIntegerCrypto.valueOf((long)xlen * (long)y);
        }
        BigIntegerCrypto result = BigIntegerCrypto.alloc(xlen + 1);
        if (xwords[xlen - 1] < 0) {
            negative = true;
            BigIntegerCrypto.negate(result.words, xwords, xlen);
            xwords = result.words;
        } else {
            negative = false;
        }
        if (y < 0) {
            negative = !negative;
            y = -y;
        }
        result.words[xlen] = MPN.mul_1(result.words, xwords, xlen, y);
        result.ival = xlen + 1;
        if (negative) {
            result.setNegative();
        }
        return result.canonicalize();
    }

    private static BigIntegerCrypto times(BigIntegerCrypto x, BigIntegerCrypto y) {
        int[] ywords;
        int[] xwords;
        if (y.words == null) {
            return BigIntegerCrypto.times(x, y.ival);
        }
        if (x.words == null) {
            return BigIntegerCrypto.times(y, x.ival);
        }
        boolean negative = false;
        int xlen = x.ival;
        int ylen = y.ival;
        if (x.isNegative()) {
            negative = true;
            xwords = new int[xlen];
            BigIntegerCrypto.negate(xwords, x.words, xlen);
        } else {
            negative = false;
            xwords = x.words;
        }
        if (y.isNegative()) {
            negative = !negative;
            ywords = new int[ylen];
            BigIntegerCrypto.negate(ywords, y.words, ylen);
        } else {
            ywords = y.words;
        }
        if (xlen < ylen) {
            int[] twords = xwords;
            xwords = ywords;
            ywords = twords;
            int tlen = xlen;
            xlen = ylen;
            ylen = tlen;
        }
        BigIntegerCrypto result = BigIntegerCrypto.alloc(xlen + ylen);
        MPN.mul(result.words, xwords, xlen, ywords, ylen);
        if (xwords != x.words && ywords != x.words) {
            Arrays.fill(xwords, 0);
            xwords = null;
        }
        if (ywords != y.words && xwords != y.words) {
            Arrays.fill(ywords, 0);
            ywords = null;
        }
        result.ival = xlen + ylen;
        if (negative) {
            result.setNegative();
        }
        return result.canonicalize();
    }

    public BigIntegerCrypto multiply(BigIntegerCrypto y) {
        return BigIntegerCrypto.times(this, y);
    }

    private static void divide(long x, long y, BigIntegerCrypto quotient, BigIntegerCrypto remainder, int rounding_mode) {
        boolean yNegative;
        boolean xNegative;
        if (x < 0L) {
            xNegative = true;
            if (x == Long.MIN_VALUE) {
                BigIntegerCrypto.divide(BigIntegerCrypto.valueOf(x), BigIntegerCrypto.valueOf(y), quotient, remainder, rounding_mode);
                return;
            }
            x = -x;
        } else {
            xNegative = false;
        }
        if (y < 0L) {
            yNegative = true;
            if (y == Long.MIN_VALUE) {
                if (rounding_mode == 3) {
                    if (quotient != null) {
                        quotient.set(0L);
                    }
                    if (remainder != null) {
                        remainder.set(x);
                    }
                } else {
                    BigIntegerCrypto.divide(BigIntegerCrypto.valueOf(x), BigIntegerCrypto.valueOf(y), quotient, remainder, rounding_mode);
                }
                return;
            }
            y = -y;
        } else {
            yNegative = false;
        }
        long q = x / y;
        long r = x % y;
        boolean qNegative = xNegative ^ yNegative;
        boolean add_one = false;
        if (r != 0L) {
            switch (rounding_mode) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    if (qNegative != (rounding_mode == 1)) break;
                    add_one = true;
                    break;
                }
                case 4: {
                    boolean bl = add_one = r > y - (q & 1L) >> 1;
                }
            }
        }
        if (quotient != null) {
            if (add_one) {
                ++q;
            }
            if (qNegative) {
                q = -q;
            }
            quotient.set(q);
        }
        if (remainder != null) {
            if (add_one) {
                r = y - r;
                boolean bl = xNegative = !xNegative;
            }
            if (xNegative) {
                r = -r;
            }
            remainder.set(r);
        }
    }

    private static void divide(BigIntegerCrypto x, BigIntegerCrypto y, BigIntegerCrypto quotient, BigIntegerCrypto remainder, int rounding_mode) {
        int qlen;
        int rlen;
        int xlen;
        int ylen;
        if (!(x.words != null && x.ival > 2 || y.words != null && y.ival > 2)) {
            long x_l = x.longValue();
            long y_l = y.longValue();
            if (x_l != Long.MIN_VALUE && y_l != Long.MIN_VALUE) {
                BigIntegerCrypto.divide(x_l, y_l, quotient, remainder, rounding_mode);
                return;
            }
        }
        boolean xNegative = x.isNegative();
        boolean yNegative = y.isNegative();
        boolean qNegative = xNegative ^ yNegative;
        int[] ywords = new int[ylen];
        y.getAbsolute(ywords);
        for (ylen = y.words == null ? 1 : y.ival; ylen > 1 && ywords[ylen - 1] == 0; --ylen) {
        }
        int[] xwords = new int[xlen + 2];
        x.getAbsolute(xwords);
        for (xlen = x.words == null ? 1 : x.ival; xlen > 1 && xwords[xlen - 1] == 0; --xlen) {
        }
        int cmpval = MPN.cmp(xwords, xlen, ywords, ylen);
        if (cmpval < 0) {
            int[] rwords = xwords;
            xwords = ywords;
            ywords = rwords;
            rlen = xlen;
            qlen = 1;
            xwords[0] = 0;
        } else if (cmpval == 0) {
            xwords[0] = 1;
            qlen = 1;
            ywords[0] = 0;
            rlen = 1;
        } else if (ylen == 1) {
            qlen = xlen;
            if (ywords[0] == 1 && xwords[xlen - 1] < 0) {
                ++qlen;
            }
            rlen = 1;
            ywords[0] = MPN.divmod_1(xwords, xwords, xlen, ywords[0]);
        } else {
            int nshift = MPN.count_leading_zeros(ywords[ylen - 1]);
            if (nshift != 0) {
                MPN.lshift(ywords, 0, ywords, ylen, nshift);
                int x_high = MPN.lshift(xwords, 0, xwords, xlen, nshift);
                xwords[xlen++] = x_high;
            }
            if (xlen == ylen) {
                xwords[xlen++] = 0;
            }
            MPN.divide(xwords, xlen, ywords, ylen);
            rlen = ylen;
            MPN.rshift0(ywords, xwords, 0, rlen, nshift);
            qlen = xlen + 1 - ylen;
            if (quotient != null) {
                for (int i = 0; i < qlen; ++i) {
                    xwords[i] = xwords[i + ylen];
                }
            }
        }
        if (ywords[rlen - 1] < 0) {
            ywords[rlen] = 0;
            ++rlen;
        }
        boolean add_one = false;
        if (rlen > 1 || ywords[0] != 0) {
            switch (rounding_mode) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    if (qNegative != (rounding_mode == 1)) break;
                    add_one = true;
                    break;
                }
                case 4: {
                    BigIntegerCrypto tmp = remainder == null ? new BigIntegerCrypto() : remainder;
                    tmp.set(ywords, rlen);
                    tmp = BigIntegerCrypto.shift(tmp, 1);
                    if (yNegative) {
                        tmp.setNegative();
                    }
                    int cmp = BigIntegerCrypto.compareTo(tmp, y);
                    if (yNegative) {
                        cmp = -cmp;
                    }
                    boolean bl = add_one = cmp == 1 || cmp == 0 && (xwords[0] & 1) != 0;
                }
            }
        }
        if (quotient != null) {
            quotient.set(xwords, qlen);
            if (qNegative) {
                if (add_one) {
                    quotient.setInvert();
                } else {
                    quotient.setNegative();
                }
            } else if (add_one) {
                quotient.setAdd(1);
            }
        }
        if (remainder != null) {
            remainder.set(ywords, rlen);
            if (add_one) {
                BigIntegerCrypto tmp;
                if (y.words == null) {
                    tmp = remainder;
                    tmp.set(yNegative ? (long)(ywords[0] + y.ival) : (long)(ywords[0] - y.ival));
                } else {
                    tmp = BigIntegerCrypto.add(remainder, y, yNegative ? 1 : -1);
                }
                if (xNegative) {
                    remainder.setNegative(tmp);
                } else {
                    remainder.set(tmp);
                }
                if (tmp != remainder) {
                    tmp.zeroize();
                }
            } else if (xNegative) {
                remainder.setNegative();
            }
        }
    }

    public BigIntegerCrypto divide(BigIntegerCrypto val) {
        if (val.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigIntegerCrypto quot = new BigIntegerCrypto();
        BigIntegerCrypto.divide(this, val, quot, null, 3);
        return quot.canonicalize();
    }

    public BigIntegerCrypto remainder(BigIntegerCrypto val) {
        if (val.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigIntegerCrypto rem = new BigIntegerCrypto();
        BigIntegerCrypto.divide(this, val, null, rem, 3);
        return rem.canonicalize();
    }

    public BigIntegerCrypto[] divideAndRemainder(BigIntegerCrypto val) {
        if (val.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigIntegerCrypto[] result = new BigIntegerCrypto[]{new BigIntegerCrypto(), new BigIntegerCrypto()};
        BigIntegerCrypto.divide(this, val, result[0], result[1], 3);
        result[0].canonicalize();
        result[1].canonicalize();
        return result;
    }

    public BigIntegerCrypto mod(BigIntegerCrypto m) {
        if (m.isNegative() || m.isZero()) {
            throw new ArithmeticException("non-positive modulus");
        }
        BigIntegerCrypto rem = new BigIntegerCrypto();
        BigIntegerCrypto.divide(this, m, null, rem, 1);
        return rem.canonicalize();
    }

    public BigIntegerCrypto pow(int exponent) {
        if (exponent <= 0) {
            if (exponent == 0) {
                return ONE;
            }
            throw new ArithmeticException("negative exponent");
        }
        if (this.isZero()) {
            return this;
        }
        int plen = this.words == null ? 1 : this.ival;
        int blen = (this.bitLength() * exponent >> 5) + 2 * plen;
        boolean negative = this.isNegative() && (exponent & 1) != 0;
        int[] pow2 = new int[blen];
        int[] rwords = new int[blen];
        int[] work = new int[blen];
        this.getAbsolute(pow2);
        int rlen = 1;
        rwords[0] = 1;
        block0: while (true) {
            int[] temp;
            if ((exponent & 1) != 0) {
                MPN.mul(work, pow2, plen, rwords, rlen);
                temp = work;
                work = rwords;
                rwords = temp;
                rlen += plen;
                while (rwords[rlen - 1] == 0) {
                    --rlen;
                }
            }
            if ((exponent >>= 1) == 0) break;
            MPN.mul(work, pow2, plen, pow2, plen);
            temp = work;
            work = pow2;
            pow2 = temp;
            plen *= 2;
            while (true) {
                if (pow2[plen - 1] != 0) continue block0;
                --plen;
            }
            break;
        }
        if (rwords[rlen - 1] < 0) {
            ++rlen;
        }
        if (negative) {
            BigIntegerCrypto.negate(rwords, rwords, rlen);
        }
        BigIntegerCrypto ret = BigIntegerCrypto.make(rwords, rlen);
        return ret;
    }

    private static int[] euclidInv(int a, int b, int prevDiv) {
        if (b == 0) {
            throw new ArithmeticException("not invertible");
        }
        if (b == 1) {
            return new int[]{-prevDiv, 1};
        }
        int[] xy = BigIntegerCrypto.euclidInv(b, a % b, a / b);
        a = xy[0];
        xy[0] = a * -prevDiv + xy[1];
        xy[1] = a;
        return xy;
    }

    private static void euclidInv(BigIntegerCrypto a, BigIntegerCrypto b, BigIntegerCrypto prevDiv, BigIntegerCrypto[] xy) {
        if (b.isZero()) {
            throw new ArithmeticException("not invertible");
        }
        if (b.isOne()) {
            xy[0] = BigIntegerCrypto.neg(prevDiv);
            xy[1] = ONE;
            return;
        }
        if (a.words == null) {
            int[] xyInt = BigIntegerCrypto.euclidInv(b.ival, a.ival % b.ival, a.ival / b.ival);
            xy[0] = new BigIntegerCrypto(xyInt[0]);
            xy[1] = new BigIntegerCrypto(xyInt[1]);
        } else {
            BigIntegerCrypto rem = new BigIntegerCrypto();
            BigIntegerCrypto quot = new BigIntegerCrypto();
            BigIntegerCrypto.divide(a, b, quot, rem, 1);
            rem.canonicalize();
            quot.canonicalize();
            BigIntegerCrypto.euclidInv(b, rem, quot, xy);
        }
        BigIntegerCrypto t = xy[0];
        xy[0] = BigIntegerCrypto.add(xy[1], BigIntegerCrypto.times(t, prevDiv), -1);
        xy[1] = t;
    }

    public BigIntegerCrypto modInverse(BigIntegerCrypto y) {
        if (y.isNegative() || y.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (y.isOne()) {
            return ZERO;
        }
        if (this.isOne()) {
            return ONE;
        }
        BigIntegerCrypto result = new BigIntegerCrypto();
        boolean swapped = false;
        if (y.words == null) {
            int yval = y.ival;
            int xval = this.words != null || this.isNegative() ? this.mod((BigIntegerCrypto)y).ival : this.ival;
            if (yval > xval) {
                int tmp = xval;
                xval = yval;
                yval = tmp;
                swapped = true;
            }
            result.ival = BigIntegerCrypto.euclidInv(yval, xval % yval, xval / yval)[swapped ? 0 : 1];
            if (result.ival < 0) {
                result.ival += y.ival;
            }
        } else {
            BigIntegerCrypto x;
            BigIntegerCrypto bigIntegerCrypto = x = this.isNegative() ? this.mod(y) : this;
            if (x.compareTo(y) < 0) {
                result = x;
                x = y;
                y = result;
                swapped = true;
            }
            BigIntegerCrypto rem = new BigIntegerCrypto();
            BigIntegerCrypto quot = new BigIntegerCrypto();
            BigIntegerCrypto.divide(x, y, quot, rem, 1);
            rem.canonicalize();
            quot.canonicalize();
            BigIntegerCrypto[] xy = new BigIntegerCrypto[2];
            BigIntegerCrypto.euclidInv(y, rem, quot, xy);
            BigIntegerCrypto bigIntegerCrypto2 = result = swapped ? xy[0] : xy[1];
            if (result.isNegative()) {
                result = BigIntegerCrypto.add(result, swapped ? x : y, 1);
            }
        }
        return result;
    }

    public BigIntegerCrypto modPow(BigIntegerCrypto exponent, BigIntegerCrypto m) {
        if (m.isNegative() || m.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (exponent.isNegative()) {
            return this.modInverse(m).modPow(exponent.negate(), m);
        }
        if (exponent.isOne()) {
            return this.mod(m);
        }
        BigIntegerCrypto s = ONE;
        BigIntegerCrypto t = this;
        BigIntegerCrypto u = exponent;
        while (!u.isZero()) {
            if (u.and(ONE).isOne()) {
                s = BigIntegerCrypto.times(s, t).mod(m);
            }
            u = u.shiftRight(1);
            t = BigIntegerCrypto.times(t, t).mod(m);
        }
        return s;
    }

    private static int gcd(int a, int b) {
        int tmp;
        if (b > a) {
            tmp = a;
            a = b;
            b = tmp;
        }
        while (b != 0) {
            if (b == 1) {
                return b;
            }
            tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    public BigIntegerCrypto gcd(BigIntegerCrypto y) {
        int xval = this.ival;
        int yval = y.ival;
        if (this.words == null) {
            if (xval == 0) {
                return BigIntegerCrypto.abs(y);
            }
            if (y.words == null && xval != Integer.MIN_VALUE && yval != Integer.MIN_VALUE) {
                if (xval < 0) {
                    xval = -xval;
                }
                if (yval < 0) {
                    yval = -yval;
                }
                return BigIntegerCrypto.valueOf(BigIntegerCrypto.gcd(xval, yval));
            }
            xval = 1;
        }
        if (y.words == null) {
            if (yval == 0) {
                return BigIntegerCrypto.abs(this);
            }
            yval = 1;
        }
        int len = (xval > yval ? xval : yval) + 1;
        int[] xwords = new int[len];
        int[] ywords = new int[len];
        this.getAbsolute(xwords);
        y.getAbsolute(ywords);
        len = MPN.gcd(xwords, ywords, len);
        BigIntegerCrypto result = new BigIntegerCrypto(0);
        result.ival = len;
        result.words = xwords;
        return result.canonicalize();
    }

    public boolean isProbablePrime(int certainty) {
        int i;
        if (certainty < 1) {
            return true;
        }
        BigIntegerCrypto rem = new BigIntegerCrypto();
        for (i = 0; i < primes.length; ++i) {
            if (this.words == null && this.ival == primes[i]) {
                return true;
            }
            BigIntegerCrypto.divide(this, smallFixNums[primes[i] - -100], null, rem, 3);
            if (!rem.canonicalize().isZero()) continue;
            return false;
        }
        BigIntegerCrypto pMinus1 = BigIntegerCrypto.add(this, -1);
        int b = pMinus1.getLowestSetBit();
        BigIntegerCrypto m = pMinus1.divide(BigIntegerCrypto.valueOf(2L).pow(b));
        int bits = this.bitLength();
        for (i = 0; i < k.length && bits > k[i]; ++i) {
        }
        int trials = t[i];
        if (certainty > 80) {
            trials *= 2;
        }
        for (int t = 0; t < trials; ++t) {
            BigIntegerCrypto z = smallFixNums[primes[t] - -100].modPow(m, this);
            if (z.isOne() || z.equals(pMinus1)) continue;
            i = 0;
            while (i < b) {
                if (z.isOne()) {
                    return false;
                }
                ++i;
                if (z.equals(pMinus1)) break;
                z = z.modPow(BigIntegerCrypto.valueOf(2L), this);
            }
            if (i != b || z.equals(pMinus1)) continue;
            return false;
        }
        return true;
    }

    private void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int i = this.ival;
            while (--i >= 0) {
                this.words[i] = ~this.words[i];
            }
        }
    }

    private void setShiftLeft(BigIntegerCrypto x, int count) {
        int i;
        int xlen;
        int[] xwords;
        if (x.words == null) {
            if (count < 32) {
                this.set((long)x.ival << count);
                return;
            }
            xwords = new int[]{x.ival};
            xlen = 1;
        } else {
            xwords = x.words;
            xlen = x.ival;
        }
        int word_count = count >> 5;
        int new_len = xlen + word_count;
        if ((count &= 0x1F) == 0) {
            this.realloc(new_len);
            i = xlen;
            while (--i >= 0) {
                this.words[i + word_count] = xwords[i];
            }
        } else {
            this.realloc(++new_len);
            int shift_out = MPN.lshift(this.words, word_count, xwords, xlen, count);
            count = 32 - count;
            this.words[new_len - 1] = shift_out << count >> count;
        }
        this.ival = new_len;
        i = word_count;
        while (--i >= 0) {
            this.words[i] = 0;
        }
    }

    private void setShiftRight(BigIntegerCrypto x, int count) {
        if (x.words == null) {
            this.set(count < 32 ? (long)(x.ival >> count) : (x.ival < 0 ? -1L : 0L));
        } else if (count == 0) {
            this.set(x);
        } else {
            boolean neg = x.isNegative();
            int word_count = count >> 5;
            count &= 0x1F;
            int d_len = x.ival - word_count;
            if (d_len <= 0) {
                this.set(neg ? -1L : 0L);
            } else {
                if (this.words == null || this.words.length < d_len) {
                    this.realloc(d_len);
                }
                MPN.rshift0(this.words, x.words, word_count, d_len, count);
                this.ival = d_len;
                if (neg) {
                    int n = d_len - 1;
                    this.words[n] = this.words[n] | -2 << 31 - count;
                }
            }
        }
    }

    private void setShift(BigIntegerCrypto x, int count) {
        if (count > 0) {
            this.setShiftLeft(x, count);
        } else {
            this.setShiftRight(x, -count);
        }
    }

    private static BigIntegerCrypto shift(BigIntegerCrypto x, int count) {
        if (x.words == null) {
            if (count <= 0) {
                return BigIntegerCrypto.valueOf(count > -32 ? (long)(x.ival >> -count) : (x.ival < 0 ? -1L : 0L));
            }
            if (count < 32) {
                return BigIntegerCrypto.valueOf((long)x.ival << count);
            }
        }
        if (count == 0) {
            return x;
        }
        BigIntegerCrypto result = new BigIntegerCrypto(0);
        result.setShift(x, count);
        return result.canonicalize();
    }

    public BigIntegerCrypto shiftLeft(int n) {
        if (n == 0) {
            return this;
        }
        return BigIntegerCrypto.shift(this, n);
    }

    public BigIntegerCrypto shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        return BigIntegerCrypto.shift(this, -n);
    }

    private void format(int radix, StringBuffer buffer) {
        if (this.words == null) {
            buffer.append(Integer.toString(this.ival, radix));
        } else if (this.ival <= 2) {
            buffer.append(Long.toString(this.longValue(), radix));
        } else {
            int[] work;
            boolean neg = this.isNegative();
            if (neg || radix != 16) {
                work = new int[this.ival];
                this.getAbsolute(work);
            } else {
                work = this.words;
            }
            int len = this.ival;
            if (radix == 16) {
                if (neg) {
                    buffer.append('-');
                }
                int buf_start = buffer.length();
                int i = len;
                while (--i >= 0) {
                    int word = work[i];
                    int j = 8;
                    while (--j >= 0) {
                        int hex_digit = word >> 4 * j & 0xF;
                        if (hex_digit <= 0 && buffer.length() <= buf_start) continue;
                        buffer.append(Character.forDigit(hex_digit, 16));
                    }
                }
            } else {
                int i = buffer.length();
                do {
                    int digit = MPN.divmod_1(work, work, len, radix);
                    buffer.append(Character.forDigit(digit, radix));
                    while (len > 0 && work[len - 1] == 0) {
                        --len;
                    }
                } while (len != 0);
                if (neg) {
                    buffer.append('-');
                }
                for (int j = buffer.length() - 1; i < j; ++i, --j) {
                    char tmp = buffer.charAt(i);
                    buffer.setCharAt(i, buffer.charAt(j));
                    buffer.setCharAt(j, tmp);
                }
            }
        }
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        if (this.words == null) {
            return Integer.toString(this.ival, radix);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), radix);
        }
        int buf_size = this.ival * (MPN.chars_per_word(radix) + 1);
        StringBuffer buffer = new StringBuffer(buf_size);
        this.format(radix, buffer);
        return buffer.toString();
    }

    @Override
    public int intValue() {
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    @Override
    public long longValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return this.words == null ? this.ival : this.words[0] + this.words[this.ival - 1];
    }

    private static boolean equals(BigIntegerCrypto x, BigIntegerCrypto y) {
        if (x.words == null && y.words == null) {
            return x.ival == y.ival;
        }
        if (x.words == null || y.words == null || x.ival != y.ival) {
            return false;
        }
        int i = x.ival;
        while (--i >= 0) {
            if (x.words[i] == y.words[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigIntegerCrypto)) {
            return false;
        }
        return BigIntegerCrypto.equals(this, (BigIntegerCrypto)obj);
    }

    private static BigIntegerCrypto valueOf(byte[] digits, int byte_len, boolean negative, int radix) {
        int chars_per_word = MPN.chars_per_word(radix);
        int[] words = new int[byte_len / chars_per_word + 1];
        int size = MPN.set_str(words, digits, byte_len, radix);
        if (size == 0) {
            return ZERO;
        }
        if (words[size - 1] < 0) {
            words[size++] = 0;
        }
        if (negative) {
            BigIntegerCrypto.negate(words, words, size);
        }
        return BigIntegerCrypto.make(words, size);
    }

    @Override
    public double doubleValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return BigIntegerCrypto.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    private boolean checkBits(int n) {
        int i;
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            return n > 31 || (this.ival & (1 << n) - 1) != 0;
        }
        for (i = 0; i < n >> 5; ++i) {
            if (this.words[i] == 0) continue;
            return true;
        }
        return (n & 0x1F) != 0 && (this.words[i] & (1 << (n & 0x1F)) - 1) != 0;
    }

    private double roundToDouble(int exp, boolean neg, boolean remainder) {
        int il = this.bitLength();
        if ((exp += il - 1) < -1075) {
            return neg ? -0.0 : 0.0;
        }
        if (exp > 1023) {
            return neg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int ml = exp >= -1022 ? 53 : 53 + exp + 1022;
        int excess_bits = il - (ml + 1);
        long m = excess_bits > 0 ? (this.words == null ? (long)(this.ival >> excess_bits) : MPN.rshift_long(this.words, this.ival, excess_bits)) : this.longValue() << -excess_bits;
        if (exp == 1023 && m >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (remainder || this.checkBits(il - ml)) {
                return neg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return neg ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if ((m & 1L) == 1L && ((m & 2L) == 2L || remainder || this.checkBits(excess_bits))) {
            if (((m += 2L) & 0x40000000000000L) != 0L) {
                ++exp;
                m >>= 1;
            } else if (ml == 52 && (m & 0x20000000000000L) != 0L) {
                ++exp;
            }
        }
        long bits_sign = neg ? Long.MIN_VALUE : 0L;
        long bits_exp = (exp += 1023) <= 0 ? 0L : (long)exp << 52;
        long bits_mant = (m >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits_sign | bits_exp | bits_mant);
    }

    private void getAbsolute(int[] words) {
        int i;
        int len;
        if (this.words == null) {
            len = 1;
            words[0] = this.ival;
        } else {
            i = len = this.ival;
            while (--i >= 0) {
                words[i] = this.words[i];
            }
        }
        if (words[len - 1] < 0) {
            BigIntegerCrypto.negate(words, words, len);
        }
        i = words.length;
        while (--i > len) {
            words[i] = 0;
        }
    }

    private static boolean negate(int[] dest, int[] src, int len) {
        long carry = 1L;
        boolean negative = src[len - 1] < 0;
        for (int i = 0; i < len; ++i) {
            dest[i] = (int)(carry += (long)(~src[i]) & 0xFFFFFFFFL);
            carry >>= 32;
        }
        return negative && dest[len - 1] < 0;
    }

    private void setNegative(BigIntegerCrypto x) {
        int len = x.ival;
        if (x.words == null) {
            if (len == Integer.MIN_VALUE) {
                this.set(-((long)len));
            } else {
                this.set(-len);
            }
            return;
        }
        this.realloc(len + 1);
        if (BigIntegerCrypto.negate(this.words, x.words, len)) {
            this.words[len++] = 0;
        }
        this.ival = len;
    }

    private void setNegative() {
        this.setNegative(this);
    }

    private static BigIntegerCrypto abs(BigIntegerCrypto x) {
        return x.isNegative() ? BigIntegerCrypto.neg(x) : x;
    }

    public BigIntegerCrypto abs() {
        return BigIntegerCrypto.abs(this);
    }

    private static BigIntegerCrypto neg(BigIntegerCrypto x) {
        if (x.words == null && x.ival != Integer.MIN_VALUE) {
            return BigIntegerCrypto.valueOf(-x.ival);
        }
        BigIntegerCrypto result = new BigIntegerCrypto(0);
        result.setNegative(x);
        return result.canonicalize();
    }

    public BigIntegerCrypto negate() {
        return BigIntegerCrypto.neg(this);
    }

    public int bitLength() {
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public byte[] toByteArray() {
        int word;
        if (this.signum() == 0) {
            return new byte[1];
        }
        byte[] bytes = new byte[(this.bitLength() + 1 + 7) / 8];
        int nbytes = bytes.length;
        int wptr = 0;
        while (nbytes > 4) {
            word = this.words[wptr++];
            int i = 4;
            while (i > 0) {
                bytes[--nbytes] = (byte)word;
                --i;
                word >>= 8;
            }
        }
        int n = word = this.words == null ? this.ival : this.words[wptr];
        while (nbytes > 0) {
            bytes[--nbytes] = (byte)word;
            word >>= 8;
        }
        return bytes;
    }

    private static int swappedOp(int op) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(op);
    }

    private static BigIntegerCrypto bitOp(int op, BigIntegerCrypto x, BigIntegerCrypto y) {
        switch (op) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return x.and(y);
            }
            case 3: {
                return x;
            }
            case 5: {
                return y;
            }
            case 15: {
                return BigIntegerCrypto.valueOf(-1L);
            }
        }
        BigIntegerCrypto result = new BigIntegerCrypto();
        BigIntegerCrypto.setBitOp(result, op, x, y);
        return result.canonicalize();
    }

    private static void setBitOp(BigIntegerCrypto result, int op, BigIntegerCrypto x, BigIntegerCrypto y) {
        int ni;
        int xlen;
        int xi;
        int ylen;
        int yi;
        if (y.words != null && (x.words == null || x.ival < y.ival)) {
            BigIntegerCrypto temp = x;
            x = y;
            y = temp;
            op = BigIntegerCrypto.swappedOp(op);
        }
        if (y.words == null) {
            yi = y.ival;
            ylen = 1;
        } else {
            yi = y.words[0];
            ylen = y.ival;
        }
        if (x.words == null) {
            xi = x.ival;
            xlen = 1;
        } else {
            xi = x.words[0];
            xlen = x.ival;
        }
        if (xlen > 1) {
            result.realloc(xlen);
        }
        int[] w = result.words;
        int i = 0;
        int finish = 0;
        block0 : switch (op) {
            case 0: {
                ni = 0;
                break;
            }
            case 1: {
                while (true) {
                    ni = xi & yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 1;
                break;
            }
            case 2: {
                while (true) {
                    ni = xi & ~yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 1;
                break;
            }
            case 3: {
                ni = xi;
                finish = 1;
                break;
            }
            case 4: {
                while (true) {
                    ni = ~xi & yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 2;
                break;
            }
            case 5: {
                while (true) {
                    ni = yi;
                    if (i + 1 >= ylen) break block0;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
            }
            case 6: {
                while (true) {
                    ni = xi ^ yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                finish = yi < 0 ? 2 : 1;
                break;
            }
            case 7: {
                while (true) {
                    ni = xi | yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 1;
                break;
            }
            case 8: {
                while (true) {
                    ni = ~(xi | yi);
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 2;
                break;
            }
            case 9: {
                while (true) {
                    ni = ~(xi ^ yi);
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                finish = yi >= 0 ? 2 : 1;
                break;
            }
            case 10: {
                while (true) {
                    ni = ~yi;
                    if (i + 1 >= ylen) break block0;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
            }
            case 11: {
                while (true) {
                    ni = xi | ~yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 1;
                break;
            }
            case 12: {
                ni = ~xi;
                finish = 2;
                break;
            }
            case 13: {
                while (true) {
                    ni = ~xi | yi;
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi < 0) break;
                finish = 2;
                break;
            }
            case 14: {
                while (true) {
                    ni = ~(xi & yi);
                    if (i + 1 >= ylen) break;
                    w[i++] = ni;
                    xi = x.words[i];
                    yi = y.words[i];
                }
                if (yi >= 0) break;
                finish = 2;
                break;
            }
            default: {
                ni = -1;
            }
        }
        if (i + 1 == xlen) {
            finish = 0;
        }
        switch (finish) {
            case 0: {
                if (i == 0 && w == null) {
                    result.ival = ni;
                    return;
                }
                w[i++] = ni;
                break;
            }
            case 1: {
                w[i] = ni;
                while (++i < xlen) {
                    w[i] = x.words[i];
                }
                break;
            }
            case 2: {
                w[i] = ni;
                while (++i < xlen) {
                    w[i] = ~x.words[i];
                }
                break;
            }
        }
        result.ival = i;
    }

    private static BigIntegerCrypto and(BigIntegerCrypto x, int y) {
        if (x.words == null) {
            return BigIntegerCrypto.valueOf(x.ival & y);
        }
        if (y >= 0) {
            return BigIntegerCrypto.valueOf(x.words[0] & y);
        }
        int len = x.ival;
        int[] words = new int[len];
        words[0] = x.words[0] & y;
        while (--len > 0) {
            words[len] = x.words[len];
        }
        return BigIntegerCrypto.make(words, x.ival);
    }

    public BigIntegerCrypto and(BigIntegerCrypto y) {
        int i;
        if (y.words == null) {
            return BigIntegerCrypto.and(this, y.ival);
        }
        if (this.words == null) {
            return BigIntegerCrypto.and(y, this.ival);
        }
        BigIntegerCrypto x = this;
        if (this.ival < y.ival) {
            BigIntegerCrypto temp = this;
            x = y;
            y = temp;
        }
        int len = y.isNegative() ? x.ival : y.ival;
        int[] words = new int[len];
        for (i = 0; i < y.ival; ++i) {
            words[i] = x.words[i] & y.words[i];
        }
        while (i < len) {
            words[i] = x.words[i];
            ++i;
        }
        return BigIntegerCrypto.make(words, len);
    }

    public BigIntegerCrypto or(BigIntegerCrypto y) {
        return BigIntegerCrypto.bitOp(7, this, y);
    }

    public BigIntegerCrypto xor(BigIntegerCrypto y) {
        return BigIntegerCrypto.bitOp(6, this, y);
    }

    public BigIntegerCrypto not() {
        return BigIntegerCrypto.bitOp(12, this, ZERO);
    }

    public BigIntegerCrypto andNot(BigIntegerCrypto val) {
        return this.and(val.not());
    }

    public BigIntegerCrypto clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n).not());
    }

    public BigIntegerCrypto setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.or(ONE.shiftLeft(n));
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return !this.and(ONE.shiftLeft(n)).isZero();
    }

    public BigIntegerCrypto flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.xor(ONE.shiftLeft(n));
    }

    public int getLowestSetBit() {
        if (this.isZero()) {
            return -1;
        }
        if (this.words == null) {
            return MPN.findLowestBit(this.ival);
        }
        return MPN.findLowestBit(this.words);
    }

    private static int bitCount(int i) {
        int count = 0;
        while (i != 0) {
            count += bit4_count[i & 0xF];
            i >>>= 4;
        }
        return count;
    }

    private static int bitCount(int[] x, int len) {
        int count = 0;
        while (--len >= 0) {
            count += BigIntegerCrypto.bitCount(x[len]);
        }
        return count;
    }

    public int bitCount() {
        int i;
        int x_len;
        int[] x_words = this.words;
        if (x_words == null) {
            x_len = 1;
            i = BigIntegerCrypto.bitCount(this.ival);
        } else {
            x_len = this.ival;
            i = BigIntegerCrypto.bitCount(x_words, x_len);
        }
        return this.isNegative() ? x_len * 32 - i : i;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.magnitude.length == 0 || this.signum == 0) {
            this.ival = 0;
            this.words = null;
        } else {
            this.words = BigIntegerCrypto.byteArrayToIntArray(this.magnitude, this.signum < 0 ? -1 : 0);
            Arrays.fill(this.magnitude, (byte)0);
            BigIntegerCrypto result = BigIntegerCrypto.make(this.words, this.words.length);
            this.ival = result.ival;
            this.words = result.words;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.signum = this.signum();
        this.magnitude = this.signum == 0 ? new byte[]{} : this.toByteArray();
        s.defaultWriteObject();
        Arrays.fill(this.magnitude, (byte)0);
        this.magnitude = null;
    }

    static {
        int i = 1125;
        while (--i >= 0) {
            BigIntegerCrypto.smallFixNums[i] = new BigIntegerCrypto(i + -100);
        }
        ZERO = smallFixNums[100];
        ONE = smallFixNums[101];
        TEN = smallFixNums[110];
        primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
        k = new int[]{100, 150, 200, 250, 300, 350, 400, 500, 600, 800, 1250, Integer.MAX_VALUE};
        t = new int[]{27, 18, 15, 12, 9, 8, 7, 6, 5, 4, 3, 2};
        bit4_count = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    }
}

