/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.sysactivity;

import net.java.sip.communicator.impl.sysactivity.DBusNetworkManager;
import net.java.sip.communicator.impl.sysactivity.SysActivityActivator;
import net.java.sip.communicator.impl.sysactivity.SystemActivityManager;
import net.java.sip.communicator.service.sysactivity.event.SystemActivityEvent;
import net.java.sip.communicator.util.Logger;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.exceptions.DBusException;

public class NetworkManagerListenerImpl
implements DBusSigHandler,
SystemActivityManager {
    private Logger logger = Logger.getLogger((String)NetworkManagerListenerImpl.class.getName());
    private DBusConnection dbusConn;

    public NetworkManagerListenerImpl() {
        try {
            this.dbusConn = DBusConnection.getConnection((int)0);
        }
        catch (DBusException e) {
            this.logger.error((Object)"Cannot obtain dbus connection", (Throwable)e);
        }
    }

    @Override
    public void start() {
        if (this.dbusConn == null) {
            return;
        }
        try {
            this.dbusConn.addSigHandler(DBus.NameOwnerChanged.class, (DBusSigHandler)this);
            this.dbusConn.addSigHandler(DBusNetworkManager.StateChange.class, (DBusSigHandler)this);
            this.dbusConn.addSigHandler(DBusNetworkManager.StateChanged.class, (DBusSigHandler)this);
        }
        catch (DBusException e) {
            this.logger.error((Object)"Error adding dbus signal handlers", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (this.dbusConn == null) {
            return;
        }
        try {
            this.dbusConn.removeSigHandler(DBus.NameOwnerChanged.class, (DBusSigHandler)this);
            this.dbusConn.removeSigHandler(DBusNetworkManager.StateChange.class, (DBusSigHandler)this);
            this.dbusConn.removeSigHandler(DBusNetworkManager.StateChanged.class, (DBusSigHandler)this);
        }
        catch (DBusException e) {
            this.logger.error((Object)"Error removing dbus signal handlers", (Throwable)e);
        }
    }

    public void handle(DBusSignal dBusSignal) {
        if (dBusSignal instanceof DBus.NameOwnerChanged) {
            DBus.NameOwnerChanged nameOwnerChanged = (DBus.NameOwnerChanged)dBusSignal;
            if (nameOwnerChanged.name.equals("org.freedesktop.NetworkManager")) {
                boolean b2;
                boolean b1 = nameOwnerChanged.old_owner != null && nameOwnerChanged.old_owner.length() > 0;
                boolean bl = b2 = nameOwnerChanged.new_owner != null && nameOwnerChanged.new_owner.length() > 0;
                if (b1 && !b2) {
                    SystemActivityEvent evt = new SystemActivityEvent(SysActivityActivator.getSystemActivityService(), 9);
                    SysActivityActivator.getSystemActivityService().fireSystemActivityEvent(evt);
                }
            }
        } else if (dBusSignal instanceof DBusNetworkManager.StateChange) {
            DBusNetworkManager.StateChange stateChange = (DBusNetworkManager.StateChange)dBusSignal;
            SystemActivityEvent evt = null;
            switch (stateChange.getStatus()) {
                case 3: 
                case 4: 
                case 20: 
                case 50: 
                case 60: 
                case 70: {
                    evt = new SystemActivityEvent(SysActivityActivator.getSystemActivityService(), 9);
                    break;
                }
                case 1: 
                case 10: {
                    evt = new SystemActivityEvent(SysActivityActivator.getSystemActivityService(), 0);
                }
            }
            if (evt != null) {
                SysActivityActivator.getSystemActivityService().fireSystemActivityEvent(evt);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.dbusConn != null;
    }
}

