/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import cx.ath.matthew.unix.NotConnectedException;
import cx.ath.matthew.unix.USInputStream;
import cx.ath.matthew.unix.USOutputStream;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnixSocket {
    private UnixSocketAddress address = null;
    private USOutputStream os = null;
    private USInputStream is = null;
    private boolean closed = false;
    private boolean connected = false;
    private boolean passcred = false;
    private int sock = 0;
    private boolean blocking = true;
    private int uid = -1;
    private int pid = -1;
    private int gid = -1;

    private native void native_set_pass_cred(int var1, boolean var2) throws IOException;

    private native int native_connect(String var1, boolean var2) throws IOException;

    private native void native_close(int var1) throws IOException;

    private native int native_getPID(int var1);

    private native int native_getUID(int var1);

    private native int native_getGID(int var1);

    private native void native_send_creds(int var1, byte var2) throws IOException;

    private native byte native_recv_creds(int var1, int[] var2) throws IOException;

    UnixSocket(int sock, UnixSocketAddress address) {
        this.sock = sock;
        this.address = address;
        this.connected = true;
        this.os = new USOutputStream(sock, this);
        this.is = new USInputStream(sock, this);
    }

    public UnixSocket() {
    }

    public UnixSocket(UnixSocketAddress address) throws IOException {
        this.connect(address);
    }

    public UnixSocket(String address) throws IOException {
        this(new UnixSocketAddress(address));
    }

    public void connect(UnixSocketAddress address) throws IOException {
        if (this.connected) {
            this.close();
        }
        this.sock = this.native_connect(address.path, address.abs);
        this.os = new USOutputStream(this.sock, this);
        this.is = new USInputStream(this.sock, this);
        this.address = address;
        this.connected = true;
        this.closed = false;
        this.is.setBlocking(this.blocking);
    }

    public void connect(String address) throws IOException {
        this.connect(new UnixSocketAddress(address));
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() throws IOException {
        this.native_close(this.sock);
        this.sock = 0;
        this.closed = true;
        this.connected = false;
        this.os = null;
        this.is = null;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public UnixSocketAddress getAddress() {
        return this.address;
    }

    public void sendCredentialByte(byte data) throws IOException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        this.native_send_creds(this.sock, data);
    }

    public byte recvCredentialByte() throws IOException {
        if (!this.connected) {
            throw new NotConnectedException();
        }
        int[] creds = new int[]{-1, -1, -1};
        byte data = this.native_recv_creds(this.sock, creds);
        this.pid = creds[0];
        this.uid = creds[1];
        this.gid = creds[2];
        return data;
    }

    public boolean getPassCred() {
        return this.passcred;
    }

    public int getPeerUID() {
        if (-1 == this.uid) {
            this.uid = this.native_getUID(this.sock);
        }
        return this.uid;
    }

    public int getPeerGID() {
        if (-1 == this.gid) {
            this.gid = this.native_getGID(this.sock);
        }
        return this.gid;
    }

    public int getPeerPID() {
        if (-1 == this.pid) {
            this.pid = this.native_getPID(this.sock);
        }
        return this.pid;
    }

    public void setPassCred(boolean enable) throws IOException {
        this.native_set_pass_cred(this.sock, enable);
        this.passcred = enable;
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean enable) {
        this.blocking = enable;
        if (null != this.is) {
            this.is.setBlocking(enable);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isInputShutdown() {
        return this.is.isClosed();
    }

    public boolean isOutputShutdown() {
        return this.os.isClosed();
    }

    public void shutdownInput() {
        this.is.closed = true;
    }

    public void shutdownOutput() {
        this.os.closed = true;
    }

    public void setSoTimeout(int timeout) {
        this.is.setSoTimeout(timeout);
    }

    static {
        System.loadLibrary("unix-java");
    }
}

