/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import cx.ath.matthew.unix.NotConnectedException;
import cx.ath.matthew.unix.UnixSocket;
import java.io.IOException;
import java.io.InputStream;

public class USInputStream
extends InputStream {
    public static final int MSG_DONTWAIT = 64;
    private int sock;
    boolean closed = false;
    private byte[] onebuf = new byte[1];
    private UnixSocket us;
    private boolean blocking = true;
    private int flags = 0;
    private int timeout = 0;

    private native int native_recv(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws IOException;

    public USInputStream(int sock, UnixSocket us) {
        this.sock = sock;
        this.us = us;
    }

    public void close() throws IOException {
        this.closed = true;
        this.us.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int rv = 0;
        while (0 >= rv) {
            rv = this.read(this.onebuf);
        }
        if (-1 == rv) {
            return -1;
        }
        return 0 > this.onebuf[0] ? -this.onebuf[0] : this.onebuf[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new NotConnectedException();
        }
        int count = this.native_recv(this.sock, b, off, len, this.flags, this.timeout);
        if (0 == count) {
            return -1;
        }
        if (-1 == count) {
            return 0;
        }
        return count;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public UnixSocket getSocket() {
        return this.us;
    }

    public void setBlocking(boolean enable) {
        this.flags = enable ? 0 : 64;
    }

    public void setSoTimeout(int timeout) {
        this.timeout = timeout;
    }
}

