/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallInfoHeader;
import javax.sip.header.Header;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerMediaHandlerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetJitsiMeetToolsSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.sdp.SdpUtils;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.utils.MediaType;

public class CallSipImpl
extends MediaAwareCall<CallPeerSipImpl, OperationSetBasicTelephonySipImpl, ProtocolProviderServiceSipImpl>
implements CallPeerListener {
    private static final Logger logger = Logger.getLogger(CallSipImpl.class);
    public static final String DS_SHARING_HEADER = "X-Desktop-Share";
    public static final String EXTRA_HEADER_NAME = "EXTRA_HEADER_NAME";
    public static final String EXTRA_HEADER_VALUE = "EXTRA_HEADER_VALUE";
    private static final int MAX_RETRANSMISSIONS = 3;
    private static final String RETRANSMITS_RINGING_INTERVAL = "net.java.sip.communicator.impl.protocol.sip.RETRANSMITS_RINGING_INTERVAL";
    private static final String SKIP_REINVITE_ON_FOCUS_CHANGE_PROP = "net.java.sip.communicator.impl.protocol.sip.SKIP_REINVITE_ON_FOCUS_CHANGE_PROP";
    private static final int DEFAULT_RETRANSMITS_RINGING_INTERVAL = 500;
    private QualityPreset initialQualityPreferences;
    private final SipMessageFactory messageFactory = this.getProtocolProvider().getMessageFactory();
    private final int retransmitsRingingInterval;
    private final boolean skipReInviteOnFocusChange;

    protected CallSipImpl(OperationSetBasicTelephonySipImpl parentOpSet) {
        super((OperationSetBasicTelephony)parentOpSet);
        ConfigurationService cfg = SipActivator.getConfigurationService();
        int retransmitsRingingInterval = 500;
        if (cfg != null) {
            retransmitsRingingInterval = cfg.getInt(RETRANSMITS_RINGING_INTERVAL, retransmitsRingingInterval);
        }
        this.retransmitsRingingInterval = retransmitsRingingInterval;
        this.skipReInviteOnFocusChange = cfg.getBoolean(SKIP_REINVITE_ON_FOCUS_CHANGE_PROP, false);
        parentOpSet.getActiveCallsRepository().addCall((Call)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conferenceFocusChanged(boolean oldValue, boolean newValue) {
        try {
            if (!this.skipReInviteOnFocusChange) {
                this.reInvite();
            }
        }
        catch (OperationFailedException ofe) {
            logger.info((Object)("Failed to re-INVITE this Call: " + (Object)((Object)this)), (Throwable)ofe);
        }
        finally {
            super.conferenceFocusChanged(oldValue, newValue);
        }
    }

    public boolean contains(Dialog dialog) {
        return this.findCallPeer(dialog) != null;
    }

    private CallPeerSipImpl createCallPeerFor(Transaction containingTransaction, SipProvider sourceProvider) {
        CallPeerSipImpl callPeer = new CallPeerSipImpl(containingTransaction.getDialog().getRemoteParty(), this, containingTransaction, sourceProvider){

            @Override
            protected void processExtraHeaders(Message message) throws ParseException {
                super.processExtraHeaders(message);
                CallSipImpl.this.processExtraHeaders(message);
            }
        };
        this.addCallPeer(callPeer);
        boolean incomingCall = containingTransaction instanceof ServerTransaction;
        callPeer.setState(incomingCall ? CallPeerState.INCOMING_CALL : CallPeerState.INITIATING_CALL);
        if (this.getCallPeerCount() == 1) {
            HashMap<MediaType, MediaDirection> mediaDirections = new HashMap<MediaType, MediaDirection>();
            mediaDirections.put(MediaType.AUDIO, MediaDirection.INACTIVE);
            mediaDirections.put(MediaType.VIDEO, MediaDirection.INACTIVE);
            boolean hasZrtp = false;
            boolean hasSdes = false;
            try {
                Request inviteReq = containingTransaction.getRequest();
                if (inviteReq != null && inviteReq.getRawContent() != null) {
                    String sdpStr = SdpUtils.getContentAsString((Message)inviteReq);
                    SessionDescription sesDescr = SdpUtils.parseSdpString(sdpStr);
                    Vector<MediaDescription> remoteDescriptions = SdpUtils.extractMediaDescriptions(sesDescr);
                    block4: for (MediaDescription mediaDescription : remoteDescriptions) {
                        MediaType mediaType = SdpUtils.getMediaType(mediaDescription);
                        mediaDirections.put(mediaType, SdpUtils.getDirection(mediaDescription));
                        if (!hasZrtp) {
                            boolean bl = hasZrtp = mediaDescription.getAttribute("zrtp-hash") != null;
                        }
                        if (hasSdes) continue;
                        Vector attrs = mediaDescription.getAttributes(true);
                        for (Attribute attr : attrs) {
                            try {
                                if (!"crypto".equals(attr.getName())) continue;
                                hasSdes = true;
                                continue block4;
                            }
                            catch (SdpParseException spe) {
                                logger.error((Object)"Failed to parse SDP attribute", (Throwable)spe);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.warn((Object)"Error getting media types", t);
            }
            this.fireCallEvent(incomingCall ? 2 : 1, (Call)this, mediaDirections);
            if (hasZrtp) {
                ((CallPeerMediaHandlerSipImpl)callPeer.getMediaHandler()).addAdvertisedEncryptionMethod(SrtpControlType.ZRTP);
            }
            if (hasSdes) {
                ((CallPeerMediaHandlerSipImpl)callPeer.getMediaHandler()).addAdvertisedEncryptionMethod(SrtpControlType.SDES);
            }
        }
        return callPeer;
    }

    protected void fireCallEvent(int eventID, Call sourceCall, Map<MediaType, MediaDirection> mediaDirections) {
        CallSipImpl callSip;
        CallPeerSipImpl callPeer;
        Request request;
        Header dsHeader;
        CallEvent callEvent = new CallEvent(sourceCall, eventID, mediaDirections);
        if (sourceCall.getCallPeerCount() == 1 && (dsHeader = (request = (callPeer = (CallPeerSipImpl)((Object)(callSip = (CallSipImpl)sourceCall).getCallPeers().next())).getLatestInviteTransaction().getRequest()).getHeader(DS_SHARING_HEADER)) != null) {
            callEvent.setDesktopStreaming(true);
        }
        ((OperationSetBasicTelephonySipImpl)this.getParentOperationSet()).fireCallEvent(callEvent);
    }

    public CallPeerSipImpl findCallPeer(Dialog dialog) {
        Iterator callPeers = this.getCallPeers();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Looking for peer with dialog: " + dialog + "among " + this.getCallPeerCount() + " calls"));
        }
        for (CallPeerSipImpl callPeer : this.getCallPeerList()) {
            if (callPeer.getDialog() == dialog) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Returning cp=" + (Object)((Object)callPeer)));
                }
                return callPeer;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Ignoring cp=" + (Object)((Object)callPeer) + " because cp.dialog=" + callPeer.getDialog() + " while dialog=" + dialog));
        }
        return null;
    }

    public ProtocolProviderServiceSipImpl getProtocolProvider() {
        return (ProtocolProviderServiceSipImpl)super.getProtocolProvider();
    }

    public CallPeerSipImpl invite(Address calleeAddress, Message cause) throws OperationFailedException {
        SipProvider jainSipProvider;
        SipURI _calleeURI;
        Request invite = this.messageFactory.createInviteRequest(calleeAddress, cause);
        String forceTransport = null;
        URI calleeURI = calleeAddress.getURI();
        if ("sips".equals(calleeURI.getScheme().toLowerCase())) {
            forceTransport = "TLS";
            logger.trace((Object)"detected SIPS URI, must use TLS");
        } else if (calleeURI.isSipURI() && calleeURI instanceof SipURI && (forceTransport = (_calleeURI = (SipURI)calleeURI).getTransportParam()) != null) {
            logger.trace((Object)("got transport parameter: " + forceTransport));
        }
        ClientTransaction inviteTransaction = null;
        if (forceTransport != null) {
            logger.trace((Object)("trying to use transport: " + forceTransport));
            jainSipProvider = this.getProtocolProvider().getJainSipProvider(forceTransport);
        } else {
            logger.trace((Object)"trying default transport");
            jainSipProvider = this.getProtocolProvider().getDefaultJainSipProvider();
        }
        try {
            inviteTransaction = jainSipProvider.getNewClientTransaction(invite);
        }
        catch (TransactionUnavailableException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create inviteTransaction.\nThis is most probably a network connection error.", 4, ex, logger);
        }
        CallPeerSipImpl callPeer = this.createCallPeerFor((Transaction)inviteTransaction, jainSipProvider);
        CallPeerMediaHandlerSipImpl mediaHandler = (CallPeerMediaHandlerSipImpl)callPeer.getMediaHandler();
        mediaHandler.setLocalVideoTransmissionEnabled(this.localVideoAllowed);
        if (this.initialQualityPreferences != null) {
            mediaHandler.setSupportQualityControls(true);
            mediaHandler.getQualityControl().setRemoteSendMaxPreset(this.initialQualityPreferences);
        }
        try {
            callPeer.invite();
        }
        catch (OperationFailedException ex) {
            callPeer.setState(CallPeerState.FAILED);
            throw ex;
        }
        return callPeer;
    }

    public CallPeerSipImpl processInvite(SipProvider jainSipProvider, ServerTransaction serverTran) {
        Request invite = serverTran.getRequest();
        CallPeerSipImpl peer = this.createCallPeerFor((Transaction)serverTran, jainSipProvider);
        CallInfoHeader infoHeader = (CallInfoHeader)invite.getHeader("Call-Info");
        String alternativeIMPPAddress = null;
        if (infoHeader != null && infoHeader.getParameter("purpose") != null && "impp".equals(infoHeader.getParameter("purpose"))) {
            alternativeIMPPAddress = infoHeader.getInfo().toString();
        }
        if (alternativeIMPPAddress != null) {
            peer.setAlternativeIMPPAddress(alternativeIMPPAddress);
        }
        OperationSetJitsiMeetToolsSipImpl jitsiMeetTools = (OperationSetJitsiMeetToolsSipImpl)this.getProtocolProvider().getOperationSet(OperationSetJitsiMeetTools.class);
        jitsiMeetTools.notifyJoinJitsiMeetRoom((Call)this, CallSipImpl.extractRequestHeaders(invite));
        Response response = null;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"will send ringing response: ");
            }
            if (CallPeerState.INCOMING_CALL.equals(peer.getState())) {
                response = this.messageFactory.createResponse(180, invite);
                serverTran.sendResponse(response);
                if (serverTran instanceof SIPTransaction && !((SIPTransaction)serverTran).isReliable()) {
                    Timer timer = new Timer();
                    int interval = this.retransmitsRingingInterval;
                    int delay = 0;
                    for (int i = 0; i < 3; ++i) {
                        timer.schedule((TimerTask)new RingingResponseTask(response, serverTran, peer, timer), delay += interval);
                        interval *= 2;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sent a ringing response: " + response));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while trying to send a request", (Throwable)ex);
            peer.setState(CallPeerState.FAILED, "Internal Error: " + ex.getMessage());
            return peer;
        }
        return peer;
    }

    public void processReplacingInvite(SipProvider jainSipProvider, ServerTransaction serverTransaction, CallPeerSipImpl callPeerToReplace) {
        CallPeerSipImpl newCallPeer = this.createCallPeerFor((Transaction)serverTransaction, jainSipProvider);
        try {
            newCallPeer.answer();
        }
        catch (OperationFailedException ex) {
            logger.error((Object)("Failed to auto-answer the referred call peer " + (Object)((Object)newCallPeer)), (Throwable)ex);
            return;
        }
        try {
            callPeerToReplace.hangup();
        }
        catch (OperationFailedException ex) {
            logger.error((Object)("Failed to hangup the referer " + (Object)((Object)callPeerToReplace)), (Throwable)ex);
            callPeerToReplace.setState(CallPeerState.FAILED, "Internal Error: " + (Object)((Object)ex));
        }
    }

    public void reInvite() throws OperationFailedException {
        for (CallPeerSipImpl peer : this.getCallPeerList()) {
            peer.sendReInvite();
        }
    }

    public void setInitialQualityPreferences(QualityPreset qualityPreferences) {
        this.initialQualityPreferences = qualityPreferences;
    }

    protected void processExtraHeaders(Message message) throws ParseException {
        int extraHeaderIx = 1;
        Object name = this.getData("EXTRA_HEADER_NAME." + extraHeaderIx);
        while (name != null) {
            Object value = this.getData("EXTRA_HEADER_VALUE." + extraHeaderIx);
            Header header = this.getProtocolProvider().getHeaderFactory().createHeader((String)name, (String)value);
            message.setHeader(header);
            name = this.getData("EXTRA_HEADER_NAME." + ++extraHeaderIx);
        }
    }

    private static Map<String, String> extractRequestHeaders(Request req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        ListIterator headerNameIter = req.getHeaderNames();
        while (headerNameIter.hasNext()) {
            String name = (String)headerNameIter.next();
            SIPHeader header = (SIPHeader)req.getHeader(name);
            if (header == null) continue;
            headers.put(name, header.getValue());
        }
        return headers;
    }

    private class RingingResponseTask
    extends TimerTask {
        private final Response response;
        private final ServerTransaction serverTran;
        private final CallPeerSipImpl peer;
        private final Timer timer;

        RingingResponseTask(Response response, ServerTransaction serverTran, CallPeerSipImpl peer, Timer timer) {
            this.response = response;
            this.serverTran = serverTran;
            this.peer = peer;
            this.timer = timer;
        }

        @Override
        public void run() {
            try {
                if (!CallPeerState.INCOMING_CALL.equals(this.peer.getState())) {
                    this.timer.cancel();
                } else {
                    this.serverTran.sendResponse(this.response);
                }
            }
            catch (Exception ex) {
                this.timer.cancel();
            }
        }
    }
}

