/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.thumbnail;

import java.text.ParseException;
import java.util.Date;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.extensions.thumbnail.Thumbnail;
import org.jitsi.xmpp.extensions.thumbnail.ThumbnailFile;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jxmpp.util.XmppDateTime;
import org.xmlpull.v1.XmlPullParser;

public class ThumbnailStreamInitiationProvider
extends IQProvider<StreamInitiation> {
    private static final Logger logger = Logger.getLogger(ThumbnailStreamInitiationProvider.class);

    public StreamInitiation parse(XmlPullParser parser, int depth) throws Exception {
        boolean done = false;
        String id = parser.getAttributeValue("", "id");
        String mimeType = parser.getAttributeValue("", "mime-type");
        StreamInitiation initiation = new StreamInitiation();
        String name = null;
        String size = null;
        String hash = null;
        String date = null;
        String desc = null;
        Thumbnail thumbnail = null;
        boolean isRanged = false;
        DataForm form = null;
        DataFormProvider dataFormProvider = new DataFormProvider();
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("file")) {
                    name = parser.getAttributeValue("", "name");
                    size = parser.getAttributeValue("", "size");
                    hash = parser.getAttributeValue("", "hash");
                    date = parser.getAttributeValue("", "date");
                    continue;
                }
                if (elementName.equals("desc")) {
                    desc = parser.nextText();
                    continue;
                }
                if (elementName.equals("range")) {
                    isRanged = true;
                    continue;
                }
                if (elementName.equals("x") && namespace.equals("jabber:x:data")) {
                    form = (DataForm)dataFormProvider.parse(parser);
                    continue;
                }
                if (!elementName.equals("thumbnail")) continue;
                thumbnail = new Thumbnail(parser);
                continue;
            }
            if (eventType != 3) continue;
            if (elementName.equals("si")) {
                done = true;
                continue;
            }
            if (!elementName.equals("file") || name == null) continue;
            long fileSize = 0L;
            if (size != null && size.trim().length() != 0) {
                try {
                    fileSize = Long.parseLong(size);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"Received an invalid file size, continuing with fileSize set to 0", (Throwable)e);
                }
            }
            ThumbnailFile file = new ThumbnailFile(name, fileSize);
            file.setHash(hash);
            if (date != null) {
                try {
                    file.setDate(XmppDateTime.parseDate((String)date));
                }
                catch (ParseException ex) {
                    logger.warn((Object)("Unknown dateformat on incoming file transfer: " + date));
                }
            } else {
                file.setDate(new Date());
            }
            if (thumbnail != null) {
                file.setThumbnail(thumbnail);
            }
            file.setDesc(desc);
            file.setRanged(isRanged);
            initiation.setFile((StreamInitiation.File)file);
        }
        initiation.setSessionID(id);
        initiation.setMimeType(mimeType);
        initiation.setFeatureNegotiationForm(form);
        return initiation;
    }
}

