/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public abstract class AbstractConferenceEntity
extends AbstractPacketExtension {
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final String CREATE_ATTR_NAME = "create";
    public static final boolean CREATE_DEFAULT = false;
    public static final String EXPIRE_ATTR_NAME = "expire";
    public static final String ID_ATTR_NAME = "id";
    public static final boolean EXPIRE_DEFAULT = false;

    protected AbstractConferenceEntity(String element) {
        super(NAMESPACE, element);
    }

    protected AbstractConferenceEntity(Builder b, String element) {
        super(NAMESPACE, element);
        if (b.id == null) {
            throw new IllegalArgumentException("ID must be set");
        }
        this.setAttribute(ID_ATTR_NAME, b.id);
        if (b.create) {
            this.setAttribute(CREATE_ATTR_NAME, b.create);
        }
        if (b.expire) {
            this.setAttribute(EXPIRE_ATTR_NAME, b.expire);
        }
        for (Media m : b.medias) {
            this.addChildExtension(m);
        }
        if (b.transport != null) {
            this.addChildExtension(b.transport);
        }
        if (b.sources != null) {
            this.addChildExtension(b.sources);
        }
    }

    @NotNull
    public String getId() {
        return this.getAttributeAsString(ID_ATTR_NAME);
    }

    @NotNull
    public List<Media> getMedia() {
        return this.getChildExtensionsOfType(Media.class);
    }

    @Nullable
    public Transport getTransport() {
        return this.getFirstChildOfType(Transport.class);
    }

    @Nullable
    public Sources getSources() {
        return this.getFirstChildOfType(Sources.class);
    }

    public boolean getCreate() {
        String create = this.getAttributeAsString(CREATE_ATTR_NAME);
        return create == null ? false : Boolean.parseBoolean(create);
    }

    public boolean getExpire() {
        String expire = this.getAttributeAsString(EXPIRE_ATTR_NAME);
        return expire == null ? false : Boolean.parseBoolean(expire);
    }

    protected static class Provider<T extends AbstractConferenceEntity>
    extends DefaultPacketExtensionProvider<T> {
        protected Provider(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public T parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            AbstractConferenceEntity abstractConferenceEntity = (AbstractConferenceEntity)super.parse(parser, depth, xmlEnvironment);
            String id = abstractConferenceEntity.getAttributeAsString(AbstractConferenceEntity.ID_ATTR_NAME);
            if (id == null) {
                throw new SmackParsingException.RequiredAttributeMissingException(AbstractConferenceEntity.ID_ATTR_NAME);
            }
            return (T)abstractConferenceEntity;
        }
    }

    public static abstract class Builder {
        private Transport transport;
        private String id;
        private final List<Media> medias = new ArrayList<Media>();
        private boolean create = false;
        private boolean expire = false;
        private Sources sources;

        protected Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder addMedia(Media m) {
            this.medias.add(m);
            return this;
        }

        public Builder setTransport(Transport t) {
            this.transport = t;
            return this;
        }

        public Builder setSources(Sources s) {
            this.sources = s;
            return this;
        }

        public Builder setCreate(boolean e) {
            this.create = e;
            return this;
        }

        public Builder setExpire(boolean e) {
            this.expire = e;
            return this;
        }

        @Contract(value=" -> new")
        @NotNull
        public abstract AbstractPacketExtension build();
    }
}

