/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.enforcer.DefaultEnforcementRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Mojo(name="enforce", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class EnforceMojo
extends AbstractMojo
implements Contextualizable {
    protected static Hashtable<String, EnforcerRule> cache = new Hashtable();
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="enforcer.skip", defaultValue="false")
    protected boolean skip = false;
    @Parameter(property="enforcer.fail", defaultValue="true")
    private boolean fail = true;
    @Parameter(property="enforcer.failFast", defaultValue="false")
    private boolean failFast = false;
    @Parameter(required=false)
    private EnforcerRule[] rules;
    @Parameter(required=false, property="rules")
    private String[] commandLineRules;
    @Parameter(property="enforcer.ignoreCache", defaultValue="false")
    protected boolean ignoreCache = false;
    protected PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private boolean havingRules() {
        return this.rules != null && this.rules.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        EnforcerExpressionEvaluator evaluator = new EnforcerExpressionEvaluator(this.session, this.mojoExecution);
        if (this.commandLineRules != null && this.commandLineRules.length > 0) {
            this.rules = this.createRulesFromCommandLineOptions();
        }
        if (this.isSkip()) {
            log.info((CharSequence)"Skipping Rule Enforcement.");
            return;
        }
        if (!this.havingRules()) {
            throw new MojoExecutionException("No rules are configured. Use the skip flag if you want to disable execution.");
        }
        ArrayList<String> list = new ArrayList<String>();
        String currentRule = "Unknown";
        DefaultEnforcementRuleHelper helper = new DefaultEnforcementRuleHelper(this.session, (ExpressionEvaluator)evaluator, log, this.container);
        if (!this.fail) {
            this.failFast = false;
        }
        boolean hasErrors = false;
        for (int i = 0; i < this.rules.length; ++i) {
            EnforcerRule rule = this.rules[i];
            EnforcerLevel level = this.getLevel(rule);
            if (rule == null) continue;
            currentRule = rule.getClass().getName();
            log.debug((CharSequence)("Executing rule: " + currentRule));
            try {
                if (!this.ignoreCache && !this.shouldExecute(rule)) continue;
                EnforcerRule enforcerRule = rule;
                synchronized (enforcerRule) {
                    rule.execute((EnforcerRuleHelper)helper);
                    continue;
                }
            }
            catch (EnforcerRuleException e) {
                if (this.failFast && level == EnforcerLevel.ERROR) {
                    throw new MojoExecutionException(currentRule + " failed with message:" + System.lineSeparator() + e.getMessage(), (Exception)((Object)e));
                }
                String exceptionMessage = e.getMessage();
                if (exceptionMessage != null) {
                    log.debug((CharSequence)("Adding " + level + " message due to exception"), (Throwable)e);
                } else {
                    log.warn((CharSequence)("Rule " + i + ": " + currentRule + " failed without a message"), (Throwable)e);
                }
                if (level == EnforcerLevel.ERROR) {
                    hasErrors = true;
                    list.add("Rule " + i + ": " + currentRule + " failed with message:" + System.lineSeparator() + exceptionMessage);
                    continue;
                }
                list.add("Rule " + i + ": " + currentRule + " warned with message:" + System.lineSeparator() + exceptionMessage);
            }
        }
        if (!list.isEmpty()) {
            for (String failure : list) {
                log.warn((CharSequence)failure);
            }
            if (this.fail && hasErrors) {
                throw new MojoExecutionException("Some Enforcer rules have failed. Look above for specific messages explaining why the rule failed.");
            }
        }
    }

    private EnforcerRule[] createRulesFromCommandLineOptions() throws MojoExecutionException {
        EnforcerRule[] rules = new EnforcerRule[this.commandLineRules.length];
        for (int i = 0; i < this.commandLineRules.length; ++i) {
            String rule = this.commandLineRules[i];
            if (!rule.contains(".")) {
                rule = ((Object)((Object)this)).getClass().getPackage().getName() + "." + Character.toUpperCase(rule.charAt(0)) + rule.substring(1);
            }
            try {
                rules[i] = (EnforcerRule)Class.forName(rule).newInstance();
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create enforcer rules from command line argument", e);
            }
        }
        return rules;
    }

    protected boolean shouldExecute(EnforcerRule rule) {
        if (rule.isCacheable()) {
            Log log = this.getLog();
            log.debug((CharSequence)("Rule " + rule.getClass().getName() + " is cacheable."));
            String key = rule.getClass().getName() + " " + rule.getCacheId();
            if (cache.containsKey(key)) {
                log.debug((CharSequence)("Key " + key + " was found in the cache"));
                if (rule.isResultValid(cache.get(key))) {
                    log.debug((CharSequence)("The cached results are still valid. Skipping the rule: " + rule.getClass().getName()));
                    return false;
                }
            }
            cache.put(key, rule);
        }
        return true;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean theFail) {
        this.fail = theFail;
    }

    public EnforcerRule[] getRules() {
        return this.rules;
    }

    public void setRules(EnforcerRule[] theRules) {
        this.rules = theRules;
    }

    public void setFailFast(boolean theFailFast) {
        this.failFast = theFailFast;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    protected String createRuleMessage(int i, String currentRule, EnforcerRuleException e) {
        return "Rule " + i + ": " + currentRule + " failed with message:" + System.lineSeparator() + e.getMessage();
    }

    private EnforcerLevel getLevel(EnforcerRule rule) {
        if (rule instanceof EnforcerRule2) {
            return ((EnforcerRule2)rule).getLevel();
        }
        return EnforcerLevel.ERROR;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean theSkip) {
        this.skip = theSkip;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession theSession) {
        this.session = theSession;
    }
}

