/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromDependencies;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromDependencies.AbstractFromDependenciesMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="copy-dependencies", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class CopyDependenciesMojo
extends AbstractFromDependenciesMojo {
    @Parameter(property="mdep.copyPom", defaultValue="false")
    protected boolean copyPom = true;
    @Component
    protected ArtifactInstaller installer;
    @Component
    protected ArtifactRepositoryFactory repositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(property="mdep.useBaseVersion", defaultValue="true")
    protected boolean useBaseVersion = true;
    @Parameter(defaultValue="false")
    protected boolean addParentPoms;
    @Parameter
    protected boolean useJvmChmod = true;
    @Parameter
    protected boolean ignorePermissions;

    @Override
    protected void doExecute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact, this.addParentPoms);
        Set<Artifact> artifacts = dss.getResolvedDependencies();
        if (!this.useRepositoryLayout) {
            for (Artifact artifact : artifacts) {
                this.copyArtifact(artifact, this.isStripVersion(), this.prependGroupId, this.useBaseVersion, this.stripClassifier);
            }
        } else {
            try {
                ArtifactRepository targetRepository = this.repositoryFactory.createDeploymentArtifactRepository("local", this.outputDirectory.toURL().toExternalForm(), this.repositoryLayouts.get("default"), false);
                for (Artifact artifact : artifacts) {
                    this.installArtifact(artifact, targetRepository);
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not create outputDirectory repository", (Exception)e);
            }
        }
        Set<Artifact> skippedArtifacts = dss.getSkippedDependencies();
        for (Artifact artifact : skippedArtifacts) {
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
        if (this.isCopyPom() && !this.useRepositoryLayout) {
            this.copyPoms(this.getOutputDirectory(), artifacts, this.stripVersion);
            this.copyPoms(this.getOutputDirectory(), skippedArtifacts, this.stripVersion, this.stripClassifier);
        }
    }

    private void installArtifact(Artifact artifact, ArtifactRepository targetRepository) {
        try {
            if ("pom".equals(artifact.getType())) {
                this.installer.install(artifact.getFile(), artifact, targetRepository);
                this.installBaseSnapshot(artifact, targetRepository);
            } else {
                Artifact pomArtifact;
                this.installer.install(artifact.getFile(), artifact, targetRepository);
                this.installBaseSnapshot(artifact, targetRepository);
                if (this.isCopyPom() && (pomArtifact = this.getResolvedPomArtifact(artifact)).getFile() != null && pomArtifact.getFile().exists()) {
                    this.installer.install(pomArtifact.getFile(), pomArtifact, targetRepository);
                    this.installBaseSnapshot(pomArtifact, targetRepository);
                }
            }
        }
        catch (ArtifactInstallationException e) {
            this.getLog().warn((CharSequence)("unable to install " + artifact), (Throwable)e);
        }
    }

    private void installBaseSnapshot(Artifact artifact, ArtifactRepository targetRepository) throws ArtifactInstallationException {
        if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
            Artifact baseArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getScope(), artifact.getType());
            this.installer.install(artifact.getFile(), baseArtifact, targetRepository);
        }
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion, boolean prependGroupId, boolean useBaseVersion) throws MojoExecutionException {
        this.copyArtifact(artifact, removeVersion, prependGroupId, useBaseVersion, false);
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion, boolean prependGroupId, boolean useBaseVersion, boolean removeClassifier) throws MojoExecutionException {
        String destFileName = DependencyUtil.getFormattedFileName(artifact, removeVersion, prependGroupId, useBaseVersion, removeClassifier);
        File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerScope, this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
    }

    public void copyPoms(File destDir, Set<Artifact> artifacts, boolean removeVersion) throws MojoExecutionException {
        this.copyPoms(destDir, artifacts, removeVersion, false);
    }

    public void copyPoms(File destDir, Set<Artifact> artifacts, boolean removeVersion, boolean removeClassifier) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            File pomDestFile;
            Artifact pomArtifact = this.getResolvedPomArtifact(artifact);
            if (pomArtifact.getFile() == null || !pomArtifact.getFile().exists() || (pomDestFile = new File(destDir, DependencyUtil.getFormattedFileName(pomArtifact, removeVersion, this.prependGroupId, this.useBaseVersion, removeClassifier))).exists()) continue;
            this.copyFile(pomArtifact.getFile(), pomDestFile);
        }
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        try {
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.getLocal());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, this.useSubDirectoryPerArtifact, this.useSubDirectoryPerType, this.useSubDirectoryPerScope, this.useRepositoryLayout, this.stripVersion, this.outputDirectory);
    }

    public boolean isCopyPom() {
        return this.copyPom;
    }

    public void setCopyPom(boolean copyPom) {
        this.copyPom = copyPom;
    }
}

