/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.framework.concurrency;

import io.kotest.common.ExperimentalKotest;
import io.kotest.framework.concurrency.Interval;
import io.kotest.framework.concurrency.IntervalKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/kotest/framework/concurrency/FibonacciInterval;", "Lio/kotest/framework/concurrency/Interval;", "base", "", "offset", "", "max", "(JILjava/lang/Long;)V", "Ljava/lang/Long;", "next", "count", "toString", "", "Companion", "kotest-framework-concurrency"})
@ExperimentalKotest
public final class FibonacciInterval
implements Interval {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long base;
    private final int offset;
    @Nullable
    private final Long max;
    public static final long defaultMax = 0x6DDD00L;

    public FibonacciInterval(long base, int offset, @Nullable Long max) {
        this.base = base;
        this.offset = offset;
        this.max = max;
        if (!(this.offset >= 0)) {
            boolean bl = false;
            String string = "Offset must be greater than or equal to 0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("FibonacciInterval(").append("base").append('=').append(this.base).append(", ").append("offset").append('=').append(this.offset).append(", ").append("max").append('=');
        Object object = this.max;
        if (object == null || (object = ((Long)object).toString()) == null) {
            object = "null";
        }
        return stringBuilder.append((String)object).append(')').toString();
    }

    @Override
    public long next(int count) {
        long total = this.base * (long)IntervalKt.fibonacci(this.offset + count);
        return this.max == null ? total : Math.min(this.max, total);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/kotest/framework/concurrency/FibonacciInterval$Companion;", "", "()V", "defaultMax", "", "kotest-framework-concurrency"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

