/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.utils.ArtifactMatcher;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                children.add(depNode.getArtifact());
                Set<Artifact> subNodes = ArtifactUtils.getAllDescendants(depNode);
                if (subNodes == null) continue;
                children.addAll(subNodes);
            }
        }
        return children;
    }

    public static Set<Artifact> checkDependencies(Set<Artifact> dependencies, List<String> thePatterns) throws EnforcerRuleException {
        HashSet<Artifact> foundMatches = null;
        if (thePatterns != null && thePatterns.size() > 0) {
            for (String pattern : thePatterns) {
                Object[] subStrings = pattern.split(":");
                subStrings = StringUtils.stripAll((String[])subStrings);
                String resultPattern = StringUtils.join((Object[])subStrings, (String)":");
                for (Artifact artifact : dependencies) {
                    if (!ArtifactUtils.compareDependency(resultPattern, artifact)) continue;
                    if (foundMatches == null) {
                        foundMatches = new HashSet<Artifact>();
                    }
                    foundMatches.add(artifact);
                }
            }
        }
        return foundMatches;
    }

    private static boolean compareDependency(String pattern, Artifact artifact) throws EnforcerRuleException {
        boolean result;
        ArtifactMatcher.Pattern am = new ArtifactMatcher.Pattern(pattern);
        try {
            result = am.match(artifact);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new EnforcerRuleException("Invalid Version Range: ", (Exception)((Object)e));
        }
        return result;
    }
}

