/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.ExtensionsKt;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/github/ajalt/colormath/Ansi256;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "code", "", "(I)V", "getCode", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toAnsi16", "Lcom/github/ajalt/colormath/Ansi16;", "toAnsi256", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colorconversion"})
public final class Ansi256
implements ConvertibleColor {
    private final int code;

    @Override
    @NotNull
    public RGB toRGB() {
        if (this.code < 16) {
            return this.toAnsi16().toRGB();
        }
        if (this.code >= 232) {
            int c = (this.code - 232) * 10 + 8;
            return new RGB(c, c, c);
        }
        int c = this.code - 16;
        int rem = c % 36;
        double r = Math.floor((double)c / 36.0) / 5.0 * (double)255;
        double g = Math.floor((double)rem / 6.0) / 5.0 * (double)255;
        double b = (double)(rem % 6) / 5.0 * (double)255;
        return new RGB(ExtensionsKt.roundToInt(r), ExtensionsKt.roundToInt(g), ExtensionsKt.roundToInt(b));
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return this;
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this.code < 8 ? new Ansi16(this.code + 30) : (this.code < 16 ? new Ansi16(this.code - 8 + 90) : this.toRGB().toAnsi16());
    }

    public final int getCode() {
        return this.code;
    }

    public Ansi256(int code) {
        int n = this.code = code;
        int n2 = n = 0 <= n && 255 >= n ? 1 : 0;
        if (n == 0) {
            String string = "code must be in range [0,255]: " + this.code;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return ConvertibleColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return ConvertibleColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return ConvertibleColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return ConvertibleColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return ConvertibleColor.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.code;
    }

    @NotNull
    public final Ansi256 copy(int code) {
        return new Ansi256(code);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Ansi256 copy$default(Ansi256 ansi256, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ansi256.code;
        }
        return ansi256.copy(n);
    }

    public String toString() {
        return "Ansi256(code=" + this.code + ")";
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Ansi256)) break block3;
                Ansi256 ansi256 = (Ansi256)object;
                if (!(this.code == ansi256.code)) break block3;
            }
            return true;
        }
        return false;
    }
}

