/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.platform;

import io.mockk.impl.platform.Disposable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010!\u001a\u00020\u001aH\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u001cH\u0016J\u001f\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\u00020\u001a2\u0014\u0010(\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010)H\u0016J\u0017\u0010*\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lio/mockk/impl/platform/JvmWeakConcurrentMap;", "K", "V", "", "()V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "queue", "Ljava/lang/ref/ReferenceQueue;", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "expunge", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "StrongKey", "WeakKey", "mockk"})
public final class JvmWeakConcurrentMap<K, V>
implements Map<K, V>,
KMutableMap {
    private final ConcurrentHashMap<Object, V> map = new ConcurrentHashMap();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    @Override
    @Nullable
    public V get(Object key) {
        return this.map.get(new StrongKey<Object>(key));
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.expunge();
        return this.map.put(new WeakKey<K>(key, this.queue), value);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        this.expunge();
        return this.map.remove(new StrongKey<Object>(key));
    }

    private final void expunge() {
        Reference<K> ref = this.queue.poll();
        while (ref != null) {
            V value = this.map.remove(ref);
            if (value instanceof Disposable) {
                ((Disposable)value).dispose();
            }
            ref = this.queue.poll();
        }
    }

    public int getSize() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        throw (Throwable)new UnsupportedOperationException("putAll");
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        throw (Throwable)new UnsupportedOperationException("entries");
    }

    @NotNull
    public Set<K> getKeys() {
        throw (Throwable)new UnsupportedOperationException("entries");
    }

    @NotNull
    public Collection<V> getValues() {
        Collection<V> collection = this.map.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"map.values");
        return collection;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mockk/impl/platform/JvmWeakConcurrentMap$WeakKey;", "K", "Ljava/lang/ref/WeakReference;", "key", "queue", "Ljava/lang/ref/ReferenceQueue;", "(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V", "hashCode", "", "equals", "", "other", "", "mockk"})
    private static final class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            Object key = this.get();
            if (key != null) {
                if (other instanceof WeakKey) {
                    return key == ((WeakKey)other).get();
                }
                if (other instanceof StrongKey) {
                    return key == ((StrongKey)other).get();
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public WeakKey(K key, @NotNull ReferenceQueue<K> queue) {
            Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\r\u0010\u000b\u001a\u0004\u0018\u00018\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lio/mockk/impl/platform/JvmWeakConcurrentMap$StrongKey;", "K", "", "key", "(Ljava/lang/Object;)V", "hashCode", "", "Ljava/lang/Object;", "equals", "", "other", "get", "()Ljava/lang/Object;", "mockk"})
    private static final class StrongKey<K> {
        private final int hashCode;
        private final K key;

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            K key = this.get();
            if (key != null) {
                if (other instanceof WeakKey) {
                    return key == ((WeakKey)other).get();
                }
                if (other instanceof StrongKey) {
                    return key == ((StrongKey)other).get();
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Nullable
        public final K get() {
            return this.key;
        }

        public StrongKey(K key) {
            this.key = key;
            this.hashCode = System.identityHashCode(this.key);
        }
    }
}

