/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jitsi.rest.MuxServerConnector;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class AbstractJettyBundleActivator
implements BundleActivator {
    public static final String JETTY_HOST_PNAME = ".jetty.host";
    public static final String JETTY_PORT_PNAME = ".jetty.port";
    static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD = ".jetty.sslContextFactory.keyStorePassword";
    static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH = ".jetty.sslContextFactory.keyStorePath";
    static final String JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH = ".jetty.sslContextFactory.needClientAuth";
    public static final String JETTY_TLS_PORT_PNAME = ".jetty.tls.port";
    private static final Logger logger;
    protected ConfigurationService cfg;
    protected final String propertyPrefix;
    protected Server server;

    protected static Handler initializeHandlerList(List<Handler> handlers) {
        int handlerCount = handlers.size();
        if (handlerCount == 1) {
            return handlers.get(0);
        }
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(handlers.toArray(new Handler[handlerCount]));
        return handlerList;
    }

    protected AbstractJettyBundleActivator(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    protected void didStart(BundleContext bundleContext) throws Exception {
    }

    protected void didStop(BundleContext bundleContext) throws Exception {
    }

    protected void doStart(BundleContext bundleContext) throws Exception {
        try {
            Server server = this.initializeServer(bundleContext);
            server.start();
            this.server = server;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to initialize and/or start a new Jetty HTTP(S) server instance.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    protected void doStop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    protected boolean getCfgBoolean(String property, boolean defaultValue) {
        return ConfigUtils.getBoolean((ConfigurationService)this.cfg, (String)this.prefixProperty(property), (boolean)defaultValue);
    }

    protected int getCfgInt(String property, int defaultValue) {
        return ConfigUtils.getInt((ConfigurationService)this.cfg, (String)this.prefixProperty(property), (int)defaultValue);
    }

    protected String getCfgString(String property, String defaultValue) {
        return ConfigUtils.getString((ConfigurationService)this.cfg, (String)this.prefixProperty(property), (String)defaultValue);
    }

    protected int getDefaultPort() {
        return 8080;
    }

    protected int getDefaultTlsPort() {
        return 8443;
    }

    private int getPort() {
        if (this.isTls()) {
            return this.getCfgInt(JETTY_TLS_PORT_PNAME, this.getDefaultTlsPort());
        }
        return this.getCfgInt(JETTY_PORT_PNAME, this.getDefaultPort());
    }

    protected boolean isTls() {
        String sslContextFactoryKeyStorePath = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH, null);
        return sslContextFactoryKeyStorePath != null;
    }

    private Connector initializeConnector(Server server) throws Exception {
        MuxServerConnector connector;
        HttpConfiguration httpCfg = new HttpConfiguration();
        int tlsPort = this.getCfgInt(JETTY_TLS_PORT_PNAME, this.getDefaultTlsPort());
        httpCfg.setSecurePort(tlsPort);
        httpCfg.setSecureScheme("https");
        String sslContextFactoryKeyStorePath = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH, null);
        if (sslContextFactoryKeyStorePath == null) {
            connector = new MuxServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpCfg)});
        } else {
            File sslContextFactoryKeyStoreFile = ConfigUtils.getAbsoluteFile((String)sslContextFactoryKeyStorePath, (ConfigurationService)this.cfg);
            SslContextFactory sslContextFactory = new SslContextFactory();
            String sslContextFactoryKeyStorePassword = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD, null);
            boolean sslContextFactoryNeedClientAuth = this.getCfgBoolean(JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH, false);
            sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", ".*NULL.*", ".*RC4.*", ".*MD5.*", ".*DES.*", ".*DSS.*"});
            sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_DHE_RSA.*", "TLS_ECDHE.*"});
            sslContextFactory.setExcludeProtocols(new String[]{"SSLv3", "TLSv1", "TLSv1.1"});
            sslContextFactory.setRenegotiationAllowed(false);
            if (sslContextFactoryKeyStorePassword != null) {
                sslContextFactory.setKeyStorePassword(sslContextFactoryKeyStorePassword);
            }
            sslContextFactory.setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
            sslContextFactory.setNeedClientAuth(sslContextFactoryNeedClientAuth);
            HttpConfiguration httpsCfg = new HttpConfiguration(httpCfg);
            httpsCfg.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new MuxServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsCfg)});
        }
        this.setPort((Connector)connector, this.getPort());
        String host = this.getCfgString(JETTY_HOST_PNAME, null);
        if (host != null) {
            this.setHost((Connector)connector, host);
        }
        return connector;
    }

    protected Handler initializeHandler(BundleContext bundleContext, Server server) throws Exception {
        return this.initializeHandlerList(bundleContext, server);
    }

    protected abstract Handler initializeHandlerList(BundleContext var1, Server var2) throws Exception;

    protected Server initializeServer(BundleContext bundleContext) throws Exception {
        Server server = new Server();
        Connector connector = this.initializeConnector(server);
        server.addConnector(connector);
        Handler handler = this.initializeHandler(bundleContext, server);
        if (handler != null) {
            server.setHandler(handler);
        }
        return server;
    }

    protected String prefixProperty(String property) {
        if (this.propertyPrefix != null && property != null && property.startsWith(".")) {
            property = this.propertyPrefix + property;
        }
        return property;
    }

    protected void setHost(Connector connector, String host) throws Exception {
        connector.getClass().getMethod("setHost", String.class).invoke((Object)connector, host);
    }

    protected void setPort(Connector connector, int port) throws Exception {
        connector.getClass().getMethod("setPort", Integer.TYPE).invoke((Object)connector, port);
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        boolean started = false;
        try {
            if (this.willStart(bundleContext)) {
                this.doStart(bundleContext);
                this.didStart(bundleContext);
                started = true;
            } else {
                logger.info((Object)("Not starting the Jetty service for " + this.getClass().getName() + "(port=" + this.getPort() + ")"));
            }
        }
        finally {
            if (!started) {
                this.cfg = null;
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.willStop(bundleContext)) {
                this.doStop(bundleContext);
                this.didStop(bundleContext);
            }
        }
        finally {
            this.cfg = null;
        }
    }

    protected boolean willStart(BundleContext bundleContext) throws Exception {
        return this.getPort() > 0;
    }

    protected boolean willStop(BundleContext bundleContext) throws Exception {
        return true;
    }

    static {
        String jettyLogLevelValue;
        logger = Logger.getLogger(AbstractJettyBundleActivator.class);
        String jettyLogLevelProperty = "org.eclipse.jetty.LEVEL";
        if (System.getProperty(jettyLogLevelProperty) == null && (jettyLogLevelValue = logger.isDebugEnabled() ? "DEBUG" : (logger.isInfoEnabled() ? "INFO" : null)) != null) {
            System.setProperty(jettyLogLevelProperty, jettyLogLevelValue);
        }
    }
}

