/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.meet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.impl.configuration.ConfigurationServiceImpl;
import org.jitsi.meet.OSGi;
import org.jitsi.meet.OSGiBundleConfig;
import org.jitsi.meet.OSGiClassLoader;
import org.jitsi.retry.RetryStrategy;
import org.jitsi.retry.SimpleRetryTask;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.xmpp.component.ComponentBase;
import org.jivesoftware.whack.ExternalComponentManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.xeustechnologies.jcl.JarClassLoader;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;

public class ComponentMain {
    private static final Logger logger = Logger.getLogger(ComponentMain.class);
    private static final Object exitSyncRoot = new Object();
    private ComponentBase component;
    private ExternalComponentManager componentManager;
    private RetryStrategy connectRetry;
    private final Object connectSynRoot = new Object();
    private ScheduledExecutorService executorService;

    public void runMainProgramLoop(OSGiBundleConfig bundleConfig) {
        this.runMainProgramLoop(null, bundleConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMainProgramLoop(ComponentBase component, OSGiBundleConfig bundleConfig) {
        ConfigurationServiceImpl.PASSWORD_SYS_PROPS = "pass";
        ConfigurationServiceImpl.PASSWORD_CMD_LINE_ARGS = "secret,user_password";
        OSGi.setBundleConfig(bundleConfig);
        bundleConfig.setSystemPropertyDefaults();
        ClassLoader classLoader = this.loadBundlesJars(bundleConfig);
        OSGi.setClassLoader(classLoader);
        BundleActivator activator = new BundleActivator(){

            public void start(BundleContext bundleContext) throws Exception {
                ComponentMain.registerShutdownService(bundleContext);
                ((ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class)).logConfigurationProperties("(pass)|(secret)");
            }

            public void stop(BundleContext bundleContext) throws Exception {
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = exitSyncRoot;
                synchronized (object) {
                    exitSyncRoot.notifyAll();
                }
            }
        });
        OSGi.start(activator);
        if (component == null || this.startComponent(component)) {
            try {
                Object object = exitSyncRoot;
                synchronized (object) {
                    exitSyncRoot.wait();
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        this.stopComponent();
        OSGi.stop(activator);
    }

    private ClassLoader loadBundlesJars(OSGiBundleConfig bundleConfig) {
        String bundlesJarsPath = bundleConfig.getBundlesJarsPath();
        if (bundlesJarsPath == null) {
            return this.getPlatformClassLoader();
        }
        JarClassLoader jcl = new JarClassLoader();
        jcl.add(bundlesJarsPath + "/");
        return new OSGiClassLoader(jcl, this.getPlatformClassLoader());
    }

    private ClassLoader getPlatformClassLoader() {
        ClassLoader cl;
        try {
            Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
            cl = (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException t) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private boolean startComponent(ComponentBase component) {
        this.component = component;
        String host = component.getHostname();
        int port = component.getPort();
        this.componentManager = new ExternalComponentManager(host, port, false);
        String componentSubDomain = component.getSubdomain();
        this.componentManager.setSecretKey(componentSubDomain, component.getSecret());
        this.componentManager.setServerName(component.getDomain());
        this.executorService = Executors.newScheduledThreadPool(1);
        component.init();
        this.connectRetry = new RetryStrategy(this.executorService);
        this.connectRetry.runRetryingTask(new SimpleRetryTask(0L, 5000L, true, this.getConnectCallable()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopComponent() {
        Object object = this.connectSynRoot;
        synchronized (object) {
            if (this.component == null || this.componentManager == null) {
                return;
            }
            if (this.connectRetry != null) {
                this.connectRetry.cancel();
                this.connectRetry = null;
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            this.component.shutdown();
            try {
                this.componentManager.removeComponent(this.component.getSubdomain());
            }
            catch (ComponentException e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.component.dispose();
            this.component = null;
            this.componentManager = null;
        }
    }

    private Callable<Boolean> getConnectCallable() {
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    Object object = ComponentMain.this.connectSynRoot;
                    synchronized (object) {
                        if (ComponentMain.this.componentManager == null || ComponentMain.this.component == null) {
                            return false;
                        }
                        ComponentMain.this.componentManager.addComponent(ComponentMain.this.component.getSubdomain(), (Component)ComponentMain.this.component);
                        return false;
                    }
                }
                catch (ComponentException e) {
                    logger.error((Object)(e.getMessage() + ", host:" + ComponentMain.this.component.getHostname() + ", port:" + ComponentMain.this.component.getPort()), (Throwable)e);
                    return true;
                }
            }
        };
    }

    private static void registerShutdownService(BundleContext bundleContext) {
        bundleContext.registerService(ShutdownService.class, (Object)new ShutdownService(){
            private boolean shutdownStarted = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beginShutdown() {
                if (this.shutdownStarted) {
                    return;
                }
                this.shutdownStarted = true;
                Object object = exitSyncRoot;
                synchronized (object) {
                    exitSyncRoot.notifyAll();
                }
            }
        }, null);
    }
}

