/*
 * Decompiled with CFR 0.152.
 */
package org.opentelecoms.javax.sdp;

import gov.nist.javax.sdp.MediaDescriptionImpl;
import gov.nist.javax.sdp.SessionDescriptionImpl;
import gov.nist.javax.sdp.TimeDescriptionImpl;
import gov.nist.javax.sdp.fields.AttributeField;
import gov.nist.javax.sdp.fields.BandwidthField;
import gov.nist.javax.sdp.fields.ConnectionField;
import gov.nist.javax.sdp.fields.EmailField;
import gov.nist.javax.sdp.fields.InformationField;
import gov.nist.javax.sdp.fields.KeyField;
import gov.nist.javax.sdp.fields.MediaField;
import gov.nist.javax.sdp.fields.OriginField;
import gov.nist.javax.sdp.fields.PhoneField;
import gov.nist.javax.sdp.fields.ProtoVersionField;
import gov.nist.javax.sdp.fields.RepeatField;
import gov.nist.javax.sdp.fields.SessionNameField;
import gov.nist.javax.sdp.fields.TimeField;
import gov.nist.javax.sdp.fields.URIField;
import gov.nist.javax.sdp.fields.ZoneField;
import gov.nist.javax.sdp.parser.SDPAnnounceParser;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.BandWidth;
import javax.sdp.Connection;
import javax.sdp.EMail;
import javax.sdp.Info;
import javax.sdp.Key;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.Phone;
import javax.sdp.RepeatTime;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import javax.sdp.Time;
import javax.sdp.TimeDescription;
import javax.sdp.TimeZoneAdjustment;
import javax.sdp.URI;
import javax.sdp.Version;

public class NistSdpFactory
implements SdpFactory {
    public SessionDescription createSessionDescription() throws SdpException {
        SessionDescriptionImpl sd = new SessionDescriptionImpl();
        sd.setVersion(this.createVersion(0));
        try {
            sd.setOrigin(this.createOrigin("user", InetAddress.getLocalHost().toString()));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        sd.setSessionName(this.createSessionName("-"));
        Vector<TimeDescriptionImpl> times = new Vector<TimeDescriptionImpl>();
        TimeField tf = new TimeField();
        tf.setZero();
        times.addElement(new TimeDescriptionImpl(tf));
        sd.setTimeDescriptions(times);
        return sd;
    }

    public SessionDescription createSessionDescription(String s) throws SdpParseException {
        SDPAnnounceParser sap = new SDPAnnounceParser(s);
        try {
            return sap.parse();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BandWidth createBandwidth(String modifier, int value) {
        BandwidthField bw = new BandwidthField();
        try {
            bw.setBandwidth(value);
            bw.setType(modifier);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return bw;
    }

    public Attribute createAttribute(String name, String value) {
        AttributeField a = new AttributeField();
        try {
            a.setName(name);
            a.setValueAllowNull(value);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return a;
    }

    public Info createInfo(String value) {
        InformationField i = new InformationField();
        try {
            i.setValue(value);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return i;
    }

    public Phone createPhone(String value) {
        PhoneField p = new PhoneField();
        try {
            p.setValue(value);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return p;
    }

    public EMail createEMail(String value) {
        EmailField e = new EmailField();
        try {
            e.setValue(value);
        }
        catch (SdpException e1) {
            e1.printStackTrace();
            return null;
        }
        return e;
    }

    public URI createURI(URL value) throws SdpException {
        URIField u = new URIField();
        u.set(value);
        return u;
    }

    public SessionName createSessionName(String name) {
        SessionNameField sn = new SessionNameField();
        try {
            sn.setValue(name);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return sn;
    }

    public Key createKey(String method, String key) {
        KeyField k = new KeyField();
        try {
            k.setMethod(method);
            k.setKey(key);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return k;
    }

    public Version createVersion(int value) {
        ProtoVersionField pv = new ProtoVersionField();
        try {
            pv.setVersion(value);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return pv;
    }

    public Media createMedia(String media, int port, int numPorts, String transport, Vector staticRtpAvpTypes) throws SdpException {
        MediaField m = new MediaField();
        m.setMediaType(media);
        m.setMediaPort(port);
        m.setPortCount(numPorts);
        m.setProtocol(transport);
        m.setMediaFormats(staticRtpAvpTypes);
        return m;
    }

    public Origin createOrigin(String userName, String address) throws SdpException {
        OriginField o = new OriginField();
        o.setUsername(userName);
        o.setAddress(address);
        return o;
    }

    public Origin createOrigin(String userName, long sessionId, long sessionVersion, String networkType, String addrType, String address) throws SdpException {
        OriginField o = new OriginField();
        o.setUsername(userName);
        o.setSessionId(sessionId);
        o.setSessionVersion(sessionVersion);
        o.setNetworkType(networkType);
        return o;
    }

    public MediaDescription createMediaDescription(String media, int port, int numPorts, String transport, int[] staticRtpAvpTypes) throws IllegalArgumentException, SdpException {
        MediaDescriptionImpl md = new MediaDescriptionImpl();
        Vector<String> types = new Vector<String>();
        for (int type : staticRtpAvpTypes) {
            types.addElement(new Integer(type).toString());
        }
        Media m = this.createMedia(media, port, numPorts, transport, types);
        md.setMedia(m);
        return md;
    }

    public MediaDescription createMediaDescription(String media, int port, int numPorts, String transport, String[] formats) {
        MediaDescriptionImpl md = new MediaDescriptionImpl();
        Vector<String> types = new Vector<String>();
        for (String format : formats) {
            types.addElement(format);
        }
        try {
            Media m = this.createMedia(media, port, numPorts, transport, types);
            md.setMedia(m);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return md;
    }

    public TimeDescription createTimeDescription(Time t) throws SdpException {
        TimeDescription td = this.createTimeDescription();
        td.setTime(t);
        return td;
    }

    public TimeDescription createTimeDescription() throws SdpException {
        return new TimeDescriptionImpl();
    }

    public TimeDescription createTimeDescription(Date start, Date stop) throws SdpException {
        TimeDescription td = this.createTimeDescription();
        td.setTime(this.createTime(start, stop));
        return td;
    }

    public String formatMulticastAddress(String addr, int ttl, int numAddrs) {
        return addr + '/' + ttl + '/' + numAddrs;
    }

    public Connection createConnection(String netType, String addrType, String addr, int ttl, int numAddrs) throws SdpException {
        Connection c = this.createConnection(netType, addrType, addr);
        return c;
    }

    public Connection createConnection(String netType, String addrType, String addr) throws SdpException {
        Connection c = this.createConnection(addr);
        c.setNetworkType(netType);
        c.setAddressType(addrType);
        return c;
    }

    public Connection createConnection(String addr, int ttl, int numAddrs) throws SdpException {
        return this.createConnection(addr);
    }

    public Connection createConnection(String addr) throws SdpException {
        ConnectionField c = new ConnectionField();
        c.setAddress(addr);
        return c;
    }

    public Time createTime(Date start, Date stop) throws SdpException {
        Time t = this.createTime();
        t.setStart(start);
        t.setStop(stop);
        return t;
    }

    public Time createTime() throws SdpException {
        return new TimeField();
    }

    public RepeatTime createRepeatTime(int repeatInterval, int activeDuration, int[] offsets) {
        RepeatField rt = new RepeatField();
        try {
            rt.setRepeatInterval(repeatInterval);
            rt.setActiveDuration(activeDuration);
            rt.setOffsetArray(offsets);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return rt;
    }

    public TimeZoneAdjustment createTimeZoneAdjustment(Date d, int offset) {
        ZoneField z = new ZoneField();
        Hashtable<Date, Integer> t = new Hashtable<Date, Integer>(1);
        t.put(d, offset);
        try {
            z.setZoneAdjustments(t);
        }
        catch (SdpException e) {
            e.printStackTrace();
            return null;
        }
        return z;
    }

    public Date getDateFromNtp(long ntpTime) {
        return new Date((ntpTime - 2208988800L) * 1000L);
    }

    public long getNtpTime(Date d) throws SdpParseException {
        if (d == null) {
            return -1L;
        }
        return d.getTime() / 1000L + 2208988800L;
    }
}

