/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J)\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00170\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/shyiko/ktlint/internal/MavenDependencyResolver;", "", "baseDir", "Ljava/io/File;", "repositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "forceUpdate", "", "(Ljava/io/File;Ljava/lang/Iterable;Z)V", "repoSystem", "Lorg/eclipse/aether/RepositorySystem;", "getRepositories", "()Ljava/lang/Iterable;", "session", "Lorg/eclipse/aether/RepositorySystemSession;", "resolve", "", "artifacts", "", "Lorg/eclipse/aether/artifact/Artifact;", "([Lorg/eclipse/aether/artifact/Artifact;)Ljava/util/Collection;", "setTransferEventListener", "", "listener", "Lkotlin/Function1;", "Lorg/eclipse/aether/transfer/TransferEvent;", "Lkotlin/ParameterName;", "name", "event", "ktlint"})
public final class MavenDependencyResolver {
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession session;
    @NotNull
    private final Iterable<RemoteRepository> repositories;

    public final void setTransferEventListener(@NotNull Function1<? super TransferEvent, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        RepositorySystemSession repositorySystemSession = this.session;
        if (repositorySystemSession == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.eclipse.aether.DefaultRepositorySystemSession");
        }
        ((DefaultRepositorySystemSession)repositorySystemSession).setTransferListener(new TransferListener(listener){
            final /* synthetic */ Function1 $listener;

            public void transferProgressed(@NotNull TransferEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$listener.invoke((Object)event);
            }

            public void transferStarted(@NotNull TransferEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$listener.invoke((Object)event);
            }

            public void transferInitiated(@NotNull TransferEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$listener.invoke((Object)event);
            }

            public void transferSucceeded(@NotNull TransferEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$listener.invoke((Object)event);
            }

            public void transferCorrupted(@NotNull TransferEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$listener.invoke((Object)event);
            }

            public void transferFailed(@NotNull TransferEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$listener.invoke((Object)event);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Collection<File> resolve(Artifact ... artifacts) {
        Intrinsics.checkParameterIsNotNull((Object)artifacts, (String)"artifacts");
        CollectRequest collectRequest = new CollectRequest();
        for (Object element$iv : (Object[])artifacts) {
            Artifact it = (Artifact)element$iv;
            collectRequest.addDependency(new Dependency(it, "compile"));
        }
        Iterable<RemoteRepository> $receiver$iv = this.repositories;
        DependencyRequest dependencyRequest = $receiver$iv.iterator();
        while (dependencyRequest.hasNext()) {
            Object element$iv = dependencyRequest.next();
            RemoteRepository it = (RemoteRepository)element$iv;
            collectRequest.addRepository(it);
        }
        DependencyNode node = this.repoSystem.collectDependencies(this.session, collectRequest).getRoot();
        dependencyRequest = new DependencyRequest();
        RepositorySystemSession repositorySystemSession = this.session;
        RepositorySystem repositorySystem = this.repoSystem;
        DependencyRequest $receiver = dependencyRequest;
        $receiver.setRoot(node);
        DependencyRequest dependencyRequest2 = dependencyRequest;
        repositorySystem.resolveDependencies(repositorySystemSession, dependencyRequest2);
        $receiver = dependencyRequest = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)$receiver);
        List list = dependencyRequest.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PreorderNodeListGenerato\u2026node.accept(this) }.files");
        return list;
    }

    @NotNull
    public final Iterable<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public MavenDependencyResolver(@NotNull File baseDir, @NotNull Iterable<RemoteRepository> repositories, boolean forceUpdate) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        this.repositories = repositories;
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(@Nullable Class<?> type, @Nullable Class<?> impl, @NotNull Throwable ex) {
                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                throw ex;
            }
        });
        Object object = locator.getService(RepositorySystem.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"locator.getService(RepositorySystem::class.java)");
        this.repoSystem = (RepositorySystem)object;
        DefaultRepositorySystemSession defaultRepositorySystemSession = MavenRepositorySystemUtils.newSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultRepositorySystemSession, (String)"MavenRepositorySystemUtils.newSession()");
        this.session = (RepositorySystemSession)defaultRepositorySystemSession;
        ((DefaultRepositorySystemSession)this.session).setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(this.session, new LocalRepository(baseDir)));
        ((DefaultRepositorySystemSession)this.session).setUpdatePolicy(forceUpdate ? "always" : "never");
    }
}

