/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class FSDeltaConsumer
implements ISVNDeltaConsumer {
    private String myBasePath;
    private FSTransactionRoot myTxnRoot;
    private FSFS myFSFS;
    private FSCommitter myCommitter;
    private SVNDeltaProcessor myDeltaProcessor;
    private FSOutputStream myTargetStream;
    private String myAuthor;
    private Collection myLockTokens;
    private SVNDeltaCombiner myDeltaCombiner;

    public FSDeltaConsumer(String basePath, FSTransactionRoot txnRoot, FSFS fsfs, FSCommitter committer, String author, Collection lockTokens) {
        this.myBasePath = basePath;
        this.myTxnRoot = txnRoot;
        this.myFSFS = fsfs;
        this.myCommitter = committer;
        this.myAuthor = author;
        this.myLockTokens = lockTokens != null ? lockTokens : Collections.EMPTY_LIST;
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        String md5HexChecksum;
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        FSParentPath parentPath = this.myTxnRoot.openPath(fullPath, true, true);
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, fullPath, this.myAuthor, this.myLockTokens, false, false);
        }
        this.myCommitter.makePathMutable(parentPath, fullPath);
        FSRevisionNode node = parentPath.getRevNode();
        if (baseChecksum != null && (md5HexChecksum = node.getFileChecksum()) != null && !md5HexChecksum.equals(baseChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Base checksum mismatch on ''{0}'':\n   expected:  {1}\n     actual:  {2}\n", new Object[]{path, baseChecksum, md5HexChecksum});
            SVNErrorManager.error(err);
        }
        InputStream sourceStream = null;
        OutputStream targetStream = null;
        int dbFormat = this.myFSFS.getDBFormat();
        try {
            sourceStream = FSInputStream.createDeltaStream(this.getCombiner(), node, this.myFSFS);
            targetStream = FSOutputStream.createStream(node, this.myTxnRoot, this.myTargetStream, dbFormat >= 2);
            if (this.myDeltaProcessor == null) {
                this.myDeltaProcessor = new SVNDeltaProcessor();
            }
            this.myDeltaProcessor.applyTextDelta(sourceStream, targetStream, false);
        }
        catch (SVNException svne) {
            SVNFileUtil.closeFile(sourceStream);
            throw svne;
        }
        finally {
            this.myTargetStream = (FSOutputStream)targetStream;
        }
        this.myCommitter.addChange(fullPath, node.getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, true, false, -1L, null);
    }

    public void applyText(String path) throws SVNException {
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        FSParentPath parentPath = this.myTxnRoot.openPath(fullPath, true, true);
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, fullPath, this.myAuthor, this.myLockTokens, false, false);
        }
        this.myCommitter.makePathMutable(parentPath, fullPath);
        FSRevisionNode node = parentPath.getRevNode();
        InputStream sourceStream = null;
        OutputStream targetStream = null;
        int dbFormat = this.myFSFS.getDBFormat();
        try {
            sourceStream = SVNFileUtil.DUMMY_IN;
            targetStream = FSOutputStream.createStream(node, this.myTxnRoot, this.myTargetStream, dbFormat >= 2);
            if (this.myDeltaProcessor == null) {
                this.myDeltaProcessor = new SVNDeltaProcessor();
            }
            this.myDeltaProcessor.applyTextDelta(sourceStream, targetStream, false);
        }
        catch (SVNException svne) {
            throw svne;
        }
        finally {
            this.myTargetStream = (FSOutputStream)targetStream;
        }
        this.myCommitter.addChange(fullPath, node.getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, true, false, -1L, null);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void abort() {
        if (this.myTargetStream != null) {
            this.myTargetStream.closeStreams();
        }
    }

    private SVNDeltaCombiner getCombiner() {
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        } else {
            this.myDeltaCombiner.reset();
        }
        return this.myDeltaCombiner;
    }
}

