/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.maven;

import com.sun.wts.tools.maven.SVNSSLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.X509Certificate;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class SVNConsoleAuthenticationProvider
implements ISVNAuthenticationProvider {
    private final boolean isInteractive;
    private final AuthenticationInfo auth;

    public SVNConsoleAuthenticationProvider(boolean interactive, AuthenticationInfo auth) {
        this.isInteractive = interactive;
        this.auth = auth;
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        if (!(certificate instanceof X509Certificate) || !this.isInteractive) {
            return 1;
        }
        String hostName = url.getHost();
        X509Certificate cert = (X509Certificate)certificate;
        StringBuffer prompt = SVNSSLUtil.getServerCertificatePrompt(cert, realm, hostName);
        if (resultMayBeStored) {
            prompt.append("\n(R)eject, accept (t)emporarily or accept (p)ermanently? ");
        } else {
            prompt.append("\n(R)eject or accept (t)emporarily? ");
        }
        System.out.print(prompt.toString());
        System.out.flush();
        try {
            char ch;
            do {
                int r;
                if ((r = System.in.read()) < 0) {
                    return 0;
                }
                ch = (char)(r & 0xFF);
                if (ch == 'R' || ch == 'r') {
                    return 0;
                }
                if (ch != 't' && ch != 'T') continue;
                return 1;
            } while (!resultMayBeStored || ch != 'p' && ch != 'P');
            return 2;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        if ("svn.simple".equals(kind)) {
            if (this.auth != null && this.auth.getPassword() != null) {
                return new SVNPasswordAuthentication(this.auth.getUserName(), this.auth.getPassword(), authMayBeStored);
            }
            String name = null;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            while (name == null) {
                name = this.prompt("Username");
                if (!"".equals(name)) continue;
                name = null;
            }
            String password = this.prompt("Password for '" + name + "'");
            if (password == null) {
                password = "";
            }
            return new SVNPasswordAuthentication(name, password, authMayBeStored);
        }
        if ("svn.ssh".equals(kind)) {
            if (this.auth != null) {
                if (this.auth.getPassword() != null) {
                    return new SVNSSHAuthentication(this.auth.getUserName(), this.auth.getPassword(), 22, authMayBeStored);
                }
                if (this.auth.getPrivateKey() != null) {
                    return new SVNSSHAuthentication(this.auth.getUserName(), new File(this.auth.getPrivateKey()), this.auth.getPassphrase(), 22, authMayBeStored);
                }
            }
            String name = null;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            while (name == null) {
                name = this.prompt("Username");
                if (!"".equals(name)) continue;
                name = null;
            }
            String password = this.prompt("Password for '" + url.getHost() + "' (leave blank if you are going to use private key)");
            if ("".equals(password)) {
                password = null;
            }
            String keyFile = null;
            String passphrase = null;
            if (password == null) {
                while (keyFile == null) {
                    File file;
                    keyFile = this.prompt("Private key for '" + url.getHost() + "' (OpenSSH format)");
                    if ("".equals(keyFile)) {
                        name = null;
                    }
                    if (!(file = new File(keyFile)).isFile() && !file.canRead() || !"".equals(passphrase = this.prompt("Private key passphrase [none]"))) continue;
                    passphrase = null;
                }
            }
            int port = 22;
            String portValue = this.prompt("Port number for '" + url.getHost() + "' [22]");
            if (portValue != null && !"".equals(portValue)) {
                try {
                    port = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (password != null) {
                return new SVNSSHAuthentication(name, password, port, authMayBeStored);
            }
            if (keyFile != null) {
                return new SVNSSHAuthentication(name, new File(keyFile), passphrase, port, authMayBeStored);
            }
        } else {
            if ("svn.username".equals(kind)) {
                if (this.auth != null && this.auth.getUserName() != null) {
                    return new SVNUserNameAuthentication(this.auth.getUserName(), authMayBeStored);
                }
                SVNConsoleAuthenticationProvider.printRealm(realm);
                String name = null;
                while (name == null) {
                    name = this.prompt(!"file".equals(url.getProtocol()) ? "Author name [" + System.getProperty("user.name") + "]" : "Username [" + System.getProperty("user.name") + "]");
                    if (!"".equals(name) && name != null) continue;
                    name = System.getProperty("user.name");
                }
                return new SVNUserNameAuthentication(name, authMayBeStored);
            }
            if ("svn.ssl".equals(kind)) {
                SVNConsoleAuthenticationProvider.printRealm(realm);
                String path = null;
                while (path == null) {
                    path = this.prompt("Client certificate filename");
                    if (!"".equals(path)) continue;
                    path = null;
                }
                String password = this.prompt("Passphrase for '" + realm + "'");
                if (password == null) {
                    password = "";
                }
                return new SVNSSLAuthentication(new File(path), password, authMayBeStored);
            }
        }
        return null;
    }

    private static void printRealm(String realm) {
        if (realm != null) {
            System.out.println("Authentication realm: " + realm);
            System.out.flush();
        }
    }

    private String prompt(String label) {
        if (!this.isInteractive) {
            return null;
        }
        System.out.print(label + ": ");
        System.out.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }
}

