/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.meet;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.jitsi.util.ConfigUtils;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.StringUtils;

public abstract class OSGiBundleConfig {
    private static final String BUNDLES_JARS_PATH = "bundles/";
    private static final String BUNDLES_FILE = "bundles.txt";
    private static final String EXTENSION_FILE = "extension_bundles.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[][] loadBundlesFromFile(String filename) {
        File file = ConfigUtils.getAbsoluteFile((String)filename, null);
        if (file == null || !file.exists()) {
            return null;
        }
        ArrayList<String[]> lines = new ArrayList<String[]>();
        try (Scanner input = null;){
            input = new Scanner(file);
            while (input.hasNextLine()) {
                String line = input.nextLine();
                if (StringUtils.isNullOrEmpty((String)line)) continue;
                lines.add(new String[]{line.trim()});
            }
        }
        return lines.isEmpty() ? (String[][])null : (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    public String[][] getBundles() {
        String[][] bundlesFromFile = this.loadBundlesFromFile(BUNDLES_FILE);
        String[][] extensionsBundlesFromFile = this.loadBundlesFromFile(EXTENSION_FILE);
        if (bundlesFromFile == null) {
            bundlesFromFile = this.getBundlesImpl();
        }
        String[][] allBundles = bundlesFromFile == null ? extensionsBundlesFromFile : (String[][])ArrayUtils.concat((Object[])bundlesFromFile, (Object[])extensionsBundlesFromFile);
        return allBundles;
    }

    protected abstract String[][] getBundlesImpl();

    public String getBundlesJarsPath() {
        File file = ConfigUtils.getAbsoluteFile((String)BUNDLES_JARS_PATH, null);
        if (file == null || !file.exists()) {
            File localPath = new File(BUNDLES_JARS_PATH);
            if (localPath == null || !localPath.exists()) {
                return null;
            }
            return localPath.getAbsolutePath();
        }
        return file.getAbsolutePath();
    }

    protected Map<String, String> getSystemPropertyDefaults() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        String true_ = Boolean.toString(true);
        defaults.put("net.java.sip.communicator.CONFIGURATION_FILE_IS_READ_ONLY", true_);
        defaults.put("net.java.sip.communicator.service.media.DISABLE_AUDIO_SUPPORT", true_);
        defaults.put("net.java.sip.communicator.service.media.DISABLE_VIDEO_SUPPORT", true_);
        return defaults;
    }

    public void setSystemPropertyDefaults() {
        Map<String, String> defaults = this.getSystemPropertyDefaults();
        for (Map.Entry<String, String> e : defaults.entrySet()) {
            String key = e.getKey();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, e.getValue());
        }
    }
}

