/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import org.jivesoftware.whack.ExternalComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.component.IQResultListener;
import org.xmpp.component.Log;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class ExternalComponentManager
implements ComponentManager {
    private static final Logger Logger = LoggerFactory.getLogger(ExternalComponentManager.class);
    private String host;
    private int port;
    private boolean startEncrypted;
    private String domain;
    private int connectTimeout = 2000;
    private String defaultSecretKey;
    private Map<String, String> secretKeys = new Hashtable<String, String>();
    private Map<String, Boolean> allowMultiple = new Hashtable<String, Boolean>();
    Preferences preferences = Preferences.userRoot();
    private String preferencesPrefix;
    private Map<String, ExternalComponent> componentsByDomain = new Hashtable<String, ExternalComponent>();
    private Map<Component, ExternalComponent> components = new Hashtable<Component, ExternalComponent>();
    @Deprecated
    private Log oldLogger;

    public ExternalComponentManager(String host) {
        this(host, 5275);
    }

    @Deprecated
    public ExternalComponentManager(String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException("Host of XMPP server cannot be null");
        }
        this.host = host;
        this.port = port;
        this.createDummyLogger();
        ComponentManagerFactory.setComponentManager((ComponentManager)this);
    }

    public ExternalComponentManager(String host, int port, boolean startEncrypted) {
        if (host == null) {
            throw new IllegalArgumentException("Host of XMPP server cannot be null");
        }
        this.host = host;
        this.port = port;
        this.startEncrypted = startEncrypted;
        this.createDummyLogger();
        ComponentManagerFactory.setComponentManager((ComponentManager)this);
    }

    public void setSecretKey(String subdomain, String secretKey) {
        this.secretKeys.put(subdomain, secretKey);
    }

    public String getSecretKey(String subdomain) {
        String secretKey = this.secretKeys.get(subdomain);
        if (secretKey == null) {
            secretKey = this.defaultSecretKey;
        }
        return secretKey;
    }

    public void setDefaultSecretKey(String secretKey) {
        this.defaultSecretKey = secretKey;
    }

    public boolean isMultipleAllowed(String subdomain) {
        Boolean allowed = this.allowMultiple.get(subdomain);
        return allowed != null && allowed != false;
    }

    public void setMultipleAllowed(String subdomain, boolean allowMultiple) {
        this.allowMultiple.put(subdomain, allowMultiple);
    }

    public void addComponent(String subdomain, Component component) throws ComponentException {
        this.addComponent(subdomain, component, this.port);
    }

    public void addComponent(String subdomain, Component component, Integer port) throws ComponentException {
        if (this.componentsByDomain.containsKey(subdomain)) {
            if (this.componentsByDomain.get(subdomain).getComponent() == component) {
                return;
            }
            throw new IllegalArgumentException("Subdomain already in use by another component");
        }
        ExternalComponent externalComponent = new ExternalComponent(component, this);
        try {
            this.componentsByDomain.put(subdomain, externalComponent);
            this.components.put(component, externalComponent);
            externalComponent.connect(this.host, port, subdomain, this.startEncrypted);
            JID componentJID = new JID(null, externalComponent.getDomain(), null);
            externalComponent.initialize(componentJID, this);
        }
        catch (ComponentException e) {
            this.componentsByDomain.remove(subdomain);
            this.components.remove(component);
            throw e;
        }
        externalComponent.start();
    }

    public void removeComponent(String subdomain) throws ComponentException {
        ExternalComponent externalComponent = this.componentsByDomain.remove(subdomain);
        if (externalComponent != null) {
            this.components.remove(externalComponent.getComponent());
            externalComponent.shutdown();
        }
    }

    public void sendPacket(Component component, Packet packet) {
        this.components.get(component).send(packet);
    }

    public IQ query(Component component, IQ packet, long timeout) throws ComponentException {
        final LinkedBlockingQueue answer = new LinkedBlockingQueue(8);
        ExternalComponent externalComponent = this.components.get(component);
        externalComponent.addIQResultListener(packet.getID(), new IQResultListener(){

            public void receivedAnswer(IQ packet) {
                answer.offer(packet);
            }

            public void answerTimeout(String packetId) {
            }
        }, timeout);
        this.sendPacket(component, (Packet)packet);
        IQ reply = null;
        try {
            reply = (IQ)answer.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return reply;
    }

    public void query(Component component, IQ packet, IQResultListener listener) throws ComponentException {
        ExternalComponent externalComponent = this.components.get(component);
        externalComponent.addIQResultListener(packet.getID(), listener, 300000L);
        this.sendPacket(component, (Packet)packet);
    }

    public String getProperty(String name) {
        return this.preferences.get(this.getPreferencesPrefix() + name, null);
    }

    public void setProperty(String name, String value) {
        this.preferences.put(this.getPreferencesPrefix() + name, value);
    }

    private String getPreferencesPrefix() {
        if (this.preferencesPrefix == null) {
            this.preferencesPrefix = "whack." + this.domain + ".";
        }
        return this.preferencesPrefix;
    }

    public void setServerName(String domain) {
        this.domain = domain;
    }

    public String getServerName() {
        return this.domain;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isExternalMode() {
        return true;
    }

    @Deprecated
    public Log getLog() {
        return this.oldLogger;
    }

    private void createDummyLogger() {
        this.oldLogger = new Log(){

            public void error(String message) {
                Logger.error(message);
            }

            public void error(String message, Throwable throwable) {
                Logger.error(message, throwable);
            }

            public void error(Throwable throwable) {
                Logger.error("", throwable);
            }

            public void warn(String message) {
                Logger.warn(message);
            }

            public void warn(String message, Throwable throwable) {
                Logger.warn(message, throwable);
            }

            public void warn(Throwable throwable) {
                Logger.warn("", throwable);
            }

            public void info(String message) {
                Logger.info(message);
            }

            public void info(String message, Throwable throwable) {
                Logger.info(message, throwable);
            }

            public void info(Throwable throwable) {
                Logger.info("", throwable);
            }

            public void debug(String message) {
                Logger.debug(message);
            }

            public void debug(String message, Throwable throwable) {
                Logger.debug(message, throwable);
            }

            public void debug(Throwable throwable) {
                Logger.debug("", throwable);
            }
        };
    }
}

