/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.osgi;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.osgi.ManifestReadingException;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

public class DefaultMaven2OsgiConverter
implements Maven2OsgiConverter {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    private String getBundleSymbolicName(String groupId, String artifactId) {
        return groupId + "." + artifactId;
    }

    public String getBundleSymbolicName(Artifact artifact) {
        String groupIdFromPackage;
        int i;
        if (artifact.getFile() != null && artifact.getFile().isFile()) {
            Analyzer analyzer = new Analyzer();
            JarFile jar = null;
            try {
                String symbolicNameAttribute;
                Parameters bundleSymbolicNameHeader;
                Iterator it;
                jar = new JarFile(artifact.getFile(), false);
                if (jar.getManifest() != null && (it = (bundleSymbolicNameHeader = analyzer.parseHeader(symbolicNameAttribute = jar.getManifest().getMainAttributes().getValue("Bundle-SymbolicName"))).keySet().iterator()).hasNext()) {
                    String string = (String)it.next();
                    return string;
                }
            }
            catch (IOException e) {
                throw new ManifestReadingException("Error reading manifest in jar " + artifact.getFile().getAbsolutePath(), e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if ((i = artifact.getGroupId().lastIndexOf(46)) < 0 && artifact.getFile() != null && artifact.getFile().isFile() && (groupIdFromPackage = this.getGroupIdFromPackage(artifact.getFile())) != null) {
            return groupIdFromPackage;
        }
        String lastSection = artifact.getGroupId().substring(++i);
        if (artifact.getArtifactId().equals(lastSection)) {
            return artifact.getGroupId();
        }
        if (artifact.getArtifactId().equals(artifact.getGroupId()) || artifact.getArtifactId().startsWith(artifact.getGroupId() + ".")) {
            return artifact.getArtifactId();
        }
        if (artifact.getArtifactId().startsWith(lastSection)) {
            String artifactId = artifact.getArtifactId().substring(lastSection.length());
            if (Character.isLetterOrDigit(artifactId.charAt(0))) {
                return this.getBundleSymbolicName(artifact.getGroupId(), artifactId);
            }
            return this.getBundleSymbolicName(artifact.getGroupId(), artifactId.substring(1));
        }
        return this.getBundleSymbolicName(artifact.getGroupId(), artifact.getArtifactId());
    }

    private String getGroupIdFromPackage(File artifactFile) {
        try {
            HashSet<String> packageNames = new HashSet<String>();
            JarFile jar = new JarFile(artifactFile, false);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                File f;
                String packageName;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class") || (packageName = (f = new File(entry.getName())).getParent()) == null) continue;
                packageNames.add(packageName);
            }
            jar.close();
            String[] groupIdSections = null;
            for (String packageName : packageNames) {
                int i;
                String[] packageNameSections = packageName.split("\\" + FILE_SEPARATOR);
                if (groupIdSections == null) {
                    groupIdSections = packageNameSections;
                    continue;
                }
                for (i = 0; i < packageNameSections.length && i < groupIdSections.length && packageNameSections[i].equals(groupIdSections[i]); ++i) {
                }
                groupIdSections = new String[i];
                System.arraycopy(packageNameSections, 0, groupIdSections, 0, i);
            }
            if (groupIdSections == null || groupIdSections.length == 0) {
                return null;
            }
            if (groupIdSections.length == 1) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < groupIdSections.length; ++i) {
                sb.append(groupIdSections[i]);
                if (i >= groupIdSections.length - 1) continue;
                sb.append('.');
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBundleFileName(Artifact artifact) {
        return this.getBundleSymbolicName(artifact) + "_" + this.getVersion(artifact.getVersion()) + ".jar";
    }

    public String getVersion(Artifact artifact) {
        return this.getVersion(artifact.getVersion());
    }

    public String getVersion(String version) {
        return DefaultMaven2OsgiConverter.cleanupVersion(version);
    }

    public static String cleanupVersion(String version) {
        StringBuffer result = new StringBuffer();
        Matcher m = FUZZY_VERSION.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            DefaultMaven2OsgiConverter.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        DefaultMaven2OsgiConverter.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    DefaultMaven2OsgiConverter.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            DefaultMaven2OsgiConverter.cleanupModifier(result, version);
        }
        return result.toString();
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }
}

