/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 -2\u00020\u0001:\u0006()*+,-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overridesBackwardCompatibilityHelper", "Lorg/jetbrains/kotlin/resolve/OverridesBackwardCompatibilityHelper;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverridesBackwardCompatibilityHelper;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkNameAndDefaultForDeclaredParameter", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "multipleDefaultsInSuper", "", "checkNameAndDefaultForFakeOverrideParameter", "containingFunction", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkOverrideForComponentFunction", "componentFunction", "checkOverrideForCopyFunction", "copyFunction", "checkOverrideForMember", "declared", "checkOverrides", "checkOverridesForParameters", "checkOverridesInAClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkParameterOverridesForAllClasses", "checkVisibility", "checkVisibilityForMember", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "memberDescriptor", "CheckInheritedSignaturesReportStrategy", "CheckOverrideReportForDeclaredMemberStrategy", "CheckOverrideReportStrategy", "CollectErrorInformationForInheritedMembersStrategy", "CollectMissingImplementationsStrategy", "Companion", "frontend"})
public final class OverrideResolver {
    private final BindingTrace trace;
    private final OverridesBackwardCompatibilityHelper overridesBackwardCompatibilityHelper;
    private final LanguageVersionSettings languageVersionSettings;
    public static final Companion Companion = new Companion(null);

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        this.checkVisibility(c);
        this.checkOverrides(c);
        this.checkParameterOverridesForAllClasses(c);
    }

    private final void checkOverrides(TopDownAnalysisContext c) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map2 = c.getDeclaredClasses();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"c.declaredClasses");
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map3 = map2;
        boolean bl = false;
        Iterator<Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes value;
            Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry;
            Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            KtClassOrObject key = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = value = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"value");
            KtClassOrObject ktClassOrObject = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject, (String)"key");
            this.checkOverridesInAClass(classDescriptorWithResolutionScopes, ktClassOrObject);
        }
    }

    private final void checkOverridesInAClass(ClassDescriptorWithResolutionScopes classDescriptor2, KtClassOrObject klass2) {
        Iterator<CallableMemberDescriptor> iterator2 = classDescriptor2.getDeclaredCallableMembers().iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor member;
            CallableMemberDescriptor callableMemberDescriptor = member = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
            this.checkOverrideForMember(callableMemberDescriptor);
        }
        CollectErrorInformationForInheritedMembersStrategy inheritedMemberErrors = new CollectErrorInformationForInheritedMembersStrategy(klass2, classDescriptor2);
        OverrideResolver.Companion.checkInheritedAndDelegatedSignatures(classDescriptor2, inheritedMemberErrors, inheritedMemberErrors);
        inheritedMemberErrors.doReportErrors$frontend();
    }

    private final void checkOverrideForMember(CallableMemberDescriptor declared) {
        if (declared.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            Name name = declared.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"declared.name");
            if (DataClassDescriptorResolver.INSTANCE.isComponentLike(name)) {
                this.checkOverrideForComponentFunction(declared);
            } else if (Intrinsics.areEqual((Object)declared.getName(), (Object)DataClassDescriptorResolver.INSTANCE.getCOPY_METHOD_NAME())) {
                this.checkOverrideForCopyFunction(declared);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(declared);
        if (ktNamedDeclaration == null) {
            throw (Throwable)new IllegalStateException("declared descriptor is not resolved to declaration: " + declared);
        }
        KtNamedDeclaration member = ktNamedDeclaration;
        KtModifierList modifierList = member.getModifierList();
        boolean hasOverrideNode = modifierList != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        Collection<? extends CallableMemberDescriptor> collection = declared.getOverriddenDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"declared.overriddenDescriptors");
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = collection;
        if (hasOverrideNode) {
            OverrideResolver.Companion.checkOverridesForMemberMarkedOverride(declared, new CheckOverrideReportForDeclaredMemberStrategy(this, member, declared){
                private boolean finalOverriddenError;
                private boolean typeMismatchError;
                private boolean kindMismatchError;
                final /* synthetic */ OverrideResolver this$0;
                final /* synthetic */ KtNamedDeclaration $member;
                final /* synthetic */ CallableMemberDescriptor $declared;

                public void overridingFinalMember(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
                    Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                    Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                    if (!this.finalOverriddenError) {
                        this.finalOverriddenError = true;
                        OverrideResolver.access$getTrace$p(this.this$0).report(Errors.OVERRIDING_FINAL_MEMBER.on((KtNamedDeclaration)((PsiElement)this.$member), overridden, overridden.getContainingDeclaration()));
                    }
                }

                public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
                    Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                    Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.access$getTrace$p(this.this$0).report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on((KtNamedDeclaration)((PsiElement)this.$member), this.$declared, overridden));
                    }
                }

                public void propertyTypeMismatchOnOverride(@NotNull PropertyDescriptor overriding, @NotNull PropertyDescriptor overridden) {
                    Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                    Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        if (overridden.isVar()) {
                            OverrideResolver.access$getTrace$p(this.this$0).report(Errors.VAR_TYPE_MISMATCH_ON_OVERRIDE.on((KtNamedDeclaration)((PsiElement)this.$member), this.$declared, overridden));
                        } else {
                            OverrideResolver.access$getTrace$p(this.this$0).report(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE.on((KtNamedDeclaration)((PsiElement)this.$member), this.$declared, overridden));
                        }
                    }
                }

                public void varOverriddenByVal(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
                    Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                    Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                    if (!this.kindMismatchError) {
                        this.kindMismatchError = true;
                        CallableMemberDescriptor callableMemberDescriptor = this.$declared;
                        if (callableMemberDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        }
                        OverrideResolver.access$getTrace$p(this.this$0).report(Errors.VAR_OVERRIDDEN_BY_VAL.on((KtNamedDeclaration)((PsiElement)this.$member), (PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)overridden));
                    }
                }

                public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor invisibleOverridden) {
                    Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                    Intrinsics.checkParameterIsNotNull((Object)invisibleOverridden, (String)"invisibleOverridden");
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on((KtModifierListOwner)((PsiElement)this.$member), this.$declared, invisibleOverridden));
                }

                public void nothingToOverride(@NotNull CallableMemberDescriptor overriding) {
                    Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.NOTHING_TO_OVERRIDE.on((KtModifierListOwner)((PsiElement)this.$member), this.$declared));
                }
                {
                    this.this$0 = $outer;
                    this.$member = $captured_local_variable$1;
                    this.$declared = $captured_local_variable$2;
                }
            });
        } else if (!overriddenDescriptors.isEmpty() && !this.overridesBackwardCompatibilityHelper.overrideCanBeOmitted(declared)) {
            CallableMemberDescriptor overridden = overriddenDescriptors.iterator().next();
            PsiElement psiElement = member;
            CallableMemberDescriptor callableMemberDescriptor = overridden;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"overridden");
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on((KtNamedDeclaration)psiElement, declared, overridden, callableMemberDescriptor.getContainingDeclaration()));
        }
    }

    private final void checkOverrideForComponentFunction(CallableMemberDescriptor componentFunction) {
        DeclarationDescriptor declarationDescriptor = componentFunction.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"componentFunction.containingDeclaration");
        PsiElement dataModifier = OverrideResolver.Companion.findDataModifierForDataClass(declarationDescriptor);
        Collection<? extends CallableMemberDescriptor> collection = componentFunction.getOverriddenDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"componentFunction.overriddenDescriptors");
        OverrideResolver.Companion.checkOverridesForMember(componentFunction, collection, new CheckOverrideReportStrategy(this, dataModifier, componentFunction){
            private boolean overrideConflict;
            final /* synthetic */ OverrideResolver this$0;
            final /* synthetic */ PsiElement $dataModifier;
            final /* synthetic */ CallableMemberDescriptor $componentFunction;

            public void overridingFinalMember(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
                Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(this.$dataModifier, this.$componentFunction, overridden.getContainingDeclaration()));
                }
            }

            public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
                Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.access$getTrace$p(this.this$0).report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(this.$dataModifier, this.$componentFunction, overridden.getContainingDeclaration()));
                }
            }

            public void propertyTypeMismatchOnOverride(@NotNull PropertyDescriptor overriding, @NotNull PropertyDescriptor overridden) {
                Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                throw (Throwable)new IllegalStateException("Component functions are not properties");
            }

            public void varOverriddenByVal(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
                Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
                Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
                throw (Throwable)new IllegalStateException("Component functions are not properties");
            }
            {
                this.this$0 = $outer;
                this.$dataModifier = $captured_local_variable$1;
                this.$componentFunction = $captured_local_variable$2;
            }
        });
    }

    private final void checkOverrideForCopyFunction(CallableMemberDescriptor copyFunction) {
        Collection<? extends CallableMemberDescriptor> collection = copyFunction.getOverriddenDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"copyFunction.overriddenDescriptors");
        CallableMemberDescriptor overridden = (CallableMemberDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
        if (overridden != null) {
            DeclarationDescriptor declarationDescriptor = overridden.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"overridden.containingDeclaration");
            DeclarationDescriptor baseClassifier = declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = copyFunction.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"copyFunction.containingDeclaration");
            PsiElement dataModifier = OverrideResolver.Companion.findDataModifierForDataClass(declarationDescriptor2);
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitDataClassesOverridingCopy)) {
                this.trace.report(Errors.DATA_CLASS_OVERRIDE_DEFAULT_VALUES_ERROR.on(dataModifier, copyFunction, baseClassifier));
            } else {
                this.trace.report(Errors.DATA_CLASS_OVERRIDE_DEFAULT_VALUES_WARNING.on(dataModifier, copyFunction, baseClassifier));
            }
        }
    }

    private final void checkParameterOverridesForAllClasses(TopDownAnalysisContext c) {
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes classDescriptor2;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"classDescriptor");
            for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(classDescriptorWithResolutionScopes.getDefaultType().getMemberScope())) {
                if (!(member instanceof CallableMemberDescriptor)) continue;
                this.checkOverridesForParameters((CallableMemberDescriptor)member);
            }
        }
    }

    private final void checkOverridesForParameters(CallableMemberDescriptor declared) {
        KtModifierListOwner declaration2;
        boolean isDeclaration;
        boolean bl = isDeclaration = declared.getKind() == CallableMemberDescriptor.Kind.DECLARATION;
        if (isDeclaration && (declaration2 = (KtModifierListOwner)DescriptorToSourceUtils.descriptorToDeclaration(declared)) != null && !declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            boolean multipleDefaultsInSuper;
            int defaultsInSuper = 0;
            ValueParameterDescriptor valueParameterDescriptor = parameterFromSubclass;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterFromSubclass");
            for (ValueParameterDescriptor parameterFromSuperclass : valueParameterDescriptor.getOverriddenDescriptors()) {
                if (!parameterFromSuperclass.declaresDefaultValue()) continue;
                ++defaultsInSuper;
            }
            boolean bl2 = multipleDefaultsInSuper = defaultsInSuper > 1;
            if (isDeclaration) {
                this.checkNameAndDefaultForDeclaredParameter(parameterFromSubclass, multipleDefaultsInSuper);
                continue;
            }
            this.checkNameAndDefaultForFakeOverrideParameter(declared, parameterFromSubclass, multipleDefaultsInSuper);
        }
    }

    private final void checkNameAndDefaultForDeclaredParameter(ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (!(psiElement instanceof KtParameter)) {
            psiElement = null;
        }
        KtParameter ktParameter = (KtParameter)psiElement;
        if (ktParameter == null) {
            String string = "Declaration not found for parameter: " + descriptor2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KtParameter parameter2 = ktParameter;
        if (descriptor2.declaresDefaultValue()) {
            this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on((KtParameter)((PsiElement)parameter2)));
        }
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on((KtParameter)((PsiElement)parameter2), descriptor2));
        }
        for (ValueParameterDescriptor parameterFromSuperclass : descriptor2.getOverriddenDescriptors()) {
            if (!Companion.shouldReportParameterNameOverrideWarning(descriptor2, parameterFromSuperclass)) continue;
            DeclarationDescriptor declarationDescriptor = parameterFromSuperclass.getContainingDeclaration().getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on((KtParameter)((PsiElement)parameter2), (ClassDescriptor)declarationDescriptor, parameterFromSuperclass));
        }
    }

    private final void checkNameAndDefaultForFakeOverrideParameter(CallableMemberDescriptor containingFunction, ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        DeclarationDescriptor declarationDescriptor = containingFunction.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingFunction.containingDeclaration");
        DeclarationDescriptor containingClass = declarationDescriptor;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)DescriptorToSourceUtils.descriptorToDeclaration(containingClass);
        if (ktClassOrObject == null) {
            String string = "Declaration not found for class: " + containingClass;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KtClassOrObject classElement = ktClassOrObject;
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on((KtClassOrObject)((PsiElement)classElement), descriptor2));
        }
        for (ValueParameterDescriptor parameterFromSuperclass : descriptor2.getOverriddenDescriptors()) {
            if (!Companion.shouldReportParameterNameOverrideWarning(descriptor2, parameterFromSuperclass)) continue;
            this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on((KtClassOrObject)((PsiElement)classElement), containingFunction.getOverriddenDescriptors(), parameterFromSuperclass.getIndex() + 1));
        }
    }

    private final void checkVisibility(TopDownAnalysisContext c) {
        Map<KtCallableDeclaration, CallableMemberDescriptor> map2 = c.getMembers();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"c.members");
        Map<KtCallableDeclaration, CallableMemberDescriptor> map3 = map2;
        boolean bl = false;
        Iterator<Map.Entry<KtCallableDeclaration, CallableMemberDescriptor>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry;
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            KtCallableDeclaration key = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            CallableMemberDescriptor value = entry2.getValue();
            KtCallableDeclaration ktCallableDeclaration = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktCallableDeclaration, (String)"key");
            KtDeclaration ktDeclaration = ktCallableDeclaration;
            CallableMemberDescriptor callableMemberDescriptor = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"value");
            this.checkVisibilityForMember(ktDeclaration, callableMemberDescriptor);
            if (!(key instanceof KtProperty) || !(value instanceof PropertyDescriptor)) continue;
            KtPropertyAccessor setter2 = ((KtProperty)key).getSetter();
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)value).getSetter();
            if (setter2 == null || setterDescriptor == null) continue;
            this.checkVisibilityForMember(setter2, setterDescriptor);
        }
    }

    private final void checkVisibilityForMember(KtDeclaration declaration2, CallableMemberDescriptor memberDescriptor) {
        Visibility visibility = memberDescriptor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"memberDescriptor.visibility");
        Visibility visibility2 = visibility;
        Iterator<? extends CallableMemberDescriptor> iterator2 = memberDescriptor.getOverriddenDescriptors().iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor descriptor2;
            CallableMemberDescriptor callableMemberDescriptor = descriptor2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"descriptor");
            Integer compare = Visibilities.compare(visibility2, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on((KtModifierListOwner)((PsiElement)declaration2), descriptor2.getVisibility(), descriptor2, descriptor2.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on((KtModifierListOwner)((PsiElement)declaration2), descriptor2.getVisibility(), descriptor2, descriptor2.getContainingDeclaration()));
            return;
        }
    }

    public OverrideResolver(@NotNull BindingTrace trace, @NotNull OverridesBackwardCompatibilityHelper overridesBackwardCompatibilityHelper, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)overridesBackwardCompatibilityHelper, (String)"overridesBackwardCompatibilityHelper");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.trace = trace;
        this.overridesBackwardCompatibilityHelper = overridesBackwardCompatibilityHelper;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "", "abstractBaseClassMemberNotImplemented", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "abstractMemberNotImplemented", "abstractMemberWithMoreSpecificType", "abstractMember", "concreteMember", "conflictingInterfaceMemberNotImplemented", "multipleImplementationsMemberNotImplemented", "typeMismatchOnInheritance", "descriptor1", "descriptor2", "frontend"})
    private static interface CheckInheritedSignaturesReportStrategy {
        public void abstractMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void abstractBaseClassMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void abstractMemberWithMoreSpecificType(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void multipleImplementationsMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void conflictingInterfaceMemberNotImplemented(@NotNull CallableMemberDescriptor var1);

        public void typeMismatchOnInheritance(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectMissingImplementationsStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "()V", "shouldImplement", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getShouldImplement", "()Ljava/util/LinkedHashSet;", "abstractBaseClassMemberNotImplemented", "", "descriptor", "abstractMemberNotImplemented", "abstractMemberWithMoreSpecificType", "abstractMember", "concreteMember", "conflictingInterfaceMemberNotImplemented", "multipleImplementationsMemberNotImplemented", "typeMismatchOnInheritance", "descriptor1", "descriptor2", "frontend"})
    private static final class CollectMissingImplementationsStrategy
    implements CheckInheritedSignaturesReportStrategy {
        @NotNull
        private final LinkedHashSet<CallableMemberDescriptor> shouldImplement = new LinkedHashSet();

        @NotNull
        public final LinkedHashSet<CallableMemberDescriptor> getShouldImplement() {
            return this.shouldImplement;
        }

        @Override
        public void abstractMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.shouldImplement.add(descriptor2);
        }

        @Override
        public void abstractBaseClassMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        }

        @Override
        public void multipleImplementationsMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.shouldImplement.add(descriptor2);
        }

        @Override
        public void conflictingInterfaceMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (descriptor2.getModality() == Modality.ABSTRACT) {
                this.shouldImplement.add(descriptor2);
            }
        }

        @Override
        public void typeMismatchOnInheritance(@NotNull CallableMemberDescriptor descriptor1, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor1, (String)"descriptor1");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor2");
        }

        @Override
        public void abstractMemberWithMoreSpecificType(@NotNull CallableMemberDescriptor abstractMember, @NotNull CallableMemberDescriptor concreteMember) {
            Intrinsics.checkParameterIsNotNull((Object)abstractMember, (String)"abstractMember");
            Intrinsics.checkParameterIsNotNull((Object)concreteMember, (String)"concreteMember");
            this.shouldImplement.add(abstractMember);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\r\u0010\u001b\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\"2\u0006\u0010 \u001a\u00020\"H\u0016JD\u0010#\u001a\u00020\u00142\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%2\u0010\u0010&\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010'\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0002J2\u0010(\u001a\u00020\u00142\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0002J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0016J\u0018\u0010-\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CollectErrorInformationForInheritedMembersStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "abstractInBaseClassNoImpl", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "Lkotlin/collections/LinkedHashSet;", "abstractNoImpl", "conflictingInterfaceMembers", "conflictingReturnTypes", "multipleImplementations", "onceErrorsReported", "Lcom/intellij/util/containers/SmartHashSet;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "abstractBaseClassMemberNotImplemented", "", "descriptor", "abstractMemberNotImplemented", "abstractMemberWithMoreSpecificType", "abstractMember", "concreteMember", "conflictingInterfaceMemberNotImplemented", "doReportErrors", "doReportErrors$frontend", "multipleImplementationsMemberNotImplemented", "overridingFinalMember", "overriding", "overridden", "propertyTypeMismatchOnOverride", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "reportDelegationProblemIfRequired", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "relevantDiagnosticFromInheritance", "delegate", "reportInheritanceConflictIfRequired", "descriptor1", "descriptor2", "returnTypeMismatchOnOverride", "typeMismatchOnInheritance", "varOverriddenByVal", "frontend"})
    private final class CollectErrorInformationForInheritedMembersStrategy
    implements CheckInheritedSignaturesReportStrategy,
    CheckOverrideReportStrategy {
        private final LinkedHashSet<CallableMemberDescriptor> abstractNoImpl;
        private final LinkedHashSet<CallableMemberDescriptor> abstractInBaseClassNoImpl;
        private final LinkedHashSet<CallableMemberDescriptor> multipleImplementations;
        private final LinkedHashSet<CallableMemberDescriptor> conflictingInterfaceMembers;
        private final LinkedHashSet<CallableMemberDescriptor> conflictingReturnTypes;
        private final SmartHashSet<DiagnosticFactoryWithPsiElement<?, ?>> onceErrorsReported;
        private final KtClassOrObject klass;
        private final ClassDescriptor classDescriptor;

        @Override
        public void abstractMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.abstractNoImpl.add(descriptor2);
        }

        @Override
        public void abstractBaseClassMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.abstractInBaseClassNoImpl.add(descriptor2);
        }

        @Override
        public void multipleImplementationsMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.multipleImplementations.add(descriptor2);
        }

        @Override
        public void conflictingInterfaceMemberNotImplemented(@NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.conflictingInterfaceMembers.add(descriptor2);
        }

        @Override
        public void typeMismatchOnInheritance(@NotNull CallableMemberDescriptor descriptor1, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor1, (String)"descriptor1");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor2");
            this.conflictingReturnTypes.add(descriptor1);
            this.conflictingReturnTypes.add(descriptor2);
            if (descriptor1 instanceof PropertyDescriptor && descriptor2 instanceof PropertyDescriptor) {
                if (((PropertyDescriptor)descriptor1).isVar() || ((PropertyDescriptor)descriptor2).isVar()) {
                    DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.VAR_TYPE_MISMATCH_ON_INHERITANCE;
                    Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"VAR_TYPE_MISMATCH_ON_INHERITANCE");
                    this.reportInheritanceConflictIfRequired(diagnosticFactory2, descriptor1, descriptor2);
                } else {
                    DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE;
                    Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"PROPERTY_TYPE_MISMATCH_ON_INHERITANCE");
                    this.reportInheritanceConflictIfRequired(diagnosticFactory2, descriptor1, descriptor2);
                }
            } else {
                DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"RETURN_TYPE_MISMATCH_ON_INHERITANCE");
                this.reportInheritanceConflictIfRequired(diagnosticFactory2, descriptor1, descriptor2);
            }
        }

        @Override
        public void abstractMemberWithMoreSpecificType(@NotNull CallableMemberDescriptor abstractMember, @NotNull CallableMemberDescriptor concreteMember) {
            Intrinsics.checkParameterIsNotNull((Object)abstractMember, (String)"abstractMember");
            Intrinsics.checkParameterIsNotNull((Object)concreteMember, (String)"concreteMember");
            this.typeMismatchOnInheritance(abstractMember, concreteMember);
        }

        private final void reportInheritanceConflictIfRequired(DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory, CallableMemberDescriptor descriptor1, CallableMemberDescriptor descriptor2) {
            if (!this.onceErrorsReported.contains(diagnosticFactory)) {
                this.onceErrorsReported.add(diagnosticFactory);
                OverrideResolver.this.trace.report(diagnosticFactory.on((KtClassOrObject)((PsiElement)this.klass), descriptor1, descriptor2));
            }
        }

        @Override
        public void overridingFinalMember(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
            Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
            Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
            DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.OVERRIDING_FINAL_MEMBER_BY_DELEGATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"OVERRIDING_FINAL_MEMBER_BY_DELEGATION");
            this.reportDelegationProblemIfRequired(diagnosticFactory2, null, overriding, overridden);
        }

        @Override
        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
            Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
            Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
            DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.RETURN_TYPE_MISMATCH_BY_DELEGATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"RETURN_TYPE_MISMATCH_BY_DELEGATION");
            this.reportDelegationProblemIfRequired(diagnosticFactory2, (DiagnosticFactoryWithPsiElement)Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE, overriding, overridden);
        }

        @Override
        public void propertyTypeMismatchOnOverride(@NotNull PropertyDescriptor overriding, @NotNull PropertyDescriptor overridden) {
            Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
            Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
            DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.PROPERTY_TYPE_MISMATCH_BY_DELEGATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"PROPERTY_TYPE_MISMATCH_BY_DELEGATION");
            this.reportDelegationProblemIfRequired(diagnosticFactory2, (DiagnosticFactoryWithPsiElement)Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE, overriding, overridden);
        }

        @Override
        public void varOverriddenByVal(@NotNull CallableMemberDescriptor overriding, @NotNull CallableMemberDescriptor overridden) {
            Intrinsics.checkParameterIsNotNull((Object)overriding, (String)"overriding");
            Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
            DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory2 = Errors.VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION");
            this.reportDelegationProblemIfRequired(diagnosticFactory2, null, overriding, overridden);
        }

        private final void reportDelegationProblemIfRequired(DiagnosticFactory2<KtClassOrObject, CallableMemberDescriptor, CallableMemberDescriptor> diagnosticFactory, DiagnosticFactoryWithPsiElement<?, ?> relevantDiagnosticFromInheritance, CallableMemberDescriptor delegate, CallableMemberDescriptor overridden) {
            boolean bl = delegate.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Delegate expected, got " + delegate + " of kind " + (Object)((Object)delegate.getKind());
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!(this.onceErrorsReported.contains(diagnosticFactory) || relevantDiagnosticFromInheritance != null && this.onceErrorsReported.contains(relevantDiagnosticFromInheritance))) {
                this.onceErrorsReported.add(diagnosticFactory);
                OverrideResolver.this.trace.report(diagnosticFactory.on((KtClassOrObject)((PsiElement)this.klass), delegate, overridden));
            }
        }

        public final void doReportErrors$frontend() {
            boolean canHaveAbstractMembers = DescriptorUtils.classCanHaveAbstractFakeOverride(this.classDescriptor);
            Collection collection = this.abstractInBaseClassNoImpl;
            boolean bl = false;
            if (!collection.isEmpty() && !canHaveAbstractMembers) {
                OverrideResolver.this.trace.report(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.abstractInBaseClassNoImpl)));
            } else {
                collection = this.abstractNoImpl;
                bl = false;
                if (!collection.isEmpty() && !canHaveAbstractMembers) {
                    OverrideResolver.this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)CollectionsKt.first((Iterable)this.abstractNoImpl)));
                }
            }
            this.conflictingInterfaceMembers.removeAll((Collection)this.conflictingReturnTypes);
            this.multipleImplementations.removeAll((Collection)this.conflictingReturnTypes);
            if (!this.conflictingInterfaceMembers.isEmpty()) {
                OverrideResolver.this.trace.report(Errors.MANY_INTERFACES_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)this.conflictingInterfaceMembers.iterator().next()));
            } else if (!this.multipleImplementations.isEmpty()) {
                OverrideResolver.this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.klass), this.klass, (CallableMemberDescriptor)this.multipleImplementations.iterator().next()));
            }
        }

        public CollectErrorInformationForInheritedMembersStrategy(@NotNull KtClassOrObject klass2, @NotNull ClassDescriptor classDescriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
            this.klass = klass2;
            this.classDescriptor = classDescriptor2;
            CollectErrorInformationForInheritedMembersStrategy collectErrorInformationForInheritedMembersStrategy = this;
            boolean bl = false;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            collectErrorInformationForInheritedMembersStrategy.abstractNoImpl = linkedHashSet;
            collectErrorInformationForInheritedMembersStrategy = this;
            bl = false;
            linkedHashSet = new LinkedHashSet();
            collectErrorInformationForInheritedMembersStrategy.abstractInBaseClassNoImpl = linkedHashSet;
            collectErrorInformationForInheritedMembersStrategy = this;
            bl = false;
            linkedHashSet = new LinkedHashSet();
            collectErrorInformationForInheritedMembersStrategy.multipleImplementations = linkedHashSet;
            collectErrorInformationForInheritedMembersStrategy = this;
            bl = false;
            linkedHashSet = new LinkedHashSet();
            collectErrorInformationForInheritedMembersStrategy.conflictingInterfaceMembers = linkedHashSet;
            collectErrorInformationForInheritedMembersStrategy = this;
            bl = false;
            linkedHashSet = new LinkedHashSet();
            collectErrorInformationForInheritedMembersStrategy.conflictingReturnTypes = linkedHashSet;
            this.onceErrorsReported = new SmartHashSet();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "", "overridingFinalMember", "", "overriding", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overridden", "propertyTypeMismatchOnOverride", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "returnTypeMismatchOnOverride", "varOverriddenByVal", "frontend"})
    private static interface CheckOverrideReportStrategy {
        public void overridingFinalMember(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

        public void propertyTypeMismatchOnOverride(@NotNull PropertyDescriptor var1, @NotNull PropertyDescriptor var2);

        public void varOverriddenByVal(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportForDeclaredMemberStrategy;", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "cannotOverrideInvisibleMember", "", "overriding", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "invisibleOverridden", "nothingToOverride", "frontend"})
    private static interface CheckOverrideReportForDeclaredMemberStrategy
    extends CheckOverrideReportStrategy {
        public void nothingToOverride(@NotNull CallableMemberDescriptor var1);

        public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010 \u001a\u00020\u0006H\u0002J(\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\fH\u0002J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u000b\u001a\u00020\fJ6\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J\u0018\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J8\u00106\u001a\u00020\u001b2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0012\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J\u0018\u00109\u001a\u00020\u001b2\u0006\u00103\u001a\u00020:2\u0006\u00105\u001a\u00020:H\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00103\u001a\u00020:2\u0006\u00105\u001a\u00020:H\u0002J\u001c\u0010=\u001a\u00020\u00042\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010&\u001a\u00020'J\u0016\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/resolve/OverrideResolver$Companion;", "", "()V", "checkInheritedAndDelegatedSignatures", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "reportingStrategy", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckInheritedSignaturesReportStrategy;", "overrideReportStrategyForDelegates", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportStrategy;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "inheritedReportStrategy", "checkInheritedDescriptorsGroup", "overriddenDescriptors", "", "checkMissingOverridesByJava8Restrictions", "relevantDirectlyOverridden", "", "checkOverridesForMember", "memberDescriptor", "reportError", "checkOverridesForMemberMarkedOverride", "declared", "Lorg/jetbrains/kotlin/resolve/OverrideResolver$CheckOverrideReportForDeclaredMemberStrategy;", "checkPropertyKind", "", "isVar", "collectAbstractMethodsWithMoreSpecificReturnType", "", "abstractOverridden", "implementation", "collectOverriddenDeclarations", "", "directOverriddenDescriptors", "createCannotInferVisibilityReporter", "Lkotlin/Function1;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "findDataModifierForDataClass", "Lcom/intellij/psi/PsiElement;", "dataClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findInvisibleOverriddenDescriptor", "declaringClass", "getMissingImplementations", "getRelevantDirectlyOverridden", "overriddenByParent", "allFilteredOverriddenDeclarations", "isPropertyTypeOkForOverride", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "subDescriptor", "isRelevant", "declarationSet", "allDeclarationSets", "isReturnTypeOkForOverride", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "prepareTypeSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "resolveUnknownVisibilities", "descriptors", "shouldReportParameterNameOverrideWarning", "parameterFromSubclass", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameterFromSuperclass", "frontend"})
    public static final class Companion {
        public final void resolveUnknownVisibilities(@NotNull Collection<? extends CallableMemberDescriptor> descriptors, @NotNull BindingTrace trace) {
            Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
                OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, this.createCannotInferVisibilityReporter(trace));
            }
        }

        @NotNull
        public final Function1<CallableMemberDescriptor, Unit> createCannotInferVisibilityReporter(@NotNull BindingTrace trace) {
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            return (Function1)new Function1<CallableMemberDescriptor, Unit>(trace){
                final /* synthetic */ BindingTrace $trace;

                public final void invoke(@NotNull CallableMemberDescriptor descriptor2) {
                    Substitutable<ClassifierDescriptorWithTypeParameters> substitutable;
                    Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                    if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION) {
                        ClassDescriptor classDescriptor2 = DescriptorUtils.getContainingClass(descriptor2);
                        if (classDescriptor2 == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("Class member expected: " + descriptor2)));
                        }
                        substitutable = classDescriptor2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"DescriptorUtils.getConta\u2026r expected: $descriptor\")");
                    } else if (descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).isDefault()) {
                        PropertyDescriptor propertyDescriptor2 = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
                        substitutable = propertyDescriptor2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"descriptor.correspondingProperty");
                    } else {
                        substitutable = descriptor2;
                    }
                    DeclarationDescriptor reportOn = substitutable;
                    PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(reportOn);
                    if (element instanceof KtDeclaration) {
                        this.$trace.report(Errors.CANNOT_INFER_VISIBILITY.on((KtDeclaration)element, descriptor2));
                    }
                }
                {
                    this.$trace = bindingTrace;
                    super(1);
                }
            };
        }

        @NotNull
        public final Set<CallableMemberDescriptor> getMissingImplementations(@NotNull ClassDescriptor classDescriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
            CollectMissingImplementationsStrategy collector2 = new CollectMissingImplementationsStrategy();
            this.checkInheritedAndDelegatedSignatures(classDescriptor2, (CheckInheritedSignaturesReportStrategy)collector2, null);
            return collector2.getShouldImplement();
        }

        private final void checkInheritedAndDelegatedSignatures(ClassDescriptor classDescriptor2, CheckInheritedSignaturesReportStrategy inheritedReportStrategy, CheckOverrideReportStrategy overrideReportStrategyForDelegates) {
            for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(classDescriptor2.getDefaultType().getMemberScope())) {
                if (!(member instanceof CallableMemberDescriptor)) continue;
                this.checkInheritedAndDelegatedSignatures((CallableMemberDescriptor)member, inheritedReportStrategy, overrideReportStrategyForDelegates);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkInheritedAndDelegatedSignatures(CallableMemberDescriptor descriptor2, CheckInheritedSignaturesReportStrategy reportingStrategy, CheckOverrideReportStrategy overrideReportStrategyForDelegates) {
            void concreteOverridden;
            void $this$filterTo$iv$iv;
            CallableMemberDescriptor.Kind kind = descriptor2.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), (String)"descriptor.kind");
            CallableMemberDescriptor.Kind kind2 = kind;
            if (kind2 != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind2 != CallableMemberDescriptor.Kind.DELEGATION) {
                return;
            }
            if (descriptor2.getVisibility() == Visibilities.INVISIBLE_FAKE) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
            Collection<? extends CallableMemberDescriptor> directOverridden = collection;
            boolean bl = !directOverridden.isEmpty();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-OverrideResolver$Companion$checkInheritedAndDelegatedSignatures$22 = false;
                String $i$a$-assert-OverrideResolver$Companion$checkInheritedAndDelegatedSignatures$22 = kind2.toString() + " " + descriptor2.getName().asString() + " must override something";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OverrideResolver$Companion$checkInheritedAndDelegatedSignatures$22));
            }
            Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = this.collectOverriddenDeclarations(directOverridden);
            List list2 = ContainerUtil.flatten((Iterable)overriddenDeclarationsByDirectParent.values());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContainerUtil.flatten(ov\u2026onsByDirectParent.values)");
            List allOverriddenDeclarations = list2;
            Set set = OverridingUtil.filterOutOverridden(Sets.newLinkedHashSet(allOverriddenDeclarations));
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"OverridingUtil.filterOut\u2026clarations)\n            )");
            Set allFilteredOverriddenDeclarations = set;
            Set<CallableMemberDescriptor> relevantDirectlyOverridden = this.getRelevantDirectlyOverridden(overriddenDeclarationsByDirectParent, allFilteredOverriddenDeclarations);
            this.checkInheritedDescriptorsGroup(descriptor2, (Collection<? extends CallableMemberDescriptor>)relevantDirectlyOverridden, reportingStrategy);
            if (kind2 == CallableMemberDescriptor.Kind.DELEGATION && overrideReportStrategyForDelegates != null) {
                this.checkOverridesForMember(descriptor2, (Collection<? extends CallableMemberDescriptor>)relevantDirectlyOverridden, overrideReportStrategyForDelegates);
            }
            if (kind2 != CallableMemberDescriptor.Kind.DELEGATION) {
                this.checkMissingOverridesByJava8Restrictions(relevantDirectlyOverridden, reportingStrategy);
            }
            Iterable $this$filter$iv = relevantDirectlyOverridden;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                boolean bl3 = false;
                if (!(!CallResolverUtilKt.isOrOverridesSynthesized(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$partition$iv = (List)destination$iv$iv;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                boolean bl4 = false;
                if (it.getModality() != Modality.ABSTRACT) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list3 = (List)pair.component1();
            List abstractOverridden = (List)pair.component2();
            int numImplementations = concreteOverridden.size();
            switch (numImplementations) {
                case 0: {
                    CallableMemberDescriptor it;
                    if (kind2 == CallableMemberDescriptor.Kind.DELEGATION) break;
                    Iterable $this$forEach$iv = abstractOverridden;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (CallableMemberDescriptor)element$iv;
                        boolean bl5 = false;
                        reportingStrategy.abstractMemberNotImplemented(it);
                    }
                    break;
                }
                case 1: {
                    if (kind2 == CallableMemberDescriptor.Kind.DELEGATION) break;
                    CallableMemberDescriptor implementation = (CallableMemberDescriptor)CollectionsKt.first((List)concreteOverridden);
                    Iterable $this$forEach$iv = this.collectAbstractMethodsWithMoreSpecificReturnType(abstractOverridden, implementation);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl6 = false;
                        reportingStrategy.abstractMemberWithMoreSpecificType(it, implementation);
                    }
                    break;
                }
                default: {
                    CallableMemberDescriptor it;
                    Iterable $this$forEach$iv = (Iterable)concreteOverridden;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (CallableMemberDescriptor)element$iv;
                        boolean bl7 = false;
                        reportingStrategy.multipleImplementationsMemberNotImplemented(it);
                    }
                }
            }
        }

        private final void checkMissingOverridesByJava8Restrictions(Set<? extends CallableMemberDescriptor> relevantDirectlyOverridden, CheckInheritedSignaturesReportStrategy reportingStrategy) {
            boolean overridesClassMember = false;
            boolean overridesNonAbstractInterfaceMember = false;
            CallableMemberDescriptor overridesAbstractInBaseClass = null;
            SmartList<CallableMemberDescriptor> overriddenInterfaceMembers = new SmartList<CallableMemberDescriptor>();
            for (CallableMemberDescriptor callableMemberDescriptor : relevantDirectlyOverridden) {
                DeclarationDescriptor containingDeclaration;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor.getContainingDeclaration(), (String)"overridden.containingDeclaration");
                if (!(containingDeclaration instanceof ClassDescriptor)) continue;
                if (((ClassDescriptor)containingDeclaration).getKind() == ClassKind.CLASS) {
                    overridesClassMember = true;
                    if (callableMemberDescriptor.getModality() != Modality.ABSTRACT) continue;
                    overridesAbstractInBaseClass = callableMemberDescriptor;
                    continue;
                }
                if (((ClassDescriptor)containingDeclaration).getKind() != ClassKind.INTERFACE) continue;
                overriddenInterfaceMembers.add(callableMemberDescriptor);
                if (callableMemberDescriptor.getModality() == Modality.ABSTRACT) continue;
                overridesNonAbstractInterfaceMember = true;
            }
            if (overridesAbstractInBaseClass != null) {
                reportingStrategy.abstractBaseClassMemberNotImplemented(overridesAbstractInBaseClass);
            }
            if (!overridesClassMember && overridesNonAbstractInterfaceMember && overriddenInterfaceMembers.size() > 1) {
                Iterator<CallableMemberDescriptor> iterator2 = overriddenInterfaceMembers.iterator();
                while (iterator2.hasNext()) {
                    CallableMemberDescriptor callableMemberDescriptor;
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"member");
                    reportingStrategy.conflictingInterfaceMemberNotImplemented(callableMemberDescriptor2);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<CallableMemberDescriptor> collectAbstractMethodsWithMoreSpecificReturnType(List<? extends CallableMemberDescriptor> abstractOverridden, CallableMemberDescriptor implementation) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = abstractOverridden;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CallableMemberDescriptor abstractMember = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(!Companion.isReturnTypeOkForOverride(abstractMember, implementation))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final Set<CallableMemberDescriptor> getRelevantDirectlyOverridden(Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenByParent, Set<? extends CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
            Iterator<Map.Entry<CallableMemberDescriptor, Set<CallableMemberDescriptor>>> iterator2 = overriddenByParent.entrySet().iterator();
            while (iterator2.hasNext()) {
                if (this.isRelevant(iterator2.next().getValue(), overriddenByParent.values(), allFilteredOverriddenDeclarations)) continue;
                iterator2.remove();
            }
            return overriddenByParent.keySet();
        }

        private final boolean isRelevant(Set<? extends CallableMemberDescriptor> declarationSet, Collection<? extends Set<? extends CallableMemberDescriptor>> allDeclarationSets, Set<? extends CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
            for (Set<? extends CallableMemberDescriptor> set : allDeclarationSets) {
                if (set == declarationSet) continue;
                if (set.containsAll((Collection)declarationSet)) {
                    return false;
                }
                if (!Collections.disjoint((Collection)allFilteredOverriddenDeclarations, (Collection)declarationSet)) continue;
                return false;
            }
            return true;
        }

        private final Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> collectOverriddenDeclarations(Collection<? extends CallableMemberDescriptor> directOverriddenDescriptors) {
            LinkedHashMap overriddenDeclarationsByDirectParent = Maps.newLinkedHashMap();
            for (CallableMemberDescriptor callableMemberDescriptor : directOverriddenDescriptors) {
                Set<CallableMemberDescriptor> filteredOverrides;
                Set<CallableMemberDescriptor> overriddenDeclarations;
                Intrinsics.checkExpressionValueIsNotNull(OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor), (String)"OverridingUtil.getOverri\u2026nDeclarations(descriptor)");
                Intrinsics.checkExpressionValueIsNotNull(OverridingUtil.filterOutOverridden(overriddenDeclarations), (String)"OverridingUtil.filterOut\u2026n(overriddenDeclarations)");
                overriddenDeclarationsByDirectParent.put(callableMemberDescriptor, new LinkedHashSet(filteredOverrides));
            }
            LinkedHashMap linkedHashMap = overriddenDeclarationsByDirectParent;
            Intrinsics.checkExpressionValueIsNotNull(linkedHashMap, (String)"overriddenDeclarationsByDirectParent");
            return linkedHashMap;
        }

        private final void checkInheritedDescriptorsGroup(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenDescriptors, CheckInheritedSignaturesReportStrategy reportingStrategy) {
            if (overriddenDescriptors.size() <= 1) {
                return;
            }
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (!(callableMemberDescriptor instanceof PropertyDescriptor)) {
                callableMemberDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)callableMemberDescriptor;
            for (CallableMemberDescriptor callableMemberDescriptor2 : overriddenDescriptors) {
                if (propertyDescriptor2 != null) {
                    PropertyDescriptor overriddenPropertyDescriptor;
                    CallableMemberDescriptor $this$assertedCast$iv = callableMemberDescriptor2;
                    boolean $i$f$assertedCast = false;
                    CallableMemberDescriptor callableMemberDescriptor3 = $this$assertedCast$iv;
                    if (!(callableMemberDescriptor3 instanceof PropertyDescriptor)) {
                        callableMemberDescriptor3 = null;
                    }
                    if ((PropertyDescriptor)callableMemberDescriptor3 == null) {
                        String string;
                        boolean bl = false;
                        String string2 = string = callableMemberDescriptor2 + " is not a property";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    if (this.isPropertyTypeOkForOverride(overriddenPropertyDescriptor, propertyDescriptor2)) continue;
                    reportingStrategy.typeMismatchOnInheritance(propertyDescriptor2, overriddenPropertyDescriptor);
                    continue;
                }
                if (this.isReturnTypeOkForOverride(callableMemberDescriptor2, descriptor2)) continue;
                reportingStrategy.typeMismatchOnInheritance(descriptor2, callableMemberDescriptor2);
            }
        }

        private final void checkOverridesForMemberMarkedOverride(CallableMemberDescriptor declared, CheckOverrideReportForDeclaredMemberStrategy reportError2) {
            Collection<? extends CallableMemberDescriptor> collection = declared.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"declared.overriddenDescriptors");
            Collection<? extends CallableMemberDescriptor> overriddenDescriptors = collection;
            this.checkOverridesForMember(declared, overriddenDescriptors, reportError2);
            if (overriddenDescriptors.isEmpty()) {
                DeclarationDescriptor containingDeclaration;
                DeclarationDescriptor declarationDescriptor = declared.getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"declared.containingDeclaration");
                DeclarationDescriptor $this$assertedCast$iv = containingDeclaration = declarationDescriptor;
                boolean $i$f$assertedCast = false;
                DeclarationDescriptor declarationDescriptor2 = $this$assertedCast$iv;
                if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                    declarationDescriptor2 = null;
                }
                ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
                if (classDescriptor2 == null) {
                    String string;
                    boolean bl = false;
                    String string2 = string = "Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                ClassDescriptor declaringClass = classDescriptor2;
                CallableMemberDescriptor invisibleOverriddenDescriptor = this.findInvisibleOverriddenDescriptor(declared, declaringClass);
                if (invisibleOverriddenDescriptor != null) {
                    reportError2.cannotOverrideInvisibleMember(declared, invisibleOverriddenDescriptor);
                } else {
                    reportError2.nothingToOverride(declared);
                }
            }
        }

        private final void checkOverridesForMember(CallableMemberDescriptor memberDescriptor, Collection<? extends CallableMemberDescriptor> overriddenDescriptors, CheckOverrideReportStrategy reportError2) {
            PropertyDescriptor propertyMemberDescriptor = memberDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)memberDescriptor : null;
            for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
                if (callableMemberDescriptor.getModality() == Modality.FINAL) {
                    reportError2.overridingFinalMember(memberDescriptor, callableMemberDescriptor);
                }
                if (propertyMemberDescriptor != null) {
                    PropertyDescriptor overriddenProperty;
                    CallableMemberDescriptor $this$assertedCast$iv = callableMemberDescriptor;
                    boolean $i$f$assertedCast = false;
                    CallableMemberDescriptor callableMemberDescriptor2 = $this$assertedCast$iv;
                    if (!(callableMemberDescriptor2 instanceof PropertyDescriptor)) {
                        callableMemberDescriptor2 = null;
                    }
                    if ((PropertyDescriptor)callableMemberDescriptor2 == null) {
                        String string;
                        boolean bl = false;
                        String string2 = string = callableMemberDescriptor + " is overridden by property " + propertyMemberDescriptor;
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    if (!this.isPropertyTypeOkForOverride(overriddenProperty, propertyMemberDescriptor)) {
                        reportError2.propertyTypeMismatchOnOverride(propertyMemberDescriptor, overriddenProperty);
                    }
                } else if (!this.isReturnTypeOkForOverride(callableMemberDescriptor, memberDescriptor)) {
                    reportError2.returnTypeMismatchOnOverride(memberDescriptor, callableMemberDescriptor);
                }
                if (!this.checkPropertyKind(callableMemberDescriptor, true) || !this.checkPropertyKind(memberDescriptor, false)) continue;
                reportError2.varOverriddenByVal(memberDescriptor, callableMemberDescriptor);
            }
        }

        private final boolean isReturnTypeOkForOverride(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor) {
            TypeSubstitutor typeSubstitutor2 = this.prepareTypeSubstitutor(superDescriptor, subDescriptor);
            if (typeSubstitutor2 == null) {
                return false;
            }
            TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
            KotlinType kotlinType2 = superDescriptor.getReturnType();
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"superDescriptor.returnType!!");
            KotlinType superReturnType = kotlinType2;
            KotlinType kotlinType3 = subDescriptor.getReturnType();
            if (kotlinType3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"subDescriptor.returnType!!");
            KotlinType subReturnType = kotlinType3;
            KotlinType kotlinType4 = typeSubstitutor3.substitute(superReturnType, Variance.OUT_VARIANCE);
            if (kotlinType4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"typeSubstitutor.substitu\u2026 Variance.OUT_VARIANCE)!!");
            KotlinType substitutedSuperReturnType = kotlinType4;
            return KotlinTypeChecker.DEFAULT.isSubtypeOf(subReturnType, substitutedSuperReturnType);
        }

        /*
         * WARNING - void declaration
         */
        private final TypeSubstitutor prepareTypeSubstitutor(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor) {
            List<TypeParameterDescriptor> list2 = superDescriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"superDescriptor.typeParameters");
            List<TypeParameterDescriptor> superTypeParameters = list2;
            List<TypeParameterDescriptor> list3 = subDescriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"subDescriptor.typeParameters");
            List<TypeParameterDescriptor> subTypeParameters = list3;
            if (subTypeParameters.size() != superTypeParameters.size()) {
                return null;
            }
            ArrayList<TypeProjectionImpl> arguments2 = new ArrayList<TypeProjectionImpl>(subTypeParameters.size());
            int n = 0;
            int n2 = ((Collection)superTypeParameters).size();
            while (n < n2) {
                void i;
                TypeParameterDescriptor typeParameterDescriptor = subTypeParameters.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"subTypeParameters[i]");
                arguments2.add(new TypeProjectionImpl(typeParameterDescriptor.getDefaultType()));
                ++i;
            }
            return new IndexedParametersSubstitution(superTypeParameters, (List<? extends TypeProjection>)arguments2).buildSubstitutor();
        }

        private final boolean isPropertyTypeOkForOverride(PropertyDescriptor superDescriptor, PropertyDescriptor subDescriptor) {
            TypeSubstitutor typeSubstitutor2 = this.prepareTypeSubstitutor(superDescriptor, subDescriptor);
            if (typeSubstitutor2 == null) {
                return false;
            }
            TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
            KotlinType kotlinType2 = typeSubstitutor3.substitute(superDescriptor.getType(), Variance.OUT_VARIANCE);
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"typeSubstitutor.substitu\u2026 Variance.OUT_VARIANCE)!!");
            KotlinType substitutedSuperReturnType = kotlinType2;
            return superDescriptor.isVar() ? KotlinTypeChecker.DEFAULT.equalTypes(subDescriptor.getType(), substitutedSuperReturnType) : KotlinTypeChecker.DEFAULT.isSubtypeOf(subDescriptor.getType(), substitutedSuperReturnType);
        }

        private final PsiElement findDataModifierForDataClass(DeclarationDescriptor dataClass) {
            KtClassOrObject classDeclaration;
            KtClassOrObject ktClassOrObject = classDeclaration = (KtClassOrObject)DescriptorToSourceUtils.getSourceFromDescriptor(dataClass);
            if ((ktClassOrObject != null ? ktClassOrObject.getModifierList() : null) != null) {
                PsiElement modifier;
                KtModifierList ktModifierList = classDeclaration.getModifierList();
                if (ktModifierList == null) {
                    Intrinsics.throwNpe();
                }
                if ((modifier = ktModifierList.getModifier(KtTokens.DATA_KEYWORD)) != null) {
                    return modifier;
                }
            }
            throw (Throwable)new IllegalStateException("No data modifier is found for data class " + dataClass);
        }

        private final CallableMemberDescriptor findInvisibleOverriddenDescriptor(CallableMemberDescriptor declared, ClassDescriptor declaringClass) {
            TypeConstructor typeConstructor2 = declaringClass.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"declaringClass.typeConstructor");
            for (KotlinType supertype : typeConstructor2.getSupertypes()) {
                boolean bl = false;
                LinkedHashSet<CallableMemberDescriptor> all2 = new LinkedHashSet<CallableMemberDescriptor>();
                MemberScope memberScope2 = supertype.getMemberScope();
                Name name = declared.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"declared.name");
                all2.addAll(memberScope2.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_OVERRIDES));
                MemberScope memberScope3 = supertype.getMemberScope();
                Name name2 = declared.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"declared.name");
                all2.addAll(memberScope3.getContributedVariables(name2, NoLookupLocation.WHEN_CHECK_OVERRIDES));
                for (CallableMemberDescriptor fromSuper : all2) {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.DEFAULT.isOverridableBy(fromSuper, declared, null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)overrideCompatibilityInfo, (String)"OverridingUtil.DEFAULT.i\u2026romSuper, declared, null)");
                    if (overrideCompatibilityInfo.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                    if (OverridingUtil.isVisibleForOverride(declared, fromSuper)) {
                        throw (Throwable)new IllegalStateException("Descriptor " + fromSuper + " is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
                    }
                    return fromSuper;
                }
            }
            return null;
        }

        public final boolean shouldReportParameterNameOverrideWarning(@NotNull ValueParameterDescriptor parameterFromSubclass, @NotNull ValueParameterDescriptor parameterFromSuperclass) {
            Intrinsics.checkParameterIsNotNull((Object)parameterFromSubclass, (String)"parameterFromSubclass");
            Intrinsics.checkParameterIsNotNull((Object)parameterFromSuperclass, (String)"parameterFromSuperclass");
            return parameterFromSubclass.getContainingDeclaration().hasStableParameterNames() && parameterFromSuperclass.getContainingDeclaration().hasStableParameterNames() && Intrinsics.areEqual((Object)parameterFromSuperclass.getName(), (Object)parameterFromSubclass.getName()) ^ true;
        }

        private final boolean checkPropertyKind(CallableMemberDescriptor descriptor2, boolean isVar) {
            return descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar() == isVar;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

