/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import io.github.classgraph.ModuleRef;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classpath.CallStackReader;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

public class ClassLoaderAndModuleFinder {
    private final ClassLoader[] contextClassLoaders;
    private List<ModuleRef> systemModuleRefs;
    private List<ModuleRef> nonSystemModuleRefs;

    public ClassLoader[] getContextClassLoaders() {
        return this.contextClassLoaders;
    }

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    private static void findLayerOrder(Object layer, Set<Object> layerVisited, Set<Object> parentLayers, Deque<Object> layerOrderOut) {
        if (layerVisited.add(layer)) {
            List parents = (List)ReflectionUtils.invokeMethod(layer, "parents", true);
            if (parents != null) {
                parentLayers.addAll(parents);
                for (Object parent : parents) {
                    ClassLoaderAndModuleFinder.findLayerOrder(parent, layerVisited, parentLayers, layerOrderOut);
                }
            }
            layerOrderOut.push(layer);
        }
    }

    private static List<ModuleRef> findModuleRefs(List<Object> layers, ScanSpec scanSpec, LogNode log) {
        ArrayList<Object> layerOrderFinal;
        if (layers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> layerOrder = new ArrayDeque<Object>();
        HashSet<Object> parentLayers = new HashSet<Object>();
        for (Object object : layers) {
            ClassLoaderAndModuleFinder.findLayerOrder(object, new HashSet<Object>(), parentLayers, layerOrder);
        }
        if (scanSpec.addedModuleLayers != null) {
            for (Object object : scanSpec.addedModuleLayers) {
                ClassLoaderAndModuleFinder.findLayerOrder(object, new HashSet<Object>(), parentLayers, layerOrder);
            }
        }
        if (scanSpec.ignoreParentModuleLayers) {
            layerOrderFinal = new ArrayList();
            for (Object e : layerOrder) {
                if (parentLayers.contains(e)) continue;
                layerOrderFinal.add(e);
            }
        } else {
            layerOrderFinal = new ArrayList<Object>(layerOrder);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object e : layerOrderFinal) {
            Set modules;
            Object configuration = ReflectionUtils.invokeMethod(e, "configuration", true);
            if (configuration == null || (modules = (Set)ReflectionUtils.invokeMethod(configuration, "modules", true)) == null) continue;
            ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
            for (Object module : modules) {
                Object moduleReference = ReflectionUtils.invokeMethod(module, "reference", true);
                if (moduleReference == null || !hashSet.add(moduleReference)) continue;
                try {
                    modulesInLayer.add(new ModuleRef(moduleReference, e));
                }
                catch (IllegalArgumentException e2) {
                    if (log == null) continue;
                    log.log("Exception while creating ModuleRef for module " + moduleReference, e2);
                }
            }
            Collections.sort(modulesInLayer);
            linkedHashSet.addAll(modulesInLayer);
        }
        return new ArrayList<ModuleRef>(linkedHashSet);
    }

    private static List<ModuleRef> findModuleRefs(Class<?>[] callStack, ScanSpec scanSpec, LogNode log) {
        Object bootLayer;
        ArrayList<Object> layers = new ArrayList<Object>();
        for (Class<?> stackFrameClass : callStack) {
            Object layer;
            Object module = ReflectionUtils.invokeMethod(stackFrameClass, "getModule", false);
            if (module == null || (layer = ReflectionUtils.invokeMethod(module, "getLayer", true)) == null) continue;
            layers.add(layer);
        }
        Class<?> moduleLayerClass = null;
        try {
            moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        if (moduleLayerClass != null && (bootLayer = ReflectionUtils.invokeStaticMethod(moduleLayerClass, "boot", false)) != null) {
            layers.add(bootLayer);
        }
        return ClassLoaderAndModuleFinder.findModuleRefs(layers, scanSpec, log);
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoaderAndModuleFinder(ScanSpec scanSpec, LogNode log) {
        LogNode classLoadersFoundLog;
        LinkedHashSet<Object> classLoadersUnique;
        if (scanSpec.overrideClassLoaders == null) {
            ClassLoader classLoader;
            classLoadersUnique = new LinkedHashSet();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                classLoadersUnique.add(systemClassLoader);
            }
            List<ModuleRef> allModuleRefsList = null;
            if (scanSpec.overrideModuleLayers == null) {
                try {
                    void var8_20;
                    Class<?>[] classArray = CallStackReader.getClassContext(log);
                    int n = classArray.length - 1;
                    while (var8_20 >= 0) {
                        ClassLoader callerClassLoader = classArray[var8_20].getClassLoader();
                        if (callerClassLoader != null) {
                            classLoadersUnique.add(callerClassLoader);
                        }
                        --var8_20;
                    }
                    allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefs(classArray, scanSpec, log);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (log != null) {
                        log.log("Could not get call stack", illegalArgumentException);
                    }
                }
            } else {
                if (log != null) {
                    LogNode logNode = log.log("Overriding module layers");
                    for (Object moduleLayer : scanSpec.overrideModuleLayers) {
                        logNode.log(moduleLayer.toString());
                    }
                }
                allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefs(scanSpec.overrideModuleLayers, scanSpec, log);
            }
            if (allModuleRefsList != null) {
                this.systemModuleRefs = new ArrayList<ModuleRef>();
                this.nonSystemModuleRefs = new ArrayList<ModuleRef>();
                for (ModuleRef moduleRef : allModuleRefsList) {
                    if (moduleRef.isSystemModule()) {
                        this.systemModuleRefs.add(moduleRef);
                        continue;
                    }
                    this.nonSystemModuleRefs.add(moduleRef);
                }
            }
            if ((classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                classLoadersUnique.add(classLoader);
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        HashSet<void> ancestralClassLoaders = new HashSet<void>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            void var8_24;
            ClassLoader classLoader2 = classLoader.getParent();
            while (var8_24 != null) {
                ancestralClassLoaders.add(var8_24);
                ClassLoader classLoader3 = var8_24.getParent();
            }
        }
        ArrayList<ClassLoader> classLoaderFinalOrder = new ArrayList<ClassLoader>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderFinalOrder.add(classLoader);
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoaderFinalOrder) {
                classLoadersFoundLog.log(classLoader.getClass().getName());
            }
        }
        if (log != null) {
            LogNode logNode = log.log("Found system modules:");
            if (this.systemModuleRefs != null && !this.systemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : this.systemModuleRefs) {
                    logNode.log(moduleRef.toString());
                }
            } else {
                logNode.log("[None]");
            }
            LogNode logNode2 = log.log("Found non-system modules:");
            if (this.nonSystemModuleRefs != null && !this.nonSystemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : this.nonSystemModuleRefs) {
                    logNode2.log(moduleRef.toString());
                }
            } else {
                logNode2.log("[None]");
            }
        }
        this.contextClassLoaders = classLoaderFinalOrder.toArray(new ClassLoader[0]);
    }
}

