/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.util.List;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

public class TomcatWebappClassLoaderBaseHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.apache.catalina.loader.WebappClassLoaderBase"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object resources = ReflectionUtils.invokeMethod(classLoader, "getResources", false);
        Object baseURLs = ReflectionUtils.invokeMethod(resources, "getBaseUrls", false);
        classpathOrderOut.addClasspathEntryObject(baseURLs, classLoader, log);
        List allResources = (List)ReflectionUtils.getFieldVal(resources, "allResources", false);
        if (allResources != null) {
            for (List webResourceSetList : allResources) {
                for (Object webResourceSet : webResourceSetList) {
                    String className;
                    String base;
                    File file = (File)ReflectionUtils.invokeMethod(webResourceSet, "getFileBase", false);
                    String string = base = file == null ? null : file.getPath();
                    if (base == null) {
                        base = (String)ReflectionUtils.invokeMethod(webResourceSet, "getBase", false);
                    }
                    if (base == null) {
                        base = (String)ReflectionUtils.invokeMethod(webResourceSet, "getBaseUrlString", false);
                    }
                    if (base == null) continue;
                    String archivePath = (String)ReflectionUtils.getFieldVal(webResourceSet, "archivePath", false);
                    if (archivePath != null && !archivePath.isEmpty()) {
                        base = base + "!" + (archivePath.startsWith("/") ? archivePath : "/" + archivePath);
                    }
                    boolean isJar = (className = webResourceSet.getClass().getName()).equals("java.org.apache.catalina.webresources.JarResourceSet") || className.equals("java.org.apache.catalina.webresources.JarWarResourceSet");
                    String internalPath = (String)ReflectionUtils.invokeMethod(webResourceSet, "getInternalPath", false);
                    if (internalPath != null && !internalPath.isEmpty() && !internalPath.equals("/")) {
                        classpathOrderOut.addClasspathEntryObject(base + (isJar ? "!" : "") + (internalPath.startsWith("/") ? internalPath : "/" + internalPath), classLoader, log);
                        continue;
                    }
                    classpathOrderOut.addClasspathEntryObject(base, classLoader, log);
                }
            }
        }
        Object urls = ReflectionUtils.invokeMethod(classLoader, "getURLs", false);
        classpathOrderOut.addClasspathEntryObject(urls, classLoader, log);
    }
}

