/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import nonapi.io.github.classgraph.utils.JarUtils;

class ClassGraphClassLoader
extends ClassLoader {
    private final ScanResult scanResult;

    ClassGraphClassLoader(ScanResult scanResult) {
        super(null);
        this.scanResult = scanResult;
        ClassGraphClassLoader.registerAsParallelCapable();
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException, LinkageError, SecurityException {
        Iterator iterator;
        ResourceList classfileResources;
        boolean classpathOverridden = this.scanResult.scanSpec.overrideClasspath != null && !this.scanResult.scanSpec.overrideClasspath.isEmpty();
        ClassInfo classInfo = null;
        if (!classpathOverridden && !this.scanResult.isObtainedFromDeserialization() && (classInfo = this.scanResult.getClassInfo(className)) != null && classInfo.classLoader != null) {
            try {
                return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, classInfo.classLoader);
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
                // empty catch block
            }
        }
        if (!classpathOverridden || this.scanResult.isObtainedFromDeserialization()) {
            if (this.scanResult.envClassLoaderOrder != null) {
                for (ClassLoader envClassLoader : this.scanResult.envClassLoaderOrder) {
                    if (classInfo != null && envClassLoader == classInfo.classLoader) continue;
                    try {
                        return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, envClassLoader);
                    }
                    catch (LinkageError | ReflectiveOperationException throwable) {
                        // empty catch block
                    }
                }
            }
            if (classInfo != null && classInfo.classpathElement instanceof ClasspathElementModule && !classInfo.isPublic()) {
                throw new ClassNotFoundException("Classfile for class " + className + " was found in a module, but the context and system classloaders could not load the class, probably because the class is not public.");
            }
        }
        if ((classfileResources = this.scanResult.getResourcesWithPath(JarUtils.classNameToClassfilePath(className))) != null && (iterator = classfileResources.iterator()).hasNext()) {
            try (Resource resource = (Resource)iterator.next();){
                byte[] resourceContent = resource.load();
                Class<?> clazz = this.defineClass(className, resourceContent, 0, resourceContent.length);
                return clazz;
            }
        }
        return Class.forName(className);
    }

    @Override
    public URL getResource(String path) {
        ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResource(path);
        }
        return ((Resource)resourceList.get(0)).getURL();
    }

    @Override
    public Enumeration<URL> getResources(String path) throws IOException {
        final ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResources(path);
        }
        return new Enumeration<URL>(){
            int idx;

            @Override
            public boolean hasMoreElements() {
                return this.idx < resourceList.size();
            }

            @Override
            public URL nextElement() {
                return ((Resource)resourceList.get(this.idx++)).getURL();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResourceAsStream(path);
        }
        try {
            return ((Resource)resourceList.get(0)).open();
        }
        catch (IOException e) {
            return null;
        }
    }
}

