/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketTimeoutException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import javax.media.Buffer;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.util.MediaThread;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.protocol.PushBufferStreamAdapter;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.DatagramPacketFilter;
import org.jitsi.utils.logging.Logger;

public abstract class RTPConnectorInputStream<T extends Closeable>
implements PushSourceStream,
Closeable {
    private static final Object[] EMPTY_CONTROLS = new Object[0];
    private static final Logger logger = Logger.getLogger(RTPConnectorInputStream.class);
    public static final int PACKET_RECEIVE_BUFFER_LENGTH = 4096;
    private final byte[] buffer;
    private boolean closed;
    private DatagramPacketFilter[] datagramPacketFilters;
    private boolean enabled;
    private boolean ioError;
    private long numberOfReceivedBytes;
    private RawPacket pkt;
    private PacketLoggingService pktLogging;
    private final Object pktSyncRoot;
    private final PushBufferStream pushBufferStream;
    private final Queue<RawPacket> rawPacketPool;
    private Thread receiveThread;
    protected final T socket;
    private SourceTransferHandler transferHandler;

    public static void setThreadPriority(Thread thread, int priority) {
        int oldPriority = thread.getPriority();
        if (priority != oldPriority) {
            int newPriority;
            RuntimeException throwable = null;
            try {
                thread.setPriority(priority);
            }
            catch (IllegalArgumentException | SecurityException iae) {
                throwable = iae;
            }
            if (throwable != null) {
                logger.warn((Object)("Failed to use Thread priority: " + priority));
            }
            if (logger.isDebugEnabled() && priority != (newPriority = thread.getPriority())) {
                logger.debug((Object)("Did not change Thread priority from " + oldPriority + " to " + priority + ", " + newPriority + " instead."));
            }
        }
    }

    protected RTPConnectorInputStream(T socket) {
        block5: {
            this.buffer = new byte[4096];
            this.enabled = true;
            this.ioError = false;
            this.numberOfReceivedBytes = 0L;
            this.pktSyncRoot = new Object();
            this.rawPacketPool = new ArrayBlockingQueue<RawPacket>(RTPConnectorOutputStream.POOL_CAPACITY);
            this.socket = socket;
            if (this.socket == null) {
                this.closed = true;
            } else {
                this.closed = false;
                try {
                    this.setReceiveBufferSize(65535);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
        }
        this.addDatagramPacketFilter(new DatagramPacketFilter(){
            private long numberOfPackets = 0L;

            public boolean accept(DatagramPacket p) {
                PacketLoggingService pktLogging;
                ++this.numberOfPackets;
                if (RTPConnectorOutputStream.logPacket(this.numberOfPackets) && (pktLogging = RTPConnectorInputStream.this.getPacketLoggingService()) != null && pktLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) {
                    RTPConnectorInputStream.this.doLogPacket(p);
                }
                return true;
            }
        });
        this.pushBufferStream = new PushBufferStreamAdapter(this, null){

            @Override
            protected int doRead(Buffer buffer, byte[] data, int offset, int length) throws IOException {
                return RTPConnectorInputStream.this.read(buffer, data, offset, length);
            }
        };
        this.maybeStartReceiveThread();
    }

    private boolean accept(DatagramPacket p) {
        boolean accept;
        if (this.enabled) {
            DatagramPacketFilter[] filters = this.getDatagramPacketFilters();
            if (filters == null) {
                accept = true;
            } else {
                accept = true;
                for (DatagramPacketFilter filter : filters) {
                    try {
                        if (filter.accept(p)) continue;
                        accept = false;
                        break;
                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
            }
        } else {
            accept = false;
            if (logger.isTraceEnabled() && !this.closed) {
                logger.trace((Object)("Will drop received packet because this is disabled: " + p.getLength() + " bytes."));
            }
        }
        return accept;
    }

    public synchronized void addDatagramPacketFilter(DatagramPacketFilter datagramPacketFilter) {
        this.datagramPacketFilters = (DatagramPacketFilter[])ArrayUtils.add((Object[])this.datagramPacketFilters, DatagramPacketFilter.class, (Object)datagramPacketFilter);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.socket != null) {
            try {
                if (this.socket instanceof Closeable) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected RawPacket[] createRawPacket(DatagramPacket datagramPacket) {
        RawPacket[] pkts = new RawPacket[1];
        RawPacket pkt = this.rawPacketPool.poll();
        if (pkt == null) {
            pkt = new RawPacket();
        }
        byte[] buffer = pkt.getBuffer();
        int length = datagramPacket.getLength();
        if (buffer == null || buffer.length < length) {
            buffer = new byte[length];
            pkt.setBuffer(buffer);
        }
        System.arraycopy(datagramPacket.getData(), datagramPacket.getOffset(), buffer, 0, length);
        pkt.setBuffer(buffer);
        pkt.setOffset(0);
        pkt.setLength(length);
        pkt.setFlags(0);
        pkts[0] = pkt;
        return pkts;
    }

    protected abstract void doLogPacket(DatagramPacket var1);

    public boolean endOfStream() {
        return false;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public Object getControl(String controlType) {
        if (AbstractPushBufferStream.PUSH_BUFFER_STREAM_CLASS_NAME.equals(controlType)) {
            return this.pushBufferStream;
        }
        return null;
    }

    public Object[] getControls() {
        return EMPTY_CONTROLS;
    }

    protected synchronized DatagramPacketFilter[] getDatagramPacketFilters() {
        return this.datagramPacketFilters;
    }

    public int getMinimumTransferSize() {
        return 2048;
    }

    public long getNumberOfReceivedBytes() {
        return this.numberOfReceivedBytes;
    }

    protected PacketLoggingService getPacketLoggingService() {
        if (this.pktLogging == null) {
            this.pktLogging = LibJitsi.getPacketLoggingService();
        }
        return this.pktLogging;
    }

    private synchronized void maybeStartReceiveThread() {
        if (this.receiveThread == null) {
            if (this.socket != null && !this.closed && this.transferHandler != null) {
                this.receiveThread = new Thread(this::runInReceiveThread);
                this.receiveThread.setDaemon(true);
                this.receiveThread.setName(RTPConnectorInputStream.class.getName() + ".receiveThread");
                RTPConnectorInputStream.setThreadPriority(this.receiveThread, MediaThread.getNetworkPriority());
                this.receiveThread.start();
            }
        } else {
            this.notifyAll();
        }
    }

    private void poolRawPacket(RawPacket pkt) {
        pkt.setFlags(0);
        pkt.setLength(0);
        pkt.setOffset(0);
        this.rawPacketPool.offer(pkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        int pktLength;
        RawPacket pkt;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.ioError) {
            return -1;
        }
        Object object = this.pktSyncRoot;
        synchronized (object) {
            pkt = this.pkt;
            this.pkt = null;
        }
        if (pkt == null) {
            pktLength = 0;
        } else {
            boolean poolPkt = true;
            try {
                pktLength = pkt.getLength();
                if (length < pktLength) {
                    poolPkt = false;
                    throw new IOException("Input buffer not big enough for " + pktLength);
                }
                byte[] pktBuffer = pkt.getBuffer();
                if (pktBuffer == null) {
                    throw new NullPointerException("pkt.buffer null, pkt.length " + pktLength + ", pkt.offset " + pkt.getOffset());
                }
                System.arraycopy(pkt.getBuffer(), pkt.getOffset(), data, offset, pktLength);
                if (buffer != null) {
                    buffer.setFlags(pkt.getFlags());
                }
            }
            finally {
                if (!poolPkt) {
                    Object object2 = this.pktSyncRoot;
                    synchronized (object2) {
                        if (this.pkt == null) {
                            this.pkt = pkt;
                        } else {
                            poolPkt = true;
                        }
                    }
                }
                if (poolPkt) {
                    this.poolRawPacket(pkt);
                }
            }
        }
        return pktLength;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.read(null, buffer, offset, length);
    }

    protected abstract void receive(DatagramPacket var1) throws IOException;

    private void runInReceiveThread() {
        DatagramPacket p = new DatagramPacket(this.buffer, 0, 4096);
        while (!this.closed) {
            p.setData(this.buffer, 0, this.buffer.length);
            try {
                this.receive(p);
            }
            catch (SocketTimeoutException ste) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Socket timeout, closed=" + this.closed));
                continue;
            }
            catch (IOException e) {
                this.ioError = true;
                break;
            }
            this.numberOfReceivedBytes += (long)p.getLength();
            try {
                if (!this.accept(p)) continue;
                RawPacket[] pkts = this.createRawPacket(p);
                this.transferData(pkts);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to receive a packet: ", (Throwable)e);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setEnabled: " + enabled));
            }
            this.enabled = enabled;
        }
    }

    public void setPriority(int priority) {
    }

    protected abstract void setReceiveBufferSize(int var1) throws IOException;

    public synchronized void setTransferHandler(SourceTransferHandler transferHandler) {
        if (this.transferHandler != transferHandler) {
            this.transferHandler = transferHandler;
            this.maybeStartReceiveThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferData(RawPacket[] pkts) {
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket oldPkt;
            RawPacket pkt = pkts[i];
            pkts[i] = null;
            if (pkt == null) continue;
            if (pkt.isInvalid()) {
                this.poolRawPacket(pkt);
                continue;
            }
            Object object = this.pktSyncRoot;
            synchronized (object) {
                oldPkt = this.pkt;
                this.pkt = pkt;
            }
            if (oldPkt != null) {
                this.poolRawPacket(oldPkt);
            }
            if (this.transferHandler == null || this.closed) continue;
            try {
                this.transferHandler.transferData((PushSourceStream)this);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn((Object)"An RTP packet may have not been fully handled.", t);
            }
        }
    }
}

