/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.impl.bundle.obr.resource.Parameter;
import org.osgi.impl.bundle.obr.resource.VersionRange;

public class ManifestEntry
implements Comparable {
    String name;
    VersionRange version;
    Map attributes;
    public Map directives;
    public Set uses;

    public ManifestEntry(String name) {
        this.name = name;
    }

    public ManifestEntry(String name, VersionRange version) {
        this.name = name;
        this.version = version;
    }

    public String toString() {
        if (this.version == null) {
            return this.name;
        }
        return this.name + " ;version=" + this.version;
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return new VersionRange("0");
    }

    public int compareTo(Object o) {
        ManifestEntry p = (ManifestEntry)o;
        return this.name.compareTo(p.name);
    }

    public Object getPath() {
        return this.getName().replace('.', '/');
    }

    public Map getDirectives() {
        return this.directives;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void addParameter(Parameter parameter) {
        switch (parameter.type) {
            case 1: {
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(parameter.key, parameter.value);
                if (!parameter.key.equalsIgnoreCase("version") && !parameter.key.equalsIgnoreCase("specification-version")) break;
                this.version = new VersionRange(parameter.value);
                break;
            }
            case 2: {
                if (this.directives == null) {
                    this.directives = new HashMap();
                }
                this.directives.put(parameter.key, parameter.value);
            }
        }
    }

    public ManifestEntry getAlias(String key) {
        ManifestEntry me = new ManifestEntry(key);
        me.attributes = this.attributes;
        me.directives = this.directives;
        me.version = this.version;
        return me;
    }

    public String getDirective(String directive) {
        if (this.directives == null) {
            return null;
        }
        return (String)this.directives.get(directive);
    }

    public String getAttribute(String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attribute);
    }
}

