/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.ChainWrappingRule;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\f\u0010\u0017\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\r*\u00020\u000bH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0019*\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/ChainWrappingRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "nextLineTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "noSpaceAroundTokens", "prefixTokens", "sameLineTokens", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isInPrefixPosition", "isPartOfSpread", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isPartOfWhenCondition", "prevLeafIgnoringWhitespaceAndComments", "ktlint-ruleset-standard"})
public final class ChainWrappingRule
extends Rule {
    private final TokenSet sameLineTokens = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.MUL, (IElementType)KtTokens.DIV, (IElementType)KtTokens.PERC, (IElementType)KtTokens.ANDAND, (IElementType)KtTokens.OROR});
    private final TokenSet prefixTokens = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.PLUS, (IElementType)KtTokens.MINUS});
    private final TokenSet nextLineTokens = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.DOT, (IElementType)KtTokens.SAFE_ACCESS, (IElementType)KtTokens.ELVIS});
    private final TokenSet noSpaceAroundTokens = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.DOT, (IElementType)KtTokens.SAFE_ACCESS});

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        PsiElement prevLeaf;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        IElementType elementType = node.getElementType();
        if (this.nextLineTokens.contains(elementType)) {
            PsiElement nextLeaf = PsiUtilsKt.nextLeaf((PsiElement)node.getPsi(), (boolean)true);
            if (nextLeaf instanceof PsiWhiteSpaceImpl && nextLeaf.textContains('\n')) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not end with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    PsiElement prevLeaf2 = PsiUtilsKt.prevLeaf((PsiElement)node.getPsi(), (boolean)true);
                    if (prevLeaf2 instanceof PsiWhiteSpaceImpl) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)((PsiWhiteSpaceImpl)prevLeaf2).rawReplaceWithText(((PsiWhiteSpaceImpl)nextLeaf).getText()), (String)"prevLeaf.rawReplaceWithText(nextLeaf.text)");
                    } else {
                        PsiElement psiElement = node.getPsi();
                        if (psiElement == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        ((LeafPsiElement)psiElement).rawInsertBeforeMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)((PsiWhiteSpaceImpl)nextLeaf).getText()));
                    }
                    if (this.noSpaceAroundTokens.contains(elementType)) {
                        ((PsiWhiteSpaceImpl)nextLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpaceImpl)nextLeaf).getNode());
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)((PsiWhiteSpaceImpl)nextLeaf).rawReplaceWithText(" "), (String)"nextLeaf.rawReplaceWithText(\" \")");
                    }
                }
            }
        } else if (!(!this.sameLineTokens.contains(elementType) && !this.prefixTokens.contains(elementType) || !((prevLeaf = PsiUtilsKt.prevLeaf((PsiElement)node.getPsi(), (boolean)true)) instanceof PsiWhiteSpaceImpl) || !prevLeaf.textContains('\n') || !(Intrinsics.areEqual((Object)elementType, (Object)KtTokens.MUL) ^ true) && this.isPartOfSpread(prevLeaf) || this.prefixTokens.contains(elementType) && this.isInPrefixPosition(node) || this.isPartOfWhenCondition(node))) {
            emit.invoke((Object)node.getStartOffset(), (Object)("Line must not begin with \"" + node.getText() + '\"'), (Object)true);
            if (autoCorrect) {
                PsiElement nextLeaf = PsiUtilsKt.nextLeaf((PsiElement)node.getPsi(), (boolean)true);
                if (nextLeaf instanceof PsiWhiteSpaceImpl) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)((PsiWhiteSpaceImpl)nextLeaf).rawReplaceWithText(((PsiWhiteSpaceImpl)prevLeaf).getText()), (String)"nextLeaf.rawReplaceWithText(prevLeaf.text)");
                } else {
                    PsiElement psiElement = node.getPsi();
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)psiElement).rawInsertAfterMe((TreeElement)new PsiWhiteSpaceImpl((CharSequence)((PsiWhiteSpaceImpl)prevLeaf).getText()));
                }
                if (this.noSpaceAroundTokens.contains(elementType)) {
                    ((PsiWhiteSpaceImpl)prevLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpaceImpl)prevLeaf).getNode());
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)((PsiWhiteSpaceImpl)prevLeaf).rawReplaceWithText(" "), (String)"prevLeaf.rawReplaceWithText(\" \")");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfSpread(@NotNull PsiElement $receiver) {
        PsiElement psiElement = this.prevLeafIgnoringWhitespaceAndComments($receiver);
        if (psiElement == null) return false;
        PsiElement psiElement2 = psiElement;
        PsiElement leaf = psiElement2;
        IElementType type = leaf.getNode().getElementType();
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.LPAR)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.COMMA)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.LBRACE)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.ELSE_KEYWORD)) return true;
        if (!KtTokens.OPERATIONS.contains(type)) return false;
        return true;
    }

    private final boolean isInPrefixPosition(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.PREFIX_EXPRESSION);
    }

    private final boolean isPartOfWhenCondition(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getTreeParent();
        return Intrinsics.areEqual(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null, (Object)KtNodeTypes.WHEN_CONDITION_EXPRESSION);
    }

    private final PsiElement prevLeafIgnoringWhitespaceAndComments(@NotNull PsiElement $receiver) {
        return PsiUtilsKt.prevLeaf((PsiElement)$receiver, (Function1)prevLeafIgnoringWhitespaceAndComments.1.INSTANCE);
    }

    public ChainWrappingRule() {
        super("chain-wrapping");
    }
}

