/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ManyCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.NoneCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ:\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u001e\u001a\u00020\u0015*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "(Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;)V", "createAllCandidatesResult", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "runCompletion", "", "resolvedCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "skipPostponedArguments", "", "factory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "prepareForCompletion", "resolution"})
public final class KotlinCallCompleter {
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;

    @NotNull
    public final CallResolutionResult runCompletion(@NotNull SimpleCandidateFactory factory2, @NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType2, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        List diagnosticsFromResolutionParts;
        Object object;
        KotlinResolutionCandidate candidate2;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        if (candidates2.isEmpty()) {
            diagnosticHolder.addDiagnostic(new NoneCandidatesCallDiagnostic(factory2.getKotlinCall()));
        }
        if (candidates2.size() > 1) {
            diagnosticHolder.addDiagnostic(new ManyCandidatesCallDiagnostic(factory2.getKotlinCall(), candidates2));
        }
        if ((object2 = (candidate2 = (KotlinResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates2))) != null && (object2 = ((KotlinResolutionCandidate)object2).getResolvedCall()) != null) {
            Object object3;
            Object it = object3 = object2;
            resolutionCallbacks.bindStubResolvedCallForCandidate((ResolvedCallAtom)it);
        }
        List list2 = (object = candidate2) != null && (object = ((KotlinResolutionCandidate)object).getDiagnosticsFromResolutionParts()) != null ? (List)object : (diagnosticsFromResolutionParts = CollectionsKt.emptyList());
        if (candidate2 == null || candidate2.getCsBuilder$resolution().getHasContradiction()) {
            KotlinResolutionCandidate kotlinResolutionCandidate = candidate2;
            if (kotlinResolutionCandidate == null) {
                kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)factory2.createErrorCandidate());
            }
            KotlinResolutionCandidate candidateForCompletion = kotlinResolutionCandidate;
            this.prepareForCompletion(candidateForCompletion, expectedType2, resolutionCallbacks);
            KotlinCallCompleter.runCompletion$default(this, candidateForCompletion.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticHolder, candidateForCompletion.getSystem(), resolutionCallbacks, false, 32, null);
            Object object4 = candidate2;
            if (object4 == null || (object4 = ((KotlinResolutionCandidate)object4).getSystem()) == null || (object4 = object4.asReadOnlyStorage()) == null) {
                object4 = ConstraintStorage.Empty.INSTANCE;
            }
            Object systemStorage = object4;
            KotlinResolutionCandidate kotlinResolutionCandidate2 = candidate2;
            return new CallResolutionResult(CallResolutionResult.Type.ERROR, kotlinResolutionCandidate2 != null ? kotlinResolutionCandidate2.getResolvedCall() : null, CollectionsKt.plus((Collection)diagnosticHolder.getDiagnostics(), (Iterable)diagnosticsFromResolutionParts), (ConstraintStorage)systemStorage, null, 16, null);
        }
        KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionType = this.prepareForCompletion(candidate2, expectedType2, resolutionCallbacks);
        NewConstraintSystem constraintSystem = candidate2.getSystem();
        KotlinCallCompleter.runCompletion$default(this, candidate2.getResolvedCall(), completionType, diagnosticHolder, constraintSystem, resolutionCallbacks, false, 32, null);
        return completionType == KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL ? new CallResolutionResult(CallResolutionResult.Type.COMPLETED, candidate2.getResolvedCall(), CollectionsKt.plus((Collection)diagnosticHolder.getDiagnostics(), (Iterable)diagnosticsFromResolutionParts), constraintSystem.asReadOnlyStorage(), null, 16, null) : new CallResolutionResult(CallResolutionResult.Type.PARTIAL, candidate2.getResolvedCall(), CollectionsKt.plus((Collection)diagnosticHolder.getDiagnostics(), (Iterable)diagnosticsFromResolutionParts), constraintSystem.asReadOnlyStorage(), null, 16, null);
    }

    @NotNull
    public final CallResolutionResult createAllCandidatesResult(@NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType2, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        for (KotlinResolutionCandidate candidate2 : candidates2) {
            this.prepareForCompletion(candidate2, expectedType2, resolutionCallbacks);
            this.runCompletion(candidate2.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticsHolder, candidate2.getSystem(), resolutionCallbacks, true);
        }
        return new CallResolutionResult(CallResolutionResult.Type.ALL_CANDIDATES, null, CollectionsKt.emptyList(), ConstraintStorage.Empty.INSTANCE, candidates2);
    }

    private final void runCompletion(ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionMode, KotlinDiagnosticsHolder diagnosticsHolder, NewConstraintSystem constraintSystem, KotlinResolutionCallbacks resolutionCallbacks, boolean skipPostponedArguments) {
        UnwrappedType unwrappedType = ResolutionAtomsKt.getFreshReturnType(resolvedCallAtom);
        if (unwrappedType == null) {
            SimpleType simpleType2 = constraintSystem.getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"constraintSystem.builtIns.unitType");
            unwrappedType = simpleType2;
        }
        UnwrappedType returnType = unwrappedType;
        this.kotlinConstraintSystemCompleter.runCompletion(constraintSystem.asConstraintSystemCompleterContext(), completionMode, resolvedCallAtom, returnType, (Function1<? super PostponedResolvedAtom, Unit>)((Function1)new Function1<PostponedResolvedAtom, Unit>(this, skipPostponedArguments, constraintSystem, resolutionCallbacks, diagnosticsHolder){
            final /* synthetic */ KotlinCallCompleter this$0;
            final /* synthetic */ boolean $skipPostponedArguments;
            final /* synthetic */ NewConstraintSystem $constraintSystem;
            final /* synthetic */ KotlinResolutionCallbacks $resolutionCallbacks;
            final /* synthetic */ KotlinDiagnosticsHolder $diagnosticsHolder;

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (!this.$skipPostponedArguments) {
                    KotlinCallCompleter.access$getPostponedArgumentsAnalyzer$p(this.this$0).analyze(this.$constraintSystem.asPostponedArgumentsAnalyzerContext(), this.$resolutionCallbacks, it, this.$diagnosticsHolder);
                }
            }
            {
                this.this$0 = kotlinCallCompleter;
                this.$skipPostponedArguments = bl;
                this.$constraintSystem = newConstraintSystem;
                this.$resolutionCallbacks = kotlinResolutionCallbacks;
                this.$diagnosticsHolder = kotlinDiagnosticsHolder;
                super(1);
            }
        }));
        Iterable $receiver$iv = constraintSystem.getDiagnostics();
        for (Object element$iv : $receiver$iv) {
            KotlinCallDiagnostic p1 = (KotlinCallDiagnostic)element$iv;
            diagnosticsHolder.addDiagnostic(p1);
        }
    }

    static /* bridge */ /* synthetic */ void runCompletion$default(KotlinCallCompleter kotlinCallCompleter, ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode constraintSystemCompletionMode, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, NewConstraintSystem newConstraintSystem, KotlinResolutionCallbacks kotlinResolutionCallbacks, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinCallCompleter.runCompletion(resolvedCallAtom, constraintSystemCompletionMode, kotlinDiagnosticsHolder, newConstraintSystem, kotlinResolutionCallbacks, bl);
    }

    private final KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode prepareForCompletion(@NotNull KotlinResolutionCandidate $receiver, UnwrappedType expectedType2, KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinType kotlinType = $receiver.getResolvedCall().getCandidateDescriptor().getReturnType();
        if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
            return KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
        }
        KotlinType unsubstitutedReturnType = kotlinType;
        ReceiverValueWithSmartCastInfo withSmartCastInfo = resolutionCallbacks.createReceiverWithSmartCastInfo($receiver.getResolvedCall());
        Object object = withSmartCastInfo;
        if (object == null || (object = ArgumentsUtilsKt.getStableType((ReceiverValueWithSmartCastInfo)object)) == null) {
            object = unsubstitutedReturnType;
        }
        Object actualType = object;
        UnwrappedType returnType = $receiver.getResolvedCall().getSubstitutor().substituteKeepAnnotations((UnwrappedType)actualType);
        if (expectedType2 != null && !TypeUtils.noExpectedType(expectedType2) && !resolutionCallbacks.isCompileTimeConstant($receiver.getResolvedCall(), expectedType2)) {
            $receiver.getCsBuilder$resolution().addSubtypeConstraint(returnType, expectedType2, new ExpectedTypeConstraintPosition($receiver.getResolvedCall().getAtom()));
        }
        return expectedType2 != null || $receiver.getCsBuilder$resolution().isProperType(returnType) ? KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL : KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
    }

    public KotlinCallCompleter(@NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter) {
        Intrinsics.checkParameterIsNotNull((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
    }

    @NotNull
    public static final /* synthetic */ PostponedArgumentsAnalyzer access$getPostponedArgumentsAnalyzer$p(KotlinCallCompleter $this) {
        return $this.postponedArgumentsAnalyzer;
    }
}

