/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BaseExpressionCodegen;
import org.jetbrains.kotlin.codegen.BoxedToPrimitiveEquality;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesKt;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallReceiver;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CodegenStatementVisitor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.FieldAccessorKind;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PrimitiveToBoxedEquality;
import org.jetbrains.kotlin.codegen.PrimitiveToObjectEquality;
import org.jetbrains.kotlin.codegen.PrimitiveToSafeCallEquality;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SafeCallToPrimitiveEquality;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueWithLeaveTask;
import org.jetbrains.kotlin.codegen.TailRecursionCodegen;
import org.jetbrains.kotlin.codegen.TypeAndNullability;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenForLambda;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.ResolvedCallWithRealDescriptor;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenForDefaultBody;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.PsiInlineCodegen;
import org.jetbrains.kotlin.codegen.inline.PsiSourceCompilerForInline;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceCompilerForInline;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicWithSpecialReceiver;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.range.RangeValue;
import org.jetbrains.kotlin.codegen.range.RangeValuesKt;
import org.jetbrains.kotlin.codegen.range.forLoop.ForLoopGenerator;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.JvmConstantsKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ExpressionCodegen
extends KtVisitor<StackValue, StackValue>
implements BaseExpressionCodegen,
LocalLookup {
    private final GenerationState state;
    final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    public final InstructionAdapter v;
    public final FrameMap myFrameMap;
    public final MethodContext context;
    private final Type returnType;
    private final CodegenStatementVisitor statementVisitor = new CodegenStatementVisitor(this);
    private final MemberCodegen<?> parentCodegen;
    private final TailRecursionCodegen tailRecursionCodegen;
    public final CallGenerator defaultCallGenerator = new CallGenerator.DefaultCallGenerator(this);
    private final SwitchCodegenProvider switchCodegenProvider;
    private final Stack<BlockStackElement> blockStackElements = new Stack();
    public final Map<KtElement, StackValue> tempVariables = Maps.newHashMap();
    private int myLastLineNumber = -1;
    private boolean shouldMarkLineNumbers = true;
    private int finallyDepth = 0;

    public ExpressionCodegen(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull Type returnType, @NotNull MethodContext context, @NotNull GenerationState state2, @NotNull MemberCodegen<?> parentCodegen) {
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.v = new InstructionAdapter(mv);
        this.myFrameMap = frameMap;
        this.context = context;
        this.returnType = returnType;
        this.parentCodegen = parentCodegen;
        this.tailRecursionCodegen = new TailRecursionCodegen(context, this, this.v, state2);
        this.switchCodegenProvider = new SwitchCodegenProvider(this);
    }

    @Nullable
    private static FunctionDescriptor getOriginalSuspendLambdaDescriptorFromContext(MethodContext context) {
        if (context.getParentContext() instanceof ClosureContext && context.getParentContext().closure != null && context.getParentContext().closure.isSuspend()) {
            return ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor();
        }
        return null;
    }

    @NotNull
    public GenerationState getState() {
        return this.state;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    @NotNull
    public ObjectLiteralResult generateObjectLiteral(@NotNull KtObjectLiteralExpression literal) {
        KtObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(objectDeclaration, classDescriptor), asmType, literal.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION);
        ImplementationBodyCodegen literalCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true);
        literalCodegen.generate();
        ExpressionCodegen.addReifiedParametersFromSignature(literalCodegen, classDescriptor);
        this.propagateChildReifiedTypeParametersUsages(literalCodegen.getReifiedTypeParametersUsages());
        return new ObjectLiteralResult(literalCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters(), classDescriptor);
    }

    private static void addReifiedParametersFromSignature(@NotNull MemberCodegen member, @NotNull ClassDescriptor descriptor2) {
        for (KotlinType type2 : descriptor2.getTypeConstructor().getSupertypes()) {
            for (TypeProjection supertypeArgument : type2.getArguments()) {
                TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(supertypeArgument.getType());
                if (parameterDescriptor == null || !parameterDescriptor.isReified()) continue;
                member.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterDescriptor.getName().asString());
            }
        }
    }

    @NotNull
    private StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, @NotNull ClassDescriptor provided, @NotNull ClassDescriptor required) {
        if (!JvmCodegenUtil.isJvmInterface(provided) && JvmCodegenUtil.isJvmInterface(required)) {
            return StackValue.coercion(inner, this.asmType(required.getDefaultType()));
        }
        return inner;
    }

    public StackValue genQualified(StackValue receiver, KtElement selector) {
        return this.genQualified(receiver, selector, this);
    }

    private StackValue genQualified(StackValue receiver, KtElement selector, KtVisitor<StackValue, StackValue> visitor2) {
        if (this.tempVariables.containsKey(selector)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector instanceof KtBlockExpression)) {
            this.markStartLineNumber(selector);
        }
        try {
            KtExpression expression2;
            StackValue samValue;
            if (selector instanceof KtExpression && (samValue = this.genSamInterfaceValue((KtExpression)selector, visitor2)) != null) {
                return samValue;
            }
            StackValue stackValue = selector.accept(visitor2, receiver);
            RuntimeAssertionInfo runtimeAssertionInfo = null;
            if (selector instanceof KtExpression && (runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2 = (KtExpression)selector)) == null && this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.StrictJavaNullabilityAssertions)) {
                runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.BODY_RUNTIME_ASSERTION_INFO, expression2);
            }
            if (BuiltinSpecialBridgesKt.isValueArgumentForCallToMethodWithTypeCheckBarrier(selector, this.bindingContext)) {
                return stackValue;
            }
            return AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
        }
        catch (CompilationException | ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable error) {
            String message = error.getMessage();
            throw new CompilationException(message != null ? message : "null", error, selector);
        }
    }

    public StackValue gen(KtElement expr) {
        StackValue tempVar = this.tempVariables.get(expr);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr);
    }

    public void gen(KtElement expr, Type type2) {
        StackValue value = Type.VOID_TYPE.equals(type2) ? this.genStatement(expr) : this.gen(expr);
        this.putStackValue(expr, type2, value);
    }

    private void putStackValue(@Nullable KtElement expr, @NotNull Type type2, @NotNull StackValue value) {
        ScriptContext context;
        if (value.type != Type.VOID_TYPE && this.state.getReplSpecific().getShouldGenerateScriptResultValue() && expr == (context = this.getScriptContext()).getLastStatement()) {
            StackValue.Field resultValue = StackValue.field(context.getResultFieldInfo(), (StackValue)StackValue.LOCAL_0);
            resultValue.store(value, this.v);
            this.state.getReplSpecific().setHasResult(true);
            return;
        }
        value.put(type2, this.v);
    }

    @NotNull
    private ScriptContext getScriptContext() {
        CodegenContext context = this.getContext();
        while (!(context instanceof ScriptContext)) {
            context = ((CodegenContext)context).getParentContext();
        }
        return (ScriptContext)context;
    }

    public StackValue genLazy(KtElement expr, Type type2) {
        StackValue value = this.gen(expr);
        return StackValue.coercion(value, type2);
    }

    private StackValue genStatement(KtElement statement2) {
        return this.genQualified(StackValue.none(), statement2, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(@NotNull KtClass klass2, StackValue data) {
        return this.visitClassOrObject(klass2);
    }

    @Override
    public StackValue visitTypeAlias(@NotNull KtTypeAlias typeAlias, StackValue data) {
        return StackValue.none();
    }

    private StackValue visitClassOrObject(KtClassOrObject declaration) {
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration);
        assert (descriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, declaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, descriptor2), asmType, declaration.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.IMPLEMENTATION);
        new ImplementationBodyCodegen(declaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true).generate();
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, StackValue data) {
        return this.visitClassOrObject(declaration);
    }

    @Override
    public StackValue visitExpression(@NotNull KtExpression expression2, StackValue receiver) {
        throw new UnsupportedOperationException("Codegen for " + expression2 + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(@NotNull KtSuperExpression expression2, StackValue data) {
        return StackValue.thisOrOuter(this, ExpressionCodegen.getSuperCallLabelTarget(this.context, expression2), true, false);
    }

    @NotNull
    public static ClassDescriptor getSuperCallLabelTarget(@NotNull CodegenContext<?> context, @NotNull KtSuperExpression expression2) {
        KotlinType thisTypeForSuperCall = context.getState().getBindingContext().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
        assert (thisTypeForSuperCall != null) : "This type for superCall ''" + expression2.getText() + "'' should be not null!";
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "'This' reference target for ''" + expression2.getText() + "''should be class descriptor, but was " + descriptor2;
        return (ClassDescriptor)descriptor2;
    }

    @NotNull
    public Type asmType(@NotNull KotlinType type2) {
        return this.typeMapper.mapType(type2);
    }

    @NotNull
    public Type expressionType(@Nullable KtExpression expression2) {
        return CodegenUtilKt.asmType(expression2, this.typeMapper, this.bindingContext);
    }

    @Override
    public StackValue visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, StackValue receiver) {
        return this.genQualified(receiver, expression2.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, StackValue receiver) {
        return this.genQualified(receiver, expression2.getBaseExpression());
    }

    private static boolean isEmptyExpression(@Nullable KtElement expr) {
        KtBlockExpression blockExpression;
        List<KtExpression> statements;
        if (expr == null) {
            return true;
        }
        return expr instanceof KtBlockExpression && ((statements = (blockExpression = (KtBlockExpression)expr).getStatements()).size() == 0 || statements.size() == 1 && ExpressionCodegen.isEmptyExpression(statements.get(0)));
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression2, StackValue receiver) {
        return this.generateIfExpression(expression2, false);
    }

    StackValue generateIfExpression(@NotNull KtIfExpression expression2, boolean isStatement) {
        Type asmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        StackValue condition = this.gen(expression2.getCondition());
        KtExpression thenExpression = expression2.getThen();
        KtExpression elseExpression = expression2.getElse();
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                return StackValue.coercion(condition, asmType);
            }
            return this.generateSingleBranchIf(condition, expression2, elseExpression, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition, expression2, thenExpression, true, isStatement);
        }
        return StackValue.operation(asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition, elseLabel, true, (InstructionAdapter)v);
            Label end = new Label();
            this.gen(thenExpression, asmType);
            v.goTo(end);
            v.mark(elseLabel);
            this.gen(elseExpression, asmType);
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitWhileExpression(@NotNull KtWhileExpression expression2, StackValue receiver) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.generateWhile(expression2);
            return Unit.INSTANCE;
        }));
    }

    private void generateWhile(@NotNull KtWhileExpression expression2) {
        Label condition = new Label();
        this.v.mark(condition);
        Label end = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, ExpressionCodegen.targetLabel(expression2)));
        StackValue conditionValue = this.gen(expression2.getCondition());
        BranchedValue.Companion.loopJump(conditionValue, end, true, this.v);
        this.generateLoopBody(expression2.getBody());
        this.markStartLineNumber(expression2);
        this.v.goTo(condition);
        this.v.mark(end);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, StackValue receiver) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.generateDoWhile(expression2);
            return Unit.INSTANCE;
        }));
    }

    private void generateDoWhile(@NotNull KtDoWhileExpression expression2) {
        StackValue conditionValue;
        Label beginLoopLabel = new Label();
        this.v.mark(beginLoopLabel);
        Label breakLabel = new Label();
        Label continueLabel = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression2)));
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, breakLabel);
        KtExpression body = expression2.getBody();
        KtExpression condition = expression2.getCondition();
        StackValueWithLeaveTask leaveTask = null;
        if (body instanceof KtBlockExpression) {
            List<KtExpression> doWhileStatements = ((KtBlockExpression)body).getStatements();
            ArrayList<KtExpression> statements = new ArrayList<KtExpression>(doWhileStatements.size() + 1);
            statements.addAll(doWhileStatements);
            statements.add(condition);
            leaveTask = this.generateBlock(statements, false, continueLabel, null);
            conditionValue = leaveTask.getStackValue();
        } else {
            if (body != null) {
                this.gen(body, Type.VOID_TYPE);
            }
            this.v.mark(continueLabel);
            conditionValue = this.gen(condition);
        }
        BranchedValue.Companion.loopJump(conditionValue, beginLoopLabel, false, this.v);
        if (leaveTask != null) {
            leaveTask.getLeaveTasks().invoke((Object)conditionValue);
        }
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitForExpression(@NotNull KtForExpression forExpression, StackValue receiver) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.generateFor(forExpression);
            return Unit.INSTANCE;
        }));
    }

    private void generateFor(@NotNull KtForExpression forExpression) {
        KtExpression range = forExpression.getLoopRange();
        assert (range != null) : "No loop range in for expression";
        RangeValue rangeValue = RangeValuesKt.createRangeValueForExpression(this, range);
        this.generateForLoop(rangeValue.createForLoopGenerator(this, forExpression));
    }

    @NotNull
    public static KotlinType getExpectedReceiverType(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        ReceiverParameterDescriptor extensionReceiver = resolvedCall2.getResultingDescriptor().getExtensionReceiverParameter();
        assert (extensionReceiver != null) : "Extension receiver should be non-null";
        return extensionReceiver.getType();
    }

    @Nullable
    public static KtExpression getSingleArgumentExpression(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        List<ResolvedValueArgument> resolvedValueArguments = resolvedCall2.getValueArgumentsByIndex();
        if (resolvedValueArguments == null) {
            return null;
        }
        if (resolvedValueArguments.size() != 1) {
            return null;
        }
        List<ValueArgument> valueArguments = resolvedValueArguments.get(0).getArguments();
        if (valueArguments.size() != 1) {
            return null;
        }
        return valueArguments.get(0).getArgumentExpression();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(ForLoopGenerator generator) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator.beforeLoop();
        generator.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        generator.checkPreCondition(loopExit);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        generator.beforeBody();
        this.blockStackElements.push(new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator.getForExpression())));
        generator.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator.afterLoop();
    }

    public void generateLoopBody(@Nullable KtExpression body) {
        if (body != null) {
            this.gen(body, Type.VOID_TYPE);
        }
    }

    @Override
    public StackValue visitBreakExpression(@NotNull KtBreakExpression expression2, StackValue receiver) {
        return this.generateBreakOrContinueExpression(expression2, true, new Label());
    }

    @Override
    public StackValue visitContinueExpression(@NotNull KtContinueExpression expression2, StackValue receiver) {
        return this.generateBreakOrContinueExpression(expression2, false, new Label());
    }

    @NotNull
    private StackValue generateBreakOrContinueExpression(@NotNull KtExpressionWithLabel expression2, boolean isBreak, @NotNull Label afterBreakContinueLabel) {
        assert (expression2 instanceof KtContinueExpression || expression2 instanceof KtBreakExpression);
        if (this.blockStackElements.isEmpty()) {
            throw new UnsupportedOperationException("Target label for break/continue not found");
        }
        BlockStackElement stackElement = this.blockStackElements.peek();
        if (stackElement instanceof FinallyBlockStackElement) {
            FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
            this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterBreakContinueLabel);
        } else if (stackElement instanceof LoopBlockStackElement) {
            LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            if (labelElement == null || loopBlockStackElement.targetLabel != null && labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName())) {
                Label label = isBreak ? loopBlockStackElement.breakLabel : loopBlockStackElement.continueLabel;
                return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                    PseudoInsnsKt.fixStackAndJump(this.v, label);
                    this.v.mark(afterBreakContinueLabel);
                    return Unit.INSTANCE;
                }));
            }
        } else {
            throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
        }
        this.blockStackElements.pop();
        StackValue result2 = this.generateBreakOrContinueExpression(expression2, isBreak, afterBreakContinueLabel);
        this.blockStackElements.push(stackElement);
        return result2;
    }

    private StackValue generateSingleBranchIf(StackValue condition, KtIfExpression ifExpression, KtExpression expression2, boolean inverse, boolean isStatement) {
        Type targetType = isStatement ? Type.VOID_TYPE : this.expressionType(ifExpression);
        return StackValue.operation(targetType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition, elseLabel, inverse, (InstructionAdapter)v);
            if (isStatement) {
                this.gen(expression2, Type.VOID_TYPE);
                v.mark(elseLabel);
            } else {
                this.gen(expression2, targetType);
                Label end = new Label();
                v.goTo(end);
                v.mark(elseLabel);
                StackValue.putUnitInstance(v);
                this.markStartLineNumber(ifExpression);
                v.mark(end);
            }
            return null;
        }));
    }

    @Override
    public StackValue visitConstantExpression(@NotNull KtConstantExpression expression2, StackValue receiver) {
        ConstantValue<?> compileTimeValue = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression2));
    }

    @Nullable
    public ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2) {
        return ExpressionCodegen.getCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
    }

    @Nullable
    public ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2) {
        return ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
    }

    @Nullable
    public static ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext, false, shouldInlineConstVals);
        if (constant == null || ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constant)) {
            return null;
        }
        return constant;
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        return ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext, false, shouldInlineConstVals);
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean takeUpConstValsAsConst, boolean shouldInlineConstVals) {
        return JvmConstantsKt.getCompileTimeConstant(expression2, bindingContext, takeUpConstValsAsConst, shouldInlineConstVals);
    }

    @Override
    public StackValue visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, StackValue receiver) {
        List<StringTemplateEntry> entries = this.preprocessStringTemplate(expression2);
        Type type2 = this.expressionType(expression2);
        if (entries.size() == 0) {
            return StackValue.constant("", type2);
        }
        if (entries.size() == 1) {
            StringTemplateEntry entry = entries.get(0);
            if (entry instanceof StringTemplateEntry.Expression) {
                KtExpression expr = ((StringTemplateEntry.Expression)entry).expression;
                return AsmUtil.genToString(this.gen(expr), type2);
            }
            return StackValue.constant(((StringTemplateEntry.Constant)entry).value, type2);
        }
        return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            AsmUtil.genStringBuilderConstructor(v);
            this.invokeAppendForEntries((InstructionAdapter)v, entries);
            v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            return Unit.INSTANCE;
        }));
    }

    private void invokeAppendForEntries(InstructionAdapter v, List<StringTemplateEntry> entries) {
        for (StringTemplateEntry entry : entries) {
            if (entry instanceof StringTemplateEntry.Expression) {
                this.invokeAppend(v, ((StringTemplateEntry.Expression)entry).expression);
                continue;
            }
            String value = ((StringTemplateEntry.Constant)entry).value;
            if (value.length() == 1) {
                v.iconst(value.charAt(0));
                AsmUtil.genInvokeAppendMethod(v, Type.CHAR_TYPE);
                continue;
            }
            v.aconst(value);
            AsmUtil.genInvokeAppendMethod(v, AsmTypes.JAVA_STRING_TYPE);
        }
    }

    @NotNull
    private List<StringTemplateEntry> preprocessStringTemplate(@NotNull KtStringTemplateExpression expression2) {
        KtStringTemplateEntry[] entries = expression2.getEntries();
        ArrayList<StringTemplateEntry> result2 = new ArrayList<StringTemplateEntry>(entries.length);
        StringBuilder constantValue = new StringBuilder("");
        for (KtStringTemplateEntry entry : entries) {
            if (entry instanceof KtLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof KtEscapeStringTemplateEntry) {
                constantValue.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            if (entry instanceof KtStringTemplateEntryWithExpression) {
                KtExpression entryExpression = entry.getExpression();
                if (entryExpression == null) {
                    throw new AssertionError((Object)("No expression in " + entry));
                }
                ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(entryExpression);
                if (compileTimeConstant != null && ExpressionCodegen.isConstantValueInlinableInStringTemplate(compileTimeConstant)) {
                    constantValue.append(String.valueOf(compileTimeConstant.getValue()));
                    continue;
                }
                result2.add(new StringTemplateEntry.Constant(constantValue.toString()));
                constantValue.setLength(0);
                result2.add(new StringTemplateEntry.Expression(entryExpression));
                continue;
            }
            throw new AssertionError((Object)("Unexpected string template entry: " + entry));
        }
        String leftoverConstantValue = constantValue.toString();
        if (leftoverConstantValue.length() > 0) {
            result2.add(new StringTemplateEntry.Constant(leftoverConstantValue));
        }
        return result2;
    }

    private static boolean isConstantValueInlinableInStringTemplate(@NotNull ConstantValue<?> constant) {
        return constant instanceof StringValue || constant instanceof BooleanValue || constant instanceof DoubleValue || constant instanceof FloatValue || constant instanceof IntegerValueConstant || constant instanceof NullValue;
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression2, StackValue receiver) {
        return this.generateBlock(expression2, false);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data) {
        return this.visitNamedFunction(function2, data, false);
    }

    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data, boolean isStatement) {
        assert (data == StackValue.none());
        if (KtPsiUtil.isScriptDeclaration(function2)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function2, null);
        if (isStatement) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            int index2 = this.lookupLocalIndex(descriptor2);
            closure.put(AsmTypes.OBJECT_TYPE, this.v);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
            return StackValue.none();
        }
        return closure;
    }

    @Override
    public StackValue visitLambdaExpression(@NotNull KtLambdaExpression expression2, StackValue receiver) {
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BLOCK, expression2))) {
            return this.gen(expression2.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression2.getFunctionLiteral(), null);
    }

    @NotNull
    private StackValue genClosure(KtDeclarationWithBody declaration, @Nullable SamType samType) {
        FunctionDescriptor descriptor2 = this.bindingContext.get(BindingContext.FUNCTION, declaration);
        assert (descriptor2 != null) : "Function is not resolved to descriptor: " + declaration.getText();
        return this.genClosure(declaration, descriptor2, new ClosureGenerationStrategy(this.state, declaration), samType, null, null);
    }

    @NotNull
    private StackValue genClosure(@NotNull KtElement declaration, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy, @Nullable SamType samType, @Nullable FunctionDescriptor functionReferenceTarget, @Nullable StackValue functionReferenceReceiver) {
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, descriptor2), CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, descriptor2), declaration.getContainingFile());
        ClosureCodegen coroutineCodegen = CoroutineCodegenForLambda.create(this, descriptor2, declaration, cv);
        ClosureCodegen closureCodegen = coroutineCodegen != null ? coroutineCodegen : new ClosureCodegen(this.state, declaration, samType, this.context.intoClosure(descriptor2, this, this.typeMapper), functionReferenceTarget, strategy, this.parentCodegen, cv);
        closureCodegen.generate();
        return this.putClosureInstanceOnStack(closureCodegen, functionReferenceReceiver);
    }

    @NotNull
    public StackValue putClosureInstanceOnStack(@NotNull ClosureCodegen closureCodegen, @Nullable StackValue functionReferenceReceiver) {
        if (closureCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
            ReifiedTypeInliner.putNeedClassReificationMarker(this.v);
            this.propagateChildReifiedTypeParametersUsages(closureCodegen.getReifiedTypeParametersUsages());
        }
        return closureCodegen.putInstanceOnStack(this, functionReferenceReceiver);
    }

    @Override
    public StackValue visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, StackValue receiver) {
        ObjectLiteralResult objectLiteralResult = this.generateObjectLiteral(expression2);
        ClassDescriptor classDescriptor = objectLiteralResult.classDescriptor;
        Type type2 = this.typeMapper.mapType(classDescriptor);
        return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (objectLiteralResult.wereReifiedMarkers) {
                ReifiedTypeInliner.putNeedClassReificationMarker(v);
            }
            v.anew(type2);
            v.dup();
            this.pushClosureOnStack(classDescriptor, true, this.defaultCallGenerator, null);
            ClassConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
            assert (primaryConstructor2 != null) : "There should be primary constructor for object literal";
            ResolvedCall<ConstructorDescriptor> superCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, primaryConstructor2);
            if (superCall != null) {
                ConstructorDescriptor superConstructor = superCall.getResultingDescriptor();
                ConstructorDescriptor constructorToCall = SamCodegenUtil.resolveSamAdapter(superConstructor);
                List<ValueParameterDescriptor> superValueParameters = superConstructor.getValueParameters();
                int params = superValueParameters.size();
                List<Type> superMappedTypes = this.typeMapper.mapToCallableMethod(constructorToCall, false).getValueParameterTypes();
                assert (superMappedTypes.size() >= params) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", superMappedTypes.size(), params, classDescriptor);
                ArrayList<ResolvedValueArgument> valueArguments = new ArrayList<ResolvedValueArgument>(params);
                ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(params);
                ArrayList<Type> mappedTypes = new ArrayList<Type>(params);
                for (ValueParameterDescriptor parameter : superCall.getValueArguments().keySet()) {
                    ResolvedValueArgument argument = superCall.getValueArguments().get(parameter);
                    if (argument instanceof DefaultValueArgument) continue;
                    valueArguments.add(argument);
                    valueParameters.add(parameter);
                    mappedTypes.add(superMappedTypes.get(parameter.getIndex()));
                }
                CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, this.defaultCallGenerator, valueParameters, mappedTypes);
                argumentGenerator.generate(valueArguments, valueArguments, null);
            }
            Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
            assert (constructors2.size() == 1) : "Unexpected number of constructors for class: " + classDescriptor + " " + constructors2;
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)CollectionsKt.single(constructors2);
            Method constructor = this.typeMapper.mapAsmMethod(SamCodegenUtil.resolveSamAdapter(constructorDescriptor));
            v.invokespecial(type2.getInternalName(), "<init>", constructor.getDescriptor(), false);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public void pushClosureOnStack(@NotNull ClassDescriptor classDescriptor, boolean putThis, @NotNull CallGenerator callGenerator, @Nullable StackValue functionReferenceReceiver) {
        KotlinType captureReceiver;
        ClassDescriptor captureThis;
        CalculatedClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        if (closure == null) {
            return;
        }
        int paramIndex = 0;
        if (putThis && (captureThis = closure.getCaptureThis()) != null) {
            StackValue thisOrOuter = this.generateThisOrOuter(captureThis, false);
            assert (!AsmUtil.isPrimitive(thisOrOuter.type)) : "This or outer should be non primitive: " + thisOrOuter.type;
            callGenerator.putCapturedValueOnStack(thisOrOuter, thisOrOuter.type, paramIndex++);
        }
        if ((captureReceiver = closure.getCaptureReceiverType()) != null) {
            StackValue capturedReceiver = functionReferenceReceiver != null ? functionReferenceReceiver : this.generateExtensionReceiver(ExpressionCodegen.unwrapOriginalReceiverOwnerForSuspendLambda(this.context));
            callGenerator.putCapturedValueOnStack(capturedReceiver, capturedReceiver.type, paramIndex++);
        }
        for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
            boolean asSharedVar;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)entry.getKey();
            EnclosedValueDescriptor valueDescriptor = (EnclosedValueDescriptor)entry.getValue();
            Type sharedVarType = this.typeMapper.getSharedVarType(declarationDescriptor);
            boolean bl = asSharedVar = sharedVarType != null;
            if (sharedVarType == null) {
                sharedVarType = this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
            }
            StackValue capturedVar = this.lookupOuterValue(valueDescriptor, asSharedVar);
            callGenerator.putCapturedValueOnStack(capturedVar, sharedVarType, paramIndex++);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor);
        if (superClass != null) {
            this.pushClosureOnStack(superClass, putThis && closure.getCaptureThis() == null, callGenerator, null);
        }
        if (closure.isSuspend()) {
            if (closure.isSuspendLambda()) {
                this.v.aconst(null);
            } else {
                assert (this.context.getFunctionDescriptor().isSuspend()) : "Coroutines closure must be created only inside suspend functions";
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.last(this.context.getFunctionDescriptor().getValueParameters());
                StackValue continuationValue = this.findLocalOrCapturedValue(valueParameterDescriptor);
                assert (continuationValue != null) : "Couldn't find a value for continuation parameter of " + this.context.getFunctionDescriptor();
                callGenerator.putCapturedValueOnStack(continuationValue, continuationValue.type, paramIndex++);
            }
        }
    }

    @NotNull
    private static CallableDescriptor unwrapOriginalReceiverOwnerForSuspendLambda(@NotNull MethodContext context) {
        FunctionDescriptor originalForDoResume = context.getFunctionDescriptor().getUserData(CoroutineCodegenUtilKt.INITIAL_SUSPEND_DESCRIPTOR_FOR_DO_RESUME);
        if (originalForDoResume != null) {
            return originalForDoResume;
        }
        if (context.getFunctionDescriptor().isSuspend()) {
            return CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(context.getFunctionDescriptor());
        }
        return context.getFunctionDescriptor();
    }

    StackValue generateBlock(@NotNull KtBlockExpression expression2, boolean isStatement) {
        if (expression2.getParent() instanceof KtNamedFunction) {
            return this.generateBlock(expression2.getStatements(), isStatement, null, this.context.getMethodEndLabel());
        }
        return this.generateBlock(expression2.getStatements(), isStatement, null, null);
    }

    @NotNull
    private StackValue lookupOuterValue(EnclosedValueDescriptor d, boolean asSharedVar) {
        DeclarationDescriptor descriptor2 = d.getDescriptor();
        for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
            if (!aCase.isCase(descriptor2)) continue;
            StackValue outerValue = aCase.outerValue(d, this);
            if (asSharedVar && outerValue instanceof StackValue.FieldForSharedVar) {
                StackValue.FieldForSharedVar fieldForSharedVar = (StackValue.FieldForSharedVar)outerValue;
                return fieldForSharedVar.receiver;
            }
            return outerValue;
        }
        throw new IllegalStateException("Can't get outer value in " + this + " for " + d);
    }

    private StackValueWithLeaveTask generateBlock(@NotNull List<KtExpression> statements, boolean isStatement, @Nullable Label labelBeforeLastExpression, @Nullable Label labelBlockEnd) {
        Label blockEnd = labelBlockEnd != null ? labelBlockEnd : new Label();
        ArrayList<Function<StackValue, Void>> leaveTasks = Lists.newArrayList();
        StackValue blockResult = null;
        Iterator<KtExpression> iterator2 = statements.iterator();
        while (iterator2.hasNext()) {
            StackValue statementResult;
            boolean isExpression;
            KtNamedDeclaration declaration;
            KtExpression possiblyLabeledStatement = iterator2.next();
            KtExpression statement2 = KtPsiUtil.safeDeparenthesize(possiblyLabeledStatement);
            if (statement2 instanceof KtNamedDeclaration && KtPsiUtil.isScriptDeclaration(declaration = (KtNamedDeclaration)statement2)) continue;
            this.putDescriptorIntoFrameMap(statement2);
            boolean bl = isExpression = !iterator2.hasNext() && !isStatement;
            if (isExpression && labelBeforeLastExpression != null) {
                this.v.mark(labelBeforeLastExpression);
            }
            StackValue stackValue = statementResult = isExpression ? this.gen(possiblyLabeledStatement) : this.genStatement(possiblyLabeledStatement);
            if (!iterator2.hasNext()) {
                blockResult = statementResult;
            } else {
                statementResult.put(Type.VOID_TYPE, this.v);
            }
            this.addLeaveTaskToRemoveDescriptorFromFrameMap(statement2, blockEnd, leaveTasks);
        }
        if (statements.isEmpty()) {
            blockResult = StackValue.none();
        }
        assert (blockResult != null) : "Block result should be initialized in the loop or the condition above";
        return new StackValueWithLeaveTask(blockResult, (Function1<? super StackValue, Unit>)((Function1)value -> {
            if (labelBlockEnd == null) {
                this.v.mark(blockEnd);
            }
            for (Function task : Lists.reverse(leaveTasks)) {
                task.fun(value);
            }
            return Unit.INSTANCE;
        }));
    }

    @Nullable
    private StackValue getCoroutineInstanceValueForSuspensionPoint(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor enclosingSuspendLambdaForSuspensionPoint = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        if (enclosingSuspendLambdaForSuspensionPoint == null) {
            return null;
        }
        return this.genCoroutineInstanceForSuspendLambda(enclosingSuspendLambdaForSuspensionPoint);
    }

    @Nullable
    public StackValue genCoroutineInstanceForSuspendLambda(@NotNull FunctionDescriptor suspendFunction) {
        if (!(suspendFunction instanceof AnonymousFunctionDescriptor)) {
            return null;
        }
        ClassDescriptor suspendLambdaClassDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, suspendFunction);
        assert (suspendLambdaClassDescriptor != null) : "Coroutine class descriptor should not be null";
        return StackValue.thisOrOuter(this, suspendLambdaClassDescriptor, false, false);
    }

    @NotNull
    private Type getVariableType(@NotNull VariableDescriptor variableDescriptor) {
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        return sharedVarType != null ? sharedVarType : this.getVariableTypeNoSharing(variableDescriptor);
    }

    @NotNull
    private Type getVariableTypeNoSharing(@NotNull VariableDescriptor variableDescriptor) {
        KotlinType varType;
        KotlinType kotlinType = varType = JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)variableDescriptor, this.bindingContext) : variableDescriptor.getType();
        if (variableDescriptor instanceof ValueParameterDescriptor && MethodSignatureMappingKt.forceSingleValueParameterBoxing((CallableDescriptor)variableDescriptor.getContainingDeclaration())) {
            return this.asmType(TypeUtils.makeNullable(varType));
        }
        return this.asmType(varType);
    }

    private void putDescriptorIntoFrameMap(@NotNull KtElement statement2) {
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.putLocalVariableIntoFrameMap(entry);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.putLocalVariableIntoFrameMap((KtVariableDeclaration)statement2);
        }
        if (statement2 instanceof KtNamedFunction) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement2);
            assert (descriptor2 instanceof FunctionDescriptor) : "Couldn't find function declaration in binding context " + statement2.getText();
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            this.myFrameMap.enter(descriptor2, type2);
        }
    }

    private void putLocalVariableIntoFrameMap(@NotNull KtVariableDeclaration statement2) {
        VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(statement2);
        if (variableDescriptor.getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        int index2 = this.myFrameMap.enter(variableDescriptor, type2);
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            this.myFrameMap.enter(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext), AsmTypes.K_PROPERTY0_TYPE);
        }
        if (AsmTypes.isSharedVarType(type2)) {
            this.markLineNumber(statement2, false);
            this.v.anew(type2);
            this.v.dup();
            this.v.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
        }
    }

    private void addLeaveTaskToRemoveDescriptorFromFrameMap(@NotNull KtElement statement2, @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.addLeaveTaskToRemoveLocalVariableFromFrameMap(entry, blockEnd, leaveTasks);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.addLeaveTaskToRemoveLocalVariableFromFrameMap((KtVariableDeclaration)statement2, blockEnd, leaveTasks);
        }
        if (statement2 instanceof KtNamedFunction) {
            this.addLeaveTaskToRemoveNamedFunctionFromFrameMap((KtNamedFunction)statement2, blockEnd, leaveTasks);
        }
    }

    private void addLeaveTaskToRemoveLocalVariableFromFrameMap(@NotNull KtVariableDeclaration statement2, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(statement2);
        if (variableDescriptor.getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(answer -> {
            if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                this.myFrameMap.leave(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
            }
            int index2 = this.myFrameMap.leave(variableDescriptor);
            this.v.visitLocalVariable(variableDescriptor.getName().asString(), type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        });
    }

    private void addLeaveTaskToRemoveNamedFunctionFromFrameMap(@NotNull KtNamedFunction statement2, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement2);
        assert (functionDescriptor != null);
        Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(answer -> {
            int index2 = this.myFrameMap.leave(functionDescriptor);
            assert (!functionDescriptor.getName().isSpecial()) : "Local variable should be generated only for function with name: " + statement2.getText();
            this.v.visitLocalVariable(functionDescriptor.getName().asString() + "$", type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        });
    }

    public boolean isShouldMarkLineNumbers() {
        return this.shouldMarkLineNumbers;
    }

    public void setShouldMarkLineNumbers(boolean shouldMarkLineNumbers) {
        this.shouldMarkLineNumbers = shouldMarkLineNumbers;
    }

    public void markStartLineNumber(@NotNull KtElement element) {
        this.markLineNumber(element, false);
    }

    public void markLineNumber(@NotNull KtElement statement2, boolean markEndOffset) {
        if (!this.shouldMarkLineNumbers) {
            return;
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement(statement2, markEndOffset);
        if (lineNumber == null || lineNumber == this.myLastLineNumber) {
            return;
        }
        this.myLastLineNumber = lineNumber;
        Label label = new Label();
        this.v.visitLabel(label);
        this.v.visitLineNumber(lineNumber, label);
    }

    @Override
    public void markLineNumberAfterInlineIfNeeded() {
        if (!this.shouldMarkLineNumbers) {
            if (this.myLastLineNumber > -1) {
                Label label = new Label();
                this.v.visitLabel(label);
                this.v.visitLineNumber(this.myLastLineNumber, label);
            }
        } else {
            this.myLastLineNumber = -1;
        }
    }

    @Override
    public int getLastLineNumber() {
        return this.myLastLineNumber;
    }

    private void doFinallyOnReturn(@NotNull Label afterReturnLabel) {
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement = this.blockStackElements.peek();
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterReturnLabel);
            } else if (!(stackElement instanceof LoopBlockStackElement)) {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            this.doFinallyOnReturn(afterReturnLabel);
            this.blockStackElements.push(stackElement);
        }
    }

    public boolean hasFinallyBlocks() {
        for (BlockStackElement element : this.blockStackElements) {
            if (!(element instanceof FinallyBlockStackElement)) continue;
            return true;
        }
        return false;
    }

    private void genFinallyBlockOrGoto(@Nullable FinallyBlockStackElement finallyBlockStackElement, @Nullable Label tryCatchBlockEnd, @Nullable Label afterJumpLabel) {
        if (finallyBlockStackElement != null) {
            ++this.finallyDepth;
            assert (finallyBlockStackElement.gaps.size() % 2 == 0) : "Finally block gaps are inconsistent";
            BlockStackElement topOfStack = this.blockStackElements.pop();
            assert (topOfStack == finallyBlockStackElement) : "Top element of stack doesn't equals processing finally block";
            KtTryExpression jetTryExpression = finallyBlockStackElement.expression;
            Label finallyStart = new Label();
            this.v.mark(finallyStart);
            finallyBlockStackElement.addGapLabel(finallyStart);
            if (InlineCodegenUtilsKt.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtilsKt.generateFinallyMarker(this.v, this.finallyDepth, true);
            }
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            if (InlineCodegenUtilsKt.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtilsKt.generateFinallyMarker(this.v, this.finallyDepth, false);
            }
        }
        if (tryCatchBlockEnd != null) {
            this.v.goTo(tryCatchBlockEnd);
        }
        if (finallyBlockStackElement != null) {
            Label finallyEnd;
            --this.finallyDepth;
            Label label = finallyEnd = afterJumpLabel != null ? afterJumpLabel : new Label();
            if (afterJumpLabel == null) {
                this.v.mark(finallyEnd);
            }
            finallyBlockStackElement.addGapLabel(finallyEnd);
            this.blockStackElements.push(finallyBlockStackElement);
        }
    }

    @Override
    public StackValue visitReturnExpression(@NotNull KtReturnExpression expression2, StackValue receiver) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            boolean isNonLocalReturn;
            KtExpression returnedExpression = expression2.getReturnedExpression();
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)this.getContext().getContextDescriptor();
            NonLocalReturnInfo nonLocalReturn = this.getNonLocalReturnInfo(descriptor2, expression2);
            boolean bl = isNonLocalReturn = nonLocalReturn != null;
            if (isNonLocalReturn && this.state.isInlineDisabled()) {
                this.state.getDiagnostics().report(Errors.NON_LOCAL_RETURN_IN_DISABLED_INLINE.on(expression2));
                AsmUtil.genThrow(this.v, "java/lang/UnsupportedOperationException", "Non-local returns are not allowed with inlining disabled");
                return Unit.INSTANCE;
            }
            Type returnType = isNonLocalReturn ? nonLocalReturn.returnType : this.returnType;
            StackValue valueToReturn = returnedExpression != null ? this.gen(returnedExpression) : StackValue.none();
            this.putStackValue(returnedExpression, returnType, valueToReturn);
            Label afterReturnLabel = new Label();
            this.generateFinallyBlocksIfNeeded(returnType, afterReturnLabel);
            if (isNonLocalReturn) {
                InlineCodegenUtilsKt.generateGlobalReturnFlag(this.v, nonLocalReturn.labelName);
                this.v.visitInsn(returnType.getOpcode(172));
            } else {
                this.v.areturn(this.returnType);
            }
            this.v.mark(afterReturnLabel);
            return Unit.INSTANCE;
        }));
    }

    public void generateFinallyBlocksIfNeeded(Type returnType, @NotNull Label afterReturnLabel) {
        if (this.hasFinallyBlocks()) {
            if (!Type.VOID_TYPE.equals(returnType)) {
                int returnValIndex = this.myFrameMap.enterTemp(returnType);
                StackValue.Local localForReturnValue = StackValue.local(returnValIndex, returnType);
                localForReturnValue.store(StackValue.onStack(returnType), this.v);
                this.doFinallyOnReturn(afterReturnLabel);
                localForReturnValue.put(returnType, this.v);
                this.myFrameMap.leaveTemp(returnType);
            } else {
                this.doFinallyOnReturn(afterReturnLabel);
            }
        }
    }

    @Nullable
    private NonLocalReturnInfo getNonLocalReturnInfo(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtReturnExpression expression2) {
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (expression2.getLabelName() == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    FunctionDescriptor containingFunction = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                    return new NonLocalReturnInfo(this.typeMapper.mapReturnType(containingFunction), "$$$$$ROOT$$$$$");
                }
                return null;
            }
            PsiElement element = this.bindingContext.get(BindingContext.LABEL_TARGET, expression2.getTargetLabel());
            if (element != DescriptorToSourceUtils.getSourceFromDescriptor(this.context.getContextDescriptor())) {
                DeclarationDescriptor elementDescriptor = this.typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                assert (element != null) : "Expression should be not null " + expression2.getText();
                assert (elementDescriptor != null) : "Descriptor should be not null: " + element.getText();
                return new NonLocalReturnInfo(this.typeMapper.mapReturnType((CallableDescriptor)elementDescriptor), expression2.getLabelName());
            }
        }
        return null;
    }

    public void returnExpression(@NotNull KtExpression expr) {
        boolean isBlockedNamedFunction = expr instanceof KtBlockExpression && expr.getParent() instanceof KtNamedFunction;
        FunctionDescriptor originalSuspendLambdaDescriptor = ExpressionCodegen.getOriginalSuspendLambdaDescriptorFromContext(this.context);
        boolean isVoidCoroutineLambda = originalSuspendLambdaDescriptor != null && TypeSignatureMappingKt.hasVoidReturnType(originalSuspendLambdaDescriptor);
        Type typeForExpression = isBlockedNamedFunction || isVoidCoroutineLambda ? Type.VOID_TYPE : this.returnType;
        this.gen(expr, typeForExpression);
        if (!ExpressionCodegen.endsWithReturn(expr)) {
            if (ExpressionCodegen.isLambdaVoidBody(expr, typeForExpression)) {
                this.markLineNumber((KtFunctionLiteral)expr.getParent(), true);
            } else {
                this.markLineNumber(expr, true);
            }
            if (typeForExpression.getSort() == 0) {
                StackValue.none().put(this.returnType, this.v);
            }
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(@NotNull KtElement bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression) {
            List<KtExpression> statements = ((KtBlockExpression)bodyExpression).getStatements();
            return statements.size() > 0 && statements.get(statements.size() - 1) instanceof KtReturnExpression;
        }
        return bodyExpression instanceof KtReturnExpression;
    }

    private static boolean isLambdaVoidBody(@NotNull KtElement bodyExpression, @NotNull Type returnType) {
        PsiElement parent2;
        if (bodyExpression instanceof KtBlockExpression && (parent2 = bodyExpression.getParent()) instanceof KtFunctionLiteral) {
            return Type.VOID_TYPE.equals(returnType);
        }
        return false;
    }

    @Override
    public StackValue visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull StackValue receiver) {
        ClassDescriptor classDescriptor;
        StackValue intrinsicResult;
        DeclarationDescriptor descriptor2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (resolvedCall2 == null) {
            descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        } else {
            StackValue intrinsicResult2;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call2 = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
                resolvedCall2 = call2.getVariableCall();
            }
            if ((intrinsicResult2 = this.applyIntrinsic(descriptor2 = resolvedCall2.getResultingDescriptor(), KCallableNameProperty.class, resolvedCall2, receiver)) != null) {
                return intrinsicResult2;
            }
            receiver = StackValue.receiver(resolvedCall2, receiver, this, null);
            if (descriptor2 instanceof FakeCallableDescriptorForObject) {
                descriptor2 = ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor();
            }
        }
        assert (descriptor2 != null) : "Couldn't find descriptor for '" + expression2.getText() + "'";
        boolean isSyntheticField = (descriptor2 = descriptor2.getOriginal()) instanceof SyntheticFieldDescriptor;
        if (isSyntheticField) {
            descriptor2 = ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor();
        }
        if ((intrinsicResult = this.applyIntrinsic(descriptor2, IntrinsicPropertyGetter.class, resolvedCall2, receiver)) != null) {
            return intrinsicResult;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ClassDescriptor superCallTarget;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
            if (!codegenExtensions.isEmpty() && resolvedCall2 != null) {
                ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this, this.typeMapper, this.v);
                KotlinType returnType = propertyDescriptor.getReturnType();
                for (ExpressionCodegenExtension extension : codegenExtensions) {
                    StackValue value;
                    if (returnType == null || (value = extension.applyProperty(receiver, resolvedCall2, context)) == null) continue;
                    return value;
                }
            }
            boolean directToField = isSyntheticField && this.contextKind() != OwnerKind.DEFAULT_IMPLS;
            ClassDescriptor classDescriptor2 = superCallTarget = resolvedCall2 == null ? null : this.getSuperCallTarget(resolvedCall2.getCall());
            if (directToField) {
                receiver = StackValue.receiverWithoutReceiverArgument(receiver);
            }
            return this.intermediateValueForProperty(propertyDescriptor, directToField, directToField, superCallTarget, false, receiver, resolvedCall2, false);
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor == null) {
                throw new IllegalStateException("Type alias " + descriptor2 + " static member reference should be rejected by type checker, since there is no class corresponding to this type alias.");
            }
            descriptor2 = classDescriptor;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)descriptor2;
            if (this.shouldGenerateSingletonAsThisOrOuterFromContext(classDescriptor)) {
                return this.generateThisOrOuterFromContext(classDescriptor, false, false);
            }
            if (DescriptorUtils.isObject(classDescriptor)) {
                return StackValue.singleton(classDescriptor, this.typeMapper);
            }
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return StackValue.enumEntry(classDescriptor, this.typeMapper);
            }
            ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
            if (companionObjectDescriptor2 != null) {
                return StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            }
            return StackValue.none();
        }
        StackValue localOrCaptured = this.findLocalOrCapturedValue(descriptor2);
        if (localOrCaptured != null) {
            return localOrCaptured;
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor2);
    }

    private boolean shouldGenerateSingletonAsThisOrOuterFromContext(ClassDescriptor classDescriptor) {
        if (!CodegenUtilKt.isPossiblyUninitializedSingleton(classDescriptor)) {
            return false;
        }
        if (!this.isInsideSingleton(classDescriptor)) {
            return false;
        }
        for (CodegenContext context = this.context; context != null; context = ((CodegenContext)context).getParentContext()) {
            ClassDescriptor contextClass;
            if (context instanceof ConstructorContext) {
                ConstructorContext constructorContext = (ConstructorContext)context;
                ClassDescriptor constructedClass = constructorContext.getConstructorDescriptor().getConstructedClass();
                if (constructedClass != classDescriptor) continue;
                return constructorContext.isThisInitialized();
            }
            if (!(context instanceof ClassContext) || !ExpressionCodegen.isInInnerClassesChainFor(contextClass = (ClassDescriptor)((ClassContext)context).getContextDescriptor(), classDescriptor)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInInnerClassesChainFor(ClassDescriptor innerClass, ClassDescriptor outerClass2) {
        if (innerClass == outerClass2) {
            return true;
        }
        if (!innerClass.isInner()) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = innerClass.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        return ExpressionCodegen.isInInnerClassesChainFor((ClassDescriptor)containingDeclaration, outerClass2);
    }

    @Nullable
    private StackValue applyIntrinsic(DeclarationDescriptor descriptor2, Class<? extends IntrinsicPropertyGetter> intrinsicType, ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsicType.isInstance(intrinsic)) {
                Type returnType = this.typeMapper.mapType(memberDescriptor);
                return ((IntrinsicPropertyGetter)intrinsic).generate(resolvedCall2, this, returnType, receiver);
            }
        }
        return null;
    }

    @Nullable
    private ClassDescriptor getSuperCallTarget(@NotNull Call call2) {
        KtSuperExpression superExpression = CallResolverUtilKt.getSuperCallExpression(call2);
        return superExpression == null ? null : ExpressionCodegen.getSuperCallLabelTarget(this.context, superExpression);
    }

    @Nullable
    public StackValue findLocalOrCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        int index2 = this.lookupLocalIndex(descriptor2);
        if (index2 >= 0) {
            return this.stackValueForLocal(descriptor2, index2);
        }
        return this.findCapturedValue(descriptor2);
    }

    @Nullable
    public StackValue findCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (this.context instanceof ConstructorContext) {
            return this.lookupCapturedValueInConstructorParameters(descriptor2);
        }
        StackValue value = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) && value != null) {
            VariableDescriptor metadata2 = CodegenBinding.getDelegatedLocalVariableMetadata((VariableDescriptor)descriptor2, this.bindingContext);
            StackValue metadataValue = this.context.lookupInContext(metadata2, StackValue.LOCAL_0, this.state, false);
            assert (metadataValue != null) : "Metadata stack value should be non-null for local delegated property: " + descriptor2;
            return this.delegatedVariableValue(value, metadataValue, (VariableDescriptorWithAccessors)descriptor2, this.typeMapper);
        }
        return value;
    }

    @Nullable
    private StackValue lookupCapturedValueInConstructorParameters(@NotNull DeclarationDescriptor descriptor2) {
        StackValue parentResult = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (this.context.closure == null || parentResult == null) {
            return parentResult;
        }
        int parameterOffsetInConstructor = this.context.closure.getCapturedParameterOffsetInConstructor(descriptor2);
        if (parameterOffsetInConstructor == -1) {
            return this.adjustVariableValue(parentResult, descriptor2);
        }
        assert (parentResult instanceof StackValue.Field || parentResult instanceof StackValue.FieldForSharedVar) : "Part of closure should be either Field or FieldForSharedVar";
        if (parentResult instanceof StackValue.FieldForSharedVar) {
            return StackValue.shared(parameterOffsetInConstructor, parentResult.type);
        }
        return this.adjustVariableValue(StackValue.local(parameterOffsetInConstructor, parentResult.type), descriptor2);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor2, int index2) {
        if (descriptor2 instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor2);
            Type varType = this.getVariableTypeNoSharing(variableDescriptor);
            if (sharedVarType != null) {
                return StackValue.shared(index2, varType, variableDescriptor);
            }
            return this.adjustVariableValue(StackValue.local(index2, varType, variableDescriptor), variableDescriptor);
        }
        return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
    }

    @Override
    public boolean isLocal(DeclarationDescriptor descriptor2) {
        LocalLookup outerLookup;
        if (this.lookupLocalIndex(descriptor2) != -1) {
            return true;
        }
        if (this.context.isContextWithUninitializedThis() && (outerLookup = this.context.getParentContext().getEnclosingLocalLookup()) != null) {
            return outerLookup.isLocal(descriptor2);
        }
        return false;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor2) {
        int index2 = this.myFrameMap.getIndex(descriptor2);
        if (index2 != -1) {
            return index2;
        }
        if (!(descriptor2 instanceof ValueParameterDescriptor)) {
            return -1;
        }
        DeclarationDescriptor synonym = this.bindingContext.get(CodegenBinding.PARAMETER_SYNONYM, (ValueParameterDescriptor)descriptor2);
        if (synonym == null) {
            return -1;
        }
        return this.myFrameMap.getIndex(synonym);
    }

    @NotNull
    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable ClassDescriptor superCallTarget, @NotNull StackValue receiver) {
        return this.intermediateValueForProperty(propertyDescriptor, forceField, false, superCallTarget, false, receiver, null, false);
    }

    private CodegenContext getBackingFieldContext(@NotNull FieldAccessorKind accessorKind, @NotNull DeclarationDescriptor containingDeclaration) {
        switch (accessorKind) {
            case NORMAL: {
                CodegenContext parentWithDescriptor;
                if (containingDeclaration instanceof ClassDescriptor && (parentWithDescriptor = this.context.findParentContextWithDescriptor(containingDeclaration)) != null) {
                    return parentWithDescriptor;
                }
                return this.context.getParentContext();
            }
            case IN_CLASS_COMPANION: {
                return this.context.findParentContextWithDescriptor(containingDeclaration.getContainingDeclaration());
            }
            case FIELD_FROM_LOCAL: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
            case LATEINIT_INTRINSIC: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
        }
        throw new IllegalStateException("Unknown field accessor kind: " + (Object)((Object)accessorKind));
    }

    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, boolean syntheticBackingField, @Nullable ClassDescriptor superCallTarget, boolean skipAccessorsForPrivateFieldInOuterClass, @NotNull StackValue receiver, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
        String fieldName;
        DeclarationDescriptor ownerDescriptor;
        boolean skipPropertyAccessors;
        if (propertyDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return this.intermediateValueForSyntheticExtensionProperty((SyntheticJavaPropertyDescriptor)propertyDescriptor, receiver);
        }
        if (propertyDescriptor instanceof PropertyImportedFromObject) {
            propertyDescriptor = (PropertyDescriptor)((PropertyImportedFromObject)propertyDescriptor).getCallableFromObject();
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean isBackingFieldInClassCompanion = JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        FieldAccessorKind fieldAccessorKind = skipLateinitAssertion ? FieldAccessorKind.LATEINIT_INTRINSIC : (isBackingFieldInClassCompanion && (forceField || propertyDescriptor.isConst() && Visibilities.isPrivate(propertyDescriptor.getVisibility())) ? FieldAccessorKind.IN_CLASS_COMPANION : (syntheticBackingField && this.context.getFirstCrossInlineOrNonInlineContext().getParentContext().getContextDescriptor() != containingDeclaration ? FieldAccessorKind.FIELD_FROM_LOCAL : FieldAccessorKind.NORMAL));
        boolean isStaticBackingField = DescriptorUtils.isStaticDeclaration(propertyDescriptor) || AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor);
        boolean isSuper = superCallTarget != null;
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(propertyDescriptor, this.bindingContext);
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        CodegenContext backingFieldContext = this.getBackingFieldContext(fieldAccessorKind, containingDeclaration);
        boolean isPrivateProperty = fieldAccessorKind != FieldAccessorKind.NORMAL && (AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegatedProperty) & 2) != 0;
        PropertyDescriptor originalPropertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        if (fieldAccessorKind == FieldAccessorKind.LATEINIT_INTRINSIC) {
            boolean bl = skipPropertyAccessors = !isPrivateProperty || this.context.getClassOrPackageParentContext() == backingFieldContext;
            if (!skipPropertyAccessors) {
                propertyDescriptor = (AccessorForPropertyBackingField)backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
            }
            ownerDescriptor = propertyDescriptor;
        } else if (fieldAccessorKind == FieldAccessorKind.IN_CLASS_COMPANION || fieldAccessorKind == FieldAccessorKind.FIELD_FROM_LOCAL) {
            boolean isInlinedConst = propertyDescriptor.isConst() && this.state.getShouldInlineConstVals();
            boolean bl = skipPropertyAccessors = isInlinedConst || !isPrivateProperty || skipAccessorsForPrivateFieldInOuterClass;
            if (!skipPropertyAccessors) {
                propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                assert (propertyDescriptor instanceof AccessorForPropertyBackingField) : "Unexpected accessor descriptor: " + propertyDescriptor;
                ownerDescriptor = propertyDescriptor;
            } else {
                ownerDescriptor = containingDeclaration;
            }
        } else {
            skipPropertyAccessors = forceField;
            DeclarationDescriptor declarationDescriptor = ownerDescriptor = isBackingFieldInClassCompanion ? containingDeclaration : propertyDescriptor;
        }
        if (!skipPropertyAccessors) {
            PropertySetterDescriptor setter2;
            if (!JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals())) {
                propertyDescriptor = this.context.getAccessorForSuperCallIfNeeded(propertyDescriptor, superCallTarget, this.state);
                PropertyGetterDescriptor getter2 = (propertyDescriptor = this.context.accessibleDescriptor(propertyDescriptor, superCallTarget)).getGetter();
                if (getter2 != null && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                    callableGetter = this.typeMapper.mapToCallableMethod(getter2, isSuper);
                }
            }
            if (propertyDescriptor.isVar() && (setter2 = propertyDescriptor.getSetter()) != null && !JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals()) && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                callableSetter = this.typeMapper.mapToCallableMethod(setter2, isSuper);
            }
        }
        if (!isStaticBackingField) {
            propertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        }
        Type backingFieldOwner = this.typeMapper.mapOwner(ownerDescriptor);
        if (isExtensionProperty && !isDelegatedProperty) {
            fieldName = null;
        } else if (originalPropertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            fieldName = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            fieldName = KotlinTypeMapper.mapDefaultFieldName(propertyDescriptor, isDelegatedProperty);
        }
        return StackValue.property(propertyDescriptor, backingFieldOwner, this.typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyDescriptor.getOriginal().getType()), isStaticBackingField, fieldName, callableGetter, callableSetter, receiver, this, resolvedCall2, skipLateinitAssertion);
    }

    @NotNull
    private StackValue.Property intermediateValueForSyntheticExtensionProperty(@NotNull SyntheticJavaPropertyDescriptor propertyDescriptor, @NotNull StackValue receiver) {
        Type type2 = this.typeMapper.mapType(propertyDescriptor.getOriginal().getType());
        CallableMethod callableGetter = this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(propertyDescriptor.getGetMethod(), null), false);
        FunctionDescriptor setMethod = propertyDescriptor.getSetMethod();
        CallableMethod callableSetter = setMethod != null ? this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(setMethod, null), false) : null;
        return StackValue.property(propertyDescriptor, null, type2, false, null, callableGetter, callableSetter, receiver, this, null, false);
    }

    @Override
    public StackValue visitCallExpression(@NotNull KtCallExpression expression2, StackValue receiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2);
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression2, resolvedCall2);
        }
        if (descriptor2.getOriginal() instanceof SamConstructorDescriptor) {
            KtExpression argumentExpression = this.bindingContext.get(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2);
            assert (argumentExpression != null) : "Argument expression is not saved for a SAM constructor: " + descriptor2;
            return this.genSamInterfaceValue(argumentExpression, this);
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    @Override
    public StackValue visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, StackValue data) {
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        assert (resolvedCall2 != null) : "No resolved call for " + PsiUtilsKt.getTextWithLocation(expression2);
        return this.invokeFunction(resolvedCall2, data);
    }

    @Nullable
    private StackValue genSamInterfaceValue(@NotNull KtExpression probablyParenthesizedExpression, @NotNull KtVisitor<StackValue, StackValue> visitor2) {
        KtExpression expression2 = KtPsiUtil.deparenthesize(probablyParenthesizedExpression);
        SamType samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, probablyParenthesizedExpression);
        if (samType == null || expression2 == null) {
            return null;
        }
        if (expression2 instanceof KtLambdaExpression) {
            return this.genClosure(((KtLambdaExpression)expression2).getFunctionLiteral(), samType);
        }
        if (expression2 instanceof KtNamedFunction) {
            return this.genClosure((KtNamedFunction)expression2, samType);
        }
        Type asmType = this.state.getSamWrapperClasses().getSamWrapperClass(samType, expression2.getContainingKtFile(), this);
        return StackValue.operation(asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label afterAll = new Label();
            Type functionType = this.typeMapper.mapType(samType.getKotlinFunctionType());
            ((StackValue)expression2.accept(visitor2, StackValue.none())).put(functionType, (InstructionAdapter)v);
            v.dup();
            v.ifnull(afterAll);
            int tmp = this.myFrameMap.enterTemp(functionType);
            v.store(tmp, functionType);
            v.anew(asmType);
            v.dup();
            v.load(tmp, functionType);
            v.invokespecial(asmType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), false);
            this.myFrameMap.leaveTemp(functionType);
            v.mark(afterAll);
            return null;
        }));
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor originalIfSamAdapter;
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof TypeAliasConstructorDescriptor) {
            descriptor2 = ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor();
        }
        if ((originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(descriptor2)) != null) {
            descriptor2 = originalIfSamAdapter;
        }
        descriptor2 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2);
        return CallUtilKt.usesDefaultArguments(resolvedCall2) ? descriptor2 : this.context.accessibleDescriptor(descriptor2, this.getSuperCallTarget(resolvedCall2.getCall()));
    }

    @NotNull
    public StackValue invokeFunction(@NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        return this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, receiver);
    }

    @NotNull
    public StackValue invokeFunction(@NotNull Call call2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        ResolvedCallWithRealDescriptor callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state.getProject(), this.state.getBindingContext());
        if (callWithRealDescriptor != null) {
            this.prepareCoroutineArgumentForSuspendCall(resolvedCall2, callWithRealDescriptor.getFakeContinuationExpression());
            return this.invokeFunction(callWithRealDescriptor.getResolvedCall(), receiver);
        }
        FunctionDescriptor fd = this.accessibleFunctionDescriptor(resolvedCall2);
        ClassDescriptor superCallTarget = this.getSuperCallTarget(call2);
        fd = this.context.getAccessorForSuperCallIfNeeded(fd, superCallTarget, this.state);
        List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
        if (!codegenExtensions.isEmpty()) {
            ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this, this.typeMapper, this.v);
            for (ExpressionCodegenExtension extension : codegenExtensions) {
                StackValue stackValue = extension.applyFunction(receiver, resolvedCall2, context);
                if (stackValue == null) continue;
                return stackValue;
            }
        }
        Callable callable = this.resolveToCallable(fd, superCallTarget != null, resolvedCall2);
        return callable.invokeMethodWithArguments(resolvedCall2, receiver, this);
    }

    private void prepareCoroutineArgumentForSuspendCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull KtExpression continuationExpression) {
        StackValue coroutineInstanceValueForSuspensionPoint = this.getCoroutineInstanceValueForSuspensionPoint(resolvedCall2);
        StackValue coroutineInstanceValue = coroutineInstanceValueForSuspensionPoint != null ? coroutineInstanceValueForSuspensionPoint : this.getContinuationParameterFromEnclosingSuspendFunction(resolvedCall2);
        this.tempVariables.put(continuationExpression, coroutineInstanceValue);
    }

    private StackValue getContinuationParameterFromEnclosingSuspendFunction(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor enclosingSuspendFunction = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        assert (enclosingSuspendFunction != null) : "Suspend functions may be called either as suspension points or from another suspend function";
        FunctionDescriptor enclosingSuspendFunctionJvmView = this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, enclosingSuspendFunction);
        assert (enclosingSuspendFunctionJvmView != null) : "No JVM view function found for " + enclosingSuspendFunction;
        return this.getContinuationParameterFromEnclosingSuspendFunctionDescriptor(enclosingSuspendFunctionJvmView);
    }

    @Nullable
    public StackValue getContinuationParameterFromEnclosingSuspendFunctionDescriptor(@NotNull FunctionDescriptor enclosingSuspendFunctionJvmView) {
        ValueParameterDescriptor continuationParameter = enclosingSuspendFunctionJvmView.getValueParameters().get(enclosingSuspendFunctionJvmView.getValueParameters().size() - 1);
        return this.findLocalOrCapturedValue(continuationParameter);
    }

    @Nullable
    public static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context) {
        for (CodegenContext c = context; c != null; c = c.getParentContext()) {
            if (!(c instanceof ClassContext) || !DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor2)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall, @NotNull ResolvedCall resolvedCall2) {
        IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(fd);
        if (intrinsic != null) {
            return intrinsic.toCallable(fd, superCall, resolvedCall2, this);
        }
        return this.resolveToCallableMethod(fd, superCall);
    }

    @NotNull
    private CallableMethod resolveToCallableMethod(@NotNull FunctionDescriptor fd, boolean superCall) {
        return this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(fd), superCall);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        CallGenerator callGenerator = this.getOrCreateCallGenerator(resolvedCall2);
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        assert (callGenerator == this.defaultCallGenerator || !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) : "Tail recursive method can't be inlined: " + descriptor2;
        CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, callGenerator, descriptor2.getValueParameters(), callableMethod.getValueParameterTypes());
        this.invokeMethodWithArguments(callableMethod, resolvedCall2, receiver, callGenerator, argumentGenerator);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, @NotNull CallGenerator callGenerator, @NotNull ArgumentGenerator argumentGenerator) {
        KotlinType returnType;
        boolean isSuspendCall = CoroutineCodegenUtilKt.isSuspendNoInlineCall(resolvedCall2);
        boolean isConstructor = resolvedCall2.getResultingDescriptor() instanceof ConstructorDescriptor;
        if (!(callableMethod instanceof IntrinsicWithSpecialReceiver)) {
            this.putReceiverAndInlineMarkerIfNeeded(callableMethod, resolvedCall2, receiver, isSuspendCall, isConstructor);
        }
        callGenerator.processAndPutHiddenParameters(false);
        List<ResolvedValueArgument> valueArguments = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments != null) : "Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor();
        DefaultCallArgs defaultArgs = argumentGenerator.generate((List<? extends ResolvedValueArgument>)valueArguments, (List<? extends ResolvedValueArgument>)new ArrayList<ResolvedValueArgument>(resolvedCall2.getValueArguments().values()), (CallableDescriptor)resolvedCall2.getResultingDescriptor());
        if (this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            this.tailRecursionCodegen.generateTailRecursion(resolvedCall2);
            return;
        }
        boolean defaultMaskWasGenerated = defaultArgs.generateOnStackIfNeeded(callGenerator, isConstructor);
        if (callableMethod instanceof CallableMethod) {
            List<JvmMethodParameterSignature> callableParameters = ((CallableMethod)callableMethod).getValueParameters();
            for (JvmMethodParameterSignature parameter : callableParameters) {
                if (parameter.getKind() != JvmMethodParameterKind.CONSTRUCTOR_MARKER) continue;
                callGenerator.putValueIfNeeded(parameter.getAsmType(), StackValue.constant(null, parameter.getAsmType()));
            }
        }
        if (isSuspendCall) {
            InlineCodegenUtilsKt.addSuspendMarker(this.v, true);
        }
        callGenerator.genCall(callableMethod, resolvedCall2, defaultMaskWasGenerated, this);
        if (isSuspendCall) {
            InlineCodegenUtilsKt.addReturnsUnitMarkerIfNecessary(this.v, resolvedCall2);
            InlineCodegenUtilsKt.addSuspendMarker(this.v, false);
            InlineCodegenUtilsKt.addInlineMarker(this.v, false);
        }
        if ((returnType = resolvedCall2.getResultingDescriptor().getReturnType()) != null && KotlinBuiltIns.isNothing(returnType)) {
            this.v.aconst(null);
            this.v.athrow();
        }
    }

    private void putReceiverAndInlineMarkerIfNeeded(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, boolean isSuspendCall, boolean isConstructor) {
        boolean isSafeCallOrOnStack;
        boolean bl = isSafeCallOrOnStack = receiver instanceof StackValue.SafeCall || receiver instanceof StackValue.OnStack;
        if (isSuspendCall && !isSafeCallOrOnStack) {
            InlineCodegenUtilsKt.addInlineMarker(this.v, true);
        }
        if (!isConstructor) {
            receiver = StackValue.receiver(resolvedCall2, receiver, this, callableMethod);
            receiver.put(receiver.type, this.v);
            if (isSuspendCall && isSafeCallOrOnStack) {
                boolean bothReceivers = receiver instanceof CallReceiver && ((CallReceiver)receiver).getDispatchReceiver().type.getSort() != 0 && ((CallReceiver)receiver).getExtensionReceiver().type.getSort() != 0;
                Type firstReceiverType = bothReceivers ? ((CallReceiver)receiver).getDispatchReceiver().type : receiver.type;
                Type secondReceiverType = bothReceivers ? receiver.type : null;
                int tmpVarForFirstReceiver = this.myFrameMap.enterTemp(firstReceiverType);
                int tmpVarForSecondReceiver = -1;
                if (secondReceiverType != null) {
                    tmpVarForSecondReceiver = this.myFrameMap.enterTemp(secondReceiverType);
                    this.v.store(tmpVarForSecondReceiver, secondReceiverType);
                }
                this.v.store(tmpVarForFirstReceiver, firstReceiverType);
                InlineCodegenUtilsKt.addInlineMarker(this.v, true);
                this.v.load(tmpVarForFirstReceiver, firstReceiverType);
                if (secondReceiverType != null) {
                    this.v.load(tmpVarForSecondReceiver, secondReceiverType);
                    this.myFrameMap.leaveTemp(secondReceiverType);
                }
                this.myFrameMap.leaveTemp(firstReceiverType);
            }
            callableMethod.afterReceiverGeneration(this.v, this.myFrameMap);
        }
    }

    @NotNull
    private CallGenerator getOrCreateCallGenerator(@NotNull CallableDescriptor descriptor2, @Nullable KtElement callElement, @Nullable TypeParameterMappings typeParameterMappings, boolean isDefaultCompilation) {
        boolean shouldInline;
        if (callElement == null) {
            return this.defaultCallGenerator;
        }
        boolean isIntrinsic = descriptor2 instanceof CallableMemberDescriptor && this.state.getIntrinsics().getIntrinsic((CallableMemberDescriptor)descriptor2) != null;
        boolean isInline = InlineUtil.isInline(descriptor2) && !isIntrinsic || InlineUtil.isArrayConstructorWithLambda(descriptor2);
        boolean bl = shouldInline = isInline && (!this.state.isInlineDisabled() || InlineUtil.containsReifiedTypeParameters(descriptor2));
        if (!shouldInline) {
            return this.defaultCallGenerator;
        }
        FunctionDescriptor original = CoroutineCodegenUtilKt.getOriginalSuspendFunctionView(CodegenUtilKt.unwrapInitialSignatureDescriptor(DescriptorUtils.unwrapFakeOverride((FunctionDescriptor)descriptor2.getOriginal())), this.bindingContext);
        if (isDefaultCompilation) {
            return new InlineCodegenForDefaultBody(original, this, this.state, new PsiSourceCompilerForInline(this, callElement));
        }
        return new PsiInlineCodegen(this, this.state, original, typeParameterMappings, (SourceCompilerForInline)new PsiSourceCompilerForInline(this, callElement));
    }

    @NotNull
    protected CallGenerator getOrCreateCallGeneratorForDefaultImplBody(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        return this.getOrCreateCallGenerator(descriptor2, function2, null, true);
    }

    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2) {
        return this.getOrCreateCallGenerator(resolvedCall2, (CallableDescriptor)resolvedCall2.getResultingDescriptor());
    }

    @NotNull
    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        Map<TypeParameterDescriptor, KotlinType> typeArguments2 = ExpressionCodegen.getTypeArgumentsForResolvedCall(resolvedCall2, descriptor2);
        TypeParameterMappings mappings = new TypeParameterMappings();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments2.entrySet()) {
            TypeParameterDescriptor key = entry.getKey();
            KotlinType type2 = entry.getValue();
            boolean isReified = key.isReified() || InlineUtil.isArrayConstructorWithLambda(resolvedCall2.getResultingDescriptor());
            Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = CodegenUtilKt.extractReificationArgument(type2);
            if (typeParameterAndReificationArgument == null) {
                KotlinType approximatedType = CapturedTypeApproximationKt.approximateCapturedTypes(entry.getValue()).getUpper();
                BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type asmType = this.typeMapper.mapTypeParameter(approximatedType, signatureWriter);
                mappings.addParameterMappingToType(key.getName().getIdentifier(), approximatedType, asmType, ((JvmSignatureWriter)signatureWriter).toString(), isReified);
                continue;
            }
            mappings.addParameterMappingForFurtherReification(key.getName().getIdentifier(), type2, (ReificationArgument)typeParameterAndReificationArgument.getSecond(), isReified);
        }
        return this.getOrCreateCallGenerator(descriptor2, resolvedCall2.getCall().getCallElement(), mappings, false);
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> getTypeArgumentsForResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            return resolvedCall2.getTypeArguments();
        }
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)descriptor2;
        ClassConstructorDescriptor underlyingConstructorDescriptor = typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor();
        KotlinType resultingType = typeAliasConstructorDescriptor.getReturnType();
        List<TypeProjection> typeArgumentsForReturnType = resultingType.getArguments();
        List<TypeParameterDescriptor> typeParameters2 = underlyingConstructorDescriptor.getTypeParameters();
        assert (typeParameters2.size() == typeArgumentsForReturnType.size()) : "Type parameters of the underlying constructor " + underlyingConstructorDescriptor + "should correspond to type arguments for the resulting type " + resultingType;
        HashMap<TypeParameterDescriptor, KotlinType> typeArgumentsMap = Maps.newHashMapWithExpectedSize(typeParameters2.size());
        for (TypeParameterDescriptor typeParameter : typeParameters2) {
            KotlinType typeArgument = typeArgumentsForReturnType.get(typeParameter.getIndex()).getType();
            typeArgumentsMap.put(typeParameter, typeArgument);
        }
        return typeArgumentsMap;
    }

    @NotNull
    public StackValue generateReceiverValue(@Nullable ReceiverValue receiverValue, boolean isSuper) {
        if (receiverValue instanceof ImplicitClassReceiver) {
            ClassDescriptor receiverDescriptor = ((ImplicitClassReceiver)receiverValue).getDeclarationDescriptor();
            if (DescriptorUtils.isCompanionObject(receiverDescriptor)) {
                CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.context.getContextDescriptor();
                if (contextDescriptor instanceof FunctionDescriptor && receiverDescriptor == contextDescriptor.getContainingDeclaration()) {
                    return StackValue.LOCAL_0;
                }
                if (CodegenUtilKt.isPossiblyUninitializedSingleton(receiverDescriptor) && this.isInsideSingleton(receiverDescriptor)) {
                    return this.generateThisOrOuterFromContext(receiverDescriptor, false, false);
                }
                return StackValue.singleton(receiverDescriptor, this.typeMapper);
            }
            if (receiverDescriptor instanceof ScriptDescriptor) {
                return this.generateScriptReceiver((ScriptDescriptor)receiverDescriptor);
            }
            return StackValue.thisOrOuter(this, receiverDescriptor, isSuper, receiverValue instanceof CastImplicitClassReceiver || DescriptorUtils.isEnumEntry(receiverDescriptor));
        }
        if (receiverValue instanceof ExtensionReceiver) {
            return this.generateExtensionReceiver(((ExtensionReceiver)receiverValue).getDeclarationDescriptor());
        }
        if (receiverValue instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            StackValue stackValue = this.gen(expressionReceiver.getExpression());
            if (!this.state.isReceiverAssertionsDisabled()) {
                RuntimeAssertionInfo runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RECEIVER_RUNTIME_ASSERTION_INFO, expressionReceiver);
                stackValue = AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
            }
            return stackValue;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue);
    }

    @NotNull
    private StackValue generateExtensionReceiver(@NotNull CallableDescriptor descriptor2) {
        if (this.myFrameMap.getIndex(descriptor2.getExtensionReceiverParameter()) != -1) {
            return StackValue.local(this.myFrameMap.getIndex(descriptor2.getExtensionReceiverParameter()), this.typeMapper.mapType(descriptor2.getExtensionReceiverParameter()));
        }
        return this.context.generateReceiver(descriptor2, this.state, false);
    }

    @NotNull
    private StackValue generateScriptReceiver(@NotNull ScriptDescriptor receiver) {
        CodegenContext cur;
        StackValue result2 = StackValue.LOCAL_0;
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (!inStartConstructorContext) {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                if (scriptContext.getScriptDescriptor() == receiver) {
                    return result2;
                }
                Type currentScriptType = this.typeMapper.mapType(scriptContext.getScriptDescriptor());
                Type classType = this.typeMapper.mapType(receiver);
                String fieldName = scriptContext.getScriptFieldName(receiver);
                return StackValue.field(classType, currentScriptType, fieldName, false, result2, receiver);
            }
            result2 = cur.getOuterExpression(result2, false);
            if (!inStartConstructorContext) continue;
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            inStartConstructorContext = false;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        return this.generateThisOrOuter(calleeContainingClass, isSuper, false);
    }

    private boolean isInsideSingleton(@NotNull ClassDescriptor singletonClassDescriptor) {
        assert (singletonClassDescriptor.getKind().isSingleton()) : "Singleton expected: " + singletonClassDescriptor;
        for (Object descriptor2 = this.context.getContextDescriptor(); descriptor2 != null; descriptor2 = descriptor2.getContainingDeclaration()) {
            if (descriptor2 == singletonClassDescriptor) {
                return true;
            }
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isAnonymousObject(descriptor2)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor thisOrOuterClass, boolean isSuper, boolean forceOuter) {
        if (!thisOrOuterClass.getKind().isSingleton()) {
            return this.generateThisOrOuterFromContext(thisOrOuterClass, isSuper, forceOuter);
        }
        if (thisOrOuterClass.equals(this.context.getThisDescriptor()) && !CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(this.context.getFunctionDescriptor())) {
            return StackValue.local(0, this.typeMapper.mapType(thisOrOuterClass));
        }
        if (this.shouldGenerateSingletonAsThisOrOuterFromContext(thisOrOuterClass)) {
            return this.generateThisOrOuterFromContext(thisOrOuterClass, isSuper, forceOuter);
        }
        if (DescriptorUtils.isEnumEntry(thisOrOuterClass)) {
            return StackValue.enumEntry(thisOrOuterClass, this.typeMapper);
        }
        return StackValue.singleton(thisOrOuterClass, this.typeMapper);
    }

    private StackValue generateThisOrOuterFromContext(@NotNull ClassDescriptor thisOrOuterClass, boolean isSuper, boolean forceOuter) {
        CodegenContext cur;
        Type type2 = this.asmType(thisOrOuterClass.getDefaultType());
        StackValue result2 = StackValue.local(0, type2);
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getEnclosingClassContext()) {
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor == thisOrOuterClass) {
                return result2;
            }
            if (!forceOuter && isSuper && DescriptorUtils.isSubclass(thisDescriptor, thisOrOuterClass)) {
                return this.castToRequiredTypeOfInterfaceIfNeeded(result2, thisDescriptor, thisOrOuterClass);
            }
            forceOuter = false;
            if (inStartConstructorContext) {
                result2 = cur.getOuterExpression(result2, false);
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                inStartConstructorContext = false;
                continue;
            }
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            result2 = cur.getOuterExpression(result2, false);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static CodegenContext getNotNullParentContextForMethod(CodegenContext cur) {
        if (cur instanceof MethodContext) {
            cur = cur.getParentContext();
        }
        assert (cur != null);
        return cur;
    }

    private boolean canSkipArrayCopyForSpreadArgument(KtExpression spreadArgument) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(spreadArgument, this.bindingContext);
        if (resolvedCall2 == null) {
            return false;
        }
        CallableDescriptor calleeDescriptor = resolvedCall2.getResultingDescriptor();
        return calleeDescriptor instanceof ConstructorDescriptor || CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2) || DescriptorUtils.getFqName(calleeDescriptor).asString().equals("kotlin.arrayOfNulls");
    }

    @NotNull
    public StackValue genVarargs(@NotNull VarargValueArgument valueArgument, @NotNull KotlinType outType) {
        Type type2 = this.asmType(outType);
        assert (type2.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type2);
        List<ValueArgument> arguments2 = valueArgument.getArguments();
        int size = arguments2.size();
        boolean hasSpread = false;
        for (int i = 0; i != size; ++i) {
            if (arguments2.get(i).getSpreadElement() == null) continue;
            hasSpread = true;
            break;
        }
        if (hasSpread) {
            String toArrayDescriptor;
            String addDescriptor;
            String owner;
            boolean arrayOfReferences = KotlinBuiltIns.isArray(outType);
            if (size == 1) {
                Type arrayType = AsmUtil.getArrayType(arrayOfReferences ? AsmTypes.OBJECT_TYPE : elementType);
                return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                    KtExpression spreadArgument = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
                    this.gen(spreadArgument, type2);
                    if (!this.canSkipArrayCopyForSpreadArgument(spreadArgument)) {
                        this.v.dup();
                        this.v.arraylength();
                        this.v.invokestatic("java/util/Arrays", "copyOf", Type.getMethodDescriptor(arrayType, arrayType, Type.INT_TYPE), false);
                    }
                    if (arrayOfReferences) {
                        this.v.checkcast(type2);
                    }
                    return Unit.INSTANCE;
                }));
            }
            if (arrayOfReferences) {
                owner = "kotlin/jvm/internal/SpreadBuilder";
                addDescriptor = "(Ljava/lang/Object;)V";
                toArrayDescriptor = "([Ljava/lang/Object;)[Ljava/lang/Object;";
            } else {
                String spreadBuilderClassName = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(elementType).getTypeName().getIdentifier() + "SpreadBuilder";
                owner = "kotlin/jvm/internal/" + spreadBuilderClassName;
                addDescriptor = "(" + elementType.getDescriptor() + ")V";
                toArrayDescriptor = "()" + type2.getDescriptor();
            }
            return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                this.v.anew(Type.getObjectType(owner));
                this.v.dup();
                this.v.iconst(size);
                this.v.invokespecial(owner, "<init>", "(I)V", false);
                for (int i = 0; i != size; ++i) {
                    this.v.dup();
                    ValueArgument argument = (ValueArgument)arguments2.get(i);
                    if (argument.getSpreadElement() != null) {
                        this.gen(argument.getArgumentExpression(), AsmTypes.OBJECT_TYPE);
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V", false);
                        continue;
                    }
                    this.gen(argument.getArgumentExpression(), elementType);
                    this.v.invokevirtual(owner, "add", addDescriptor, false);
                }
                if (arrayOfReferences) {
                    this.v.dup();
                    this.v.invokevirtual(owner, "size", "()I", false);
                    this.newArrayInstruction(outType);
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                    this.v.checkcast(type2);
                } else {
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                }
                return Unit.INSTANCE;
            }));
        }
        return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.v.iconst(arguments2.size());
            this.newArrayInstruction(outType);
            for (int i = 0; i != size; ++i) {
                this.v.dup();
                StackValue rightSide = this.gen(((ValueArgument)arguments2.get(i)).getArgumentExpression());
                StackValue.arrayElement(elementType, StackValue.onStack(type2), StackValue.constant(i, Type.INT_TYPE)).store(rightSide, this.v);
            }
            return Unit.INSTANCE;
        }));
    }

    public int indexOfLocalNotDelegated(KtReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (BindingContextUtils.isVarCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        if (declarationDescriptor instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)declarationDescriptor).isDelegated()) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, StackValue data) {
        KtExpression receiverExpression = expression2.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = this.bindingContext.get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        return this.generateClassLiteralReference(lhs, receiverExpression, true);
    }

    @Override
    public StackValue visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, StackValue data) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2.getCallableReference(), this.bindingContext);
        StackValue receiver = this.generateCallableReferenceReceiver(resolvedCall2);
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
        if (functionDescriptor != null) {
            FunctionReferenceGenerationStrategy strategy = new FunctionReferenceGenerationStrategy(this.state, functionDescriptor, resolvedCall2, receiver != null ? receiver.type : null, null, false);
            return this.genClosure(expression2, functionDescriptor, strategy, null, (FunctionDescriptor)resolvedCall2.getResultingDescriptor(), receiver);
        }
        return this.generatePropertyReference(expression2, this.getVariableDescriptorNotNull(expression2), (VariableDescriptor)resolvedCall2.getResultingDescriptor(), receiver);
    }

    @Nullable
    public StackValue generateCallableReferenceReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        ReceiverValue receiver = JvmCodegenUtil.getBoundCallableReferenceReceiver(resolvedCall2);
        if (receiver == null) {
            return null;
        }
        return StackValue.coercion(this.generateReceiverValue(receiver, false), this.asmType(receiver.getType()));
    }

    @NotNull
    private StackValue generatePropertyReference(@NotNull KtElement element, @NotNull VariableDescriptor variableDescriptor, @NotNull VariableDescriptor target, @Nullable StackValue receiverValue) {
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForCallable(this.bindingContext, variableDescriptor);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(element), this.typeMapper.mapClass(classDescriptor), element.getContainingFile());
        Type receiverAsmType = receiverValue != null ? receiverValue.type : null;
        PropertyReferenceCodegen codegen = new PropertyReferenceCodegen(this.state, this.parentCodegen, this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION), element, classBuilder2, variableDescriptor, target, receiverAsmType);
        codegen.generate();
        return codegen.putInstanceOnStack(receiverValue);
    }

    @NotNull
    public StackValue generateClassLiteralReference(@NotNull DoubleColonLHS lhs, @Nullable KtExpression receiverExpression, boolean wrapIntoKClass) {
        return StackValue.operation(wrapIntoKClass ? AsmTypes.K_CLASS_TYPE : AsmTypes.JAVA_CLASS_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            KotlinType type2 = lhs.getType();
            if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
                JavaClassProperty.INSTANCE.generateImpl((InstructionAdapter)v, this.gen(receiverExpression));
            } else {
                if (TypeUtils.isTypeParameter(type2)) {
                    assert (TypeUtils.isReifiedTypeParameter(type2)) : "Non-reified type parameter under ::class should be rejected by type checker: " + type2;
                    this.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, ReifiedTypeInliner.OperationKind.JAVA_CLASS);
                }
                AsmUtil.putJavaLangClassInstance(v, this.typeMapper.mapType(type2));
            }
            if (wrapIntoKClass) {
                AsmUtil.wrapJavaClassIntoKClass(v);
            }
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, StackValue receiver) {
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression2.getSelectorExpression());
    }

    private StackValue generateExpressionWithNullFallback(@NotNull KtExpression expression2, @NotNull Label ifnull) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        assert (deparenthesized != null) : "Unexpected empty expression";
        expression2 = deparenthesized;
        Type type2 = this.expressionType(expression2);
        if (expression2 instanceof KtSafeQualifiedExpression && !AsmUtil.isPrimitive(type2)) {
            return StackValue.coercion(this.generateSafeQualifiedExpression((KtSafeQualifiedExpression)expression2, ifnull), type2);
        }
        return this.genLazy(expression2, type2);
    }

    private StackValue generateSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @NotNull Label ifNull) {
        KtExpression receiver = expression2.getReceiverExpression();
        KtExpression selector = expression2.getSelectorExpression();
        Type receiverType = this.expressionType(receiver);
        StackValue receiverValue = this.generateExpressionWithNullFallback(receiver, ifNull);
        StackValue.SafeCall newReceiver = new StackValue.SafeCall(receiverType, receiverValue, AsmUtil.isPrimitive(receiverType) ? null : ifNull);
        return this.genQualified(newReceiver, selector);
    }

    @Override
    public StackValue visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, StackValue unused2) {
        Label ifnull = new Label();
        Type type2 = AsmUtil.boxType(this.expressionType(expression2));
        StackValue value = this.generateSafeQualifiedExpression(expression2, ifnull);
        StackValue newReceiver = StackValue.coercion(value, type2);
        StackValue result2 = !AsmUtil.isPrimitive(this.expressionType(expression2.getReceiverExpression())) ? new StackValue.SafeFallback(type2, ifnull, newReceiver) : newReceiver;
        return result2;
    }

    @Override
    public StackValue visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull StackValue receiver) {
        KtOperationReferenceExpression reference = expression2.getOperationReference();
        IElementType opToken = reference.getReferencedNameElementType();
        if (opToken == KtTokens.EQ) {
            return this.generateAssignmentExpression(expression2);
        }
        if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression2);
        }
        if (opToken == KtTokens.ANDAND) {
            return this.generateBooleanAnd(expression2);
        }
        if (opToken == KtTokens.OROR) {
            return this.generateBooleanOr(expression2);
        }
        if (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ || opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression2.getLeft(), expression2.getRight(), opToken, null);
        }
        if (opToken == KtTokens.LT || opToken == KtTokens.LTEQ || opToken == KtTokens.GT || opToken == KtTokens.GTEQ) {
            return this.generateComparison(expression2, receiver);
        }
        if (opToken == KtTokens.ELVIS) {
            return this.generateElvis(expression2);
        }
        if (opToken == KtTokens.IN_KEYWORD || opToken == KtTokens.NOT_IN) {
            return this.generateIn(StackValue.expression(this.expressionType(expression2.getLeft()), expression2.getLeft(), this), expression2.getRight(), reference);
        }
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateConstructorCall(resolvedCall2, this.expressionType(expression2));
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    private StackValue generateIn(StackValue leftValue, KtExpression rangeExpression, KtSimpleNameExpression operationReference) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(rangeExpression);
        assert (deparenthesized != null) : "For with empty range expression";
        RangeValue rangeValue = RangeValuesKt.createRangeValueForExpression(this, deparenthesized);
        return rangeValue.createInExpressionGenerator(this, operationReference).generate(leftValue);
    }

    private StackValue generateBooleanAnd(KtBinaryExpression expression2) {
        return StackValue.and(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue generateBooleanOr(KtBinaryExpression expression2) {
        return StackValue.or(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue genLazyUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr, @NotNull Type type2) {
        return pregenerated != null ? StackValue.coercion(pregenerated, type2) : this.genLazy(expr, type2);
    }

    private StackValue genUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr, @NotNull Type type2) {
        if (pregenerated != null) {
            pregenerated.put(type2, this.v);
        } else {
            this.gen(expr, type2);
        }
        return StackValue.onStack(type2);
    }

    private StackValue generateEquals(@Nullable KtExpression left, @Nullable KtExpression right, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft) {
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        if (KtPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right, opToken, null);
        }
        if (KtPsiUtil.isNullConstant(right)) {
            return this.genCmpWithNull(left, opToken, pregeneratedLeft);
        }
        if (this.isIntZero(left, leftType) && AsmUtil.isIntPrimitive(rightType)) {
            return this.genCmpWithZero(right, opToken, null);
        }
        if (this.isIntZero(right, rightType) && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, opToken, pregeneratedLeft);
        }
        if (pregeneratedLeft == null && left instanceof KtSafeQualifiedExpression && this.isSelectorPureNonNullType((KtSafeQualifiedExpression)left) && AsmUtil.isPrimitive(rightType)) {
            return this.genCmpSafeCallToPrimitive((KtSafeQualifiedExpression)left, right, rightType, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) && right instanceof KtSafeQualifiedExpression && this.isSelectorPureNonNullType((KtSafeQualifiedExpression)right)) {
            return this.genCmpPrimitiveToSafeCall(left, leftType, (KtSafeQualifiedExpression)right, opToken, pregeneratedLeft);
        }
        if (BoxedToPrimitiveEquality.isApplicable(opToken, leftType, rightType)) {
            return BoxedToPrimitiveEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), leftType, this.genLazy(right, rightType), rightType, this.myFrameMap);
        }
        if (PrimitiveToBoxedEquality.isApplicable(opToken, leftType, rightType)) {
            return PrimitiveToBoxedEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), leftType, this.genLazy(right, rightType), rightType);
        }
        if (PrimitiveToObjectEquality.isApplicable(opToken, leftType, rightType)) {
            return PrimitiveToObjectEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), leftType, this.genLazy(right, rightType), rightType);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType)) {
            leftType = AsmUtil.boxType(leftType);
            rightType = AsmUtil.boxType(rightType);
        }
        if (opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            Type operandType = AsmUtil.isPrimitive(leftType) ? leftType : AsmTypes.OBJECT_TYPE;
            return StackValue.cmp(opToken, operandType, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), this.genLazy(right, rightType));
        }
        return this.genEqualsForExpressionsPreferIEEE754Arithmetic(left, right, opToken, leftType, rightType, pregeneratedLeft);
    }

    private boolean isSelectorPureNonNullType(@NotNull KtSafeQualifiedExpression safeExpression) {
        KtExpression expression2 = safeExpression.getSelectorExpression();
        if (expression2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (resolvedCall2 == null) {
            return false;
        }
        KotlinType returnType = resolvedCall2.getResultingDescriptor().getReturnType();
        return returnType != null && !TypeUtils.isNullableType(returnType);
    }

    private StackValue genCmpPrimitiveToSafeCall(@NotNull KtExpression left, @NotNull Type leftType, @NotNull KtSafeQualifiedExpression right, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft) {
        Label rightIsNull = new Label();
        return new PrimitiveToSafeCallEquality(opToken, leftType, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), this.generateSafeQualifiedExpression(right, rightIsNull), this.expressionType(right.getReceiverExpression()), rightIsNull);
    }

    private StackValue genCmpSafeCallToPrimitive(@NotNull KtSafeQualifiedExpression left, @NotNull KtExpression right, @NotNull Type rightType, @NotNull IElementType opToken) {
        Label leftIsNull = new Label();
        return new SafeCallToPrimitiveEquality(opToken, rightType, this.generateSafeQualifiedExpression(left, leftIsNull), this.genLazy(right, rightType), this.expressionType(left.getReceiverExpression()), leftIsNull);
    }

    private StackValue genEqualsForExpressionsPreferIEEE754Arithmetic(@Nullable KtExpression left, @Nullable KtExpression right, @NotNull IElementType opToken, @NotNull Type leftType, @NotNull Type rightType, @Nullable StackValue pregeneratedLeft) {
        assert (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) : "Optoken should be '==' or '!=', but: " + opToken;
        TypeAndNullability left754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(left);
        TypeAndNullability right754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(right);
        if (left754Type != null && right754Type != null && left754Type.type.equals(right754Type.type)) {
            if (left754Type.isNullable || right754Type.isNullable) {
                if (this.state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0) {
                    return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                        this.generate754EqualsForNullableTypesViaIntrinsic((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                        return Unit.INSTANCE;
                    }));
                }
                return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                    this.generate754EqualsForNullableTypes((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                    return Unit.INSTANCE;
                }));
            }
            leftType = left754Type.type;
            rightType = right754Type.type;
        }
        return AsmUtil.genEqualsForExpressionsOnStack(opToken, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), this.genLazy(right, rightType));
    }

    private void generate754EqualsForNullableTypesViaIntrinsic(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        Type leftType = left754Type.isNullable ? AsmUtil.boxType(left754Type.type) : left754Type.type;
        this.genUnlessProvided(pregeneratedLeft, left, leftType);
        Type rightType = right754Type.isNullable ? AsmUtil.boxType(right754Type.type) : right754Type.type;
        this.gen(right, rightType);
        AsmUtil.genIEEE754EqualForNullableTypesCall(v, leftType, rightType);
        if (opToken == KtTokens.EXCLEQ) {
            AsmUtil.genInvertBoolean(v);
        }
    }

    private void generate754EqualsForNullableTypes(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        int equals = opToken == KtTokens.EQEQ ? 1 : 0;
        int notEquals = opToken != KtTokens.EQEQ ? 1 : 0;
        Label end = new Label();
        StackValue leftValue = pregeneratedLeft != null ? pregeneratedLeft : this.gen(left);
        leftValue.put(leftValue.type, v);
        leftValue = StackValue.onStack(leftValue.type);
        Type leftType = left754Type.type;
        Type rightType = right754Type.type;
        if (left754Type.isNullable) {
            leftValue.dup(v, false);
            Label leftIsNull = new Label();
            v.ifnull(leftIsNull);
            StackValue.coercion(leftValue, leftType).put(leftType, v);
            StackValue nonNullLeftValue = StackValue.onStack(leftType);
            StackValue rightValue = this.gen(right);
            rightValue.put(rightValue.type, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                rightValue.dup(v, false);
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                AsmUtil.pop(v, rightValue.type);
                AsmUtil.pop(v, nonNullLeftValue.type);
                v.iconst(notEquals);
                v.goTo(end);
                v.mark(rightIsNotNull);
            }
            StackValue.coercion(rightValue, rightType).put(rightType, v);
            StackValue nonNullRightValue = StackValue.onStack(rightType);
            StackValue.cmp(opToken, leftType, nonNullLeftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, v);
            v.goTo(end);
            v.mark(leftIsNull);
            AsmUtil.pop(v, leftValue.type);
            rightValue = this.gen(right);
            rightValue.put(rightValue.type, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                v.iconst(equals);
                v.goTo(end);
                v.mark(rightIsNotNull);
                v.iconst(notEquals);
            } else {
                AsmUtil.pop(v, rightValue.type);
                v.iconst(notEquals);
            }
            v.mark(end);
            return;
        }
        StackValue.coercion(leftValue, leftType).put(leftType, v);
        leftValue = StackValue.onStack(leftType);
        StackValue rightValue = this.gen(right);
        rightValue.put(rightValue.type, v);
        rightValue = StackValue.onStack(rightValue.type);
        rightValue.dup(v, false);
        Label rightIsNotNull = new Label();
        v.ifnonnull(rightIsNotNull);
        AsmUtil.pop(v, rightValue.type);
        AsmUtil.pop(v, leftValue.type);
        v.iconst(notEquals);
        v.goTo(end);
        v.mark(rightIsNotNull);
        StackValue.coercion(rightValue, rightType).put(rightType, v);
        StackValue nonNullRightValue = StackValue.onStack(rightType);
        StackValue.cmp(opToken, leftType, leftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, v);
        v.mark(end);
    }

    private boolean isIntZero(KtExpression expr, Type exprType) {
        ConstantValue<?> exprValue = this.getPrimitiveOrStringCompileTimeConstant(expr);
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && Integer.valueOf(0).equals(exprValue.getValue());
    }

    private StackValue genCmpWithZero(KtExpression exp, IElementType opToken, @Nullable StackValue pregeneratedExpr) {
        return StackValue.compareIntWithZero(pregeneratedExpr != null ? pregeneratedExpr : this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 154 : 153);
    }

    private StackValue genCmpWithNull(KtExpression exp, IElementType opToken, @Nullable StackValue pregeneratedExpr) {
        return StackValue.compareWithNull(pregeneratedExpr != null ? pregeneratedExpr : this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 199 : 198);
    }

    private StackValue generateElvis(@NotNull KtBinaryExpression expression2) {
        KtExpression left = expression2.getLeft();
        Type exprType = this.expressionType(expression2);
        Type leftType = this.expressionType(left);
        Label ifNull = new Label();
        assert (left != null) : "left expression in elvis should be not null: " + expression2.getText();
        StackValue value = this.generateExpressionWithNullFallback(left, ifNull);
        if (AsmUtil.isPrimitive(leftType)) {
            return value;
        }
        return StackValue.operation(exprType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            value.put(value.type, (InstructionAdapter)v);
            v.dup();
            v.ifnull(ifNull);
            StackValue.onStack(leftType).put(exprType, (InstructionAdapter)v);
            Label end = new Label();
            v.goTo(end);
            v.mark(ifNull);
            v.pop();
            this.gen(expression2.getRight(), exprType);
            v.mark(end);
            return null;
        }));
    }

    private StackValue generateComparison(KtBinaryExpression expression2, StackValue receiver) {
        StackValue rightValue;
        StackValue leftValue;
        Type type2;
        boolean is754Arithmetic;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        TypeAndNullability left754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(left);
        TypeAndNullability right754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(right);
        Callable callable = this.resolveToCallable((FunctionDescriptor)resolvedCall2.getResultingDescriptor(), false, resolvedCall2);
        boolean bl = is754Arithmetic = left754Type != null && right754Type != null && left754Type.type.equals(right754Type.type);
        if (callable instanceof IntrinsicCallable && (AsmUtil.isPrimitive(leftType) && AsmUtil.isPrimitive(rightType) || is754Arithmetic)) {
            type2 = is754Arithmetic ? left754Type.type : AsmUtil.comparisonOperandType(leftType, rightType);
            leftValue = this.gen(left);
            rightValue = this.gen(right);
        } else {
            type2 = Type.INT_TYPE;
            leftValue = this.invokeFunction(resolvedCall2, receiver);
            rightValue = StackValue.constant(0, type2);
        }
        return StackValue.cmp(expression2.getOperationToken(), type2, leftValue, rightValue);
    }

    private TypeAndNullability calcTypeForIEEE754ArithmeticIfNeeded(@Nullable KtExpression expression2) {
        return CodegenUtilKt.calcTypeForIEEE754ArithmeticIfNeeded(expression2, this.bindingContext, this.context.getFunctionDescriptor(), this.state.getLanguageVersionSettings());
    }

    private StackValue generateAssignmentExpression(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            StackValue stackValue = this.gen(expression2.getLeft());
            KtExpression right = expression2.getRight();
            assert (right != null) : expression2.getText();
            stackValue.store(this.gen(right), this.v);
            return Unit.INSTANCE;
        }));
    }

    private StackValue generateAugmentedAssignment(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            ResolvedCall<CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
            ResolvedCallWithRealDescriptor callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state.getProject(), this.state.getBindingContext());
            if (callWithRealDescriptor != null) {
                this.prepareCoroutineArgumentForSuspendCall(resolvedCall2, callWithRealDescriptor.getFakeContinuationExpression());
                resolvedCall2 = callWithRealDescriptor.getResolvedCall();
            }
            FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2);
            Callable callable = this.resolveToCallable(descriptor2, false, resolvedCall2);
            KtExpression lhs = expression2.getLeft();
            Type lhsType = this.expressionType(lhs);
            boolean keepReturnValue = Boolean.TRUE.equals(this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression2)) || !KotlinBuiltIns.isUnit(descriptor2.getReturnType());
            this.putCallAugAssignMethod(expression2, resolvedCall2, callable, lhsType, keepReturnValue);
            return Unit.INSTANCE;
        }));
    }

    private void putCallAugAssignMethod(@NotNull KtBinaryExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Callable callable, @NotNull Type lhsType, boolean keepReturnValue) {
        StackValue value = this.gen(expression2.getLeft());
        if (keepReturnValue) {
            value = StackValue.complexWriteReadReceiver(value);
        }
        value.put(lhsType, this.v);
        StackValue receiver = StackValue.onStack(lhsType);
        callable.invokeMethodWithArguments(resolvedCall2, receiver, this).put(callable.getReturnType(), this.v);
        if (keepReturnValue) {
            value.store(StackValue.onStack(callable.getReturnType()), this.v, true);
        }
    }

    public void invokeAppend(InstructionAdapter v, KtExpression expr) {
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expr = KtPsiUtil.safeDeparenthesize(expr));
        if (compileTimeConstant == null) {
            if (expr instanceof KtBinaryExpression) {
                KtBinaryExpression binaryExpression = (KtBinaryExpression)expr;
                if (binaryExpression.getOperationToken() == KtTokens.PLUS) {
                    KtExpression left = binaryExpression.getLeft();
                    KtExpression right = binaryExpression.getRight();
                    Type leftType = this.expressionType(left);
                    if (leftType.equals(AsmTypes.JAVA_STRING_TYPE)) {
                        this.invokeAppend(v, left);
                        this.invokeAppend(v, right);
                        return;
                    }
                }
            } else if (expr instanceof KtStringTemplateExpression) {
                List<StringTemplateEntry> entries = this.preprocessStringTemplate((KtStringTemplateExpression)expr);
                this.invokeAppendForEntries(v, entries);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        if (compileTimeConstant != null) {
            StackValue.constant(compileTimeConstant.getValue(), exprType).put(exprType, v);
        } else {
            this.gen(expr, exprType);
        }
        AsmUtil.genInvokeAppendMethod(v, exprType.getSort() == 9 ? AsmTypes.OBJECT_TYPE : exprType);
    }

    @Nullable
    private static KtSimpleNameExpression targetLabel(KtExpression expression2) {
        if (expression2.getParent() instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2.getParent()).getTargetLabel();
        }
        return null;
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression2, StackValue receiver) {
        return this.genQualified(receiver, expression2.getBaseExpression());
    }

    @Override
    public StackValue visitPrefixExpression(@NotNull KtPrefixExpression expression2, @NotNull StackValue receiver) {
        String operationName;
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        assert (op instanceof FunctionDescriptor || originalOperation == null) : String.valueOf(op);
        String string = operationName = originalOperation == null ? "" : originalOperation.getName().asString();
        if (!operationName.equals("inc") && !operationName.equals("dec")) {
            return this.invokeFunction(resolvedCall2, receiver);
        }
        int increment = operationName.equals("inc") ? 1 : -1;
        Type type2 = this.expressionType(expression2.getBaseExpression());
        StackValue value = this.gen(expression2.getBaseExpression());
        return StackValue.preIncrement(type2, value, increment, resolvedCall2, this);
    }

    @Override
    public StackValue visitPostfixExpression(@NotNull KtPostfixExpression expression2, StackValue receiver) {
        int index2;
        KtExpression operand;
        int increment;
        if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
            StackValue base = this.genQualified(receiver, expression2.getBaseExpression());
            if (AsmUtil.isPrimitive(base.type)) {
                return base;
            }
            return StackValue.operation(base.type, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                base.put(base.type, (InstructionAdapter)v);
                v.dup();
                Label ok = new Label();
                v.ifnonnull(ok);
                v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwNpe", "()V", false);
                v.mark(ok);
                return null;
            }));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        String originalOperationName = originalOperation != null ? originalOperation.getName().asString() : null;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        if (!(op instanceof FunctionDescriptor) || originalOperation == null) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + originalOperationName + " " + op);
        }
        Type asmResultType = this.expressionType(expression2);
        Type asmBaseType = this.expressionType(expression2.getBaseExpression());
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (originalOperationName.equals("inc")) {
            increment = 1;
        } else if (originalOperationName.equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + originalOperationName + " " + op);
        }
        boolean isPrimitiveNumberClassDescriptor = AsmUtil.isPrimitiveNumberClassDescriptor(cls);
        if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType) && (operand = expression2.getBaseExpression()) instanceof KtReferenceExpression && asmResultType == Type.INT_TYPE && this.bindingContext.get(BindingContext.SMARTCAST, operand) == null && (index2 = this.indexOfLocalNotDelegated((KtReferenceExpression)operand)) >= 0) {
            return StackValue.postIncrement(index2, increment);
        }
        return StackValue.operation(asmBaseType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Type storeType;
            StackValue value = StackValue.complexWriteReadReceiver(this.gen(expression2.getBaseExpression()));
            value.put(asmBaseType, (InstructionAdapter)v);
            AsmUtil.dup(v, asmBaseType);
            StackValue.Local previousValue = StackValue.local(this.myFrameMap.enterTemp(asmBaseType), asmBaseType);
            previousValue.store(StackValue.onStack(asmBaseType), (InstructionAdapter)v);
            if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType)) {
                AsmUtil.genIncrement(asmBaseType, increment, v);
                storeType = asmBaseType;
            } else {
                StackValue result2 = this.invokeFunction(resolvedCall2, StackValue.onStack(asmBaseType));
                result2.put(result2.type, (InstructionAdapter)v);
                storeType = result2.type;
            }
            value.store(StackValue.onStack(storeType), (InstructionAdapter)v, true);
            previousValue.put(asmBaseType, (InstructionAdapter)v);
            this.myFrameMap.leaveTemp(asmBaseType);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitProperty(@NotNull KtProperty property, StackValue receiver) {
        KtExpression initializer2 = property.getInitializer();
        KtExpression delegateExpression = property.getDelegateExpression();
        if (initializer2 != null) {
            assert (delegateExpression == null) : PsiUtilsKt.getElementTextWithContext(property);
            this.initializeLocalVariable(property, this.gen(initializer2));
        } else if (delegateExpression != null) {
            this.initializeLocalVariable(property, this.gen(delegateExpression));
        } else if (property.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            this.initializeLocalVariable(property, null);
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, StackValue receiver) {
        return this.initializeDestructuringDeclaration(multiDeclaration, false);
    }

    public StackValue initializeDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, boolean asProperty) {
        KtExpression initializer2 = multiDeclaration.getInitializer();
        if (initializer2 == null) {
            return StackValue.none();
        }
        KotlinType initializerType = this.bindingContext.getType(initializer2);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer2, initializerAsmType);
        this.v.store(tempVarIndex, initializerAsmType);
        StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType);
        this.initializeDestructuringDeclarationVariables(multiDeclaration, initializerAsReceiver, local, asProperty);
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    public void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull StackValue receiverStackValue) {
        this.initializeDestructuringDeclarationVariables(destructuringDeclaration, receiver, receiverStackValue, false);
    }

    private void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull StackValue receiverStackValue, boolean asProperty) {
        for (KtDestructuringDeclarationEntry variableDeclaration : destructuringDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
            assert (resolvedCall2 != null) : "Resolved call is null for " + variableDeclaration.getText();
            Call call2 = this.makeFakeCall(receiver);
            VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(variableDeclaration);
            if (UnderscoreUtilKt.isSingleUnderscore(variableDeclaration)) continue;
            if (asProperty && variableDescriptor instanceof PropertyDescriptor) {
                StackValue.Property propertyValue = this.intermediateValueForProperty((PropertyDescriptor)variableDescriptor, true, false, null, true, StackValue.LOCAL_0, null, false);
                propertyValue.store(this.invokeFunction(call2, resolvedCall2, receiverStackValue), this.v);
                continue;
            }
            this.initializeLocalVariable(variableDeclaration, this.invokeFunction(call2, resolvedCall2, receiverStackValue));
        }
    }

    @NotNull
    private StackValue getVariableMetadataValue(@NotNull VariableDescriptorWithAccessors variableDescriptor) {
        StackValue value = this.findLocalOrCapturedValue(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
        assert (value != null) : "Can't find stack value for local delegated variable metadata: " + variableDescriptor;
        return value;
    }

    @NotNull
    private StackValue adjustVariableValue(@NotNull StackValue varValue, DeclarationDescriptor descriptor2) {
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2)) {
            return varValue;
        }
        VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
        StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
        return this.delegatedVariableValue(varValue, metadataValue, variableDescriptor, this.typeMapper);
    }

    private void initializeLocalVariable(@NotNull KtVariableDeclaration variableDeclaration, @Nullable StackValue initializer2) {
        LocalVariableDescriptor variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration);
        if (KtPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type varType = this.getVariableTypeNoSharing(variableDescriptor);
        StackValue storeTo = sharedVarType == null ? StackValue.local(index2, varType) : StackValue.shared(index2, varType);
        storeTo.putReceiver(this.v, false);
        if (variableDescriptor.isLateInit()) {
            assert (initializer2 == null) : "Initializer should be null for lateinit var " + variableDescriptor + ": " + initializer2;
            this.v.aconst(null);
            storeTo.storeSelector(storeTo.type, this.v);
            return;
        }
        assert (initializer2 != null) : "Initializer should be not null for " + variableDescriptor;
        initializer2.put(initializer2.type, this.v);
        this.markLineNumber(variableDeclaration, false);
        Type resultType = initializer2.type;
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
            this.initializePropertyMetadata((KtProperty)variableDeclaration, variableDescriptor, metadataValue);
            ResolvedCall<FunctionDescriptor> provideDelegateCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
            if (provideDelegateCall != null) {
                resultType = this.generateProvideDelegateCallForLocalVariable(initializer2, metadataValue, provideDelegateCall);
            }
        }
        storeTo.storeSelector(resultType, this.v);
    }

    @NotNull
    private Type generateProvideDelegateCallForLocalVariable(@NotNull StackValue initializer2, final StackValue metadataValue, ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall) {
        StackValue provideDelegateReceiver = StackValue.onStack(initializer2.type);
        List<? extends ValueArgument> arguments2 = provideDelegateResolvedCall.getCall().getValueArguments();
        assert (arguments2.size() == 2) : "Resolved call for '" + OperatorNameConventions.PROVIDE_DELEGATE.asString() + "' should have exactly 2 value parameters";
        this.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
        this.tempVariables.put(arguments2.get(1).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                metadataValue.put(type2, v);
            }
        });
        StackValue result2 = this.invokeFunction(provideDelegateResolvedCall, provideDelegateReceiver);
        result2.put(result2.type, this.v);
        this.tempVariables.remove(arguments2.get(0).asElement());
        this.tempVariables.remove(arguments2.get(1).asElement());
        return result2.type;
    }

    @NotNull
    public VariableDescriptor getVariableDescriptorNotNull(@NotNull KtElement declaration) {
        VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VARIABLE, declaration);
        assert (descriptor2 != null) : "Couldn't find variable declaration in binding context " + declaration.getText();
        return descriptor2;
    }

    private void initializePropertyMetadata(@NotNull KtProperty variable2, @NotNull LocalVariableDescriptor variableDescriptor, @NotNull StackValue metadataVar) {
        StackValue value = this.context.getFunctionDescriptor().isInline() ? this.generatePropertyReference(variable2.getDelegate(), variableDescriptor, variableDescriptor, null) : PropertyCodegen.getDelegatedPropertyMetadata(variableDescriptor, this.bindingContext);
        value.put(AsmTypes.K_PROPERTY_TYPE, this.v);
        metadataVar.storeSelector(AsmTypes.K_PROPERTY_TYPE, this.v);
    }

    @NotNull
    private StackValue generateNewCall(@NotNull KtCallExpression expression2, @NotNull ResolvedCall<?> resolvedCall2) {
        Type type2 = this.expressionType(expression2);
        if (type2.getSort() == 9) {
            return this.generateNewArray(expression2, this.bindingContext.getType(expression2), resolvedCall2);
        }
        return this.generateConstructorCall(resolvedCall2, type2);
    }

    @NotNull
    public ClassConstructorDescriptor getConstructorDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor accessibleDescriptor = this.accessibleFunctionDescriptor(resolvedCall2);
        assert (accessibleDescriptor instanceof ClassConstructorDescriptor) : "getConstructorDescriptor must be called only for constructors: " + accessibleDescriptor;
        return (ClassConstructorDescriptor)accessibleDescriptor;
    }

    @Nullable
    private static ReceiverValue getConstructorReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        Object constructor = resolvedCall2.getResultingDescriptor();
        if (constructor.getExtensionReceiverParameter() != null) {
            assert (constructor instanceof TypeAliasConstructorDescriptor) : "Only type alias constructor can have an extension receiver: " + constructor;
            return resolvedCall2.getExtensionReceiver();
        }
        if (constructor.getDispatchReceiverParameter() != null) {
            return resolvedCall2.getDispatchReceiver();
        }
        return null;
    }

    @NotNull
    public StackValue generateConstructorCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull Type objectType) {
        return StackValue.functionCall(objectType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            v.anew(objectType);
            v.dup();
            ClassConstructorDescriptor constructor = this.getConstructorDescriptor(resolvedCall2);
            ReceiverParameterDescriptor dispatchReceiver = constructor.getDispatchReceiverParameter();
            ClassDescriptor containingDeclaration = constructor.getContainingDeclaration();
            if (dispatchReceiver != null) {
                Type receiverType = this.typeMapper.mapType(dispatchReceiver.getType());
                ReceiverValue receiver = ExpressionCodegen.getConstructorReceiver(resolvedCall2);
                boolean callSuper = containingDeclaration.isInner() && receiver instanceof ImplicitClassReceiver;
                this.generateReceiverValue(receiver, callSuper).put(receiverType, (InstructionAdapter)v);
            }
            this.pushClosureOnStack(containingDeclaration, dispatchReceiver == null, this.defaultCallGenerator, null);
            constructor = SamCodegenUtil.resolveSamAdapter(constructor);
            CallableMethod method = this.typeMapper.mapToCallableMethod(constructor, false);
            this.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
            return Unit.INSTANCE;
        }));
    }

    public StackValue generateNewArray(@NotNull KtCallExpression expression2, @NotNull KotlinType arrayType, @NotNull ResolvedCall<?> resolvedCall2) {
        List<KtValueArgument> args = expression2.getValueArguments();
        assert (args.size() == 1 || args.size() == 2) : "Unknown constructor called: " + args.size() + " arguments";
        if (args.size() == 1) {
            KtExpression sizeExpression = args.get(0).getArgumentExpression();
            return StackValue.operation(this.typeMapper.mapType(arrayType), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                this.gen(sizeExpression, Type.INT_TYPE);
                this.newArrayInstruction(arrayType);
                return Unit.INSTANCE;
            }));
        }
        return this.invokeFunction(resolvedCall2, StackValue.none());
    }

    public void newArrayInstruction(@NotNull KotlinType arrayType) {
        if (KotlinBuiltIns.isArray(arrayType)) {
            KotlinType elementJetType = arrayType.getArguments().get(0).getType();
            this.putReifiedOperationMarkerIfTypeIsReifiedParameter(elementJetType, ReifiedTypeInliner.OperationKind.NEW_ARRAY);
            this.v.newarray(AsmUtil.boxType(this.asmType(elementJetType)));
        } else {
            Type type2 = this.typeMapper.mapType(arrayType);
            this.v.newarray(AsmUtil.correctElementType(type2));
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, StackValue receiver) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        KtExpression array = expression2.getArrayExpression();
        KotlinType type2 = array != null ? this.bindingContext.getType(array) : null;
        Type arrayType = this.expressionType(array);
        List<KtExpression> indices = expression2.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        assert (operationDescriptor != null);
        if (arrayType.getSort() == 9 && indices.size() == 1 && KotlinBuiltIns.isInt(operationDescriptor.getValueParameters().get(0).getType())) {
            Type elementType;
            assert (type2 != null);
            if (KotlinBuiltIns.isArray(type2)) {
                KotlinType jetElementType = type2.getArguments().get(0).getType();
                elementType = AsmUtil.boxType(this.asmType(jetElementType));
            } else {
                elementType = AsmUtil.correctElementType(arrayType);
            }
            StackValue arrayValue = this.genLazy(array, arrayType);
            StackValue index2 = this.genLazy(indices.get(0), Type.INT_TYPE);
            return StackValue.arrayElement(elementType, arrayValue, index2);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression2);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression2);
        boolean isGetter = OperatorNameConventions.GET.equals(operationDescriptor.getName());
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "No resolved call for " + operationDescriptor;
        Callable callable = this.resolveToCallable(this.accessibleFunctionDescriptor(resolvedCall2), false, resolvedCall2);
        CallableMethod callableMethod = this.resolveToCallableMethod(operationDescriptor, false);
        Type[] argumentTypes2 = callableMethod.getParameterTypes();
        StackValue.CollectionElementReceiver collectionElementReceiver = this.createCollectionElementReceiver(expression2, receiver, operationDescriptor, isGetter, resolvedGetCall, resolvedSetCall, callable);
        Type elementType = isGetter ? callableMethod.getReturnType() : ArrayUtil.getLastElement(argumentTypes2);
        return StackValue.collectionElement(collectionElementReceiver, elementType, resolvedGetCall, resolvedSetCall, this);
    }

    @NotNull
    private StackValue.CollectionElementReceiver createCollectionElementReceiver(@NotNull KtArrayAccessExpression expression2, @NotNull StackValue receiver, @NotNull FunctionDescriptor operationDescriptor, boolean isGetter, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull Callable callable) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "couldn't find resolved call: " + expression2.getText();
        List<ResolvedValueArgument> valueArguments = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments != null) : "Failed to arrange value arguments by index: " + operationDescriptor;
        if (!isGetter) {
            assert (valueArguments.size() >= 2) : "Setter call should have at least 2 arguments: " + operationDescriptor;
            valueArguments.remove(valueArguments.size() - 1);
        }
        return new StackValue.CollectionElementReceiver(callable, receiver, resolvedGetCall, resolvedSetCall, isGetter, this, valueArguments);
    }

    @Override
    public StackValue visitThrowExpression(@NotNull KtThrowExpression expression2, StackValue receiver) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.gen(expression2.getThrownExpression(), AsmTypes.JAVA_THROWABLE_TYPE);
            this.v.athrow();
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitThisExpression(@NotNull KtThisExpression expression2, StackValue receiver) {
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
        if (descriptor2 instanceof ClassDescriptor) {
            return StackValue.thisOrOuter(this, (ClassDescriptor)descriptor2, false, true);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.generateExtensionReceiver((CallableDescriptor)descriptor2);
        }
        throw new UnsupportedOperationException("Neither this nor receiver: " + descriptor2 + expression2.getParent().getContainingFile().getText());
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression2, StackValue receiver) {
        return this.generateTryExpression(expression2, false);
    }

    public StackValue generateTryExpression(KtTryExpression expression2, boolean isStatement) {
        Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        return StackValue.operation(expectedAsmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            FinallyBlockStackElement finallyBlockStackElement = null;
            if (finallyBlock != null) {
                finallyBlockStackElement = new FinallyBlockStackElement(expression2);
                this.blockStackElements.push(finallyBlockStackElement);
            }
            Label tryStart = new Label();
            v.mark(tryStart);
            v.nop();
            this.gen(expression2.getTryBlock(), expectedAsmType);
            int savedValue = -1;
            if (!isStatement) {
                savedValue = this.myFrameMap.enterTemp(expectedAsmType);
                v.store(savedValue, expectedAsmType);
            }
            Label tryEnd = new Label();
            v.mark(tryEnd);
            List<Label> tryBlockRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, tryEnd);
            Label end = new Label();
            this.genFinallyBlockOrGoto(finallyBlockStackElement, end, null);
            List<KtCatchClause> clauses = expression2.getCatchClauses();
            int size = clauses.size();
            for (int i = 0; i < size; ++i) {
                KtCatchClause clause = clauses.get(i);
                Label clauseStart = new Label();
                v.mark(clauseStart);
                KtExpression catchBody = clause.getCatchBody();
                if (catchBody != null) {
                    this.markLineNumber(catchBody, false);
                }
                VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
                assert (descriptor2 != null);
                Type descriptorType = this.asmType(descriptor2.getType());
                this.myFrameMap.enter(descriptor2, descriptorType);
                int index2 = this.lookupLocalIndex(descriptor2);
                v.store(index2, descriptorType);
                Label catchVariableStart = new Label();
                v.mark(catchVariableStart);
                this.gen(catchBody, expectedAsmType);
                if (!isStatement) {
                    v.store(savedValue, expectedAsmType);
                }
                this.myFrameMap.leave(descriptor2);
                Label clauseEnd = new Label();
                v.mark(clauseEnd);
                v.visitLocalVariable(descriptor2.getName().asString(), descriptorType.getDescriptor(), null, catchVariableStart, clauseEnd, index2);
                this.genFinallyBlockOrGoto(finallyBlockStackElement, i != size - 1 || finallyBlock != null ? end : null, null);
                this.generateExceptionTable(clauseStart, tryBlockRegions, descriptorType.getInternalName());
            }
            if (finallyBlock != null) {
                Label defaultCatchStart = new Label();
                v.mark(defaultCatchStart);
                int savedException = this.myFrameMap.enterTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.store(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                Label defaultCatchEnd = new Label();
                v.mark(defaultCatchEnd);
                List<Label> defaultCatchRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, defaultCatchEnd);
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, null);
                v.load(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                this.myFrameMap.leaveTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.athrow();
                this.generateExceptionTable(defaultCatchStart, defaultCatchRegions, null);
            }
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            if (!isStatement) {
                v.load(savedValue, expectedAsmType);
                this.myFrameMap.leaveTemp(expectedAsmType);
            }
            if (finallyBlock != null) {
                this.blockStackElements.pop();
            }
            return Unit.INSTANCE;
        }));
    }

    private void generateExceptionTable(@NotNull Label catchStart, @NotNull List<Label> catchedRegions, @Nullable String exception) {
        for (int i = 0; i < catchedRegions.size(); i += 2) {
            Label startRegion = catchedRegions.get(i);
            Label endRegion = catchedRegions.get(i + 1);
            this.v.visitTryCatchBlock(startRegion, endRegion, catchStart, exception);
        }
    }

    @NotNull
    private static List<Label> getCurrentCatchIntervals(@Nullable FinallyBlockStackElement finallyBlockStackElement, @NotNull Label blockStart, @NotNull Label blockEnd) {
        ArrayList<Label> gapsInBlock;
        ArrayList<Label> arrayList = gapsInBlock = finallyBlockStackElement != null ? new ArrayList<Label>(finallyBlockStackElement.gaps) : Collections.emptyList();
        assert (gapsInBlock.size() % 2 == 0);
        ArrayList<Label> blockRegions = new ArrayList<Label>(gapsInBlock.size() + 2);
        blockRegions.add(blockStart);
        blockRegions.addAll(gapsInBlock);
        blockRegions.add(blockEnd);
        return blockRegions;
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, StackValue receiver) {
        KtExpression left = expression2.getLeft();
        IElementType opToken = expression2.getOperationReference().getReferencedNameElementType();
        KotlinType rightType = this.bindingContext.get(BindingContext.TYPE, expression2.getRight());
        assert (rightType != null);
        StackValue value = this.genQualified(receiver, left);
        return StackValue.operation(AsmUtil.boxType(this.asmType(rightType)), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            value.put(AsmUtil.boxType(value.type), (InstructionAdapter)v);
            if (value.type == Type.VOID_TYPE) {
                StackValue.putUnitInstance(v);
            }
            boolean safeAs = opToken == KtTokens.AS_SAFE;
            Type type2 = AsmUtil.boxType(this.asmType(rightType));
            if (TypeUtils.isReifiedTypeParameter(rightType)) {
                this.putReifiedOperationMarkerIfTypeIsReifiedParameter(rightType, safeAs ? ReifiedTypeInliner.OperationKind.SAFE_AS : ReifiedTypeInliner.OperationKind.AS);
                v.checkcast(type2);
                return Unit.INSTANCE;
            }
            CodegenUtilKt.generateAsCast(v, rightType, type2, safeAs);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitIsExpression(@NotNull KtIsExpression expression2, StackValue receiver) {
        StackValue match2 = StackValue.expression(AsmTypes.OBJECT_TYPE, expression2.getLeftHandSide(), this);
        return this.generateIsCheck(match2, expression2.getTypeReference(), expression2.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, KtExpression subjectExpression, KtExpression patternExpression) {
        if (expressionToMatch != null) {
            return this.generateEquals(subjectExpression, patternExpression, KtTokens.EQEQ, expressionToMatch);
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, KtTypeReference typeReference, boolean negated) {
        KotlinType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        this.markStartLineNumber(typeReference);
        StackValue value = this.generateIsCheck(expressionToMatch, jetType, false);
        return negated ? StackValue.not(value) : value;
    }

    private StackValue generateIsCheck(StackValue expressionToGen, KotlinType kotlinType, boolean leaveExpressionOnStack) {
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            expressionToGen.put(AsmTypes.OBJECT_TYPE, (InstructionAdapter)v);
            if (leaveExpressionOnStack) {
                v.dup();
            }
            Type type2 = AsmUtil.boxType(this.asmType(kotlinType));
            if (TypeUtils.isReifiedTypeParameter(kotlinType)) {
                this.putReifiedOperationMarkerIfTypeIsReifiedParameter(kotlinType, ReifiedTypeInliner.OperationKind.IS);
                v.instanceOf(type2);
                return null;
            }
            CodegenUtilKt.generateIsCheck(v, kotlinType, type2);
            return null;
        }));
    }

    public void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind) {
        ExpressionCodegen.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, operationKind, this.v, this);
    }

    public static void putReifiedOperationMarkerIfTypeIsReifiedParameterWithoutPropagation(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind, @NotNull InstructionAdapter v) {
        ExpressionCodegen.putReifiedOperationMarkerIfTypeIsReifiedParameterImpl(type2, operationKind, v, null);
    }

    public static void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind, @NotNull InstructionAdapter v, @NotNull BaseExpressionCodegen codegen) {
        ExpressionCodegen.putReifiedOperationMarkerIfTypeIsReifiedParameterImpl(type2, operationKind, v, codegen);
    }

    private static void putReifiedOperationMarkerIfTypeIsReifiedParameterImpl(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind, @NotNull InstructionAdapter v, @Nullable BaseExpressionCodegen codegen) {
        Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = CodegenUtilKt.extractReificationArgument(type2);
        if (typeParameterAndReificationArgument != null && ((TypeParameterDescriptor)typeParameterAndReificationArgument.getFirst()).isReified()) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeParameterAndReificationArgument.getFirst();
            if (codegen != null) {
                codegen.consumeReifiedOperationMarker(typeParameterDescriptor);
            }
            v.iconst(operationKind.getId());
            v.visitLdcInsn(((ReificationArgument)typeParameterAndReificationArgument.getSecond()).asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "reifiedOperationMarker", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE, Type.getType(String.class)), false);
        }
    }

    @Override
    public void propagateChildReifiedTypeParametersUsages(@NotNull ReifiedTypeParametersUsages usages) {
        this.parentCodegen.getReifiedTypeParametersUsages().propagateChildUsagesWithinContext(usages, this.context);
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression2, StackValue receiver) {
        return this.generateWhenExpression(expression2, false);
    }

    public StackValue generateWhenExpression(KtWhenExpression expression2, boolean isStatement) {
        KtExpression expr = expression2.getSubjectExpression();
        Type subjectType = this.expressionType(expr);
        Type resultType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        return StackValue.operation(resultType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            int subjectLocal;
            SwitchCodegen switchCodegen = this.switchCodegenProvider.buildAppropriateSwitchCodegenIfPossible(expression2, isStatement, CodegenUtil.isExhaustive(this.bindingContext, expression2, isStatement));
            if (switchCodegen != null) {
                switchCodegen.generate();
                return null;
            }
            int n = subjectLocal = expr != null ? this.myFrameMap.enterTemp(subjectType) : -1;
            if (subjectLocal != -1) {
                this.gen(expr, subjectType);
                this.tempVariables.put(expr, StackValue.local(subjectLocal, subjectType));
                v.store(subjectLocal, subjectType);
            }
            Label end = new Label();
            boolean hasElse = KtPsiUtil.checkWhenExpressionHasSingleElse(expression2);
            Label nextCondition = null;
            for (KtWhenEntry whenEntry : expression2.getEntries()) {
                if (nextCondition != null) {
                    v.mark(nextCondition);
                }
                nextCondition = new Label();
                FrameMap.Mark mark = this.myFrameMap.mark();
                Label thisEntry = new Label();
                if (!whenEntry.isElse()) {
                    KtWhenCondition[] conditions2 = whenEntry.getConditions();
                    for (int i = 0; i < conditions2.length; ++i) {
                        StackValue conditionValue = this.generateWhenCondition(expr, subjectType, subjectLocal, conditions2[i]);
                        BranchedValue.Companion.condJump(conditionValue, nextCondition, true, (InstructionAdapter)v);
                        if (i >= conditions2.length - 1) continue;
                        v.goTo(thisEntry);
                        v.mark(nextCondition);
                        nextCondition = new Label();
                    }
                }
                v.visitLabel(thisEntry);
                this.gen(whenEntry.getExpression(), resultType);
                mark.dropTo();
                if (whenEntry.isElse()) continue;
                v.goTo(end);
            }
            if (!hasElse && nextCondition != null) {
                v.mark(nextCondition);
                this.putUnitInstanceOntoStackForNonExhaustiveWhen(expression2, isStatement);
            }
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            this.myFrameMap.leaveTemp(subjectType);
            this.tempVariables.remove(expr);
            return null;
        }));
    }

    public void putUnitInstanceOntoStackForNonExhaustiveWhen(@NotNull KtWhenExpression whenExpression, boolean isStatement) {
        if (CodegenUtil.isExhaustive(this.bindingContext, whenExpression, isStatement)) {
            AsmUtil.genThrow(this.v, "kotlin/NoWhenBranchMatchedException", null);
        } else if (!isStatement) {
            StackValue.putUnitInstance(this.v);
        }
    }

    private StackValue generateWhenCondition(KtExpression subjectExpression, Type subjectType, int subjectLocal, KtWhenCondition condition) {
        StackValue.Local match2;
        if (condition instanceof KtWhenConditionInRange) {
            KtWhenConditionInRange conditionInRange = (KtWhenConditionInRange)condition;
            return this.generateIn(StackValue.local(subjectLocal, subjectType), conditionInRange.getRangeExpression(), conditionInRange.getOperationReference());
        }
        StackValue.Local local = match2 = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType);
        if (condition instanceof KtWhenConditionIsPattern) {
            KtWhenConditionIsPattern patternCondition = (KtWhenConditionIsPattern)condition;
            return this.generateIsCheck((StackValue)match2, patternCondition.getTypeReference(), patternCondition.isNegated());
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition).getExpression();
            return this.generateExpressionMatch(match2, subjectExpression, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    public Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        KtSimpleNameExpression fake = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createSimpleName("fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return ((CallableMemberDescriptor)this.context.getContextDescriptor()).toString();
    }

    @Override
    @NotNull
    public FrameMap getFrameMap() {
        return this.myFrameMap;
    }

    @NotNull
    public MethodContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public NameGenerator getInlineNameGenerator() {
        NameGenerator nameGenerator2 = this.getParentCodegen().getInlineNameGenerator();
        Name name = ((CallableMemberDescriptor)this.context.getContextDescriptor()).getName();
        String inlinedName = name.isSpecial() ? "$special" : name.asString();
        return nameGenerator2.subGenerator(inlinedName + "$$inlined");
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Stack<BlockStackElement> getBlockStackElements() {
        return new Stack<BlockStackElement>((Collection<BlockStackElement>)this.blockStackElements);
    }

    public void addBlockStackElementsForNonLocalReturns(@NotNull Stack<BlockStackElement> elements, int finallyDepth) {
        this.blockStackElements.addAll(elements);
        this.finallyDepth = finallyDepth;
    }

    @NotNull
    private StackValue.Delegate delegatedVariableValue(@NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        return StackValue.delegate(typeMapper.mapType(variableDescriptor.getType()), delegateValue, metadataValue, variableDescriptor, this);
    }

    @Override
    @NotNull
    public InstructionAdapter getVisitor() {
        return this.v;
    }

    @Override
    public void consumeReifiedOperationMarker(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor.getContainingDeclaration() != this.context.getContextDescriptor()) {
            this.parentCodegen.getReifiedTypeParametersUsages().addUsedReifiedParameter(typeParameterDescriptor.getName().asString());
        }
    }

    private static class NonLocalReturnInfo {
        private final Type returnType;
        private final String labelName;

        private NonLocalReturnInfo(@NotNull Type type2, @NotNull String name) {
            this.returnType = type2;
            this.labelName = name;
        }
    }

    private static abstract class StringTemplateEntry {
        private StringTemplateEntry() {
        }

        static class Expression
        extends StringTemplateEntry {
            final KtExpression expression;

            Expression(KtExpression expression2) {
                this.expression = expression2;
            }
        }

        static class Constant
        extends StringTemplateEntry {
            final String value;

            Constant(String value) {
                this.value = value;
            }
        }
    }

    private static class ObjectLiteralResult {
        private final boolean wereReifiedMarkers;
        private final ClassDescriptor classDescriptor;

        public ObjectLiteralResult(boolean wereReifiedMarkers, @NotNull ClassDescriptor classDescriptor) {
            this.wereReifiedMarkers = wereReifiedMarkers;
            this.classDescriptor = classDescriptor;
        }
    }

    static class FinallyBlockStackElement
    extends BlockStackElement {
        List<Label> gaps = new ArrayList<Label>();
        final KtTryExpression expression;

        FinallyBlockStackElement(KtTryExpression expression2) {
            this.expression = expression2;
        }

        private void addGapLabel(Label label) {
            this.gaps.add(label);
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final KtSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, KtSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

