/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.Delta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;

public final class ChangeDelta<T>
extends Delta<T> {
    public ChangeDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.CHANGE, original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        int i;
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void restore(List<T> target) {
        int i;
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getOriginal().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + " to " + this.getRevised().getLines() + "]";
    }
}

