/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioWebSocketMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;

public class NioWebSocketMessageProcessor
extends NioTcpMessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(NioWebSocketMessageProcessor.class);

    public NioWebSocketMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, sipStack, port);
        this.transport = "WS";
    }

    @Override
    public NioTcpMessageChannel createMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel client) throws IOException {
        return NioWebSocketMessageChannel.create(this, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(":createMessageChannel: " + targetHostPort);
        }
        try {
            String key = MessageChannel.getKey(targetHostPort, this.transport);
            if (this.messageChannels.get(key) != null) {
                MessageChannel messageChannel = (MessageChannel)this.messageChannels.get(key);
                return messageChannel;
            }
            NioWebSocketMessageChannel retval = new NioWebSocketMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
            Object object = this.messageChannels;
            synchronized (object) {
                this.messageChannels.put(key, retval);
            }
            retval.isCached = true;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("key " + key);
                logger.logDebug("Creating " + retval);
            }
            this.selector.wakeup();
            object = retval;
            return object;
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("MessageChannel::createMessageChannel - exit");
            }
        }
    }

    @Override
    public MessageChannel createMessageChannel(InetAddress targetHost, int port) throws IOException {
        String key = MessageChannel.getKey(targetHost, port, this.transport);
        if (this.messageChannels.get(key) != null) {
            return (MessageChannel)this.messageChannels.get(key);
        }
        NioWebSocketMessageChannel retval = new NioWebSocketMessageChannel(targetHost, port, this.sipStack, this);
        this.selector.wakeup();
        this.messageChannels.put(key, retval);
        retval.isCached = true;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("key " + key);
            logger.logDebug("Creating " + retval);
        }
        return retval;
    }
}

