/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsIQ;
import org.jitsi.xmpp.extensions.colibri.ShutdownIQ;
import org.jitsi.xmpp.extensions.colibri.SimulcastMode;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceRidGroupPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jxmpp.jid.parts.Localpart;
import org.xmlpull.v1.XmlPullParser;

public class ColibriIQProvider
extends IQProvider {
    private static final Logger logger = Logger.getLogger(ColibriIQProvider.class);

    public ColibriIQProvider() {
        ProviderManager.addExtensionProvider((String)"payload-type", (String)"http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rtcp-fb", (String)"urn:xmpp:jingle:apps:rtp:rtcp-fb:0", new DefaultPacketExtensionProvider<RtcpFbPacketExtension>(RtcpFbPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rtp-hdrext", (String)"http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"source", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourcePacketExtension>(SourcePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"ssrc-group", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceGroupPacketExtension>(SourceGroupPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rid-group", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceRidGroupPacketExtension>(SourceRidGroupPacketExtension.class));
        DefaultPacketExtensionProvider<ParameterPacketExtension> parameterProvider = new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class);
        ProviderManager.addExtensionProvider((String)"parameter", (String)"http://jitsi.org/protocol/colibri", parameterProvider);
        ProviderManager.addExtensionProvider((String)"parameter", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", parameterProvider);
        ProviderManager.addIQProvider((String)"graceful-shutdown", (String)"http://jitsi.org/protocol/colibri", (Object)((Object)this));
        ProviderManager.addIQProvider((String)"force-shutdown", (String)"http://jitsi.org/protocol/colibri", (Object)((Object)this));
        DefaultPacketExtensionProvider<ColibriConferenceIQ.GracefulShutdown> shutdownProvider = new DefaultPacketExtensionProvider<ColibriConferenceIQ.GracefulShutdown>(ColibriConferenceIQ.GracefulShutdown.class);
        ProviderManager.addExtensionProvider((String)"graceful-shutdown", (String)"http://jitsi.org/protocol/colibri", shutdownProvider);
        ProviderManager.addIQProvider((String)"stats", (String)"http://jitsi.org/protocol/colibri", (Object)((Object)this));
        DefaultPacketExtensionProvider<ColibriStatsExtension> statsProvider = new DefaultPacketExtensionProvider<ColibriStatsExtension>(ColibriStatsExtension.class);
        ProviderManager.addExtensionProvider((String)"stats", (String)"http://jitsi.org/protocol/colibri", statsProvider);
        DefaultPacketExtensionProvider<ColibriStatsExtension.Stat> statProvider = new DefaultPacketExtensionProvider<ColibriStatsExtension.Stat>(ColibriStatsExtension.Stat.class);
        ProviderManager.addExtensionProvider((String)"stat", (String)"http://jitsi.org/protocol/colibri", statProvider);
        ProviderManager.addExtensionProvider((String)"ssrc-info", (String)"http://jitsi.org/jitmeet", new DefaultPacketExtensionProvider<SSRCInfoPacketExtension>(SSRCInfoPacketExtension.class));
    }

    private void addChildExtension(ColibriConferenceIQ.Channel channel, ExtensionElement childExtension) {
        if (childExtension instanceof PayloadTypePacketExtension) {
            PayloadTypePacketExtension payloadType = (PayloadTypePacketExtension)childExtension;
            if ("opus".equals(payloadType.getName()) && payloadType.getChannels() != 2) {
                payloadType.setChannels(2);
            }
            channel.addPayloadType(payloadType);
        } else if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            channel.setTransport(transport);
        } else if (childExtension instanceof SourcePacketExtension) {
            channel.addSource((SourcePacketExtension)childExtension);
        } else if (childExtension instanceof SourceGroupPacketExtension) {
            SourceGroupPacketExtension sourceGroup = (SourceGroupPacketExtension)childExtension;
            channel.addSourceGroup(sourceGroup);
        } else if (childExtension instanceof RTPHdrExtPacketExtension) {
            RTPHdrExtPacketExtension rtpHdrExtPacketExtension = (RTPHdrExtPacketExtension)childExtension;
            channel.addRtpHeaderExtension(rtpHdrExtPacketExtension);
        } else {
            logger.error((Object)("Ignoring a child of 'channel' of unknown type: " + childExtension));
        }
    }

    private void addChildExtension(ColibriConferenceIQ.ChannelBundle bundle, ExtensionElement childExtension) {
        if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            bundle.setTransport(transport);
        }
    }

    private void addChildExtension(ColibriConferenceIQ.SctpConnection sctpConnection, ExtensionElement childExtension) {
        if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            sctpConnection.setTransport(transport);
        }
    }

    private ExtensionElement parseExtension(XmlPullParser parser, String name, String namespace) throws Exception {
        ExtensionElement extension;
        ExtensionElementProvider extensionProvider = ProviderManager.getExtensionProvider((String)name, (String)namespace);
        if (extensionProvider == null) {
            this.throwAway(parser, name);
            extension = null;
        } else {
            extension = (ExtensionElement)extensionProvider.parse(parser);
        }
        return extension;
    }

    public IQ parse(XmlPullParser parser, int depth) throws Exception {
        IQ iq;
        String namespace = parser.getNamespace();
        if ("conference".equals(parser.getName()) && "http://jitsi.org/protocol/colibri".equals(namespace)) {
            String conferenceName;
            String conferenceGID;
            ColibriConferenceIQ conference = new ColibriConferenceIQ();
            String conferenceID = parser.getAttributeValue("", "id");
            if (conferenceID != null && conferenceID.length() != 0) {
                conference.setID(conferenceID);
            }
            if ((conferenceGID = parser.getAttributeValue("", "gid")) != null && conferenceGID.length() != 0) {
                conference.setGID(conferenceGID);
            }
            if (!StringUtils.isNullOrEmpty((String)(conferenceName = parser.getAttributeValue("", "name")))) {
                conference.setName(Localpart.from((String)conferenceName));
            }
            boolean done = false;
            ColibriConferenceIQ.Channel channel = null;
            ColibriConferenceIQ.RTCPTerminationStrategy rtcpTerminationStrategy = null;
            ColibriConferenceIQ.SctpConnection sctpConnection = null;
            ColibriConferenceIQ.ChannelBundle bundle = null;
            ColibriConferenceIQ.Content content = null;
            ColibriConferenceIQ.Recording recording = null;
            ColibriConferenceIQ.Endpoint conferenceEndpoint = null;
            StringBuilder ssrc = null;
            while (!done) {
                switch (parser.next()) {
                    case 3: {
                        String name = parser.getName();
                        if ("conference".equals(name)) {
                            done = true;
                            break;
                        }
                        if ("channel".equals(name)) {
                            content.addChannel(channel);
                            channel = null;
                            break;
                        }
                        if ("sctpconnection".equals(name)) {
                            if (sctpConnection != null) {
                                content.addSctpConnection(sctpConnection);
                            }
                            sctpConnection = null;
                            break;
                        }
                        if ("channel-bundle".equals(name)) {
                            if (bundle == null) break;
                            if (conference.addChannelBundle(bundle) != null) {
                                logger.warn((Object)"Replacing a channel-bundle with the sameID (not a valid Colibri packet).");
                            }
                            bundle = null;
                            break;
                        }
                        if ("endpoint".equals(name)) {
                            if (conference.addEndpoint(conferenceEndpoint) != null) {
                                logger.warn((Object)"Replacing an endpoint element with the sameID (not a valid Colibri packet).");
                            }
                            conferenceEndpoint = null;
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            String s = ssrc.toString().trim();
                            if (s.length() != 0) {
                                int i = s.startsWith("-") ? Integer.parseInt(s) : (int)Long.parseLong(s);
                                channel.addSSRC(i);
                            }
                            ssrc = null;
                            break;
                        }
                        if ("content".equals(name)) {
                            conference.addContent(content);
                            content = null;
                            break;
                        }
                        if ("rtcp-termination-strategy".equals(name)) {
                            conference.setRTCPTerminationStrategy(rtcpTerminationStrategy);
                            rtcpTerminationStrategy = null;
                            break;
                        }
                        if ("recording".equals(name)) {
                            conference.setRecording(recording);
                            recording = null;
                            break;
                        }
                        if (!"graceful-shutdown".equals(name)) break;
                        conference.setGracefulShutdown(true);
                        break;
                    }
                    case 2: {
                        String id;
                        String channelBundleId;
                        String name = parser.getName();
                        if ("channel".equals(name)) {
                            String rtpPort;
                            String rtpLevelRelayType;
                            String rtcpPort;
                            String receivingSimulcastLayer;
                            String simulcastMode;
                            String lastN;
                            String initiator;
                            String channelID;
                            String host;
                            String packetDelay;
                            String expire;
                            String endpoint;
                            String type = parser.getAttributeValue("", "type");
                            channel = "octo".equals(type) ? new ColibriConferenceIQ.OctoChannel() : new ColibriConferenceIQ.Channel();
                            String direction = parser.getAttributeValue("", "direction");
                            if (direction != null && direction.length() != 0) {
                                channel.setDirection(direction);
                            }
                            if (!StringUtils.isNullOrEmpty((String)(endpoint = parser.getAttributeValue("", "endpoint")))) {
                                channel.setEndpoint(endpoint);
                            }
                            if (!StringUtils.isNullOrEmpty((String)(channelBundleId = parser.getAttributeValue("", "channel-bundle-id")))) {
                                channel.setChannelBundleId(channelBundleId);
                            }
                            if ((expire = parser.getAttributeValue("", "expire")) != null && expire.length() != 0) {
                                channel.setExpire(Integer.parseInt(expire));
                            }
                            if (!StringUtils.isNullOrEmpty((String)(packetDelay = parser.getAttributeValue("", "packet-delay")))) {
                                channel.setPacketDelay(Integer.parseInt(packetDelay));
                            }
                            if ((host = parser.getAttributeValue("", "host")) != null && host.length() != 0) {
                                channel.setHost(host);
                            }
                            if ((channelID = parser.getAttributeValue("", "id")) != null && channelID.length() != 0) {
                                channel.setID(channelID);
                            }
                            if ((initiator = parser.getAttributeValue("", "initiator")) != null && initiator.length() != 0) {
                                channel.setInitiator(Boolean.valueOf(initiator));
                            }
                            if ((lastN = parser.getAttributeValue("", "last-n")) != null && lastN.length() != 0) {
                                channel.setLastN(Integer.parseInt(lastN));
                            }
                            if (!StringUtils.isNullOrEmpty((String)(simulcastMode = parser.getAttributeValue("", "simulcast-mode")))) {
                                channel.setSimulcastMode(SimulcastMode.fromString(simulcastMode));
                            }
                            if ((receivingSimulcastLayer = parser.getAttributeValue("", "receive-simulcast-layer")) != null && receivingSimulcastLayer.length() != 0) {
                                channel.setReceivingSimulcastLayer(Integer.parseInt(receivingSimulcastLayer));
                            }
                            if ((rtcpPort = parser.getAttributeValue("", "rtcpport")) != null && rtcpPort.length() != 0) {
                                channel.setRTCPPort(Integer.parseInt(rtcpPort));
                            }
                            if ((rtpLevelRelayType = parser.getAttributeValue("", "rtp-level-relay-type")) != null && rtpLevelRelayType.length() != 0) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if ((rtpPort = parser.getAttributeValue("", "rtpport")) == null || rtpPort.length() == 0) break;
                            channel.setRTPPort(Integer.parseInt(rtpPort));
                            break;
                        }
                        if ("channel-bundle".equals(name)) {
                            String bundleId = parser.getAttributeValue("", "id");
                            if (StringUtils.isNullOrEmpty((String)bundleId)) break;
                            bundle = new ColibriConferenceIQ.ChannelBundle(bundleId);
                            break;
                        }
                        if ("rtcp-termination-strategy".equals(name)) {
                            rtcpTerminationStrategy = new ColibriConferenceIQ.RTCPTerminationStrategy();
                            String strategyName = parser.getAttributeValue("", "name");
                            if (strategyName == null || strategyName.length() == 0) break;
                            rtcpTerminationStrategy.setName(strategyName);
                            break;
                        }
                        if ("relay".equals(name)) {
                            id = parser.getAttributeValue("", "id");
                            if (id == null || !(channel instanceof ColibriConferenceIQ.OctoChannel)) break;
                            ((ColibriConferenceIQ.OctoChannel)channel).addRelay(id);
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            ssrc = new StringBuilder();
                            break;
                        }
                        if ("content".equals(name)) {
                            content = new ColibriConferenceIQ.Content();
                            String contentName = parser.getAttributeValue("", "name");
                            if (contentName == null || contentName.length() == 0) break;
                            content.setName(contentName);
                            break;
                        }
                        if ("recording".equals(name)) {
                            String stateStr = parser.getAttributeValue("", "state");
                            String token = parser.getAttributeValue("", "token");
                            recording = new ColibriConferenceIQ.Recording(stateStr, token);
                            break;
                        }
                        if ("sctpconnection".equals(name)) {
                            String expire;
                            String initiator;
                            String port;
                            String endpoint = parser.getAttributeValue("", "endpoint");
                            String connID = parser.getAttributeValue("", "id");
                            if (StringUtils.isNullOrEmpty((String)connID) && StringUtils.isNullOrEmpty((String)endpoint)) {
                                sctpConnection = null;
                                break;
                            }
                            sctpConnection = new ColibriConferenceIQ.SctpConnection();
                            if (!StringUtils.isNullOrEmpty((String)connID)) {
                                sctpConnection.setID(connID);
                            }
                            if (!StringUtils.isNullOrEmpty((String)endpoint)) {
                                sctpConnection.setEndpoint(endpoint);
                            }
                            if (!StringUtils.isNullOrEmpty((String)(port = parser.getAttributeValue("", "port")))) {
                                sctpConnection.setPort(Integer.parseInt(port));
                            }
                            if (!StringUtils.isNullOrEmpty((String)(channelBundleId = parser.getAttributeValue("", "channel-bundle-id")))) {
                                sctpConnection.setChannelBundleId(channelBundleId);
                            }
                            if (!StringUtils.isNullOrEmpty((String)(initiator = parser.getAttributeValue("", "initiator")))) {
                                sctpConnection.setInitiator(Boolean.valueOf(initiator));
                            }
                            if (StringUtils.isNullOrEmpty((String)(expire = parser.getAttributeValue("", "expire")))) break;
                            sctpConnection.setExpire(Integer.parseInt(expire));
                            break;
                        }
                        if ("endpoint".equals(name)) {
                            id = parser.getAttributeValue("", "id");
                            String displayName = parser.getAttributeValue("", "displayname");
                            String statsId = parser.getAttributeValue("", "stats-id");
                            if (StringUtils.isNullOrEmpty((String)id)) break;
                            conferenceEndpoint = new ColibriConferenceIQ.Endpoint(id, statsId, displayName);
                            break;
                        }
                        if (channel == null && sctpConnection == null && bundle == null) break;
                        String peName = null;
                        String peNamespace = null;
                        if ("transport".equals(name) && "urn:xmpp:jingle:transports:ice-udp:1".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:ice-udp:1";
                        } else if ("payload-type".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("rtcp-fb".equals(name) && "urn:xmpp:jingle:apps:rtp:rtcp-fb:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("rtp-hdrext".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("transport".equals(name) && "urn:xmpp:jingle:transports:raw-udp:1".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:raw-udp:1";
                        } else if ("source".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        } else if ("ssrc-group".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        } else if ("rid-group".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        }
                        if (peName == null) {
                            this.throwAway(parser, name);
                            break;
                        }
                        ExtensionElement extension = this.parseExtension(parser, peName, peNamespace);
                        if (extension == null) break;
                        if (channel != null) {
                            this.addChildExtension(channel, extension);
                            break;
                        }
                        if (sctpConnection != null) {
                            this.addChildExtension(sctpConnection, extension);
                            break;
                        }
                        this.addChildExtension(bundle, extension);
                        break;
                    }
                    case 4: {
                        if (ssrc == null) break;
                        ssrc.append(parser.getText());
                    }
                }
            }
            iq = conference;
        } else if ("http://jitsi.org/protocol/colibri".equals(namespace) && ShutdownIQ.isValidElementName(parser.getName())) {
            String rootElement = parser.getName();
            iq = ShutdownIQ.createShutdownIQ(rootElement);
            boolean done = false;
            while (!done) {
                switch (parser.next()) {
                    case 3: {
                        String name = parser.getName();
                        if (!rootElement.equals(name)) break;
                        done = true;
                        break;
                    }
                }
            }
        } else if ("stats".equals(parser.getName()) && "http://jitsi.org/protocol/colibri".equals(namespace)) {
            String rootElement = parser.getName();
            ColibriStatsIQ statsIQ = new ColibriStatsIQ();
            iq = statsIQ;
            ColibriStatsExtension.Stat stat = null;
            boolean done = false;
            while (!done) {
                switch (parser.next()) {
                    case 2: {
                        String name = parser.getName();
                        if (!"stat".equals(name)) break;
                        stat = new ColibriStatsExtension.Stat();
                        String statName = parser.getAttributeValue("", "name");
                        stat.setName(statName);
                        String statValue = parser.getAttributeValue("", "value");
                        stat.setValue(statValue);
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (rootElement.equals(name)) {
                            done = true;
                            break;
                        }
                        if (!"stat".equals(name) || stat == null) break;
                        statsIQ.addStat(stat);
                        stat = null;
                        break;
                    }
                }
            }
        } else {
            iq = null;
        }
        return iq;
    }

    private void throwAway(XmlPullParser parser, String name) throws Exception {
        while (3 != parser.next() || !name.equals(parser.getName())) {
        }
    }
}

