/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.HashSet;
import java.util.List;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.Logger;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleUtils;

public class ColibriAnalyser {
    private static final Logger logger = Logger.getLogger(ColibriAnalyser.class);
    private final ColibriConferenceIQ conferenceState;

    public ColibriAnalyser(ColibriConferenceIQ conferenceStateHolder) {
        this.conferenceState = conferenceStateHolder;
    }

    public void processChannelAllocResp(ColibriConferenceIQ allocateResponse) {
        String conferenceResponseID = allocateResponse.getID();
        String colibriID = this.conferenceState.getID();
        if (colibriID == null) {
            this.conferenceState.setID(conferenceResponseID);
        } else if (!colibriID.equals(conferenceResponseID)) {
            throw new IllegalStateException("conference.id");
        }
        this.conferenceState.setFrom(allocateResponse.getFrom());
        HashSet<String> endpoints = new HashSet<String>();
        for (ColibriConferenceIQ.Content contentResponse : allocateResponse.getContents()) {
            String contentName = contentResponse.getName();
            ColibriConferenceIQ.Content content = this.conferenceState.getOrCreateContent(contentName);
            for (ColibriConferenceIQ.Channel channelResponse : contentResponse.getChannels()) {
                content.addChannel(channelResponse);
                endpoints.add(channelResponse.getEndpoint());
            }
            for (ColibriConferenceIQ.SctpConnection sctpConnResponse : contentResponse.getSctpConnections()) {
                content.addSctpConnection(sctpConnResponse);
                endpoints.add(sctpConnResponse.getEndpoint());
            }
        }
        for (ColibriConferenceIQ.ChannelBundle bundle : allocateResponse.getChannelBundles()) {
            this.conferenceState.addChannelBundle(bundle);
        }
        for (ColibriConferenceIQ.Endpoint endpoint : allocateResponse.getEndpoints()) {
            this.conferenceState.addEndpoint(endpoint);
        }
    }

    public static ColibriConferenceIQ getResponseContents(ColibriConferenceIQ conferenceResponse, List<ContentPacketExtension> peerContents) {
        ColibriConferenceIQ conferenceResult = new ColibriConferenceIQ();
        conferenceResult.setFrom(conferenceResponse.getFrom());
        conferenceResult.setID(conferenceResponse.getID());
        conferenceResult.setGID(conferenceResponse.getGID());
        conferenceResult.setName(conferenceResponse.getName());
        String bundleId = null;
        HashSet<String> endpointIds = new HashSet<String>();
        for (ContentPacketExtension content : peerContents) {
            MediaType mediaType = JingleUtils.getMediaType(content);
            ColibriConferenceIQ.Content contentResponse = conferenceResponse.getContent(mediaType.toString());
            if (contentResponse == null) continue;
            String contentName = contentResponse.getName();
            ColibriConferenceIQ.Content contentResult = new ColibriConferenceIQ.Content(contentName);
            conferenceResult.addContent(contentResult);
            for (ColibriConferenceIQ.Channel channelResponse : contentResponse.getChannels()) {
                contentResult.addChannel(channelResponse);
                bundleId = ColibriAnalyser.readChannelBundle(channelResponse, bundleId);
                endpointIds.add(channelResponse.getEndpoint());
            }
            for (ColibriConferenceIQ.SctpConnection sctpConnResponse : contentResponse.getSctpConnections()) {
                contentResult.addSctpConnection(sctpConnResponse);
                bundleId = ColibriAnalyser.readChannelBundle(sctpConnResponse, bundleId);
                endpointIds.add(sctpConnResponse.getEndpoint());
            }
        }
        if (bundleId != null) {
            for (ColibriConferenceIQ.ChannelBundle bundle : conferenceResponse.getChannelBundles()) {
                if (!bundleId.equals(bundle.getId())) continue;
                conferenceResult.addChannelBundle(bundle);
                break;
            }
        }
        for (ColibriConferenceIQ.Endpoint en : conferenceResponse.getEndpoints()) {
            if (!endpointIds.contains(en.getId())) continue;
            conferenceResult.addEndpoint(en);
        }
        return conferenceResult;
    }

    private static String readChannelBundle(ColibriConferenceIQ.ChannelCommon channel, String currentBundle) {
        String channelBundle = channel.getChannelBundleId();
        if (channelBundle == null) {
            return currentBundle;
        }
        if (currentBundle == null) {
            return channel.getChannelBundleId();
        }
        if (!currentBundle.equals(channelBundle)) {
            logger.error((Object)("Replaced bundle: " + currentBundle + " with " + channelBundle));
        }
        return channelBundle;
    }
}

