/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.SourceStream;

public abstract class BufferStreamAdapter<T extends SourceStream>
implements SourceStream {
    private final Format format;
    protected final T stream;

    public BufferStreamAdapter(T stream, Format format) {
        this.stream = stream;
        this.format = format;
    }

    public boolean endOfStream() {
        return this.stream.endOfStream();
    }

    public ContentDescriptor getContentDescriptor() {
        return this.stream.getContentDescriptor();
    }

    public long getContentLength() {
        return this.stream.getContentLength();
    }

    public Object getControl(String controlType) {
        return this.stream.getControl(controlType);
    }

    public Object[] getControls() {
        return this.stream.getControls();
    }

    public Format getFormat() {
        return this.format;
    }

    public T getStream() {
        return this.stream;
    }

    protected void read(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        int numberOfBytesRead = this.doRead(buffer, data, offset, length);
        buffer.setData((Object)data);
        if (numberOfBytesRead >= 0) {
            buffer.setLength(numberOfBytesRead);
        } else {
            buffer.setLength(0);
            if (numberOfBytesRead == -1) {
                buffer.setEOM(true);
            }
        }
        buffer.setOffset(offset);
        Format format = this.getFormat();
        if (format != null) {
            buffer.setFormat(format);
        }
    }

    protected abstract int doRead(Buffer var1, byte[] var2, int var3, int var4) throws IOException;
}

