/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Controls;
import javax.media.Format;
import javax.media.Manager;
import javax.media.NoProcessorException;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.Renderer;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.rtp.ReceiveStream;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.ProcessorUtility;
import org.jitsi.impl.neomedia.control.AbstractControls;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.device.AudioMixerMediaDevice;
import org.jitsi.impl.neomedia.device.ReceiveStreamPushBufferDataSource;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.impl.neomedia.protocol.InbandDTMFDataSource;
import org.jitsi.impl.neomedia.protocol.MuteDataSource;
import org.jitsi.impl.neomedia.protocol.RewritablePullBufferDataSource;
import org.jitsi.impl.neomedia.protocol.RewritablePushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.service.neomedia.DTMFInbandTone;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.control.AdvancedAttributesAwareCodec;
import org.jitsi.service.neomedia.control.FormatParametersAwareCodec;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.utils.logging.Logger;

public class MediaDeviceSession
extends PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(MediaDeviceSession.class);
    public static final String OUTPUT_DATA_SOURCE = "OUTPUT_DATA_SOURCE";
    public static final String SSRC_LIST = "SSRC_LIST";
    private DataSource captureDevice;
    private boolean captureDeviceIsConnected;
    private ContentDescriptor contentDescriptor;
    private final AbstractMediaDevice device;
    private MediaFormatImpl<? extends Format> format;
    private boolean mute = false;
    private final List<Playback> playbacks = new LinkedList<Playback>();
    private final ReadWriteLock playbacksLock = new ReentrantReadWriteLock();
    private final ControllerListener playerControllerListener = new ControllerListener(){

        public void controllerUpdate(ControllerEvent ev) {
            MediaDeviceSession.this.playerControllerUpdate(ev);
        }
    };
    private Processor processor;
    private ControllerListener processorControllerListener;
    private boolean processorIsPrematurelyClosed;
    private long[] ssrcList = null;
    private MediaDirection startedDirection = MediaDirection.INACTIVE;
    private boolean disposePlayerOnClose = true;
    protected boolean outputSizeChanged = false;
    public boolean useTranslator = false;

    protected MediaDeviceSession(AbstractMediaDevice device) {
        this.checkDevice(device);
        this.device = device;
    }

    public void setDisposePlayerOnClose(boolean disposePlayerOnClose) {
        this.disposePlayerOnClose = disposePlayerOnClose;
    }

    protected void addSSRC(long ssrc) {
        if (this.ssrcList == null) {
            this.setSsrcList(new long[]{ssrc});
            return;
        }
        for (int i = 0; i < this.ssrcList.length; ++i) {
            if (ssrc != this.ssrcList[i]) continue;
            return;
        }
        long[] newSsrcList = new long[this.ssrcList.length + 1];
        System.arraycopy(this.ssrcList, 0, newSsrcList, 0, this.ssrcList.length);
        newSsrcList[newSsrcList.length - 1] = ssrc;
        this.setSsrcList(newSsrcList);
    }

    private static VideoFormat assertSize(VideoFormat sourceFormat) {
        int height;
        int width;
        if (sourceFormat.matches(new Format("jpeg/rtp"))) {
            Dimension size = sourceFormat.getSize();
            width = size.width % 8 == 0 ? size.width : size.width / 8 * 8;
            height = size.height % 8 == 0 ? size.height : size.height / 8 * 8;
        } else if (sourceFormat.matches(new Format("h263/rtp"))) {
            width = 352;
            height = 288;
        } else {
            return sourceFormat;
        }
        VideoFormat result = new VideoFormat(null, new Dimension(width, height), -1, null, -1.0f);
        return (VideoFormat)result.intersects((Format)sourceFormat);
    }

    protected void checkDevice(AbstractMediaDevice device) {
    }

    public void close() {
        try {
            this.stop(MediaDirection.SENDRECV);
        }
        finally {
            this.disconnectCaptureDevice();
            this.closeProcessor();
            if (this.disposePlayerOnClose) {
                this.disposePlayer();
            }
            this.processor = null;
            this.captureDevice = null;
        }
    }

    private void closeProcessor() {
        if (this.processor != null) {
            if (this.processorControllerListener != null) {
                this.processor.removeControllerListener(this.processorControllerListener);
            }
            this.processor.stop();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Stopped Processor with hashCode " + this.processor.hashCode()));
            }
            if (this.processor.getState() == 300) {
                DataSource dataOutput;
                try {
                    dataOutput = this.processor.getDataOutput();
                }
                catch (NotRealizedError nre) {
                    dataOutput = null;
                }
                if (dataOutput != null) {
                    dataOutput.disconnect();
                }
            }
            this.processor.deallocate();
            this.processor.close();
            this.processorIsPrematurelyClosed = false;
            this.disconnectCaptureDevice();
        }
    }

    protected DataSource createCaptureDevice() {
        Object captureDevice = this.getDevice().createOutputDataSource();
        if (captureDevice != null) {
            MuteDataSource muteDataSource = AbstractControls.queryInterface((Controls)captureDevice, MuteDataSource.class);
            if (muteDataSource == null) {
                if (captureDevice instanceof PushBufferDataSource) {
                    captureDevice = new RewritablePushBufferDataSource((PushBufferDataSource)captureDevice);
                } else if (captureDevice instanceof PullBufferDataSource) {
                    captureDevice = new RewritablePullBufferDataSource((PullBufferDataSource)captureDevice);
                }
                muteDataSource = AbstractControls.queryInterface((Controls)captureDevice, MuteDataSource.class);
            }
            if (muteDataSource != null) {
                muteDataSource.setMute(this.mute);
            }
        }
        return captureDevice;
    }

    protected Player createPlayer(DataSource dataSource) {
        Processor player = null;
        Exception exception = null;
        try {
            player = this.getDevice().createPlayer(dataSource);
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (exception != null) {
            logger.error((Object)("Failed to create Player for " + MediaStreamImpl.toString(dataSource)), (Throwable)exception);
        } else if (player != null) {
            player.addControllerListener(this.playerControllerListener);
            player.configure();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Created Player with hashCode " + player.hashCode() + " for " + MediaStreamImpl.toString(dataSource)));
            }
        }
        return player;
    }

    protected Processor createProcessor() {
        DataSource captureDevice = this.getConnectedCaptureDevice();
        if (captureDevice != null) {
            Processor processor = null;
            Throwable exception = null;
            try {
                processor = Manager.createProcessor((DataSource)captureDevice);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            catch (NoProcessorException npe) {
                exception = npe;
            }
            if (exception != null) {
                logger.error((Object)("Failed to create Processor for " + captureDevice), exception);
            } else {
                if (this.processorControllerListener == null) {
                    this.processorControllerListener = new ControllerListener(){

                        public void controllerUpdate(ControllerEvent event) {
                            MediaDeviceSession.this.processorControllerUpdate(event);
                        }
                    };
                }
                processor.addControllerListener(this.processorControllerListener);
                if (MediaDeviceSession.waitForState(processor, 180)) {
                    this.processor = processor;
                    this.processorIsPrematurelyClosed = false;
                } else {
                    if (this.processorControllerListener != null) {
                        processor.removeControllerListener(this.processorControllerListener);
                    }
                    Object var2_2 = null;
                }
            }
        }
        return this.processor;
    }

    protected ContentDescriptor createProcessorContentDescriptor(Processor processor) {
        return this.contentDescriptor == null ? new ContentDescriptor("raw.rtp") : this.contentDescriptor;
    }

    protected Renderer createRenderer(Player player, TrackControl trackControl) {
        return this.getDevice().createRenderer();
    }

    private void disconnectCaptureDevice() {
        if (this.captureDevice != null) {
            try {
                this.captureDevice.stop();
            }
            catch (IOException ioe) {
                logger.error((Object)("Failed to properly stop captureDevice " + this.captureDevice), (Throwable)ioe);
            }
            this.captureDevice.disconnect();
            this.captureDeviceIsConnected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposePlayer() {
        Lock writeLock = this.playbacksLock.writeLock();
        writeLock.lock();
        try {
            for (Playback playback : this.playbacks) {
                if (playback.player == null) continue;
                this.disposePlayer(playback.player);
                playback.player = null;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void disposePlayer(Player player) {
        if (this.playerControllerListener != null) {
            player.removeControllerListener(this.playerControllerListener);
        }
        player.stop();
        player.deallocate();
        player.close();
    }

    private static Format findFirstMatchingFormat(Format[] formats, Format format) {
        double formatSampleRate = format instanceof AudioFormat ? ((AudioFormat)format).getSampleRate() : -1.0;
        ParameterizedVideoFormat parameterizedVideoFormat = format instanceof ParameterizedVideoFormat ? (ParameterizedVideoFormat)format : null;
        for (Format match : formats) {
            double matchSampleRate;
            if (!match.isSameEncoding(format) || (match instanceof AudioFormat ? formatSampleRate != -1.0 && (matchSampleRate = ((AudioFormat)match).getSampleRate()) != -1.0 && matchSampleRate != formatSampleRate : (match instanceof ParameterizedVideoFormat ? !((ParameterizedVideoFormat)match).formatParametersMatch(format) : parameterizedVideoFormat != null && !parameterizedVideoFormat.formatParametersMatch(match)))) continue;
            return match;
        }
        return null;
    }

    public synchronized DataSource getCaptureDevice() {
        if (this.captureDevice == null) {
            this.captureDevice = this.createCaptureDevice();
        }
        return this.captureDevice;
    }

    protected DataSource getConnectedCaptureDevice() {
        DataSource captureDevice = this.getCaptureDevice();
        if (captureDevice != null && !this.captureDeviceIsConnected) {
            try {
                if (this.format != null) {
                    this.setCaptureDeviceFormat(captureDevice, this.format);
                }
            }
            catch (Throwable t) {
                logger.warn((Object)"Failed to setup an optimized media codec chain by setting the output Format on the input CaptureDevice", t);
            }
            IOException exception = null;
            try {
                this.getDevice().connect(captureDevice);
            }
            catch (IOException ioex) {
                exception = ioex;
            }
            if (exception == null) {
                this.captureDeviceIsConnected = true;
            } else {
                logger.error((Object)("Failed to connect to " + MediaStreamImpl.toString(captureDevice)), (Throwable)exception);
                captureDevice = null;
            }
        }
        return captureDevice;
    }

    public AbstractMediaDevice getDevice() {
        return this.device;
    }

    public Format getProcessorFormat() {
        Processor processor = this.getProcessor();
        if (processor != null && this.processor == processor && !this.processorIsPrematurelyClosed) {
            MediaType mediaType = this.getMediaType();
            for (TrackControl trackControl : processor.getTrackControls()) {
                MediaType type;
                if (!trackControl.isEnabled()) continue;
                Format jmfFormat = trackControl.getFormat();
                MediaType mediaType2 = type = jmfFormat instanceof VideoFormat ? MediaType.VIDEO : MediaType.AUDIO;
                if (!mediaType.equals((Object)type)) continue;
                return jmfFormat;
            }
        }
        return null;
    }

    public MediaFormatImpl<? extends Format> getFormat() {
        if (logger.isDebugEnabled() && this.processor != null) {
            boolean processorFormatMatchesFormat;
            Format format;
            Format processorFormat = this.getProcessorFormat();
            Format format2 = format = this.format == null ? null : this.format.getFormat();
            boolean bl = processorFormat == null ? format == null : (processorFormatMatchesFormat = processorFormat.matches(format));
            if (!processorFormatMatchesFormat) {
                logger.debug((Object)("processorFormat != format; processorFormat= `" + processorFormat + "`; format= `" + format + "`"));
            }
        }
        return this.format;
    }

    private MediaType getMediaType() {
        return this.getDevice().getMediaType();
    }

    public DataSource getOutputDataSource() {
        DataSource outputDataSource;
        Processor processor = this.getProcessor();
        if (processor == null || processor.getState() < 300 && !MediaDeviceSession.waitForState(processor, 300)) {
            outputDataSource = null;
        } else {
            outputDataSource = processor.getDataOutput();
            if (logger.isTraceEnabled() && outputDataSource != null) {
                logger.trace((Object)("Processor with hashCode " + processor.hashCode() + " provided " + MediaStreamImpl.toString(outputDataSource)));
            }
            this.startProcessorInAccordWithDirection(processor);
        }
        return outputDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Playback getPlayback(DataSource dataSource) {
        Lock readLock = this.playbacksLock.readLock();
        readLock.lock();
        try {
            for (Playback playback : this.playbacks) {
                if (playback.dataSource != dataSource) continue;
                Playback playback2 = playback;
                return playback2;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Playback getPlayback(ReceiveStream receiveStream) {
        Lock readLock = this.playbacksLock.readLock();
        readLock.lock();
        try {
            for (Playback playback : this.playbacks) {
                if (playback.receiveStream != receiveStream) continue;
                Playback playback2 = playback;
                return playback2;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Player getPlayer(long ssrc) {
        Lock readLock = this.playbacksLock.readLock();
        readLock.lock();
        try {
            for (Playback playback : this.playbacks) {
                long playbackSSRC = 0xFFFFFFFFL & playback.receiveStream.getSSRC();
                if (playbackSSRC != ssrc) continue;
                Player player = playback.player;
                return player;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Player> getPlayers() {
        ArrayList<Player> players;
        Lock readLock = this.playbacksLock.readLock();
        readLock.lock();
        try {
            players = new ArrayList<Player>(this.playbacks.size());
            for (Playback playback : this.playbacks) {
                if (playback.player == null) continue;
                players.add(playback.player);
            }
        }
        finally {
            readLock.unlock();
        }
        return players;
    }

    private Processor getProcessor() {
        if (this.processor == null) {
            this.processor = this.createProcessor();
        }
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReceiveStream> getReceiveStreams() {
        ArrayList<ReceiveStream> receiveStreams;
        Lock readLock = this.playbacksLock.readLock();
        readLock.lock();
        try {
            receiveStreams = new ArrayList<ReceiveStream>(this.playbacks.size());
            for (Playback playback : this.playbacks) {
                if (playback.receiveStream == null) continue;
                receiveStreams.add(playback.receiveStream);
            }
        }
        finally {
            readLock.unlock();
        }
        return receiveStreams;
    }

    public long[] getRemoteSSRCList() {
        return this.ssrcList;
    }

    public MediaDirection getStartedDirection() {
        return this.startedDirection;
    }

    public List<MediaFormat> getSupportedFormats() {
        Processor processor = this.getProcessor();
        HashSet<Format> supportedFormats = new HashSet<Format>();
        if (processor != null && this.processor == processor && !this.processorIsPrematurelyClosed) {
            MediaType mediaType = this.getMediaType();
            for (TrackControl trackControl : processor.getTrackControls()) {
                if (!trackControl.isEnabled()) continue;
                block5: for (Format supportedFormat : trackControl.getSupportedFormats()) {
                    switch (mediaType) {
                        case AUDIO: {
                            if (!(supportedFormat instanceof AudioFormat)) continue block5;
                            supportedFormats.add(supportedFormat);
                            continue block5;
                        }
                        case VIDEO: {
                            if (!(supportedFormat instanceof VideoFormat)) continue block5;
                            supportedFormats.add(supportedFormat);
                            continue block5;
                        }
                    }
                }
            }
        }
        ArrayList<MediaFormat> supportedMediaFormats = new ArrayList<MediaFormat>(supportedFormats.size());
        for (Format format : supportedFormats) {
            supportedMediaFormats.add(MediaFormatImpl.createInstance(format));
        }
        return supportedMediaFormats;
    }

    public boolean isMute() {
        DataSource captureDevice = this.captureDevice;
        if (captureDevice == null) {
            return this.mute;
        }
        MuteDataSource muteDataSource = AbstractControls.queryInterface((Controls)captureDevice, MuteDataSource.class);
        return muteDataSource == null ? false : muteDataSource.isMute();
    }

    protected void playbackDataSourceAdded(DataSource playbackDataSource) {
    }

    protected void playbackDataSourceRemoved(DataSource playbackDataSource) {
    }

    protected void playbackDataSourceUpdated(DataSource playbackDataSource) {
    }

    public void playbackDataSourceChanged(DataSource playbackDataSource) {
        this.playbackDataSourceUpdated(playbackDataSource);
    }

    protected void playerConfigureComplete(Processor player) {
        TrackControl[] tcs = player.getTrackControls();
        if (tcs != null && tcs.length != 0) {
            for (int i = 0; i < tcs.length; ++i) {
                TrackControl tc = tcs[i];
                Renderer renderer = this.createRenderer((Player)player, tc);
                if (renderer == null) continue;
                try {
                    tc.setRenderer(renderer);
                    continue;
                }
                catch (UnsupportedPlugInException upie) {
                    logger.warn((Object)("Failed to set " + renderer.getClass().getName() + " renderer on track " + i), (Throwable)upie);
                }
            }
        }
    }

    protected void playerControllerUpdate(ControllerEvent ev) {
        Processor player;
        if (ev instanceof ConfigureCompleteEvent) {
            Processor player2 = (Processor)ev.getSourceController();
            if (player2 != null) {
                this.playerConfigureComplete(player2);
                try {
                    player2.setContentDescriptor(null);
                }
                catch (NotConfiguredError nce) {
                    logger.error((Object)"Failed to set ContentDescriptor to Player.", (Throwable)nce);
                    return;
                }
                player2.realize();
            }
        } else if (ev instanceof RealizeCompleteEvent && (player = (Processor)ev.getSourceController()) != null) {
            this.playerRealizeComplete(player);
            player.start();
        }
    }

    protected void playerRealizeComplete(Processor player) {
    }

    protected void processorControllerUpdate(ControllerEvent ev) {
        block9: {
            block8: {
                if (!(ev instanceof ConfigureCompleteEvent)) break block8;
                Processor processor = (Processor)ev.getSourceController();
                if (processor == null) break block9;
                try {
                    processor.setContentDescriptor(this.createProcessorContentDescriptor(processor));
                }
                catch (NotConfiguredError nce) {
                    logger.error((Object)"Failed to set ContentDescriptor to Processor.", (Throwable)nce);
                }
                if (this.format == null) break block9;
                this.setProcessorFormat(processor, this.format);
                break block9;
            }
            if (ev instanceof ControllerClosedEvent) {
                Processor processor = (Processor)ev.getSourceController();
                logger.warn((Object)ev);
                if (processor != null && this.processor == processor) {
                    this.processorIsPrematurelyClosed = true;
                }
            } else if (ev instanceof RealizeCompleteEvent) {
                Processor processor = (Processor)ev.getSourceController();
                for (FormatParametersAwareCodec fpac : this.getAllTrackControls(FormatParametersAwareCodec.class, processor)) {
                    Map<String, String> formatParameters = this.format == null ? null : this.format.getFormatParameters();
                    if (formatParameters == null) continue;
                    fpac.setFormatParameters(formatParameters);
                }
                for (AdvancedAttributesAwareCodec aaac : this.getAllTrackControls(AdvancedAttributesAwareCodec.class, processor)) {
                    Map<String, String> advanceAttrs = this.format == null ? null : this.format.getAdvancedAttributes();
                    if (advanceAttrs == null) continue;
                    aaac.setAdvancedAttributes(advanceAttrs);
                }
            }
        }
    }

    protected void removeSSRC(long ssrc) {
        int index = -1;
        if (this.ssrcList == null || this.ssrcList.length == 0) {
            return;
        }
        for (int i = 0; i < this.ssrcList.length; ++i) {
            if (this.ssrcList[i] != ssrc) continue;
            index = i;
            break;
        }
        if (index < 0 || index >= this.ssrcList.length) {
            return;
        }
        if (this.ssrcList.length == 1) {
            this.setSsrcList(null);
            return;
        }
        long[] newSsrcList = new long[this.ssrcList.length - 1];
        System.arraycopy(this.ssrcList, 0, newSsrcList, 0, index);
        if (index < this.ssrcList.length - 1) {
            System.arraycopy(this.ssrcList, index + 1, newSsrcList, index, this.ssrcList.length - index - 1);
        }
        this.setSsrcList(newSsrcList);
    }

    protected void receiveStreamAdded(ReceiveStream receiveStream) {
    }

    protected void receiveStreamRemoved(ReceiveStream receiveStream) {
    }

    protected void setCaptureDeviceFormat(DataSource captureDevice, MediaFormatImpl<? extends Format> mediaFormat) {
        Format format = mediaFormat.getFormat();
        if (format instanceof AudioFormat) {
            Format[] supportedFormats;
            FormatControl formatControl;
            double sampleRate;
            AudioFormat audioFormat = (AudioFormat)format;
            int channels = audioFormat.getChannels();
            double d = sampleRate = OSUtils.IS_ANDROID ? audioFormat.getSampleRate() : -1.0;
            if ((channels != -1 || sampleRate != -1.0) && (formatControl = (FormatControl)captureDevice.getControl(FormatControl.class.getName())) != null && (supportedFormats = formatControl.getSupportedFormats()) != null && supportedFormats.length != 0) {
                String encoding;
                if (sampleRate != -1.0 && ("g722".equalsIgnoreCase(encoding = audioFormat.getEncoding()) || "g722/rtp".equalsIgnoreCase(encoding)) && sampleRate == 8000.0) {
                    sampleRate = 16000.0;
                }
                AudioFormat supportedAudioFormat = null;
                for (int i = 0; i < supportedFormats.length; ++i) {
                    Format sf = supportedFormats[i];
                    if (!(sf instanceof AudioFormat)) continue;
                    AudioFormat saf = (AudioFormat)sf;
                    if (-1 != channels && saf.getChannels() != channels || -1.0 != sampleRate && saf.getSampleRate() != sampleRate) continue;
                    supportedAudioFormat = saf;
                    break;
                }
                if (supportedAudioFormat != null) {
                    formatControl.setFormat(supportedAudioFormat);
                }
            }
        }
    }

    public void setContentDescriptor(ContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            throw new NullPointerException("contentDescriptor");
        }
        this.contentDescriptor = contentDescriptor;
    }

    public void setFormat(MediaFormat format) {
        MediaFormatImpl mediaFormatImpl;
        if (!this.getMediaType().equals((Object)format.getMediaType())) {
            throw new IllegalArgumentException("format");
        }
        this.format = mediaFormatImpl = (MediaFormatImpl)format;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Set format " + this.format + " on " + ((Object)((Object)this)).getClass().getSimpleName() + " " + ((Object)((Object)this)).hashCode()));
        }
        if (this.processor != null) {
            int processorState = this.processor.getState();
            if (processorState == 180) {
                this.setProcessorFormat(this.processor, this.format);
            } else if (this.processorIsPrematurelyClosed || processorState > 180 && !this.format.getFormat().equals((Object)this.getProcessorFormat()) || this.outputSizeChanged) {
                this.outputSizeChanged = false;
                this.setProcessor(null);
            }
        }
    }

    protected void setProcessorFormat(Processor processor, MediaFormatImpl<? extends Format> mediaFormat) {
        TrackControl[] trackControls = processor.getTrackControls();
        MediaType mediaType = this.getMediaType();
        Format format = mediaFormat.getFormat();
        for (int trackIndex = 0; trackIndex < trackControls.length; ++trackIndex) {
            TrackControl trackControl = trackControls[trackIndex];
            if (!trackControl.isEnabled()) continue;
            Format[] supportedFormats = trackControl.getSupportedFormats();
            if (supportedFormats == null || supportedFormats.length < 1) {
                trackControl.setEnabled(false);
                continue;
            }
            Format supportedFormat = null;
            switch (mediaType) {
                case AUDIO: {
                    if (!(supportedFormats[0] instanceof AudioFormat) || (supportedFormat = MediaDeviceSession.findFirstMatchingFormat(supportedFormats, format)) != null) break;
                    supportedFormat = format;
                    break;
                }
                case VIDEO: {
                    if (!(supportedFormats[0] instanceof VideoFormat)) break;
                    supportedFormat = MediaDeviceSession.findFirstMatchingFormat(supportedFormats, format);
                    if (supportedFormat == null) {
                        supportedFormat = format;
                    }
                    if (supportedFormat == null) break;
                    supportedFormat = MediaDeviceSession.assertSize((VideoFormat)supportedFormat);
                    break;
                }
            }
            if (supportedFormat == null) {
                trackControl.setEnabled(false);
                continue;
            }
            if (supportedFormat.equals((Object)trackControl.getFormat())) continue;
            Format setFormat = this.setProcessorFormat(trackControl, mediaFormat, supportedFormat);
            if (setFormat == null) {
                logger.error((Object)("Failed to set format of track " + trackIndex + " to " + supportedFormat + ". Processor is in state " + processor.getState()));
                continue;
            }
            if (setFormat != supportedFormat) {
                logger.warn((Object)("Failed to change format of track " + trackIndex + " from " + setFormat + " to " + supportedFormat + ". Processor is in state " + processor.getState()));
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Set format of track " + trackIndex + " to " + setFormat));
        }
    }

    protected Format setProcessorFormat(TrackControl trackControl, MediaFormatImpl<? extends Format> mediaFormat, Format format) {
        return trackControl.setFormat(format);
    }

    public void setMute(boolean mute) {
        if (this.mute != mute) {
            this.mute = mute;
            MuteDataSource muteDataSource = AbstractControls.queryInterface((Controls)this.captureDevice, MuteDataSource.class);
            if (muteDataSource != null) {
                muteDataSource.setMute(this.mute);
            }
        }
    }

    public void addDTMF(DTMFInbandTone tone) {
        InbandDTMFDataSource inbandDTMFDataSource = AbstractControls.queryInterface((Controls)this.captureDevice, InbandDTMFDataSource.class);
        if (inbandDTMFDataSource != null) {
            inbandDTMFDataSource.addDTMF(tone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlaybackDataSource(DataSource playbackDataSource) {
        Lock writeLock = this.playbacksLock.writeLock();
        Lock readLock = this.playbacksLock.readLock();
        boolean added = false;
        writeLock.lock();
        try {
            Playback playback = this.getPlayback(playbackDataSource);
            if (playback == null) {
                if (playbackDataSource instanceof ReceiveStreamPushBufferDataSource) {
                    ReceiveStream receiveStream = ((ReceiveStreamPushBufferDataSource)playbackDataSource).getReceiveStream();
                    playback = this.getPlayback(receiveStream);
                }
                if (playback == null) {
                    playback = new Playback(playbackDataSource);
                    this.playbacks.add(playback);
                } else {
                    playback.dataSource = playbackDataSource;
                }
                playback.player = this.createPlayer(playbackDataSource);
                readLock.lock();
                added = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (added) {
            try {
                this.playbackDataSourceAdded(playbackDataSource);
            }
            finally {
                readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlaybackDataSource(DataSource playbackDataSource) {
        Lock writeLock = this.playbacksLock.writeLock();
        Lock readLock = this.playbacksLock.readLock();
        boolean removed = false;
        writeLock.lock();
        try {
            Playback playback = this.getPlayback(playbackDataSource);
            if (playback != null) {
                if (playback.player != null) {
                    this.disposePlayer(playback.player);
                    playback.player = null;
                }
                playback.dataSource = null;
                if (playback.receiveStream == null) {
                    this.playbacks.remove(playback);
                }
                readLock.lock();
                removed = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (removed) {
            try {
                this.playbackDataSourceRemoved(playbackDataSource);
            }
            finally {
                readLock.unlock();
            }
        }
    }

    private void setProcessor(Processor processor) {
        if (this.processor != processor) {
            this.closeProcessor();
            this.processor = processor;
            this.firePropertyChange(OUTPUT_DATA_SOURCE, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiveStream(ReceiveStream receiveStream) {
        Lock writeLock = this.playbacksLock.writeLock();
        Lock readLock = this.playbacksLock.readLock();
        boolean added = false;
        writeLock.lock();
        try {
            if (this.getPlayback(receiveStream) == null) {
                this.playbacks.add(new Playback(receiveStream));
                this.addSSRC(0xFFFFFFFFL & receiveStream.getSSRC());
                Object receiveStreamDataSource = receiveStream.getDataSource();
                if (receiveStreamDataSource != null) {
                    if (receiveStreamDataSource instanceof PushBufferDataSource) {
                        receiveStreamDataSource = new ReceiveStreamPushBufferDataSource(receiveStream, (PushBufferDataSource)receiveStreamDataSource, true);
                    } else {
                        logger.warn((Object)("Adding ReceiveStream with DataSource not of type PushBufferDataSource but " + receiveStreamDataSource.getClass().getSimpleName() + " which may prevent the ReceiveStream from properly transferring to another MediaDevice if such a need arises."));
                    }
                    this.addPlaybackDataSource((DataSource)receiveStreamDataSource);
                }
                readLock.lock();
                added = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (added) {
            try {
                this.receiveStreamAdded(receiveStream);
            }
            finally {
                readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiveStream(ReceiveStream receiveStream) {
        Lock writeLock = this.playbacksLock.writeLock();
        Lock readLock = this.playbacksLock.readLock();
        boolean removed = false;
        writeLock.lock();
        try {
            Playback playback = this.getPlayback(receiveStream);
            if (playback != null) {
                this.removeSSRC(0xFFFFFFFFL & receiveStream.getSSRC());
                if (playback.dataSource != null) {
                    this.removePlaybackDataSource(playback.dataSource);
                }
                if (playback.dataSource != null) {
                    logger.warn((Object)"Removing ReceiveStream with an associated DataSource.");
                }
                this.playbacks.remove(playback);
                readLock.lock();
                removed = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (removed) {
            try {
                this.receiveStreamRemoved(receiveStream);
            }
            finally {
                readLock.unlock();
            }
        }
    }

    private void setSsrcList(long[] newSsrcList) {
        long[] oldSsrcList = this.getRemoteSSRCList();
        this.ssrcList = newSsrcList;
        this.firePropertyChange(SSRC_LIST, oldSsrcList, this.getRemoteSSRCList());
    }

    public void start(MediaDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        MediaDirection oldValue = this.startedDirection;
        this.startedDirection = this.startedDirection.or(direction);
        if (!oldValue.equals((Object)this.startedDirection)) {
            this.startedDirectionChanged(oldValue, this.startedDirection);
        }
    }

    protected void startedDirectionChanged(MediaDirection oldValue, MediaDirection newValue) {
        if (newValue.allowsSending()) {
            Processor processor = this.getProcessor();
            if (processor != null) {
                this.startProcessorInAccordWithDirection(processor);
            }
        } else if (this.processor != null && this.processor.getState() > 180) {
            this.processor.stop();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Stopped Processor with hashCode " + this.processor.hashCode()));
            }
        }
    }

    protected void startProcessorInAccordWithDirection(Processor processor) {
        if (this.startedDirection.allowsSending() && processor.getState() != 600) {
            processor.start();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Started Processor with hashCode " + processor.hashCode()));
            }
        }
    }

    public void stop(MediaDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        MediaDirection oldValue = this.startedDirection;
        switch (this.startedDirection) {
            case SENDRECV: {
                if (direction.allowsReceiving()) {
                    this.startedDirection = direction.allowsSending() ? MediaDirection.INACTIVE : MediaDirection.SENDONLY;
                    break;
                }
                if (!direction.allowsSending()) break;
                this.startedDirection = MediaDirection.RECVONLY;
                break;
            }
            case SENDONLY: {
                if (!direction.allowsSending()) break;
                this.startedDirection = MediaDirection.INACTIVE;
                break;
            }
            case RECVONLY: {
                if (!direction.allowsReceiving()) break;
                this.startedDirection = MediaDirection.INACTIVE;
                break;
            }
            case INACTIVE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("direction");
            }
        }
        if (!oldValue.equals((Object)this.startedDirection)) {
            this.startedDirectionChanged(oldValue, this.startedDirection);
        }
    }

    private static boolean waitForState(Processor processor, int state) {
        return new ProcessorUtility().waitForState(processor, state);
    }

    public void copyPlayback(MediaDeviceSession deviceSession) {
        if (deviceSession.disposePlayerOnClose) {
            logger.error((Object)"Cannot copy playback if MediaDeviceSession has closed it");
        } else {
            this.playbacks.addAll(deviceSession.playbacks);
            this.setSsrcList(deviceSession.ssrcList);
        }
    }

    public TranscodingDataSource getTranscodingDataSource(ReceiveStream receiveStream) {
        TranscodingDataSource transcodingDataSource = null;
        if (this.device instanceof AudioMixerMediaDevice) {
            transcodingDataSource = ((AudioMixerMediaDevice)this.device).getTranscodingDataSource(receiveStream.getDataSource());
        }
        return transcodingDataSource;
    }

    public <T> Set<T> getEncoderControls(Class<T> controlType) {
        return this.getAllTrackControls(controlType, this.processor);
    }

    public <T> Set<T> getDecoderControls(ReceiveStream receiveStream, Class<T> controlType) {
        TranscodingDataSource transcodingDataSource = this.getTranscodingDataSource(receiveStream);
        if (transcodingDataSource == null) {
            return Collections.emptySet();
        }
        return this.getAllTrackControls(controlType, transcodingDataSource.getTranscodingProcessor());
    }

    private <T> Set<T> getAllTrackControls(Class<T> controlType, Processor processor) {
        TrackControl[] trackControls;
        Set controls = null;
        if (processor != null && processor.getState() >= 300 && (trackControls = processor.getTrackControls()) != null && trackControls.length != 0) {
            String className = controlType.getName();
            for (TrackControl trackControl : trackControls) {
                Object o = trackControl.getControl(className);
                if (!controlType.isInstance(o)) continue;
                Object t = o;
                if (controls == null) {
                    controls = new HashSet();
                }
                controls.add(t);
            }
        }
        if (controls == null) {
            controls = Collections.emptySet();
        }
        return controls;
    }

    public void setUseTranslator(boolean useTranslator) {
        this.useTranslator = useTranslator;
    }

    private static class Playback {
        public DataSource dataSource;
        public ReceiveStream receiveStream;
        public Player player;

        public Playback(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Playback(ReceiveStream receiveStream) {
            this.receiveStream = receiveStream;
        }
    }
}

