/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import com.github.marschall.memoryfilesystem.MemoryUserPrincipalLookupService;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.Set;

final class EntryCreationContext {
    final Set<Class<? extends FileAttributeView>> additionalViews;
    final Set<PosixFilePermission> permissions;
    final UserPrincipal user;
    final GroupPrincipal group;
    final MemoryFileSystem fileSystem;
    final Path path;

    EntryCreationContext(Set<Class<? extends FileAttributeView>> additionalViews, Set<PosixFilePermission> permissions, UserPrincipal user, GroupPrincipal group, MemoryFileSystem fileSystem, Path path) {
        this.additionalViews = additionalViews;
        this.permissions = permissions;
        this.user = user;
        this.group = group;
        this.fileSystem = fileSystem;
        this.path = path;
    }

    Class<? extends FileAttributeView> firstView() {
        return this.additionalViews.iterator().next();
    }

    static EntryCreationContext empty() {
        Set<Class<? extends FileAttributeView>> noViews = Collections.emptySet();
        Set<PosixFilePermission> noPermissions = Collections.emptySet();
        return new EntryCreationContext(noViews, noPermissions, new MemoryUserPrincipalLookupService.MemoryUser("dummy"), new MemoryUserPrincipalLookupService.MemoryGroup("dummy"), null, null);
    }
}

