/* $Id$ */
/* Copyright (c) 2011-2018 Pierre Pronchery <khorben@defora.org> */
/* This file is part of DeforaOS Desktop Locker */
/* Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY ITS AUTHORS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */



#ifndef DESKTOP_LOCKER_LOCKER_H
# define DESKTOP_LOCKER_LOCKER_H


/* Locker */
/* public */
/* types */
typedef struct _Locker Locker;

typedef enum _LockerAction
{
	LOCKER_ACTION_ACTIVATE = 0,
	LOCKER_ACTION_CYCLE,
	LOCKER_ACTION_DEACTIVATE,
	LOCKER_ACTION_DISABLE,
	LOCKER_ACTION_ENABLE,
	LOCKER_ACTION_LOCK,
	LOCKER_ACTION_RELOAD,
	LOCKER_ACTION_SHOW_PREFERENCES,
	LOCKER_ACTION_START,
	LOCKER_ACTION_STOP,
	LOCKER_ACTION_SUSPEND,
	LOCKER_ACTION_UNLOCK
} LockerAction;

typedef enum _LockerEvent
{
	LOCKER_EVENT_ACTIVATING = 0,
	LOCKER_EVENT_ACTIVATED,
	LOCKER_EVENT_CYCLING = 0,
	LOCKER_EVENT_CYCLED,
	LOCKER_EVENT_DEACTIVATING,
	LOCKER_EVENT_DEACTIVATED,
	LOCKER_EVENT_LOCKING,
	LOCKER_EVENT_LOCKED,
	LOCKER_EVENT_SUSPENDING,
	LOCKER_EVENT_UNLOCKING,
	LOCKER_EVENT_UNLOCKED
} LockerEvent;


/* constants */
# define LOCKER_CLIENT_MESSAGE	"DEFORAOS_DESKTOP_LOCKER_CLIENT"
# define LOCKER_MESSAGE_ACTION	0

#endif /* !DESKTOP_LOCKER_LOCKER_H */
