/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class CastCompletionProposal
extends LinkedCorrectionProposal {
    private Expression fNodeToCast;
    private final String fCastType;

    public CastCompletionProposal(String label, ICompilationUnit targetCU, Expression nodeToCast, String castType, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_cast.gif"));
        this.fNodeToCast = nodeToCast;
        this.fCastType = castType;
    }

    private Type getNewCastTypeNode(ASTRewrite rewrite) throws CoreException {
        ITypeBinding[] bindings;
        MethodInvocation invocation;
        AST ast = rewrite.getAST();
        if (this.fCastType != null) {
            String string = this.getImportRewrite().addImport(this.fCastType);
            return ASTNodeFactory.newType(ast, string);
        }
        Expression node = this.fNodeToCast;
        ASTNode parent = node.getParent();
        if (parent instanceof CastExpression) {
            node = parent;
            parent = parent.getParent();
        }
        while (parent instanceof ParenthesizedExpression) {
            node = parent;
            parent = parent.getParent();
        }
        if (parent instanceof MethodInvocation && (invocation = (MethodInvocation)node.getParent()).getExpression() == node && (bindings = ASTResolving.getQualifierGuess(node.getRoot(), invocation.getName().getIdentifier(), invocation.arguments())).length > 0) {
            ITypeBinding first = this.getCastFavorite(bindings, this.fNodeToCast.resolveTypeBinding());
            String typeName = this.getImportRewrite().addImport(first);
            Type newTypeNode = ASTNodeFactory.newType(ast, typeName);
            this.addLinkedPosition(rewrite.track((ASTNode)newTypeNode), true, "casttype");
            for (int i = 0; i < bindings.length; ++i) {
                this.addLinkedPositionProposal("casttype", bindings[i]);
            }
            return newTypeNode;
        }
        SimpleType newCastType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
        this.addLinkedPosition(rewrite.track((ASTNode)newCastType), true, "casttype");
        return newCastType;
    }

    private ITypeBinding getCastFavorite(ITypeBinding[] suggestedCasts, ITypeBinding nodeToCastBinding) {
        if (nodeToCastBinding == null) {
            return suggestedCasts[0];
        }
        ITypeBinding favourite = suggestedCasts[0];
        for (int i = 0; i < suggestedCasts.length; ++i) {
            ITypeBinding curr = suggestedCasts[i];
            if (TypeRules.canCast(nodeToCastBinding, curr)) {
                return curr;
            }
            if (!curr.isInterface()) continue;
            favourite = curr;
        }
        return favourite;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fNodeToCast.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Type newTypeNode = this.getNewCastTypeNode(rewrite);
        if (this.fNodeToCast.getNodeType() == 11) {
            CastExpression expression = (CastExpression)this.fNodeToCast;
            rewrite.replace((ASTNode)expression.getType(), (ASTNode)newTypeNode, null);
        } else {
            Expression expressionCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.fNodeToCast);
            if (CastCompletionProposal.needsInnerParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression(expressionCopy);
                expressionCopy = parenthesizedExpression;
            }
            CastExpression castExpression = ast.newCastExpression();
            castExpression.setExpression(expressionCopy);
            castExpression.setType(newTypeNode);
            CastExpression replacingNode = castExpression;
            if (CastCompletionProposal.needsOuterParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)castExpression);
                replacingNode = parenthesizedExpression;
            }
            rewrite.replace((ASTNode)this.fNodeToCast, (ASTNode)replacingNode, null);
        }
        return rewrite;
    }

    private static boolean needsInnerParantheses(ASTNode nodeToCast) {
        int nodeType = nodeToCast.getNodeType();
        return nodeType == 27 || nodeType == 16 || nodeType == 7 || nodeType == 62;
    }

    private static boolean needsOuterParantheses(ASTNode nodeToCast) {
        ASTNode parent = nodeToCast.getParent();
        return parent instanceof MethodInvocation ? ((MethodInvocation)parent).getExpression() == nodeToCast : (parent instanceof QualifiedName ? ((QualifiedName)parent).getQualifier() == nodeToCast : parent instanceof FieldAccess && ((FieldAccess)parent).getExpression() == nodeToCast);
    }
}

