/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ResourceProcessors {
    public static String[] computeAffectedNatures(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        HashSet result = new HashSet();
        HashSet visitedProjects = new HashSet();
        ResourceProcessors.computeNatures(result, visitedProjects, project);
        return result.toArray(new String[result.size()]);
    }

    public static String[] computeAffectedNatures(IResource[] resources) throws CoreException {
        HashSet result = new HashSet();
        HashSet visitedProjects = new HashSet();
        for (int i = 0; i < resources.length; ++i) {
            ResourceProcessors.computeNatures(result, visitedProjects, resources[i].getProject());
        }
        return result.toArray(new String[result.size()]);
    }

    private static void computeNatures(Set result, Set visitedProjects, IProject focus) throws CoreException {
        if (visitedProjects.contains(focus)) {
            return;
        }
        String[] pns = focus.getDescription().getNatureIds();
        for (int p = 0; p < pns.length; ++p) {
            result.add(pns[p]);
        }
        visitedProjects.add(focus);
        IProject[] referencing = focus.getReferencingProjects();
        for (int i = 0; i < referencing.length; ++i) {
            ResourceProcessors.computeNatures(result, visitedProjects, referencing[i]);
        }
    }
}

