/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.UpdateMergableOnly;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateOnlyMergableOperation
extends SingleCommandOperation {
    List skippedFiles = new ArrayList();

    public UpdateOnlyMergableOperation(IWorkbenchPart part, IResource[] resources, Command.LocalOption[] localOptions) {
        super(part, resources, localOptions);
    }

    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        UpdateMergableOnly update = new UpdateMergableOnly();
        IStatus status = update.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(), resources, null, monitor);
        if (status.getCode() != 4) {
            this.addSkippedFiles(update.getSkippedFiles());
            return OK;
        }
        return status;
    }

    protected String getTaskName() {
        return Policy.bind("UpdateOnlyMergeable.taskName");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("UpdateOperation.0", provider.getProject().getName());
    }

    protected void addSkippedFiles(IFile[] files) {
        this.skippedFiles.addAll(Arrays.asList(files));
    }

    public IFile[] getSkippedFiles() {
        return this.skippedFiles.toArray(new IFile[this.skippedFiles.size()]);
    }
}

