/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;

public class SystemMenuFastViewOrientation
extends ContributionItem {
    private ViewPane viewPane;
    private IntModel currentOrientation = new IntModel(512);

    public SystemMenuFastViewOrientation(ViewPane newViewPane) {
        this.viewPane = newViewPane;
        this.currentOrientation.addChangeListener(new IChangeListener(){

            public void update(boolean changed) {
                WorkbenchWindow workbenchWindow;
                FastViewBar bar;
                if (changed && (bar = (workbenchWindow = (WorkbenchWindow)SystemMenuFastViewOrientation.this.viewPane.getPage().getWorkbenchWindow()).getFastViewBar()) != null && SystemMenuFastViewOrientation.this.viewPane != null) {
                    bar.setOrientation(SystemMenuFastViewOrientation.this.viewPane.getViewReference(), SystemMenuFastViewOrientation.this.currentOrientation.get());
                }
            }
        });
    }

    public void dispose() {
        this.viewPane = null;
    }

    public void fill(Menu menu, int index) {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.viewPane.getPage().getWorkbenchWindow();
        FastViewBar bar = workbenchWindow.getFastViewBar();
        if (bar != null && this.viewPane != null) {
            this.currentOrientation.set(bar.getOrientation(this.viewPane.getViewReference()));
            MenuItem orientationItem = new MenuItem(menu, 64, index);
            orientationItem.setText(WorkbenchMessages.getString("FastViewBar.view_orientation"));
            Menu orientationSwtMenu = new Menu(orientationItem);
            RadioMenu orientationMenu = new RadioMenu(orientationSwtMenu, this.currentOrientation);
            orientationMenu.addMenuItem(WorkbenchMessages.getString("FastViewBar.horizontal"), new Integer(256));
            orientationMenu.addMenuItem(WorkbenchMessages.getString("FastViewBar.vertical"), new Integer(512));
            orientationItem.setMenu(orientationSwtMenu);
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

