/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class CookieUtil {
    private static final int COOKIE_LIFE = 157680000;
    private static final int MAX_COOKIE_PAYLOAD = 4096 - "wset01=".length() - "81920<".length() - 1;

    public static String getCookieValue(String name, HttpServletRequest request) {
        String ret = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equals(cookies[i].getName())) continue;
                ret = cookies[i].getValue();
                break;
            }
        }
        if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
            System.out.println("CookieUtil.getCookieValue(" + name + ", " + request.getRequestURI() + ") returning " + ret);
        }
        return ret;
    }

    public static void setCookieValue(String name, String value, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(157680000);
        response.addCookie(cookie);
        if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
            System.out.println("CookieUtil.setCookieValue(" + name + ", " + value + ",...)");
        }
    }

    public static void deleteCookie(String name, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static void saveString(String name, String data, int maxCookies, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int i;
        int len = data.length();
        int n = len / MAX_COOKIE_PAYLOAD;
        if (n > maxCookies) {
            throw new IOException(WebappResources.getString((String)"CookieUtil.tooManyCookiesNeeded", (Locale)UrlUtil.getLocaleObj(request, response)));
        }
        for (i = 1; i <= n; ++i) {
            if (i == 1) {
                CookieUtil.setCookieValue(name + "1", len + "<" + data.substring(0, MAX_COOKIE_PAYLOAD), response);
                continue;
            }
            CookieUtil.setCookieValue(name + i, data.substring(MAX_COOKIE_PAYLOAD * (i - 1), MAX_COOKIE_PAYLOAD * i), response);
        }
        if (len % MAX_COOKIE_PAYLOAD > 0) {
            if (n == 0) {
                CookieUtil.setCookieValue(name + "1", len + "<" + data.substring(0, len), response);
            } else {
                CookieUtil.setCookieValue(name + (n + 1), data.substring(MAX_COOKIE_PAYLOAD * n, len), response);
            }
        }
        for (i = n + 1; i <= maxCookies; ++i) {
            if (i == n + 1 && len % MAX_COOKIE_PAYLOAD > 0) continue;
            if (CookieUtil.getCookieValue(name + i, request) == null) break;
            CookieUtil.deleteCookie(name + i, response);
        }
    }

    public static String restoreString(String name, HttpServletRequest request) {
        String value1 = CookieUtil.getCookieValue(name + "1", request);
        if (value1 == null) {
            return null;
        }
        String[] lengthAndSubstring1 = value1.split("<");
        if (lengthAndSubstring1.length < 2) {
            return null;
        }
        int len = 0;
        try {
            len = Integer.parseInt(lengthAndSubstring1[0]);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        StringBuffer data = new StringBuffer(len);
        data.append(lengthAndSubstring1[1]);
        int n = len / MAX_COOKIE_PAYLOAD;
        for (int i = 2; i <= n; ++i) {
            String substring = CookieUtil.getCookieValue(name + i, request);
            if (substring == null) {
                return null;
            }
            data.append(substring);
        }
        if (len % MAX_COOKIE_PAYLOAD > 0 && n > 0) {
            String substring = CookieUtil.getCookieValue(name + (n + 1), request);
            if (substring == null) {
                return null;
            }
            data.append(substring);
        }
        if (data.length() != len) {
            return null;
        }
        return data.toString();
    }
}

