/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.JavacTask;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ClasspathComputer2_1;
import org.eclipse.pde.internal.build.builder.ClasspathComputer3_0;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.IClasspathComputer;
import org.eclipse.update.core.IPluginEntry;

public class ModelBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    public static final String EXPANDED_DOT = "@dot";
    public static final String DOT = ".";
    protected BundleDescription model;
    protected String fullName;
    protected String pluginZipDestination;
    protected String pluginUpdateJarDestination;
    private FeatureBuildScriptGenerator featureGenerator;
    protected final String PLUGIN_DESTINATION = this.getPropertyFormat("plugin.destination");
    private Properties permissionProperties;
    private String propertiesFileName = "build.properties";
    private String buildScriptFileName = "build.xml";
    private ArrayList compiledJarNames;
    private boolean dotOnTheClasspath = false;
    private boolean binaryPlugin = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CoreException {
        String custom;
        if (this.model == null) {
            String message = Policy.bind("error.missingElement");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        if (this.featureGenerator != null && !this.featureGenerator.isSourceFeatureGeneration() && this.featureGenerator.getBuildProperties().containsKey("generate.plugin@" + this.model.getSymbolicName())) {
            return;
        }
        if (!AbstractScriptGenerator.isBuildingOSGi()) {
            this.checkBootAndRuntime();
        }
        this.initializeVariables();
        if (BundleHelper.getDefault().isDebugging()) {
            System.out.println("Generating plugin " + this.model.getSymbolicName());
        }
        if ((custom = (String)this.getBuildProperties().get("custom")) != null && custom.equalsIgnoreCase("true")) {
            this.updateExistingScript();
            return;
        }
        this.openScript(this.getLocation(this.model), this.buildScriptFileName);
        try {
            this.generateBuildScript();
        }
        finally {
            this.closeScript();
        }
    }

    private void checkBootAndRuntime() throws CoreException {
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.boot") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", "org.eclipse.core.boot"), null);
            throw new CoreException((IStatus)status);
        }
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.runtime") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", "org.eclipse.core.runtime"), null);
            throw new CoreException((IStatus)status);
        }
    }

    private void initializeVariables() throws CoreException {
        this.fullName = this.model.getSymbolicName() + "_" + this.model.getVersion();
        this.pluginZipDestination = this.PLUGIN_DESTINATION + '/' + this.fullName + ".zip";
        this.pluginUpdateJarDestination = this.PLUGIN_DESTINATION + '/' + this.fullName + ".jar";
        String[] classpathInfo = this.getClasspathEntries(this.model);
        if (!this.binaryPlugin) {
            this.specialDotProcessing(classpathInfo);
        }
    }

    protected static boolean findAndReplaceDot(String[] classpathInfo) {
        for (int i = 0; i < classpathInfo.length; ++i) {
            if (!DOT.equals(classpathInfo[i])) continue;
            classpathInfo[i] = EXPANDED_DOT;
            return true;
        }
        return false;
    }

    private void specialDotProcessing(String[] classpathInfo) throws CoreException {
        if (ModelBuildScriptGenerator.findAndReplaceDot(classpathInfo)) {
            String includeString;
            String extraEntries;
            String buildOrder;
            String outputValue;
            String sourceFolder = this.getBuildProperties().getProperty("source..");
            if (sourceFolder != null) {
                this.getBuildProperties().setProperty("source.@dot", sourceFolder);
                this.getBuildProperties().remove("source..");
            }
            if ((outputValue = this.getBuildProperties().getProperty("output..")) != null) {
                this.getBuildProperties().setProperty("output.@dot", outputValue);
                this.getBuildProperties().remove("output..");
            }
            if ((buildOrder = this.getBuildProperties().getProperty("jars.compile.order")) != null) {
                String[] order = Utils.getArrayFromString(buildOrder);
                for (int i = 0; i < order.length; ++i) {
                    if (!order[i].equals(DOT)) continue;
                    order[i] = EXPANDED_DOT;
                }
                this.getBuildProperties().setProperty("jars.compile.order", Utils.getStringFromArray(order, ","));
            }
            if ((extraEntries = this.getBuildProperties().getProperty("extra..")) != null) {
                this.getBuildProperties().setProperty("extra.@dot", extraEntries);
            }
            if ((includeString = this.getBuildProperties().getProperty("bin.includes")) != null) {
                String[] includes = Utils.getArrayFromString(includeString);
                for (int i = 0; i < includes.length; ++i) {
                    if (!includes[i].equals(DOT)) continue;
                    includes[i] = null;
                }
                this.getBuildProperties().setProperty("bin.includes", Utils.getStringFromArray(includes, ","));
            }
            this.dotOnTheClasspath = true;
        }
    }

    private void generateBuildScript() throws CoreException {
        this.generatePrologue();
        this.generateBuildUpdateJarTarget();
        if (this.getBuildProperties().getProperty("sourcePlugin", null) == null) {
            this.generateBuildJarsTarget(this.model);
        } else {
            this.generateBuildJarsTargetForSourceGathering();
            this.generateEmptyBuildSourcesTarget();
        }
        this.generateGatherBinPartsTarget();
        this.generateBuildZipsTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateZipPluginTarget();
        this.generateEpilogue();
    }

    private void generateEmptyBuildSourcesTarget() {
        this.script.printTargetDeclaration("build.sources", null, null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTargetForSourceGathering() throws CoreException {
        this.script.printTargetDeclaration("build.jars", null, null, null, null);
        this.compiledJarNames = new ArrayList(0);
        IPluginEntry entry = Utils.getPluginEntry(this.featureGenerator.feature, this.model.getSymbolicName(), false)[0];
        Config configInfo = entry.getOS() == null && entry.getWS() == null && entry.getOSArch() == null ? Config.genericConfig() : new Config(entry.getOS(), entry.getWS(), entry.getOSArch());
        Set pluginsToGatherSourceFrom = (Set)this.featureGenerator.sourceToGather.getElementEntries().get(configInfo);
        if (pluginsToGatherSourceFrom != null) {
            Iterator iter = pluginsToGatherSourceFrom.iterator();
            while (iter.hasNext()) {
                BundleDescription plugin = (BundleDescription)iter.next();
                if (plugin.getSymbolicName().equals(this.model.getSymbolicName())) continue;
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(plugin)), (IPath)new Path(this.getLocation(this.model)));
                this.script.printAntTask(location.append(this.buildScriptFileName).toString(), location.toOSString(), "build.sources", null, null, null);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("destination.temp.folder", this.getPropertyFormat("basedir") + "/src");
                this.script.printAntTask(location.append(this.buildScriptFileName).toString(), location.toOSString(), "gather.sources", null, null, params);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        this.script.printTargetDeclaration("clean", "init", null, null, Policy.bind("build.plugin.clean", this.model.getSymbolicName()));
        if (!this.binaryPlugin) {
            for (int i = 0; i < availableJars.length; ++i) {
                String jarName = availableJars[i].getName(true);
                if (availableJars[i].type == 0) {
                    this.script.printDeleteTask(null, this.getJARLocation(jarName), null);
                } else {
                    this.script.printDeleteTask(this.getJARLocation(jarName), null, null);
                }
                this.script.printDeleteTask(null, this.getSRCLocation(jarName), null);
            }
            this.script.printDeleteTask(null, this.pluginUpdateJarDestination, null);
            this.script.printDeleteTask(null, this.pluginZipDestination, null);
            this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherLogTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(this.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        for (int i = 0; i < availableJars.length; ++i) {
            String name = availableJars[i].getName(true);
            IPath destination = baseDestination.append(name).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            this.script.printCopyTask(this.getTempJARFolderLocation(name) + ".log", destination.toString(), null, false);
        }
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        Path root = new Path(this.getPropertyFormat("basedir"));
        this.script.printZipTask(root.append(zipName).toString(), root.append(source).toString(), false, false, null);
        this.script.printTargetEnd();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.sources", "init", "destination.temp.folder", null, null);
        if (!this.binaryPlugin) {
            Path baseDestination = new Path(this.getPropertyFormat("destination.temp.folder"));
            baseDestination = baseDestination.append(this.fullName);
            ArrayList<IPath> destinations = new ArrayList<IPath>(5);
            Properties properties = this.getBuildProperties();
            CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
            for (int i = 0; i < availableJars.length; ++i) {
                String jar = availableJars[i].getName(true);
                IPath destination = baseDestination.append(jar).removeLastSegments(1);
                if (!destinations.contains(destination)) {
                    this.script.printMkdirTask(destination.toString());
                    destinations.add(destination);
                }
                this.script.printCopyTask(this.getSRCLocation(jar), destination.toString(), null, false);
            }
            String include = (String)this.getBuildProperties().get("src.includes");
            String exclude = (String)this.getBuildProperties().get("src.excludes");
            if (include != null || exclude != null) {
                FileSet fileSet = new FileSet(this.getPropertyFormat("basedir"), null, include, null, exclude, null, null);
                this.script.printCopyTask(null, baseDestination.toString(), new FileSet[]{fileSet}, false);
            }
        }
        this.script.printTargetEnd();
    }

    private boolean containsStarDotJar(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].endsWith("*.jar")) continue;
            return true;
        }
        return false;
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "destination.temp.folder", null, null);
        Path destination = new Path(this.getPropertyFormat("destination.temp.folder"));
        destination = destination.append(this.fullName);
        String root = destination.toString();
        this.script.printMkdirTask(root);
        ArrayList<Path> destinations = new ArrayList<Path>(5);
        destinations.add(destination);
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        if (!this.binaryPlugin) {
            FileSet fileSet;
            String[] splitIncludes = Utils.getArrayFromString(include);
            boolean allJars = this.containsStarDotJar(splitIncludes);
            String[] fileSetValues = new String[this.compiledJarNames.size()];
            int count = 0;
            Iterator iter = this.compiledJarNames.iterator();
            while (iter.hasNext()) {
                CompiledEntry entry = (CompiledEntry)iter.next();
                String formatedName = entry.getName(false) + (entry.getType() == 1 ? "/" : "");
                if (!allJars && !Utils.isStringIn(splitIncludes, formatedName)) continue;
                fileSetValues[count++] = formatedName;
            }
            if (count != 0) {
                fileSet = new FileSet(this.getPropertyFormat("build.result.folder"), null, Utils.getStringFromArray(fileSetValues, ","), null, this.replaceVariables(exclude, true), null, null);
                this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true);
            }
            if (this.dotOnTheClasspath) {
                fileSet = new FileSet(this.getPropertyFormat("build.result.folder") + '/' + EXPANDED_DOT, null, "**", null, null, null, null);
                this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true);
            }
        }
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(this.getPropertyFormat("basedir"), null, this.replaceVariables(include, true), null, this.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true);
        }
        this.generatePermissionProperties(root);
        this.genarateIdReplacementCall(destination.toString());
        this.script.printTargetEnd();
    }

    private void genarateIdReplacementCall(String location) throws CoreException {
        String qualifier = this.getBuildProperties().getProperty("qualifier");
        if (qualifier == null) {
            return;
        }
        this.script.print("<eclipse.versionReplacer path=\"" + location + "\" version=\"" + this.model.getVersion() + "\"/>");
    }

    private void generatePermissionProperties(String directory) throws CoreException {
        this.getPermissionProperties();
        Iterator<Map.Entry<Object, Object>> iter = this.permissionProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> permission = iter.next();
            String instruction = (String)permission.getKey();
            String parameters = (String)permission.getValue();
            int index = instruction.indexOf("permissions");
            if (index != -1) {
                this.generateChmodInstruction(directory, instruction.substring(index + "permissions".length() + 1), parameters);
                continue;
            }
            if (!instruction.startsWith("link")) continue;
            this.generateLinkInstruction(directory, parameters);
        }
    }

    private void generateChmodInstruction(String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        this.script.printChmod(dir, rights, files);
    }

    private void generateLinkInstruction(String dir, String files) {
        String[] links = Utils.getArrayFromString(files, ",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        for (int i = 0; i < links.length; i += 2) {
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            this.script.printExecTask("ln -s", dir, arguments, "Linux");
            arguments.clear();
        }
    }

    protected Properties getPermissionProperties() throws CoreException {
        if (this.permissionProperties == null) {
            this.permissionProperties = ModelBuildScriptGenerator.readProperties(this.getLocation(this.model), "permissions.properties", 1);
        }
        return this.permissionProperties;
    }

    private void generateZipPluginTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("zip.plugin", "init", null, null, Policy.bind("build.plugin.zipPlugin", this.model.getSymbolicName()));
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(this.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        this.script.printAntCallTask("build.sources", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", this.getPropertyFormat("temp.folder") + '/');
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printAntCallTask("gather.sources", null, params);
        FileSet fileSet = new FileSet(this.getPropertyFormat("temp.folder"), null, "**/*.bin.log", null, null, null, null);
        this.script.printDeleteTask(null, null, new FileSet[]{fileSet});
        this.script.printZipTask(this.pluginZipDestination, this.getPropertyFormat("temp.folder"), true, false, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, Policy.bind("build.plugin.buildUpdateJar", this.model.getSymbolicName()));
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(this.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", this.getPropertyFormat("temp.folder") + '/');
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printZipTask(this.pluginUpdateJarDestination, this.getPropertyFormat("temp.folder") + '/' + this.fullName, false, false, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Policy.bind("build.plugin.refresh"));
        this.script.printConvertPathTask(new Path(this.getLocation(this.model)).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(this.getPropertyFormat("resourcePath"), "infinite");
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.model.getSymbolicName(), "build.jars", DOT);
        this.script.println();
        this.script.printProperty("bootclasspath", "");
        this.script.printProperty("basews", this.getPropertyFormat("ws"));
        this.script.printProperty("baseos", this.getPropertyFormat("os"));
        this.script.printProperty("basearch", this.getPropertyFormat("arch"));
        this.script.printProperty("basenl", this.getPropertyFormat("nl"));
        this.script.printProperty("javacFailOnError", "false");
        this.script.printProperty("javacDebugInfo", "on");
        this.script.printProperty("javacVerbose", "true");
        this.script.printProperty("javacSource", "1.3");
        this.script.printProperty("javacTarget", "1.2");
        this.script.printProperty("compilerArg", "");
        this.script.println();
        this.script.printTargetDeclaration("init", "properties", null, null, null);
        this.script.println("<condition property=\"pluginTemp\" value=\"" + this.getPropertyFormat("buildTempFolder") + '/' + "plugins" + "\">");
        this.script.println("\t<isset property=\"buildTempFolder\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginTemp", this.getPropertyFormat("basedir"));
        this.script.println("<condition property=\"build.result.folder\" value=\"" + this.getPropertyFormat("pluginTemp") + '/' + new Path(this.model.getLocation()).lastSegment() + "\">");
        this.script.println("\t<isset property=\"buildTempFolder\"/>");
        this.script.println("</condition>");
        this.script.printProperty("build.result.folder", this.getPropertyFormat("basedir"));
        this.script.printProperty("temp.folder", this.getPropertyFormat("basedir") + '/' + "temp.folder");
        this.script.printProperty("plugin.destination", this.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("properties", null, "eclipse.running", null, null);
        this.script.printProperty("build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        this.script.printTargetEnd();
    }

    public void setModel(BundleDescription model) throws CoreException {
        if (model == null) {
            String message = Policy.bind("error.missingElement");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        this.model = model;
        if (this.getBuildProperties().size() != 0) {
            this.getCompiledElements().add(model.getSymbolicName());
        } else {
            this.binaryPlugin = true;
            this.buildProperties.put("bin.includes", "**/**");
            this.buildProperties.put("bin.excludes", ".project, .classpath, build.xml");
        }
    }

    public void setModelId(String modelId) throws CoreException {
        BundleDescription newModel = this.getModel(modelId);
        if (newModel == null) {
            String message = Policy.bind("exception.missingElement", modelId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        this.setModel(newModel);
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    public void setFeatureGenerator(FeatureBuildScriptGenerator featureGenerator) {
        this.featureGenerator = featureGenerator;
    }

    private void generateBuildJarsTarget(BundleDescription pluginModel) throws CoreException {
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.binaryPlugin ? new CompiledEntry[]{} : this.extractEntriesToCompile(properties);
        this.compiledJarNames = new ArrayList(availableJars.length);
        HashMap<String, CompiledEntry> jars = new HashMap<String, CompiledEntry>(availableJars.length);
        for (int i = 0; i < availableJars.length; ++i) {
            jars.put(availableJars[i].getName(false), availableJars[i]);
        }
        String jarOrder = (String)this.getBuildProperties().get("jars.compile.order");
        IClasspathComputer classpath = AbstractScriptGenerator.isBuildingOSGi() ? new ClasspathComputer3_0(this) : new ClasspathComputer2_1(this);
        if (jarOrder != null) {
            String[] order = Utils.getArrayFromString(jarOrder);
            for (int i = 0; i < order.length; ++i) {
                CompiledEntry jar = (CompiledEntry)jars.get(order[i]);
                if (jar == null) continue;
                this.compiledJarNames.add(jar);
                this.generateCompilationTarget(classpath.getClasspath(pluginModel, jar), jar);
                this.generateSRCTarget(jar);
                jars.remove(order[i]);
            }
        }
        Iterator iterator = jars.values().iterator();
        while (iterator.hasNext()) {
            CompiledEntry jar = (CompiledEntry)iterator.next();
            this.compiledJarNames.add(jar);
            this.generateCompilationTarget(classpath.getClasspath(pluginModel, jar), jar);
            this.generateSRCTarget(jar);
        }
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, Policy.bind("build.plugin.buildJars", pluginModel.getSymbolicName()));
        Iterator iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            String name = ((CompiledEntry)iter.next()).getName(false);
            this.script.printAvailableTask(name, this.replaceVariables(this.getJARLocation(name), true));
            this.script.printAntCallTask(name, null, null);
        }
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            String jarName = ((CompiledEntry)iter.next()).getName(false);
            String srcName = this.getSRCName(jarName);
            this.script.printAvailableTask(srcName, this.getSRCLocation(jarName));
            this.script.printAntCallTask(srcName, null, null);
        }
        this.script.printTargetEnd();
    }

    private void generateCompilationTarget(List classpath, CompiledEntry entry) throws CoreException {
        this.script.println();
        String name = entry.getName(false);
        this.script.printTargetDeclaration(name, "init", null, entry.getName(true), Policy.bind("build.plugin.jar", name));
        String destdir = this.getTempJARFolderLocation(entry.getName(true));
        this.script.printDeleteTask(destdir, null, null);
        this.script.printMkdirTask(destdir);
        this.script.printComment("compile the source code");
        JavacTask javac = new JavacTask();
        javac.setClasspath(classpath);
        javac.setBootClasspath(this.getPropertyFormat("bootclasspath"));
        javac.setDestdir(destdir);
        javac.setFailOnError(this.getPropertyFormat("javacFailOnError"));
        javac.setDebug(this.getPropertyFormat("javacDebugInfo"));
        javac.setVerbose(this.getPropertyFormat("javacVerbose"));
        javac.setIncludeAntRuntime("no");
        javac.setSource(this.getPropertyFormat("javacSource"));
        javac.setTarget(this.getPropertyFormat("javacTarget"));
        javac.setCompileArgs(this.getPropertyFormat("compilerArg"));
        String[] sources = entry.getSource();
        javac.setSrcdir(sources);
        this.script.print(javac);
        this.script.printComment("Copy necessary resources");
        FileSet[] fileSets = new FileSet[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            fileSets[i] = new FileSet(sources[i], null, null, null, "**/*.java, **/package.htm*", null, null);
        }
        this.script.printCopyTask(null, destdir, fileSets, true);
        String jarLocation = this.getJARLocation(entry.getName(true));
        this.script.printMkdirTask(new Path(jarLocation).removeLastSegments(1).toString());
        if (entry.getType() == 1) {
            FileSet[] binFolder = new FileSet[]{new FileSet(destdir, null, null, null, null, null, null)};
            this.script.printCopyTask(null, jarLocation, binFolder, true);
        } else {
            this.script.printJarTask(jarLocation, destdir);
        }
        this.script.printDeleteTask(destdir, null, null);
        this.script.printTargetEnd();
    }

    protected CompiledEntry[] extractEntriesToCompile(Properties properties) {
        ArrayList<CompiledEntry> result = new ArrayList<CompiledEntry>(5);
        int prefixLength = "source.".length();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.")) continue;
            key = key.substring(prefixLength);
            String[] source = Utils.getArrayFromString((String)entry.getValue());
            String[] output = Utils.getArrayFromString(properties.getProperty("output." + key));
            String[] extraClasspath = Utils.getArrayFromString(properties.getProperty("extra." + key));
            CompiledEntry newEntry = new CompiledEntry(key, source, output, extraClasspath, key.endsWith(".jar") ? (byte)0 : 1);
            result.add(newEntry);
        }
        return result.toArray(new CompiledEntry[result.size()]);
    }

    private void generateSRCTarget(CompiledEntry jar) throws CoreException {
        this.script.println();
        String name = jar.getName(false);
        String srcName = this.getSRCName(name);
        this.script.printTargetDeclaration(srcName, "init", null, srcName, null);
        String[] sources = jar.getSource();
        this.filterNonExistingSourceFolders(sources);
        FileSet[] fileSets = new FileSet[sources.length];
        int count = 0;
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i] == null) continue;
            fileSets[count++] = new FileSet(sources[i], null, "**/*.java", null, null, null, null);
        }
        String srcLocation = this.getSRCLocation(name);
        this.script.printMkdirTask(new Path(srcLocation).removeLastSegments(1).toString());
        if (count != 0) {
            this.script.printZipTask(srcLocation, null, false, false, fileSets);
        }
        this.script.printTargetEnd();
    }

    private void filterNonExistingSourceFolders(String[] sources) {
        File pluginRoot;
        try {
            pluginRoot = new File(this.getLocation(this.model));
        }
        catch (CoreException e) {
            BundleHelper.getDefault().getLog().log(e.getStatus());
            return;
        }
        for (int i = 0; i < sources.length; ++i) {
            File file = new File(pluginRoot, sources[i]);
            if (file.exists()) continue;
            sources[i] = null;
            Status status = new Status(2, "org.eclipse.pde.build", 11, Policy.bind("warning.cannotLocateSource", file.getAbsolutePath()), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
        }
    }

    protected String getSRCLocation(String jarName) {
        return this.getJARLocation(this.getSRCName(jarName));
    }

    protected String getTempJARFolderLocation(String jarName) {
        Path destination = new Path(this.getPropertyFormat("temp.folder"));
        destination = destination.append(jarName + ".bin");
        return destination.toString();
    }

    protected String getJARLocation(String jarName) {
        return new Path(this.getPropertyFormat("build.result.folder")).append(jarName).toString();
    }

    protected String[] getClasspathEntries(BundleDescription lookedUpModel) throws CoreException {
        return (String[])this.getSite(false).getRegistry().getExtraData().get(new Long(lookedUpModel.getBundleId()));
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = ModelBuildScriptGenerator.readProperties(this.model.getLocation(), this.propertiesFileName, 2);
            return this.buildProperties;
        }
        return this.buildProperties;
    }

    protected String getSRCName(String jarName) {
        if (jarName.endsWith(".jar")) {
            return jarName.substring(0, jarName.length() - 4) + "src.zip";
        }
        return jarName.replace('/', '.') + "src.zip";
    }

    private void updateExistingScript() throws CoreException {
        String root = this.getLocation(this.model);
        File buildFile = new File(root, this.buildScriptFileName);
        try {
            this.updateVersion(buildFile, "version.suffix", this.model.getVersion().toString());
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writeScript", buildFile.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
        }
    }

    protected String replaceVariables(String sourceString, boolean compiledElement) {
        if (sourceString == null) {
            return null;
        }
        int i = -1;
        String result = sourceString;
        while ((i = result.indexOf("$ws$")) >= 0) {
            result = result.substring(0, i) + "ws/" + this.getPropertyFormat(compiledElement ? "ws" : "basews") + result.substring(i + "$ws$".length());
        }
        while ((i = result.indexOf("$os$")) >= 0) {
            result = result.substring(0, i) + "os/" + this.getPropertyFormat(compiledElement ? "os" : "baseos") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$arch$")) >= 0) {
            result = result.substring(0, i) + "arch/" + this.getPropertyFormat(compiledElement ? "arch" : "basearch") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$nl$")) >= 0) {
            result = result.substring(0, i) + "nl/" + this.getPropertyFormat(compiledElement ? "nl" : "basenl") + result.substring(i + "$nl$".length());
        }
        return result;
    }

    public BundleDescription getModel() {
        return this.model;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertyFileName) {
        this.propertiesFileName = propertyFileName;
    }

    public String getBuildScriptFileName() {
        return this.buildScriptFileName;
    }

    public void setBuildScriptFileName(String buildScriptFileName) {
        this.buildScriptFileName = buildScriptFileName;
    }

    protected BundleDescription getModel(String modelId) throws CoreException {
        return this.getSite(false).getRegistry().getResolvedBundle(modelId);
    }

    protected class CompiledEntry {
        static final byte JAR = 0;
        static final byte FOLDER = 1;
        private String name;
        private String resolvedName;
        private String[] source;
        private String[] output;
        private String[] extraClasspath;
        private byte type;

        protected CompiledEntry(String entryName, String[] entrySource, String[] entryOutput, String[] entryExtraClasspath, byte entryType) {
            this.name = entryName;
            this.source = entrySource;
            this.output = entryOutput;
            this.extraClasspath = entryExtraClasspath;
            this.type = entryType;
        }

        protected String getName(boolean resolved) {
            if (!resolved) {
                return this.name;
            }
            if (this.resolvedName == null) {
                this.resolvedName = ModelBuildScriptGenerator.this.replaceVariables(this.name, true);
            }
            return this.resolvedName;
        }

        protected String[] getSource() {
            return this.source;
        }

        public String[] getOutput() {
            return this.output;
        }

        public String[] getExtraClasspath() {
            return this.extraClasspath;
        }

        public byte getType() {
            return this.type;
        }
    }
}

