/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorAction;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class SortViewAction
extends ResourceNavigatorAction {
    private int sortCriteria;

    public SortViewAction(IResourceNavigator navigator, boolean sortByType) {
        super(navigator, sortByType ? ResourceNavigatorMessages.getString("SortView.byType") : ResourceNavigatorMessages.getString("SortView.byName"));
        if (sortByType) {
            this.setToolTipText(ResourceNavigatorMessages.getString("SortView.toolTipByType"));
        } else {
            this.setToolTipText(ResourceNavigatorMessages.getString("SortView.toolTipByName"));
        }
        this.setEnabled(true);
        this.sortCriteria = sortByType ? 2 : 1;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.sort_view_action_context");
    }

    public void run() {
        IResourceNavigator navigator = this.getNavigator();
        ResourceSorter sorter = navigator.getSorter();
        if (sorter == null) {
            navigator.setSorter(new ResourceSorter(this.sortCriteria));
        } else {
            sorter.setCriteria(this.sortCriteria);
            navigator.setSorter(sorter);
        }
    }
}

