/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.IResourceNavigator;

public abstract class ResourceNavigatorActionGroup
extends ActionGroup {
    protected IResourceNavigator navigator;

    public ResourceNavigatorActionGroup(IResourceNavigator navigator) {
        this.navigator = navigator;
        this.makeActions();
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public IResourceNavigator getNavigator() {
        return this.navigator;
    }

    public void handleKeyPressed(KeyEvent event) {
    }

    protected abstract void makeActions();

    public void runDefaultAction(IStructuredSelection selection) {
    }
}

