/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int labelHandle;
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNshadowThickness, 0, OS.XmNmarginWidth, 0, OS.XmNmarginHeight, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int thickness = argList[1];
        int marginWidth = argList[3];
        int marginHeight = argList[5];
        int borderWidth = this.getBorderWidth();
        int trimX = x - marginWidth + thickness - borderWidth;
        int trimY = y - marginHeight + thickness - borderWidth;
        int trimWidth = width + (marginWidth + thickness + borderWidth) * 2;
        int trimHeight = height + (marginHeight + thickness + borderWidth) * 2;
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] argList2 = new int[]{OS.XmNy, 0, OS.XmNheight, 0, OS.XmNchildHorizontalSpacing, 0};
            OS.XtGetValues(this.labelHandle, argList2, argList2.length / 2);
            int titleHeight = (short)argList2[1] + argList2[3];
            trimY = y - titleHeight;
            trimHeight = height + titleHeight + (marginHeight + thickness + borderWidth);
            XtWidgetGeometry result = new XtWidgetGeometry();
            OS.XtQueryGeometry(this.labelHandle, null, result);
            int titleWidth = result.width + 2 * (argList2[5] + marginWidth + thickness + borderWidth);
            trimWidth = Math.max(trimWidth, titleWidth);
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createHandle(int index) {
        this.state |= 8;
        int border = (this.style & 0x800) != 0 ? 1 : 0;
        int[] argList1 = new int[]{OS.XmNancestorSensitive, 1, OS.XmNborderWidth, border};
        int parentHandle = this.parent.handle;
        this.formHandle = OS.XmCreateForm(parentHandle, null, argList1, argList1.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int[] argList2 = new int[]{OS.XmNshadowType, this.shadowType(), OS.XmNtopAttachment, 1, OS.XmNbottomAttachment, 1, OS.XmNleftAttachment, 1, OS.XmNrightAttachment, 1, OS.XmNresizable, 0};
        this.handle = OS.XmCreateFrame(this.formHandle, null, argList2, argList2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int[] argList3 = new int[]{OS.XmNframeChildType, 2};
        this.labelHandle = OS.XmCreateLabel(this.handle, null, argList3, argList3.length / 2);
        if (this.labelHandle == 0) {
            this.error(2);
        }
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        this.enableHandle(enabled, this.labelHandle);
    }

    int fontHandle() {
        return this.labelHandle;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNshadowThickness, 0, OS.XmNmarginWidth, 0, OS.XmNmarginHeight, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int thickness = argList[5];
        int marginWidth = argList[7];
        int marginHeight = argList[9];
        int x = marginWidth + thickness;
        int y = marginHeight + thickness;
        int width = argList[1] - (marginWidth + thickness) * 2 - 1;
        int height = argList[3] - (marginHeight + thickness) * 2 - 1;
        if (OS.XtIsManaged(this.labelHandle)) {
            int[] argList2 = new int[]{OS.XmNy, 0, OS.XmNheight, 0};
            OS.XtGetValues(this.labelHandle, argList2, argList2.length / 2);
            y = (short)argList2[1] + argList2[3];
            height = argList[3] - y - (marginHeight + thickness) - 1;
        }
        return new Rectangle(x, y, width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char key) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        this.propagateHandle(enabled, this.labelHandle, 0);
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        super.redrawWidget(x, y, width, height, all);
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)x, (short)y, root_x, root_y);
        short[] label_x = new short[1];
        short[] label_y = new short[1];
        OS.XtTranslateCoords(this.labelHandle, (short)0, (short)0, label_x, label_y);
        this.redrawHandle(root_x[0] - label_x[0], root_y[0] - label_y[0], width, height, this.labelHandle);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] argList = new int[]{OS.XmNforeground, 0};
        OS.XtGetValues(this.labelHandle, argList, argList.length / 2);
        OS.XmChangeColor(this.labelHandle, pixel);
        OS.XtSetValues(this.labelHandle, argList, argList.length / 2);
    }

    void setForegroundPixel(int pixel) {
        int[] argList = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(this.labelHandle, argList, argList.length / 2);
        super.setForegroundPixel(pixel);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        int mnemonic = this.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), text, true);
        int xmString = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (xmString == 0) {
            this.error(13);
        }
        if (mnemonic == 0) {
            mnemonic = 0xFFFFFF;
        }
        int[] argList = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString, OS.XmNmnemonic, mnemonic};
        OS.XtSetValues(this.labelHandle, argList, argList.length / 2);
        if (xmString != 0) {
            OS.XmStringFree(xmString);
        }
        if (string.length() == 0) {
            OS.XtUnmanageChild(this.labelHandle);
        } else {
            OS.XtManageChild(this.labelHandle);
        }
    }

    int shadowType() {
        if ((this.style & 4) != 0) {
            return 7;
        }
        if ((this.style & 8) != 0) {
            return 8;
        }
        if ((this.style & 0x10) != 0) {
            return 5;
        }
        if ((this.style & 0x40) != 0) {
            return 6;
        }
        return 5;
    }
}

