/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFontStruct;

public final class Font {
    public int handle;
    public String codePage;
    Device device;

    Font() {
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fd == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{fd});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        for (int i = 0; i < fds.length; ++i) {
            if (fds[i] != null) continue;
            SWT.error(4);
        }
        this.init(device, fds);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{new FontData(name, height, style)});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.handle == this.device.systemFont.handle) {
            return;
        }
        OS.XmFontListFree(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    static String getCodePage(int xDisplay, int fontList) {
        int fontListEntry;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            return null;
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        String codePage = null;
        block0: while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int propPtr = fontStruct.properties;
                for (int i = 0; i < fontStruct.n_properties; ++i) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                        int length = OS.strlen(ptr);
                        byte[] nameBuf = new byte[length];
                        OS.memmove(nameBuf, ptr, length);
                        String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                        int start = xlfd.lastIndexOf(45);
                        if (start != -1 && start > 0 && (start = xlfd.lastIndexOf(45, start - 1)) != -1 && (codePage = xlfd.substring(start + 1, xlfd.length())).indexOf("iso") == 0 && OS.IsLinux) {
                            codePage = "ISO-" + codePage.substring(3, codePage.length());
                        }
                        OS.XtFree(ptr);
                        continue block0;
                    }
                    propPtr += 8;
                }
                continue;
            }
            int localePtr = OS.XLocaleOfFontSet(fontPtr);
            int length = OS.strlen(localePtr);
            byte[] locale = new byte[length + 1];
            OS.memmove(locale, localePtr, length);
            OS.setlocale(OS.LC_CTYPE, locale);
            int codesetPtr = OS.nl_langinfo(OS.CODESET);
            length = OS.strlen(codesetPtr);
            byte[] codeset = new byte[length];
            OS.memmove(codeset, codesetPtr, length);
            codePage = new String(Converter.mbcsToWcs(null, codeset));
            OS.setlocale(OS.LC_CTYPE, new byte[1]);
        }
        OS.XmFontListFreeFontContext(context);
        return codePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        xDisplay = this.device.xDisplay;
        buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, this.handle)) {
            return null;
        }
        context = buffer[0];
        fontStruct = new XFontStruct();
        fontStructPtr = new int[1];
        fontNamePtr = new int[1];
        data = new FontData[]{};
lbl12:
        // 3 sources

        try {
            block7: while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
                block18: {
                    fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
                    if (buffer[0] != 0) break block18;
                    OS.memmove(fontStruct, fontPtr, 80);
                    propPtr = fontStruct.properties;
                    for (i = 0; i < fontStruct.n_properties; ++i) {
                        prop = new int[2];
                        OS.memmove(prop, propPtr, 8);
                        if (prop[0] == 18) {
                            ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                            length = OS.strlen(ptr);
                            nameBuf = new byte[length];
                            OS.memmove(nameBuf, ptr, length);
                            OS.XtFree(ptr);
                            xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                            newData = new FontData[data.length + 1];
                            System.arraycopy(data, 0, newData, 0, data.length);
                            newData[newData.length - 1] = FontData.motif_new(xlfd);
                            data = newData;
                            continue block7;
                        }
                        propPtr += 8;
                    }
                    ** GOTO lbl12
                }
                nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
                fontStructs = new int[nFonts];
                OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
                block9: for (i = 0; i < nFonts; ++i) {
                    OS.memmove(fontStruct, fontStructs[i], 80);
                    propPtr = fontStruct.properties;
                    for (j = 0; j < fontStruct.n_properties; ++j) {
                        prop = new int[2];
                        OS.memmove(prop, propPtr, 8);
                        if (prop[0] == 18) {
                            block16: {
                                ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                                length = OS.strlen(ptr);
                                nameBuf = new byte[length];
                                OS.memmove(nameBuf, ptr, length);
                                OS.XFree(ptr);
                                xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                                newData = new FontData[data.length + 1];
                                System.arraycopy(data, 0, newData, 0, data.length);
                                try {
                                    newData[newData.length - 1] = FontData.motif_new(xlfd);
                                }
                                catch (Exception e) {
                                    fontName = new int[1];
                                    OS.memmove(fontName, fontNamePtr[0] + i * 4, 4);
                                    ptr = fontName[0];
                                    if (ptr == 0) break block16;
                                    length = OS.strlen(ptr);
                                    nameBuf = new byte[length];
                                    OS.memmove(nameBuf, ptr, length);
                                    xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                                    newData[newData.length - 1] = FontData.motif_new(xlfd);
                                }
                            }
                            data = newData;
                            continue block9;
                        }
                        propPtr += 8;
                    }
                }
                ** GOTO lbl12
            }
            if (data.length == 0) {
                fontPtr = null;
                return fontPtr;
            }
        }
        catch (Exception e) {
            var10_13 = null;
            return var10_13;
        }
        finally {
            OS.XmFontListFreeFontContext(context);
        }
        return data;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, FontData[] fds) {
        byte[] buffer;
        this.device = device;
        FontData firstFd = fds[0];
        if (firstFd.lang != null) {
            String lang = firstFd.lang;
            String country = firstFd.country;
            String variant = firstFd.variant;
            String osLocale = lang;
            if (country != null) {
                osLocale = osLocale + "_" + country;
            }
            if (variant != null) {
                osLocale = osLocale + "." + variant;
            }
            int length = osLocale.length();
            buffer = new byte[length + 1];
            for (int i = 0; i < length; ++i) {
                buffer[i] = (byte)osLocale.charAt(i);
            }
            OS.setlocale(OS.LC_CTYPE, buffer);
        }
        int fontType = 1;
        if (OS.IsHPUX) {
            int localePtr = OS.setlocale(OS.LC_CTYPE, null);
            int length = OS.strlen(localePtr);
            byte[] buffer2 = new byte[length];
            OS.memmove(buffer2, localePtr, length);
            if ("C".equals(new String(Converter.mbcsToWcs(null, buffer2)))) {
                fontType = 0;
            }
        }
        Point dpi = null;
        if (device.setDPI) {
            dpi = device.getDPI();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fds.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            FontData fd = fds[i];
            int hRes = fd.horizontalResolution;
            int vRes = fd.verticalResolution;
            if (dpi != null) {
                fd.horizontalResolution = dpi.x;
                fd.verticalResolution = dpi.y;
            }
            stringBuffer.append(fd.getXlfd());
            fd.horizontalResolution = hRes;
            fd.verticalResolution = vRes;
        }
        FontData newFd = new FontData();
        newFd.points = firstFd.points;
        if (fontType == 1) {
            if (OS.IsAIX && OS.IsDBLocale) {
                stringBuffer.append(',');
                stringBuffer.append(newFd.getXlfd());
            } else {
                newFd.weight = firstFd.weight;
                newFd.slant = firstFd.slant;
                stringBuffer.append(',');
                stringBuffer.append(newFd.getXlfd());
                newFd.weight = null;
                newFd.slant = null;
                stringBuffer.append(',');
                stringBuffer.append(newFd.getXlfd());
            }
        }
        boolean warnings = device._getWarnings();
        device._setWarnings(false);
        buffer = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
        int fontListEntry = OS.XmFontListEntryLoad(device.xDisplay, buffer, fontType, OS.XmFONTLIST_DEFAULT_TAG);
        device._setWarnings(warnings);
        if (fontListEntry != 0) {
            this.handle = OS.XmFontListAppendEntry(0, fontListEntry);
            OS.XmFontListEntryFree(new int[]{fontListEntry});
            int codesetPtr = OS.nl_langinfo(OS.CODESET);
            int length = OS.strlen(codesetPtr);
            buffer = new byte[length];
            OS.memmove(buffer, codesetPtr, length);
            this.codePage = new String(Converter.mbcsToWcs(null, buffer));
        } else {
            Font systemFont = device.systemFont;
            this.handle = systemFont.handle;
            this.codePage = systemFont.codePage;
        }
        if (firstFd.lang != null) {
            OS.setlocale(OS.LC_CTYPE, new byte[0]);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static Font motif_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.device = device;
        font.handle = handle;
        font.codePage = Font.getCodePage(device.xDisplay, handle);
        return font;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

